/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.sample.login;

import de.ipk_gatersleben.bit.bi.edal.sample.login.GoogleOauth;
import de.ipk_gatersleben.bit.bi.edal.sample.login.GooglePrincipal;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class GoogleLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> sharedState;
    private Map<String, ?> options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private boolean keepLogin;
    private GooglePrincipal principal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.setSharedState(sharedState);
        this.setOptions(options);
        this.keepLogin = false;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to get authentication information from the user");
        }
        Callback[] callbacks = new Callback[4];
        try {
            callbacks[0] = new NameCallback(" ");
            callbacks[1] = new PasswordCallback(" ", false);
            callbacks[2] = new ConfirmationCallback(0, 0, 1);
            callbacks[3] = new TextInputCallback("proxy");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
            if (((ConfirmationCallback)callbacks[2]).getSelectedIndex() == 0) {
                this.keepLogin = true;
            }
            if (this.username == null && this.password.length == 0) {
                throw new LoginException("Authentication stopped by User");
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        try {
            GoogleOauth.authenticateGoogleUser(this.username, new String(this.password), this.keepLogin, ((TextInputCallback)callbacks[3]).getText());
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.principal = new GooglePrincipal(this.username);
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.username = null;
        int i = 0;
        while (i < this.password.length) {
            this.password[i] = 32;
            ++i;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                int i = 0;
                while (i < this.password.length) {
                    this.password[i] = 32;
                    ++i;
                }
                this.password = null;
            }
            this.principal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            int i = 0;
            while (i < this.password.length) {
                this.password[i] = 32;
                ++i;
            }
            this.password = null;
        }
        this.principal = null;
        return true;
    }

    public Map<String, ?> getSharedState() {
        return this.sharedState;
    }

    public void setSharedState(Map<String, ?> sharedState) {
        this.sharedState = sharedState;
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, ?> options) {
        this.options = options;
    }
}

