/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.sample.login;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;
import de.ipk_gatersleben.bit.bi.edal.sample.login.GooglePrincipal;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class GoogleOauth {
    private static String openidurl = "https://accounts.google.com/o/oauth2/";
    private static String clientid = "185350669209-g332o78obs1033ep4kk4ke2mf2833455.apps.googleusercontent.com";
    private static String clientsecret = "6s2W5F2XfZU97TL0DTWPG7T1";
    private static String callbackurl = "urn:ietf:wg:oauth:2.0:oob";
    private static String code = null;
    private static String openidusername = "Email";
    private static String openidpassword = "Passwd";
    private static String openidloginbutton = "signIn";
    private static String openidcode = "code";
    private static final String SUBMIT_APPROVE_ACCESS = "submit_approve_access";
    private static final String SMS_USER_PIN = "smsUserPin";
    private static final String SMS_VERIFY_PIN = "smsVerifyPin";

    public static boolean isLogged(String username) {
        try {
            Set<Cookie> cookieset = GoogleOauth.getcookies(username);
            if (cookieset.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            DataManager.getImplProv().getLogger().error((Object)e);
        }
        return false;
    }

    public static GooglePrincipal authenticateGoogleUser(String emailaddress, String userpassword, boolean keepLogin, String proxy) throws Exception {
        WebClient webClient;
        String access_token = null;
        if (proxy != null && proxy.indexOf(":") > 0) {
            String proxyHost = proxy.substring(0, proxy.indexOf(":"));
            String proxyPort = proxy.substring(proxy.indexOf(":") + 1);
            webClient = new WebClient(BrowserVersion.FIREFOX_24, proxyHost, Integer.valueOf(proxyPort).intValue());
        } else {
            webClient = new WebClient(BrowserVersion.FIREFOX_24);
        }
        webClient.getOptions().setJavaScriptEnabled(true);
        webClient.getOptions().setCssEnabled(true);
        webClient.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        webClient.getOptions().setTimeout(5000);
        webClient.getOptions().setThrowExceptionOnScriptError(false);
        webClient.waitForBackgroundJavaScript(15000L);
        try {
            if (keepLogin) {
                Set<Cookie> cookieset = GoogleOauth.getcookies(emailaddress);
                if (cookieset.size() == 0) {
                    GoogleOauth.loginwithoutcookie(webClient, keepLogin, emailaddress, userpassword);
                    access_token = GoogleOauth.getaccesstoken(webClient);
                } else {
                    GoogleOauth.loginwithcookie(webClient, cookieset);
                    access_token = GoogleOauth.getaccesstoken(webClient);
                }
            } else {
                GoogleOauth.deletecookie(emailaddress);
                GoogleOauth.loginwithoutcookie(webClient, keepLogin, emailaddress, userpassword);
                access_token = GoogleOauth.getaccesstoken(webClient);
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new EdalAuthenticateException("Please check your HTTP Proxy!");
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            throw new EdalAuthenticateException("Please check your HTTP Proxy Configuration!");
        }
        catch (FailingHttpStatusCodeException failingHttpStatusCodeException) {
            throw new EdalAuthenticateException("the Google OAuth service has exception!");
        }
        JSONParser parser = new JSONParser();
        UnexpectedPage peoplePage = (UnexpectedPage)webClient.getPage("https://www.googleapis.com/plus/v1/people/me?access_token=" + access_token);
        Object obj = parser.parse(peoplePage.getWebResponse().getContentAsString());
        JSONObject jsonobj = (JSONObject)obj;
        if ("person".equals(jsonobj.get((Object)"objectType"))) {
            GooglePrincipal googlePrincipal = new GooglePrincipal(emailaddress);
            return googlePrincipal;
        }
        throw new EdalAuthenticateException("Please check your username and password!");
    }

    private static void loginwithcookie(WebClient webClient, Set<Cookie> cookieset) throws Exception {
        try {
            for (Cookie cookie : cookieset) {
                webClient.getCookieManager().addCookie(cookie);
            }
            HtmlPage rootPage = (HtmlPage)webClient.getPage(String.valueOf(openidurl) + "auth?scope=email%20profile&redirect_uri=" + callbackurl + "&response_type=code&client_id=" + clientid);
            HtmlButton appbutton = (HtmlButton)rootPage.getHtmlElementById(SUBMIT_APPROVE_ACCESS);
            Thread.sleep(2000L);
            HtmlPage fpage = (HtmlPage)appbutton.click();
            HtmlInput codeinput = (HtmlInput)fpage.getHtmlElementById(openidcode);
            code = codeinput.getValueAttribute();
        }
        catch (ElementNotFoundException elementNotFoundException) {}
    }

    private static void loginwithoutcookie(WebClient webClient, boolean savecookie, String emailaddress, String userpassword) throws Exception {
        HtmlButton appbutton;
        HtmlPage loginPage = (HtmlPage)webClient.getPage(String.valueOf(openidurl) + "auth?scope=email%20profile&redirect_uri=" + callbackurl + "&response_type=code&client_id=" + clientid);
        HtmlInput usernameintputBox = (HtmlInput)loginPage.getHtmlElementById(openidusername);
        usernameintputBox.setValueAttribute(emailaddress);
        HtmlInput passwordintputBox = (HtmlInput)loginPage.getHtmlElementById(openidpassword);
        passwordintputBox.setValueAttribute(userpassword);
        HtmlElement loginbutton = loginPage.getHtmlElementById(openidloginbutton);
        HtmlPage approvepage = (HtmlPage)loginbutton.click();
        try {
            if (approvepage.getHtmlElementById(openidloginbutton) != null) {
                throw new EdalAuthenticateException("Please check your username and password!");
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {}
        try {
            if (approvepage.getHtmlElementById(SUBMIT_APPROVE_ACCESS) != null) {
                appbutton = (HtmlButton)approvepage.getHtmlElementById(SUBMIT_APPROVE_ACCESS);
                Thread.sleep(2000L);
                HtmlPage fpage = (HtmlPage)appbutton.click();
                HtmlInput codeinput = (HtmlInput)fpage.getHtmlElementById(openidcode);
                code = codeinput.getValueAttribute();
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {}
        try {
            if (approvepage.getHtmlElementById(SMS_VERIFY_PIN) != null) {
                appbutton = (HtmlSubmitInput)approvepage.getHtmlElementById(SMS_VERIFY_PIN);
                HtmlInput pinbox = (HtmlInput)approvepage.getHtmlElementById(SMS_USER_PIN);
                String pincode = JOptionPane.showInputDialog("Please Enter your pincode: ");
                if (pincode == null) {
                    System.exit(0);
                }
                pinbox.setValueAttribute(pincode);
                Thread.sleep(2000L);
                HtmlPage page3 = (HtmlPage)appbutton.click();
                HtmlButton okbutton = (HtmlButton)page3.getHtmlElementById(SUBMIT_APPROVE_ACCESS);
                Thread.sleep(2000L);
                HtmlPage fpage = (HtmlPage)okbutton.click();
                HtmlInput codeinput = (HtmlInput)fpage.getHtmlElementById(openidcode);
                code = codeinput.getValueAttribute();
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {}
        if (code != null && savecookie) {
            GoogleOauth.writecookies(webClient.getCookieManager().getCookies(), emailaddress);
        }
        if (code == null) {
            throw new EdalAuthenticateException("Please check your username and password!");
        }
    }

    private static String getaccesstoken(WebClient webClient) throws Exception {
        WebRequest requestSettings = new WebRequest(new URL(String.valueOf(openidurl) + "token"), HttpMethod.POST);
        requestSettings.setRequestParameters(GoogleOauth.getAssocQuery());
        Page page = webClient.getPage(requestSettings);
        String pageContent = page.getWebResponse().getContentAsString();
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(pageContent);
        JSONObject jsonobj = (JSONObject)obj;
        String access_token = jsonobj.get((Object)"access_token").toString();
        return access_token;
    }

    private static List<NameValuePair> getAssocQuery() {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("code", code));
        list.add(new NameValuePair("client_id", clientid));
        list.add(new NameValuePair("client_secret", clientsecret));
        list.add(new NameValuePair("redirect_uri", callbackurl));
        list.add(new NameValuePair("grant_type", "authorization_code"));
        return list;
    }

    private static void deletecookie(String emailaddress) throws Exception {
        File tempfile = new File(GoogleOauth.getFilepath(emailaddress));
        if (tempfile.exists()) {
            tempfile.delete();
        }
    }

    private static void writecookies(Set<Cookie> cookieset, String emailaddress) throws Exception {
        Path path;
        Boolean hidden;
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(GoogleOauth.getFilepath(emailaddress)))));
        for (Cookie cookie : cookieset) {
            bw.write(String.valueOf(cookie.getDomain()) + " " + cookie.getName() + " " + cookie.getValue());
            bw.newLine();
        }
        bw.close();
        if (SystemUtils.IS_OS_WINDOWS && (hidden = (Boolean)Files.getAttribute(path = Paths.get(GoogleOauth.getFilepath(emailaddress), new String[0]), "dos:hidden", LinkOption.NOFOLLOW_LINKS)) != null && !hidden.booleanValue()) {
            Files.setAttribute(path, "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
        }
    }

    private static Set<Cookie> getcookies(String emailaddress) throws Exception {
        HashSet<Cookie> cookies = new HashSet<Cookie>();
        File tempfile = new File(GoogleOauth.getFilepath(emailaddress));
        if (tempfile.exists()) {
            BufferedReader br = null;
            FileReader fr = null;
            fr = new FileReader(GoogleOauth.getFilepath(emailaddress));
            br = new BufferedReader(fr);
            while (br.ready()) {
                String line = br.readLine();
                String[] arr = line.split("\\s+");
                if (arr.length != 3) continue;
                cookies.add(new Cookie(arr[0], arr[1], arr[2]));
            }
            br.close();
            ((Reader)fr).close();
        }
        return cookies;
    }

    private static String getFilepath(String emailaddress) {
        return String.valueOf(System.getProperty("user.home")) + File.separator + "." + emailaddress + "_google_cookie.txt";
    }

    public static void main(String[] args) throws Exception {
        System.out.println(EdalHelpers.authenticateGoogleUser("gaterslebenchen@gmail.com", "proxy1.ipk-gatersleben.de", 3128));
    }
}

