/*
 * Copyright (c) 2015 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import java.util.HashMap;
import java.util.Map;

import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdSchedulerFactory;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;

/**
 * Thread to calculate the size of directories within a {@link PublicReference}
 * 
 * @author arendd
 */
public class CalculateDirectorySizeThread extends Thread {

	/**
	 * Interval to rerun the {@link CalculateDirectorySizeThread} in seconds
	 */
	private static final int INTERVAL_TO_REPEAT_JOB = 24;

	private static Scheduler scheduler;

	public static Map<String, Long> directorySizes = new HashMap<String, Long>();

	public CalculateDirectorySizeThread() {

	}

	/**
	 * Finish the {@link CalculateDirectorySizeThread} an shutdown the
	 * {@link Scheduler}.
	 */
	public void done() {
		try {
			this.getScheduler().shutdown(true);
		} catch (SchedulerException e) {
			DataManager.getImplProv().getLogger().info("unable to stop CalculateDirectorySizeThreadScheduler", e);
		}
	}

	/**
	 * Getter for the {@link Scheduler}
	 * 
	 * @return the scheduler
	 */
	public Scheduler getScheduler() {
		return scheduler;
	}

	/**
	 * Start the {@link CalculateDirectorySizeThread} by starting the
	 * {@link Scheduler} and run the
	 * {@link CalculateDirectorySizeJob}.
	 */
	public void run() {

		DataManager.getImplProv().getLogger().info("Starting CalculateDirectorySizeThread");

		Scheduler defaultQuartzScheduler = SchedulerRepository.getInstance().lookup("DefaultQuartzScheduler");

		if (defaultQuartzScheduler == null) {

			try {
				Scheduler std = new StdSchedulerFactory().getScheduler();
				CalculateDirectorySizeThread.setScheduler(std);
			} catch (SchedulerException e) {
				DataManager.getImplProv().getLogger().warn("unable to create new CalculateDirectorySizeThreadScheduler", e);
			}
		}

		else {
			CalculateDirectorySizeThread.setScheduler(defaultQuartzScheduler);
		}
		try {
			this.getScheduler().start();

			JobDetail job = JobBuilder.newJob(CalculateDirectorySizeJob.class).build();

			Trigger trigger = TriggerBuilder.newTrigger().startNow().withSchedule(SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(INTERVAL_TO_REPEAT_JOB).repeatForever()).build();

			this.getScheduler().scheduleJob(job, trigger);
		} catch (SchedulerException e) {
			DataManager.getImplProv().getLogger().warn("unable to start CalculateDirectorySizeThreadScheduler", e);

		}
	}

	/**
	 * Setter for the {@link Scheduler}
	 * 
	 * @param scheduler
	 *            the scheduler to set
	 */
	private static void setScheduler(Scheduler scheduler) {
		CalculateDirectorySizeThread.scheduler = scheduler;
	}

}
