/*
 * Copyright (c) 2015 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import org.apache.log4j.Appender;

import org.apache.log4j.Logger;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;

/**
 * ErrorHandler for log4j errors in eDAL.
 * 
 * @author arendd
 */
public class EdalErrorHandler implements ErrorHandler {

	/**
	 * {@inheritDoc}
	 * <p>
	 */
	@Override
	public void error(String message, Exception e, int errorCode) {
		error(message, e, errorCode, null);
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 */
	@Override
	public void error(String message) {
		throw new Error("Fail to write/access log files: " + message);
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 */
	@Override
	public void error(String message, Exception e, int errorCode,
			LoggingEvent event) {
		throw new Error("Fail to write/access log files: " + message + " : "
				+ e.getMessage());

	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * No options to activate.
	 */
	@Override
	public void activateOptions() {
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * Does not do anything.
	 */
	@Override
	public void setLogger(Logger logger) {
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * Does not do anything.
	 */
	@Override
	public void setAppender(Appender appender) {
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * Does not do anything.
	 */
	@Override
	public void setBackupAppender(Appender appender) {
	}

}
