package de.ipk_gatersleben.bit.bi.edal.sample;

import java.util.HashMap;
import java.util.Map;

import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.AppConfigurationEntry.LoginModuleControlFlag;
import javax.security.auth.login.Configuration;

public class EdalLoginConfiguration extends Configuration {

	@Override
	public AppConfigurationEntry[] getAppConfigurationEntry(String name) {

		Map<String, String> map = new HashMap<>();

		AppConfigurationEntry[] array = new AppConfigurationEntry[1];

		switch (name) {
		case "Sample":

			map.put("debug", "false");

			AppConfigurationEntry sampleLoginModule = new AppConfigurationEntry(
					"de.ipk_gatersleben.bit.bi.edal.sample.login.SampleUserLoginModule",
					LoginModuleControlFlag.REQUIRED, map);

			array[0] = sampleLoginModule;

			return array;

		case "Windows":

			map.put("debug", "false");

			AppConfigurationEntry windowsLoginModule = new AppConfigurationEntry(
					"com.sun.security.auth.module.NTLoginModule", LoginModuleControlFlag.REQUIRED, map);

			array[0] = windowsLoginModule;

			return array;

		case "Unix":

			map.put("debug", "false");

			AppConfigurationEntry unixLoginModule = new AppConfigurationEntry(
					"com.sun.security.auth.module.UnixLoginModule", LoginModuleControlFlag.REQUIRED, map);

			array[0] = unixLoginModule;

			return array;

		case "Kerberos":

			map.put("debug", "false");
			map.put("useTicketCache", "false");
			map.put("storeKey", "true");

			AppConfigurationEntry kerberosLoginModule = new AppConfigurationEntry(
					"com.sun.security.auth.module.Krb5LoginModule", LoginModuleControlFlag.REQUIRED, map);

			array[0] = kerberosLoginModule;

			return array;
		case "User":

			AppConfigurationEntry userLoginModule = new AppConfigurationEntry(
					"de.ipk_gatersleben.bit.bi.edal.sample.login.UserLoginModule", LoginModuleControlFlag.REQUIRED,
					map);

			array[0] = userLoginModule;

			return array;
		case "Google":

			AppConfigurationEntry googleLoginModule = new AppConfigurationEntry(
					"de.ipk_gatersleben.bit.bi.edal.sample.login.GoogleLoginModule", LoginModuleControlFlag.REQUIRED,
					map);

			array[0] = googleLoginModule;

			return array;
			
		case "NewGoogle":

			AppConfigurationEntry newGoogleLoginModule = new AppConfigurationEntry(
					"de.ipk_gatersleben.bit.bi.edal.sample.login.NewGoogleLoginModule", LoginModuleControlFlag.REQUIRED,
					map);

			array[0] = newGoogleLoginModule;

			return array;
		default:
			return array;
		}

	}

}
