/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.desktop.kde;

import com.btr.proxy.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class KdeSettingsParser {
    private File settingsFile;

    public KdeSettingsParser() {
        this(null);
    }

    public KdeSettingsParser(File settingsFile) {
        this.settingsFile = settingsFile;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties parseSettings() throws IOException {
        if (this.settingsFile == null) {
            this.settingsFile = this.findSettingsFile();
        }
        if (this.settingsFile == null) {
            return null;
        }
        Properties result = new Properties();
        try (BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(this.settingsFile)));){
            block12: {
                String line;
                block11: {
                    line = fin.readLine();
                    while (line != null && !"[Proxy Settings]".equals(line.trim())) {
                        line = fin.readLine();
                    }
                    if (line == null) {
                        Properties properties = result;
                        return properties;
                    }
                    line = "";
                    if (!true) break block11;
                    if (line == null) return result;
                    if (line.trim().startsWith("[")) break block12;
                }
                do {
                    int index;
                    if ((index = (line = line.trim()).indexOf(61)) > 0) {
                        String key = line.substring(0, index).trim();
                        String value = line.substring(index + 1).trim();
                        result.setProperty(key, value);
                    }
                    line = fin.readLine();
                    if (line == null) return result;
                } while (!line.trim().startsWith("["));
            }
            return result;
        }
    }

    private File findSettingsFile() {
        File userDir = new File(System.getProperty("user.home"));
        if ("4".equals(System.getenv("KDE_SESSION_VERSION"))) {
            this.settingsFile = this.findSettingsFile(new File(userDir, ".kde4" + File.separator + "share" + File.separator + "config" + File.separator + "kioslaverc"));
        }
        if (this.settingsFile == null) {
            return this.findSettingsFile(new File(userDir, ".kde" + File.separator + "share" + File.separator + "config" + File.separator + "kioslaverc"));
        }
        return this.settingsFile;
    }

    private File findSettingsFile(File settingsFile) {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Searching Kde settings in {0}", settingsFile);
        if (!settingsFile.exists()) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Settings not found", new Object[0]);
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Settings found", new Object[0]);
        return settingsFile;
    }
}

