/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.whitelist;

import com.btr.proxy.selector.whitelist.HostnameFilter;
import com.btr.proxy.selector.whitelist.IPv4WithSubnetChecker;
import com.btr.proxy.selector.whitelist.IpRangeFilter;
import com.btr.proxy.selector.whitelist.WhiteListParser;
import com.btr.proxy.util.UriFilter;
import java.util.ArrayList;
import java.util.List;

public class DefaultWhiteListParser
implements WhiteListParser {
    @Override
    public List<UriFilter> parseWhiteList(String whiteList) {
        ArrayList<UriFilter> result = new ArrayList<UriFilter>();
        String[] token = whiteList.split("[, ]+");
        int i = 0;
        while (i < token.length) {
            String tkn = token[i].trim();
            if (this.isIP4SubnetFilter(tkn)) {
                result.add(new IpRangeFilter(tkn));
            } else if (tkn.endsWith("*")) {
                tkn = tkn.substring(0, tkn.length() - 1);
                result.add(new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, tkn));
            } else if (tkn.trim().startsWith("*")) {
                tkn = tkn.substring(1);
                result.add(new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, tkn));
            } else {
                result.add(new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, tkn));
            }
            ++i;
        }
        return result;
    }

    private boolean isIP4SubnetFilter(String token) {
        return IPv4WithSubnetChecker.isValid(token);
    }
}

