/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalLog;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalSecuredJettyHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class EdalJettyServer {
    public static final String EDAL_PATH_SEPARATOR = "/";
    private static URL url = null;
    private boolean useSSL = false;
    private Server eDALServer = null;
    private String domainNameToUse = null;

    protected EdalJettyServer(EdalConfiguration configuration) {
        try {
            if (!configuration.isInTestMode()) {
                this.checkIfDomainIsRegisteredByDataCite(InetAddress.getLocalHost(), configuration.getAliasDomainNames());
            } else {
                this.domainNameToUse = InetAddress.getLocalHost().getCanonicalHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            DataManager.getImplProv().getLogger().error((Object)"Unable to validate registered domain names");
            System.exit(0);
        }
        this.useSSL = configuration.isUseSSLForHttpListener();
        this.eDALServer = new Server((ThreadPool)new ExecutorThreadPool(DataManager.getJettyThreadPool()));
        JAASLoginService jaasLoginService = new JAASLoginService("Test JAAS Realm");
        jaasLoginService.setLoginModuleName("Kerberos");
        jaasLoginService.setIdentityService((IdentityService)new DefaultIdentityService());
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"**"});
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setPathSpec(EDAL_PATH_SEPARATOR + EdalHttpFunctions.REPORT.name() + "/*");
        constraintMapping.setConstraint(constraint);
        securityHandler.setConstraintMappings(Collections.singletonList(constraintMapping));
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setLoginService((LoginService)jaasLoginService);
        securityHandler.setHandler((Handler)new EdalSecuredJettyHandler());
        if (!Files.exists(Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "jetty_log"), new LinkOption[0])) {
            try {
                Files.createDirectories(Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "jetty_log"), new FileAttribute[0]);
            }
            catch (IOException e) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to create jetty log directory " + e.getMessage()));
            }
        }
        EdalLog requestLog = new EdalLog(Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "jetty_log", "jetty-yyyy_mm_dd.request.log").toString());
        requestLog.setRetainDays(Integer.MAX_VALUE);
        requestLog.setAppend(true);
        requestLog.setExtended(true);
        requestLog.setLogServer(true);
        requestLog.setPreferProxiedForAddress(true);
        requestLog.setLogTimeZone("GMT+1");
        requestLog.setIgnorePaths(new String[]{EDAL_PATH_SEPARATOR + EdalHttpFunctions.CSS.name() + "/*", EDAL_PATH_SEPARATOR + EdalHttpFunctions.LOGO.name() + "/*", EDAL_PATH_SEPARATOR + EdalHttpFunctions.JS.name() + "/*", EDAL_PATH_SEPARATOR + EdalHttpFunctions.FILEICONS.name() + "/*", EDAL_PATH_SEPARATOR + EdalHttpFunctions.ACCEPT.name() + "/*", EDAL_PATH_SEPARATOR + EdalHttpFunctions.REJECT.name() + "/*", EDAL_PATH_SEPARATOR + EdalHttpFunctions.USER_ACCEPT.name() + "/*", EDAL_PATH_SEPARATOR + EdalHttpFunctions.USER_REJECT.name() + "/*", EDAL_PATH_SEPARATOR + EdalHttpFunctions.LOGIN.name() + "/*", "/favicon.ico", "/index.htm", "/robots.txt", "/Report", "/REPORT"});
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        ContextHandler contextHandler = new ContextHandler(EDAL_PATH_SEPARATOR);
        contextHandler.setHandler((Handler)new EdalJettyHandler());
        HandlerCollection collection = new HandlerCollection();
        collection.addHandler((Handler)contextHandler);
        collection.addHandler((Handler)requestLogHandler);
        if (this.useSSL) {
            SslContextFactory contextFactory = new SslContextFactory();
            KeyStore keystore = null;
            try {
                keystore = KeyStore.getInstance("JKS");
                keystore.load(new FileInputStream(configuration.getCertificatePathForHttpListener().getPath()), configuration.getKeystorePasswordForHttpListener().toCharArray());
            }
            catch (IOException | GeneralSecurityException e) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to load/open keystore : " + e.getMessage()));
            }
            contextFactory.setKeyStore(keystore);
            contextFactory.setKeyStorePassword(configuration.getKeystorePasswordForHttpListener());
            ServerConnector sslConnector = new ServerConnector(this.eDALServer, contextFactory);
            try {
                sslConnector.setPort(configuration.getHttpPort());
                this.eDALServer.setConnectors(new Connector[]{sslConnector});
                this.eDALServer.setHandler((Handler)collection);
                this.setURL(new URL("https://" + this.domainNameToUse + ":" + configuration.getHttpPort()));
            }
            catch (EdalConfigurationException | MalformedURLException e) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to initialize HTTPS-server : " + e.getMessage()));
            }
        } else {
            ServerConnector connector = new ServerConnector(this.eDALServer);
            try {
                connector.setPort(configuration.getHttpPort());
                this.eDALServer.setConnectors(new Connector[]{connector});
                this.eDALServer.setHandler((Handler)collection);
                this.setURL(new URL("http://" + this.domainNameToUse + ":" + configuration.getHttpPort()));
            }
            catch (EdalConfigurationException | MalformedURLException e) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to initialize HTTP-server : " + e.getMessage()));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfDomainIsRegisteredByDataCite(InetAddress localhost, List<String> domainNames) {
        try {
            block3: {
                String domain;
                Iterator<String> iterator = domainNames.iterator();
                do {
                    if (!iterator.hasNext()) break block3;
                    domain = iterator.next();
                    if (!EdalJettyServer.checkIfLocalhostIsInDomain(localhost, domain) && !EdalJettyServer.checkIfLocalhostHasSubDomain(localhost, domain)) continue;
                    this.domainNameToUse = localhost.getCanonicalHostName();
                    return true;
                } while (!EdalJettyServer.checkIfDomainIsAliasForLocalhost(localhost, domain));
                this.domainNameToUse = domain;
                return true;
            }
            DataManager.getImplProv().getLogger().error((Object)("e!DAL is running on '" + localhost.getCanonicalHostName() + "' and not one of your registrated DataCite Domain(s) '" + domainNames + "'"));
            System.exit(0);
        }
        catch (UnknownHostException unknownHostException) {
            DataManager.getImplProv().getLogger().error((Object)"Unable to validate registered domain names");
            System.exit(0);
        }
        System.exit(0);
        return false;
    }

    public static boolean checkIfLocalhostIsInDomain(InetAddress localhost, String domain) {
        return localhost.getCanonicalHostName().endsWith(domain) || domain.equals("*");
    }

    public static boolean checkIfDomainIsAliasForLocalhost(InetAddress localhost, String domain) throws UnknownHostException {
        return localhost.getCanonicalHostName().endsWith(InetAddress.getByName(domain).getCanonicalHostName());
    }

    public static boolean checkIfLocalhostHasSubDomain(InetAddress localhost, String domain) throws UnknownHostException {
        return localhost.getCanonicalHostName().endsWith(domain);
    }

    protected void start() {
        try {
            this.eDALServer.start();
            if (this.useSSL) {
                DataManager.getImplProv().getLogger().info((Object)("HTTPS-Server is listening on : " + EdalJettyServer.getServerURL()));
            } else {
                DataManager.getImplProv().getLogger().info((Object)("HTTP-Server is listening on : " + EdalJettyServer.getServerURL()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.useSSL) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to start HTTPS Server : " + e.getMessage()));
            } else {
                DataManager.getImplProv().getLogger().error((Object)("Unable to start HTTP Server : " + e.getMessage()));
            }
            System.exit(0);
        }
    }

    protected void stop() {
        try {
            this.eDALServer.stop();
        }
        catch (Exception e) {
            if (this.useSSL) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to stop HTTPS-Server : " + e.getMessage()));
            }
            DataManager.getImplProv().getLogger().error((Object)("Unable to stop HTTP-Server : " + e.getMessage()));
        }
    }

    private void setURL(URL url) {
        EdalJettyServer.url = url;
    }

    public static URL getServerURL() throws EdalException {
        if (url != null) {
            return url;
        }
        throw new EdalException("no eDAL HTTP server started");
    }

    public static URL generateMethodURL(String ticket, int reviewerCode, EdalHttpFunctions method) throws EdalException {
        try {
            URI uri = new URI(EdalJettyServer.getServerURL().toString());
            URL methodURL = new URL(String.valueOf(uri.getScheme()) + "://" + uri.getHost() + ":" + uri.getPort() + EDAL_PATH_SEPARATOR + (Object)((Object)method) + EDAL_PATH_SEPARATOR + ticket + EDAL_PATH_SEPARATOR + reviewerCode);
            return methodURL;
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new EdalException("unable to generate URL for " + (Object)((Object)method), e);
        }
    }

    public static URL generateReviewerURL(URL entityURL, int reviewersCode) throws EdalException {
        try {
            URL reviewerUrl = new URL(String.valueOf(entityURL.toString()) + EDAL_PATH_SEPARATOR + reviewersCode);
            return reviewerUrl;
        }
        catch (MalformedURLException e) {
            throw new EdalException("unable to generate ReviewerURL", e);
        }
    }
}

