/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.Location;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;

public class GenerateLocations {
    private static DatabaseReader reader = null;

    static {
        try {
            reader = new DatabaseReader.Builder(GenerateLocations.class.getResourceAsStream("GeoLite2-City.mmdb")).build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String generateGpsLocations(HashSet<String> ipList) {
        StringBuffer locationXML = new StringBuffer();
        locationXML.append("<markers>");
        for (String ip : ipList) {
            try {
                InetAddress ipAddress = InetAddress.getByName(ip);
                CityResponse response = reader.city(ipAddress);
                Location location = response.getLocation();
                if (location == null) continue;
                String str = "";
                String cityName = response.getCity().getName();
                if (cityName != null) {
                    if (cityName.contains("'")) {
                        cityName = cityName.replace("'", " ");
                    }
                    str = "<marker lat='" + location.getLatitude() + "' lng='" + location.getLongitude() + "' title='" + cityName + "' percent='" + "'></marker>";
                } else {
                    str = "<marker lat='" + location.getLatitude() + "' lng='" + location.getLongitude() + "' title='' percent='" + "'></marker>";
                }
                locationXML.append(str);
            }
            catch (Exception exception) {}
        }
        locationXML.append("</markers>");
        return locationXML.toString();
    }
}

