/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReferenceException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.mail.internet.InternetAddress;

public class PrimaryDataEntityVersion
implements Comparable<PrimaryDataEntityVersion>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Calendar creationDate;
    private long revision = 0L;
    private boolean isDeleted = false;
    private Calendar revisionDate;
    private MetaData metaData = null;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private List<PublicReference> publicReferences;
    private PrimaryDataEntity entity;
    private Principal owner;

    protected PrimaryDataEntityVersion() {
        this.creationDate = Calendar.getInstance();
        this.revisionDate = this.creationDate;
        this.publicReferences = new ArrayList<PublicReference>(0);
    }

    protected PrimaryDataEntityVersion(PrimaryDataEntity entity, boolean delete, MetaData metadata) throws PrimaryDataEntityVersionException {
        this();
        this.metaData = metadata;
        if (entity.getVersions() == null || entity.getVersions().isEmpty()) {
            this.creationDate = Calendar.getInstance();
            this.revision = 0L;
            this.isDeleted = delete;
            this.revisionDate = this.creationDate;
        } else {
            PrimaryDataEntityVersion lastVersion = entity.getVersions().last();
            if (lastVersion.isDeleted()) {
                throw new PrimaryDataEntityVersionException("entity " + entity.getName() + " was already deleted at: " + lastVersion.getRevisionDate());
            }
            this.creationDate = lastVersion.getCreationDate();
            this.revision = lastVersion.getRevision() + 1L;
            this.revisionDate = Calendar.getInstance();
            this.isDeleted = delete;
            this.setEntity(entity);
        }
        Iterator<Principal> iterator = DataManager.getSubject().getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal principal = iterator.next();
            this.setOwner(principal);
        }
    }

    protected void addPublicReference(PersistentIdentifier identifierType, PrimaryDataEntity entity) throws PrimaryDataEntityException {
        PublicReference pub;
        List<PublicReference> list = this.getPublicReferences();
        try {
            pub = new PublicReference(this, identifierType);
        }
        catch (EdalException e) {
            throw new PrimaryDataEntityException("unable to create PublicReference: " + e.getMessage(), e);
        }
        if (list.contains(pub)) {
            throw new PrimaryDataEntityException("There is already a PublicReference of the type '" + identifierType.toString() + "' stored !");
        }
        PrimaryDataEntityVersion newFileVersion = null;
        try {
            newFileVersion = new PrimaryDataEntityVersion(entity, false, this.getMetaData().clone());
            for (PublicReference publicReference : this.getPublicReferences()) {
                newFileVersion.publicReferences.add(publicReference);
            }
            newFileVersion.publicReferences.add(pub);
            entity.commitVersion(newFileVersion);
        }
        catch (Exception e) {
            throw new PrimaryDataEntityException("unable to store PublicReference", e);
        }
    }

    @Override
    public int compareTo(PrimaryDataEntityVersion o) {
        if (o.revision == this.revision) {
            return 0;
        }
        return this.revision < o.revision ? -1 : 1;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public PrimaryDataEntity getEntity() {
        return this.entity;
    }

    public final String getName() {
        try {
            return ((UntypedData)this.getMetaData().getElementValue(EnumDublinCoreElements.TITLE)).toString();
        }
        catch (MetaDataException metaDataException) {
            return "";
        }
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public PublicReference getPublicReference(PersistentIdentifier identifierType) throws PrimaryDataEntityVersionException {
        List<PublicReference> list = this.getPublicReferences();
        if (list.isEmpty()) {
            throw new PrimaryDataEntityVersionException("no PublicReference of type '" + (Object)((Object)identifierType) + "' for this version defined");
        }
        for (PublicReference publicReference : list) {
            if (!publicReference.getIdentifierType().equals((Object)identifierType)) continue;
            return publicReference;
        }
        throw new PrimaryDataEntityVersionException("no PublicReference of type '" + (Object)((Object)identifierType) + "' for this version defined");
    }

    public List<PublicReference> getPublicReferences() {
        return Collections.unmodifiableList(this.publicReferences);
    }

    final ReentrantReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public long getRevision() {
        return this.revision;
    }

    public Calendar getRevisionDate() {
        return this.revisionDate;
    }

    public URL getURL() throws PrimaryDataEntityException {
        URL url;
        int port = 0;
        try {
            port = DataManager.getConfiguration().getHttpPort();
        }
        catch (EdalConfigurationException e) {
            throw new PrimaryDataEntityException("unable to get HTTP port", e);
        }
        String requestURL = EdalHttpFunctions.EDAL.toString();
        InetSocketAddress addr = new InetSocketAddress(port);
        String hostName = "";
        try {
            addr.getAddress();
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new PrimaryDataEntityException("unable to load host URL", e);
        }
        try {
            String useSSL = "http://";
            if (DataManager.getConfiguration().isUseSSL()) {
                useSSL = "https://";
            }
            url = new URL(String.valueOf(useSSL) + hostName + ":" + port + "/" + requestURL + "/" + this.getEntity().getID() + "/" + this.getRevision());
        }
        catch (MalformedURLException e) {
            throw new PrimaryDataEntityException("unable to generate version URL", e);
        }
        return url;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setAllReferencesPublic(InternetAddress emailNotificationAddress, Calendar releaseDate) throws PublicReferenceException {
        for (PublicReference publicReference : this.getPublicReferences()) {
            publicReference.setPublic(emailNotificationAddress, releaseDate);
        }
    }

    public void setAllReferencesPublic(InternetAddress emailNotificationAddress) throws PublicReferenceException {
        this.setAllReferencesPublic(emailNotificationAddress, null);
    }

    protected void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    protected void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    protected void setEntity(PrimaryDataEntity entity) {
        this.entity = entity;
    }

    protected void setMetaData(MetaData metadata) {
        this.metaData = metadata;
    }

    protected void setPublicReferences(List<PublicReference> references) {
        this.publicReferences = references;
    }

    protected void setRevision(long revision) {
        this.revision = revision;
    }

    protected void setRevisionDate(Calendar revisionDate) {
        this.revisionDate = revisionDate;
    }

    public String toString() {
        String output = "";
        try {
            output = "PrimaryDataEntityVersion [creationDate=" + this.getCreationDate().getTime() + ", revision=" + this.getRevision() + ", isDeleted=" + this.isDeleted() + ", revisionDate=" + this.getRevisionDate().getTime() + ", metaData=" + this.getMetaData().getElementValue(EnumDublinCoreElements.TITLE) + "]";
        }
        catch (MetaDataException e) {
            e.printStackTrace();
        }
        return output;
    }

    public Principal getOwner() {
        return this.owner;
    }

    protected void setOwner(Principal owner) {
        this.owner = owner;
    }
}

