/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReferenceException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ApprovalServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalReferenceable;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Calendar;
import java.util.Iterator;
import java.util.UUID;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class PublicReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PrimaryDataEntityVersion version = null;
    protected PersistentIdentifier identifierType = null;
    private boolean isPublic = false;
    private Calendar creationDate = Calendar.getInstance();
    private Calendar requestedDate;
    private Calendar acceptedDate;
    private Calendar rejectedDate;
    private Calendar releaseDate;
    private PublicationStatus publicationStatus;
    private Principal requestedPrincipal;
    private String assignedID = null;
    private String internalID;

    protected PublicReference() {
        this.setPublicationStatus(PublicationStatus.SUBMITTED);
        this.releaseDate = null;
    }

    protected PublicReference(PrimaryDataEntityVersion entityVersion, PersistentIdentifier identifierType) throws EdalException {
        this();
        try {
            Method validateMethod = identifierType.getImplClass().getMethod("validateMetaData", PrimaryDataEntityVersion.class);
            validateMethod.invoke((Object)identifierType.getImplClass().newInstance(), entityVersion);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new EdalException("unable to validate metadata: " + e.getCause().getMessage(), e);
        }
        this.setIdentifierType(identifierType);
        this.setVersion(entityVersion);
        Iterator<Principal> iterator = DataManager.getSubject().getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal p = iterator.next();
            this.setRequestedPrincipal(p);
        }
        this.setInternalID(UUID.randomUUID().toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        PublicReference other = (PublicReference)obj;
        return this.getIdentifierType() == other.getIdentifierType();
    }

    public Calendar getAcceptedDate() {
        return this.acceptedDate;
    }

    public String getAssignedID() throws PublicReferenceException {
        if (this.assignedID == null) {
            throw new PublicReferenceException("id not yet assigned. please request approval first");
        }
        return this.assignedID;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public PersistentIdentifier getIdentifierType() {
        return this.identifierType;
    }

    public PublicationStatus getPublicationStatus() {
        return this.publicationStatus;
    }

    public EdalReferenceable getReferencable() throws EdalException {
        try {
            return this.identifierType.getImplClass().newInstance();
        }
        catch (Exception e) {
            throw new EdalException("unable to load the class for the identifierType '" + (Object)((Object)this.identifierType) + "' : " + e.getMessage());
        }
    }

    public Calendar getRejectedDate() {
        return this.rejectedDate;
    }

    public Calendar getRequestedDate() {
        return this.requestedDate;
    }

    public Principal getRequestedPrincipal() {
        return this.requestedPrincipal;
    }

    public PrimaryDataEntityVersion getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getInternalID() == null ? 0 : this.getInternalID().hashCode());
        return result;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    protected void setAcceptedDate(Calendar acceptedDate) {
        this.acceptedDate = acceptedDate;
    }

    protected void setAssignedID(String assignedID) {
        this.assignedID = assignedID;
    }

    protected void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    private void setIdentifierType(PersistentIdentifier identifierType) {
        this.identifierType = identifierType;
    }

    public void setPublic(InternetAddress emailNotificationAddress, Calendar releaseDate) throws PublicReferenceException {
        this.setReleaseDate(releaseDate);
        try {
            emailNotificationAddress.validate();
        }
        catch (AddressException e) {
            throw new PublicReferenceException("could not validate eMail adress", e);
        }
        try {
            ApprovalServiceProvider appService = DataManager.getImplProv().getApprovalServiceProvider().newInstance();
            appService.approve(this, emailNotificationAddress);
        }
        catch (EdalException | IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new PublicReferenceException("unable to request approval", e);
        }
    }

    public void setPublic(InternetAddress emailNotificationAddress) throws PublicReferenceException {
        this.setPublic(emailNotificationAddress, null);
    }

    protected void setRejectedDate(Calendar rejectedDate) {
        this.rejectedDate = rejectedDate;
    }

    protected void setRequestedDate(Calendar requestedDate) {
        this.requestedDate = requestedDate;
    }

    protected void setRequestedPrincipal(Principal requestedPrincipal) {
        this.requestedPrincipal = requestedPrincipal;
    }

    public void setVersion(PrimaryDataEntityVersion version) {
        this.version = version;
    }

    public String toString() {
        return "PublicReference [version=" + this.version + ", identifierType=" + (Object)((Object)this.identifierType) + ", isPublic=" + this.isPublic + ", creationDate=" + this.creationDate.getTime() + "]";
    }

    protected void setPublicationStatus(PublicationStatus publicationStatus) {
        this.publicationStatus = publicationStatus;
    }

    public String getInternalID() {
        return this.internalID;
    }

    protected void setInternalID(String internalID) {
        this.internalID = internalID;
    }

    public Calendar getReleaseDate() {
        return this.releaseDate;
    }

    protected void setReleaseDate(Calendar releaseDate) {
        this.releaseDate = releaseDate;
    }

    public void changeReleaseDate(Calendar releaseDate) {
        this.releaseDate = releaseDate;
    }
}

