/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.HttpServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewersImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import java.util.Calendar;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class HttpServiceProviderImplementation
implements HttpServiceProvider {
    @Override
    public PrimaryDataEntity getPrimaryDataEntityByID(String uuid, long versionNumber) throws EdalException {
        PrimaryDataEntityVersion version;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Criteria getFile = session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid));
        PrimaryDataFile file = (PrimaryDataFile)getFile.uniqueResult();
        if (file == null) {
            PrimaryDataEntityVersion version2;
            Criteria getDirectory = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid));
            PrimaryDataDirectory directory = (PrimaryDataDirectory)getDirectory.uniqueResult();
            if (directory == null) {
                throw new EdalException("found no entity with ID '" + uuid + "'");
            }
            try {
                version2 = directory.getVersionByRevisionNumber(versionNumber);
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException(e.getMessage(), e);
            }
            try {
                directory.switchCurrentVersion(version2);
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException("unable to switch the version with the number " + versionNumber, e);
            }
            List<PublicReference> list = directory.getCurrentVersion().getPublicReferences();
            for (PublicReference publicReference : list) {
                if (!publicReference.isPublic()) continue;
                if (publicReference.getReleaseDate() == null) {
                    return directory;
                }
                if (publicReference.getReleaseDate().after(Calendar.getInstance())) {
                    throw new EdalException("the PublicReference for this version of '" + directory.getName() + "' is locked until " + publicReference.getReleaseDate().getTime());
                }
                return directory;
            }
            throw new EdalException("found no PublicReference for this version of " + directory.getName());
        }
        try {
            version = file.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException(e.getMessage(), e);
        }
        try {
            file.switchCurrentVersion(version);
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException("unable to switch the version with the number " + versionNumber, e);
        }
        List<PublicReference> list = file.getCurrentVersion().getPublicReferences();
        for (PublicReference publicReference : list) {
            if (!publicReference.isPublic()) continue;
            if (publicReference.getReleaseDate() == null) {
                return file;
            }
            if (publicReference.getReleaseDate().after(Calendar.getInstance())) {
                throw new EdalException("the PublicReference for this version of '" + file.getName() + "' is locked until " + publicReference.getReleaseDate().getTime());
            }
            return file;
        }
        throw new EdalException("found no PublicReference for this version of " + file.getName());
    }

    @Override
    public PrimaryDataEntity getPrimaryDataEntityForPersistenIdentifier(String uuid, long versionNumber, PersistentIdentifier persistentIdentifier) throws EdalException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        PrimaryDataFile file = (PrimaryDataFile)session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid)).uniqueResult();
        if (file == null) {
            PrimaryDataDirectory directory = (PrimaryDataDirectory)session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid)).uniqueResult();
            if (directory == null) {
                session.close();
                throw new EdalException("no entity with ID '" + uuid + "' found !");
            }
            try {
                PublicReference reference = directory.getVersionByRevisionNumber(versionNumber).getPublicReference(persistentIdentifier);
                if (reference.isPublic()) {
                    if (reference.getReleaseDate() == null) {
                        session.close();
                        return directory;
                    }
                    if (reference.getReleaseDate().after(Calendar.getInstance())) {
                        session.close();
                        throw new EdalException("the PublicReference for this version of '" + directory.getName() + "' is locked until " + reference.getReleaseDate().getTime());
                    }
                    session.close();
                    return directory;
                }
                return this.searchRekursiveForPersistentIdentifiers(session, directory, versionNumber, persistentIdentifier);
            }
            catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
                return this.searchRekursiveForPersistentIdentifiers(session, directory, versionNumber, persistentIdentifier);
            }
        }
        try {
            PublicReference reference = file.getVersionByRevisionNumber(versionNumber).getPublicReference(persistentIdentifier);
            if (reference.isPublic()) {
                if (reference.getReleaseDate() == null) {
                    session.close();
                    return file;
                }
                if (reference.getReleaseDate().after(Calendar.getInstance())) {
                    session.close();
                    throw new EdalException("the PublicReference for this version of '" + file.getName() + "' is locked until " + reference.getReleaseDate().getTime());
                }
                session.close();
                return file;
            }
            return this.searchRekursiveForPersistentIdentifiers(session, file, versionNumber, persistentIdentifier);
        }
        catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
            return this.searchRekursiveForPersistentIdentifiers(session, file, versionNumber, persistentIdentifier);
        }
    }

    @Override
    public PrimaryDataEntity getPrimaryDataEntityForReviewer(String uuid, long versionNumber, String internalId, int reviewerCode) throws EdalException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        ReviewersImplementation reviewer = (ReviewersImplementation)session.createCriteria(ReviewersImplementation.class).add((Criterion)Restrictions.eq((String)"hashCode", (Object)reviewerCode)).uniqueResult();
        if (reviewer != null) {
            PrimaryDataFile file = (PrimaryDataFile)session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid)).uniqueResult();
            if (file != null) {
                try {
                    PrimaryDataEntityVersion version = file.getVersionByRevisionNumber(versionNumber);
                    file.switchCurrentVersion(version);
                    session.close();
                    return file;
                }
                catch (PrimaryDataEntityVersionException e) {
                    session.close();
                    throw new EdalException(e.getMessage(), e);
                }
            }
            PrimaryDataDirectory directory = (PrimaryDataDirectory)session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid)).uniqueResult();
            if (directory == null) {
                session.close();
                throw new EdalException("no entity with ID '" + uuid + "' found !");
            }
            try {
                PrimaryDataEntityVersion version = directory.getVersionByRevisionNumber(versionNumber);
                directory.switchCurrentVersion(version);
                session.close();
                return directory;
            }
            catch (PrimaryDataEntityVersionException e) {
                session.close();
                throw new EdalException(e.getMessage(), e);
            }
        }
        session.close();
        throw new EdalException("no reviewer with ID '" + reviewerCode + "' found !");
    }

    /*
     * Unable to fully structure code
     */
    private PrimaryDataEntity searchRekursiveForPersistentIdentifiers(Session session, PrimaryDataEntity entity, long versionNumber, PersistentIdentifier persistentIdentifier) throws EdalException {
        version = null;
        try {
            version = entity.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            session.close();
            throw new EdalException(e.getMessage());
        }
        ready = false;
        parent = null;
        try {
            parent = entity.getParentDirectory();
            if (parent == null) {
                session.close();
                throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
            }
            ** GOTO lbl49
        }
        catch (PrimaryDataDirectoryException v0) {
            session.close();
            throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
        }
lbl-1000:
        // 1 sources

        {
            set = parent.getVersions();
            found = false;
            for (PrimaryDataEntityVersion primaryDataEntityVersion : set) {
                try {
                    if (!primaryDataEntityVersion.getPublicReference(persistentIdentifier).isPublic() || !primaryDataEntityVersion.getRevisionDate().after(version.getRevisionDate())) continue;
                    if (primaryDataEntityVersion.getPublicReference(persistentIdentifier).getReleaseDate() != null && primaryDataEntityVersion.getPublicReference(persistentIdentifier).getReleaseDate().after(Calendar.getInstance())) {
                        throw new EdalException("the PublicReference for this version of '" + parent.getName() + "' is locked until " + primaryDataEntityVersion.getPublicReference(persistentIdentifier).getReleaseDate().getTime());
                    }
                    found = true;
                }
                catch (PrimaryDataEntityVersionException v1) {
                    DataManager.getImplProv().getLogger().debug((Object)("no public reference found for '" + parent + "', trying next"));
                }
            }
            if (!found) {
                try {
                    parent = parent.getParentDirectory();
                }
                catch (PrimaryDataDirectoryException v2) {
                    session.close();
                    throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
                }
                if (parent != null) continue;
                session.close();
                throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
            }
            session.close();
            ready = true;
lbl49:
            // 3 sources

            ** while (!ready)
        }
lbl50:
        // 1 sources

        return entity;
    }
}

