/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyUntypedData;
import java.net.URL;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.lucene.index.IndexReader;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.indexes.IndexReaderAccessor;

public class IndexWriterThread
extends Thread {
    private static final int SLEEP_RUNTIME_FACTOR = 2;
    private static final long MIN_THREAD_SLEEP = 500L;
    private static final long MAX_THREAD_SLEEP = 2000L;
    private SessionFactory sessionFactory;
    private int currentID = 0;
    private Logger threadLog = null;
    private final ReentrantLock lock = new ReentrantLock(true);

    protected IndexWriterThread(SessionFactory sessionFactory) {
        PropertyConfigurator.configure((URL)EdalConfiguration.class.getResource("log4j.properties"));
        this.setThreadLog(Logger.getLogger((String)"IndexWriterThread"));
        this.setSessionFactory(sessionFactory);
        Session session = this.getSessionFactory().openSession();
        SearchFactory searchFactory = Search.getFullTextSession((Session)session).getSearchFactory();
        IndexReaderAccessor readerProvider = searchFactory.getIndexReaderAccessor();
        IndexReader reader = readerProvider.open(new Class[]{MyUntypedData.class});
        try {
            this.setCurrentID(reader.numDocs());
            this.getThreadLog().debug((Object)"START IndexWriterThread ...");
            this.getThreadLog().debug((Object)("Current docs : " + this.getCurrentID()));
        }
        finally {
            readerProvider.close(reader);
            session.close();
        }
    }

    private void executeIndexing() {
        if (!this.getSessionFactory().isClosed()) {
            Session session = this.getSessionFactory().openSession();
            session.setDefaultReadOnly(true);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            fullTextSession.setFlushMode(FlushMode.MANUAL);
            fullTextSession.setCacheMode(CacheMode.NORMAL);
            this.getThreadLog().debug((Object)"START Indexing...");
            long queryStartTime = System.currentTimeMillis();
            ScrollableResults results = fullTextSession.createCriteria(MyUntypedData.class).add((Criterion)Restrictions.gt((String)"id", (Object)this.getCurrentID())).setFetchSize(500).scroll(ScrollMode.FORWARD_ONLY);
            int index = 0;
            int countIndexedObjects = 0;
            long queryTime = System.currentTimeMillis() - queryStartTime;
            long indexStartTime = System.currentTimeMillis();
            while (results.next()) {
                fullTextSession.index(results.get(0));
                if (++index % 500 == 0) {
                    try {
                        fullTextSession.flushToIndexes();
                        fullTextSession.clear();
                    }
                    catch (Exception exception) {
                        throw new Error("Unable to read/write index files");
                    }
                }
                ++countIndexedObjects;
            }
            session.close();
            this.setCurrentID(this.getCurrentID() + countIndexedObjects);
            long indexingTime = System.currentTimeMillis() - indexStartTime;
            this.getThreadLog().info((Object)("INDEXING SUCCESSFUL : Objects|Index|Query : " + index + " | " + indexingTime + " ms | " + queryTime + " ms"));
            try {
                Thread.sleep(Math.min(Math.max(indexingTime * 2L, 500L), 2000L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private ReentrantLock getLock() {
        return this.lock;
    }

    private int getCurrentID() {
        return this.currentID;
    }

    private SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private Logger getThreadLog() {
        return this.threadLog;
    }

    @Override
    public void run() {
        while (!this.getSessionFactory().isClosed()) {
            this.getThreadLog().debug((Object)"try lock run method");
            this.getLock().lock();
            this.getThreadLog().debug((Object)"locked run method");
            this.executeIndexing();
            this.getThreadLog().debug((Object)"unlock run method");
            this.getLock().unlock();
        }
    }

    private void setCurrentID(int currentID) {
        this.currentID = currentID;
    }

    private void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private void setThreadLog(Logger threadLog) {
        this.threadLog = threadLog;
    }

    void waitForFinish() {
        long time = System.currentTimeMillis();
        this.getThreadLog().debug((Object)"Wait for finish current indexing...");
        this.lock.lock();
        this.getThreadLog().debug((Object)"Got lock for last indexing...");
        this.getThreadLog().debug((Object)"FINALZE indexing...");
        this.executeIndexing();
        this.getSessionFactory().close();
        this.lock.unlock();
        this.getThreadLog().debug((Object)("Index is finished after waiting : " + (System.currentTimeMillis() - time) + " ms"));
        this.getThreadLog().debug((Object)"unlock Lock");
    }
}

