/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.AsynchronList;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import java.util.Calendar;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ListThread
extends Thread {
    private static final String STRING_PARENT_DIRECTORY = "parentDirectory";
    private static final String STRING_CLASS = "class";
    private AsynchronList<PrimaryDataEntity> asynList = new AsynchronList();
    private PrimaryDataDirectory parentDirectory = null;
    private Calendar currentVersionDate = null;
    private Calendar nextVersionDate = null;

    public ListThread(PrimaryDataDirectory parentDirectory, Calendar currentVersionDate, Calendar nextVersionDate) {
        this.parentDirectory = parentDirectory;
        this.currentVersionDate = currentVersionDate;
        this.nextVersionDate = nextVersionDate;
    }

    public AsynchronList<PrimaryDataEntity> getAsynchronList() {
        return this.asynList;
    }

    @Override
    public void run() {
        try {
            Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session.setDefaultReadOnly(true);
            int firstPage = 0;
            int pagesSteps = 1000;
            Criteria directoryQuery = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this.parentDirectory)).setCacheable(true).setCacheRegion("query.list").setFirstResult(firstPage).setMaxResults(pagesSteps);
            List directories = null;
            while ((directories = directoryQuery.list()).size() > 0) {
                session.clear();
                System.gc();
                block11: for (PrimaryDataDirectoryImplementation directory : directories) {
                    if (this.nextVersionDate == null) {
                        try {
                            directory.switchCurrentVersion(directory.getVersionByRevisionNumber(directory.getVersions().size() - 1));
                            this.asynList.add(directory);
                            this.asynList.notifyNewDataAvailable();
                            continue;
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Can not switch version of '" + this + "' :" + e.getMessage());
                        }
                    }
                    for (PrimaryDataEntityVersion version : directory.getVersions()) {
                        if (!version.getRevisionDate().before(this.nextVersionDate) || !version.getRevisionDate().after(this.currentVersionDate)) continue;
                        try {
                            directory.switchCurrentVersion(version);
                            this.asynList.add(directory);
                            this.asynList.notifyNewDataAvailable();
                            continue block11;
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Can not switch version of '" + this + "' :" + e.getMessage());
                        }
                    }
                }
                if (this.asynList.isStopped()) {
                    DataManager.getImplProv().getLogger().warn((Object)"Stopped ListThread !");
                    break;
                }
                directoryQuery.setFirstResult(firstPage += pagesSteps);
            }
            firstPage = 0;
            Criteria fileQuery = session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this.parentDirectory)).setCacheable(true).setCacheRegion("query.list").setFirstResult(firstPage).setMaxResults(pagesSteps);
            List files = null;
            while ((files = fileQuery.list()).size() > 0) {
                session.clear();
                System.gc();
                block14: for (PrimaryDataFileImplementation file : files) {
                    if (this.nextVersionDate == null) {
                        try {
                            file.switchCurrentVersion(file.getVersionByRevisionNumber(file.getVersions().size() - 1));
                            this.asynList.add(file);
                            this.asynList.notifyNewDataAvailable();
                            continue;
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Can not switch version of '" + this + "' :" + e.getMessage());
                        }
                    }
                    for (PrimaryDataEntityVersion version : file.getVersions()) {
                        if (!version.getRevisionDate().before(this.nextVersionDate) || !version.getRevisionDate().after(this.currentVersionDate)) continue;
                        try {
                            file.switchCurrentVersion(version);
                            this.asynList.add(file);
                            this.asynList.notifyNewDataAvailable();
                            continue block14;
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Can not switch version of '" + this + "' :" + e.getMessage());
                        }
                    }
                }
                if (this.asynList.isStopped()) {
                    DataManager.getImplProv().getLogger().warn((Object)"Stopped ListThread !");
                    break;
                }
                fileQuery.setFirstResult(firstPage += pagesSteps);
            }
            session.clear();
            session.close();
            System.gc();
            this.asynList.notifyNoMoreNewData();
        }
        catch (Exception e) {
            DataManager.getImplProv().getLogger().error((Object)("Can not list all PrimaryDataEntities of '" + this + "' :" + e.getMessage()));
        }
    }
}

