/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.PublicPermissionCheck;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ListThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.MetaDataImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataEntityVersionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDatePrecision;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDateRange;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Identifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.IdentifierRelation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEdalDateRange;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyIdentifierRelation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyLegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyNaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyUntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPermission;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.SortNatural;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;

@Entity
@Table(name="ENTITIES")
@DiscriminatorColumn(columnDefinition="char(1)", name="TYPE", discriminatorType=DiscriminatorType.CHAR)
@DiscriminatorValue(value="D")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="PrimaryDataDirectory")
public class PrimaryDataDirectoryImplementation
extends PrimaryDataDirectory {
    private static final String STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION = "Unable to switch to current version";
    private static final String CACHE_REGION_SEARCH_ENTITY = "search.entity";
    private static final String STRING_ID = "id";
    private static final String STRING_PARENT_DIRECTORY = "parentDirectory";
    private static final String STRING_CLASS = "class";
    private static final String SUPPRESS_UNCHECKED_WARNING = "unchecked";
    private static final int MAX_NUMBER_SEARCH_RESULTS = 1000;
    private SortedSet<PrimaryDataEntityVersionImplementation> versionList;

    protected PrimaryDataDirectoryImplementation() {
    }

    public PrimaryDataDirectoryImplementation(PrimaryDataDirectory path, String name) throws PrimaryDataEntityVersionException, PrimaryDataDirectoryException, MetaDataException {
        super(path, name);
    }

    @Override
    @Id
    @Column(columnDefinition="char(40)")
    public String getID() {
        String string;
        PublicPermissionCheck.ajc$cflowCounter$5.inc();
        try {
            string = super.getID();
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$5.dec();
        }
        return string;
    }

    @Override
    @OneToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    public PrimaryDataDirectoryImplementation getParentDirectory() {
        try {
            return (PrimaryDataDirectoryImplementation)super.getParentDirectory();
        }
        catch (PrimaryDataDirectoryException primaryDataDirectoryException) {
            return null;
        }
    }

    @Override
    @Transient
    protected Map<Principal, List<EdalPermission>> getPermissionsImpl() throws PrimaryDataEntityException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Criteria query = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)this.getID())).add((Criterion)Restrictions.eq((String)"internVersion", (Object)this.getCurrentVersion().getRevision()));
        List privatePerms = query.list();
        HashMap<Principal, List<EdalPermission>> publicMap = new HashMap<Principal, List<EdalPermission>>();
        try {
            for (EdalPermissionImplementation p : privatePerms) {
                if (publicMap.containsKey(p.getPrincipal().toPrincipal())) continue;
                Criteria tmpQuery = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)this.getID())).add((Criterion)Restrictions.eq((String)"internVersion", (Object)this.getCurrentVersion().getRevision())).add((Criterion)Restrictions.eq((String)"principal", (Object)p.getPrincipal()));
                List userPerms = tmpQuery.list();
                ArrayList<EdalPermission> publicPerms = new ArrayList<EdalPermission>(privatePerms.size());
                for (EdalPermissionImplementation permission : userPerms) {
                    publicPerms.add(permission.toEdalPermission());
                }
                publicMap.put(p.getPrincipal().toPrincipal(), publicPerms);
            }
        }
        catch (Exception e) {
            session.close();
            throw new PrimaryDataEntityException("Unable to load permissions !", e);
        }
        session.close();
        return publicMap;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="primaryEntityId")
    @SortNatural
    protected SortedSet<PrimaryDataEntityVersionImplementation> getVersionList() {
        return this.versionList;
    }

    @Override
    @Transient
    protected SortedSet<PrimaryDataEntityVersion> getVersionsImpl() {
        if (this.getVersionList() == null) {
            return new TreeSet<PrimaryDataEntityVersion>();
        }
        return new TreeSet<PrimaryDataEntityVersion>((Collection<PrimaryDataEntityVersion>)this.getVersionList());
    }

    @Override
    protected List<PrimaryDataEntity> listPrimaryDataEntitiesImpl(Calendar currentVersionDate, Calendar nextVersionDate) throws PrimaryDataDirectoryException {
        ListThread thread = new ListThread(this, currentVersionDate, nextVersionDate);
        DataManager.getListThreadPool().execute(thread);
        return thread.getAsynchronList();
    }

    @Override
    protected void moveImpl(PrimaryDataDirectory destinationDirectory) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        this.setParentDirectory(destinationDirectory);
        session.update((Object)this);
        transaction.commit();
        session.close();
    }

    private List<MyDataFormat> searchByDataFormat(DataFormat dataFormat, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        TermQuery query = null;
        if (fuzzy) {
            QueryParser queryParser = new QueryParser(Version.LUCENE_36, "mimeType", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser.setAllowLeadingWildcard(true);
            query = this.consistsQueryParserSyntax(dataFormat.getMimeType()) ? queryParser.parse(dataFormat.getMimeType()) : queryParser.parse("*" + dataFormat.getMimeType() + "*");
        } else {
            query = new TermQuery(new Term("mimeType", dataFormat.getMimeType()));
        }
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery((Query)query, new Class[]{MyDataFormat.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private List<MyDataType> searchByDataType(DataType dataType) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        TermQuery query = new TermQuery(new Term("string", dataType.getDataType().toString().toLowerCase()));
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery((Query)query, new Class[]{MyDataType.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private List<MyDateEvents> searchByDateEvents(DateEvents dateEvents) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        ArrayList<MyDateEvents> result = new ArrayList<MyDateEvents>();
        Set<EdalDate> set = dateEvents.getSet();
        if (set.size() > 1) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().warn((Object)"no DateEvents with multiple BasicDates allowed");
        } else if (set.size() == 1) {
            for (EdalDate edalDate : set) {
                List idlist;
                SQLQuery metaDataQuery;
                List<MyEdalDate> list;
                if (edalDate instanceof EdalDateRange) {
                    list = this.searchByEDALDateRange((EdalDateRange)edalDate);
                    metaDataQuery = session.createSQLQuery("select D.UNTYPEDDATA_ID from UNTYPEDDATA_MYEDALDATE D where D.SET_ID in (:list)");
                    metaDataQuery.setParameterList("list", list);
                    idlist = metaDataQuery.list();
                    for (Integer integer : idlist) {
                        result.add((MyDateEvents)session.get(MyDateEvents.class, (Serializable)integer));
                    }
                    continue;
                }
                if (!(edalDate instanceof EdalDate)) continue;
                list = this.searchByEDALDate(edalDate);
                metaDataQuery = session.createSQLQuery("select D.UNTYPEDDATA_ID from UNTYPEDDATA_MYEDALDATE D where D.SET_ID in (:list)");
                metaDataQuery.setParameterList("list", list);
                idlist = metaDataQuery.list();
                for (Integer integer : idlist) {
                    result.add((MyDateEvents)session.get(MyDateEvents.class, (Serializable)integer));
                }
            }
        }
        session.close();
        return result;
    }

    private List<MyEdalDate> searchByEDALDate(EdalDate edalDate) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Criteria myEDALDateCriteria = session.createCriteria(MyEdalDate.class);
        int precission = edalDate.getStartPrecision().ordinal();
        Calendar date = edalDate.getStartDate();
        if (precission == EdalDatePrecision.CENTURY.ordinal()) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().warn((Object)"no Dates with CENTURY Precission allowed");
            return new ArrayList<MyEdalDate>();
        }
        if (precission >= EdalDatePrecision.DECADE.ordinal()) {
            myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("SUBSTR(YEAR(startDate),1,3)=" + Integer.toString(date.get(1)).substring(0, 3))));
            if (precission >= EdalDatePrecision.YEAR.ordinal()) {
                myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("YEAR(startDate)=" + date.get(1))));
                if (precission >= EdalDatePrecision.MONTH.ordinal()) {
                    myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("MONTH(startDate)=" + (date.get(2) + 1))));
                    if (precission >= EdalDatePrecision.DAY.ordinal()) {
                        myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("DAY(startDate)=" + date.get(5))));
                        if (precission >= EdalDatePrecision.HOUR.ordinal()) {
                            myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("HOUR(startDate)=" + date.get(11))));
                            if (precission >= EdalDatePrecision.MINUTE.ordinal()) {
                                myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("MINUTE(startDate)=" + date.get(12))));
                                if (precission >= EdalDatePrecision.SECOND.ordinal()) {
                                    myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("SECOND(startDate)=" + date.get(13))));
                                    if (precission >= EdalDatePrecision.MILLISECOND.ordinal()) {
                                        myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("MILLISECOND(startDate)=" + date.get(14))));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        List result = myEDALDateCriteria.list();
        session.close();
        return result;
    }

    private List<MyEdalDateRange> searchByEDALDateRange(EdalDateRange edalDateRange) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Criteria myEDALDateCriteria = session.createCriteria(MyEdalDateRange.class);
        int precissionStart = edalDateRange.getStartPrecision().ordinal();
        Calendar dateStart = edalDateRange.getStartDate();
        int precissionEnd = edalDateRange.getEndPrecision().ordinal();
        Calendar dateEnd = edalDateRange.getEndDate();
        if (precissionStart == EdalDatePrecision.CENTURY.ordinal() || precissionEnd == EdalDatePrecision.CENTURY.ordinal()) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().warn((Object)"no DateRanges with CENTURY Precission allowed");
            return new ArrayList<MyEdalDateRange>();
        }
        if (precissionStart >= EdalDatePrecision.DECADE.ordinal()) {
            myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("SUBSTR(YEAR(startDate),1,3)=" + Integer.toString(dateStart.get(1)).substring(0, 3))));
            if (precissionStart >= EdalDatePrecision.YEAR.ordinal()) {
                myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("YEAR(startDate)=" + dateStart.get(1))));
                if (precissionStart >= EdalDatePrecision.MONTH.ordinal()) {
                    myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("MONTH(startDate)=" + (dateStart.get(2) + 1))));
                    if (precissionStart >= EdalDatePrecision.DAY.ordinal()) {
                        myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("DAY(startDate)=" + dateStart.get(5))));
                        if (precissionStart >= EdalDatePrecision.HOUR.ordinal()) {
                            myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("HOUR(startDate)=" + dateStart.get(11))));
                            if (precissionStart >= EdalDatePrecision.MINUTE.ordinal()) {
                                myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("MINUTE(startDate)=" + dateStart.get(12))));
                                if (precissionStart >= EdalDatePrecision.SECOND.ordinal()) {
                                    myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("SECOND(startDate)=" + dateStart.get(13))));
                                    if (precissionStart >= EdalDatePrecision.MILLISECOND.ordinal()) {
                                        myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("MILLISECOND(startDate)=" + dateStart.get(14))));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (precissionEnd >= EdalDatePrecision.DECADE.ordinal()) {
            myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("SUBSTR(YEAR(endDate),1,3)=" + Integer.toString(dateEnd.get(1)).substring(0, 3))));
            if (precissionEnd >= EdalDatePrecision.YEAR.ordinal()) {
                myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("YEAR(endDate)=" + dateEnd.get(1))));
                if (precissionEnd >= EdalDatePrecision.MONTH.ordinal()) {
                    myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("MONTH(endDate)=" + (dateEnd.get(2) + 1))));
                    if (precissionEnd >= EdalDatePrecision.DAY.ordinal()) {
                        myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("DAY(endDate)=" + dateEnd.get(5))));
                        if (precissionEnd >= EdalDatePrecision.HOUR.ordinal()) {
                            myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("HOUR(endDate)=" + dateEnd.get(11))));
                            if (precissionEnd >= EdalDatePrecision.MINUTE.ordinal()) {
                                myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("MINUTE(endDate)=" + dateEnd.get(12))));
                                if (precissionEnd >= EdalDatePrecision.SECOND.ordinal()) {
                                    myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("SECOND(endDate)=" + dateEnd.get(13))));
                                    if (precissionEnd >= EdalDatePrecision.MILLISECOND.ordinal()) {
                                        myEDALDateCriteria.add(Restrictions.sqlRestriction((String)("MILLISECOND(endDate)=" + dateEnd.get(14))));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        List result = myEDALDateCriteria.list();
        session.close();
        return result;
    }

    private List<MyIdentifier> searchByIdentifier(Identifier identifier, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        TermQuery query = null;
        if (fuzzy) {
            QueryParser queryParser = new QueryParser(Version.LUCENE_36, "identifier", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser.setAllowLeadingWildcard(true);
            query = this.consistsQueryParserSyntax(identifier.getID()) ? queryParser.parse(identifier.getID()) : queryParser.parse("*" + identifier.getID() + "*");
        } else {
            query = new TermQuery(new Term("identifier", identifier.getID()));
        }
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery((Query)query, new Class[]{MyIdentifier.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private List<MyIdentifierRelation> searchByIdentifierRelation(IdentifierRelation identifierRelation, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        ArrayList<MyIdentifierRelation> result = new ArrayList<MyIdentifierRelation>();
        if (identifierRelation.getRelations().size() > 1) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().warn((Object)"only IdentifierRelations with only one Identifier allowed");
        } else if (identifierRelation.getRelations().size() == 1) {
            Identifier id = null;
            Iterator<Identifier> iterator = identifierRelation.iterator();
            while (iterator.hasNext()) {
                Identifier identifier;
                id = identifier = iterator.next();
            }
            List<MyIdentifier> myIdentifierList = this.searchByIdentifier(id, fuzzy);
            if (!myIdentifierList.isEmpty()) {
                org.hibernate.Query metaDataQuery = session.createQuery("select D.id from MyIdentifierRelation D join D.relations V where V in (:list)");
                metaDataQuery.setParameterList("list", myIdentifierList);
                List idlist = metaDataQuery.list();
                for (Integer integer : idlist) {
                    result.add((MyIdentifierRelation)session.get(MyIdentifierRelation.class, (Serializable)integer));
                }
            }
        }
        return result;
    }

    private List<MyNaturalPerson> searchByNaturalPerson(NaturalPerson naturalPerson, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        BooleanQuery query = new BooleanQuery();
        if (fuzzy) {
            QueryParser queryParser1 = new QueryParser(Version.LUCENE_36, "givenName", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser1.setAllowLeadingWildcard(true);
            Query givenName = null;
            givenName = this.consistsQueryParserSyntax(naturalPerson.getGivenName()) ? queryParser1.parse(naturalPerson.getGivenName()) : queryParser1.parse("*" + naturalPerson.getGivenName() + "*");
            QueryParser queryParser2 = new QueryParser(Version.LUCENE_36, "sureName", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser2.setAllowLeadingWildcard(true);
            Query sureName = null;
            sureName = this.consistsQueryParserSyntax(naturalPerson.getGivenName()) ? queryParser2.parse(naturalPerson.getSureName()) : queryParser2.parse("*" + naturalPerson.getSureName() + "*");
            QueryParser queryParser3 = new QueryParser(Version.LUCENE_36, "addressLine", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser3.setAllowLeadingWildcard(true);
            Query addressLine = null;
            addressLine = this.consistsQueryParserSyntax(naturalPerson.getAddressLine()) ? queryParser3.parse(naturalPerson.getAddressLine()) : queryParser3.parse("*" + naturalPerson.getAddressLine() + "*");
            QueryParser queryParser4 = new QueryParser(Version.LUCENE_36, "zip", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser4.setAllowLeadingWildcard(true);
            Query zip = null;
            zip = this.consistsQueryParserSyntax(naturalPerson.getZip()) ? queryParser4.parse(naturalPerson.getZip()) : queryParser4.parse("*" + naturalPerson.getZip() + "*");
            QueryParser queryParser5 = new QueryParser(Version.LUCENE_36, "country", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser5.setAllowLeadingWildcard(true);
            Query country = null;
            country = this.consistsQueryParserSyntax(naturalPerson.getCountry()) ? queryParser5.parse(naturalPerson.getCountry()) : queryParser5.parse("*" + naturalPerson.getCountry() + "*");
            query.add(givenName, BooleanClause.Occur.SHOULD);
            query.add(sureName, BooleanClause.Occur.SHOULD);
            query.add(addressLine, BooleanClause.Occur.SHOULD);
            query.add(zip, BooleanClause.Occur.SHOULD);
            query.add(country, BooleanClause.Occur.SHOULD);
        } else {
            TermQuery givenName = new TermQuery(new Term("givenName", naturalPerson.getGivenName()));
            TermQuery sureName = new TermQuery(new Term("sureName", naturalPerson.getSureName()));
            TermQuery adressLine = new TermQuery(new Term("addressLine", naturalPerson.getAddressLine()));
            TermQuery zip = new TermQuery(new Term("zip", naturalPerson.getZip()));
            TermQuery country = new TermQuery(new Term("country", naturalPerson.getCountry()));
            query.add((Query)givenName, BooleanClause.Occur.SHOULD);
            query.add((Query)sureName, BooleanClause.Occur.SHOULD);
            query.add((Query)adressLine, BooleanClause.Occur.SHOULD);
            query.add((Query)zip, BooleanClause.Occur.SHOULD);
            query.add((Query)country, BooleanClause.Occur.SHOULD);
        }
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery((Query)query, new Class[]{MyNaturalPerson.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private PrimaryDataEntity checkIfEntityExists(String name) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.setDefaultReadOnly(true);
        SQLQuery fileQuery = session.createSQLQuery("SELECT DISTINCT t4.ID, t4.TYPE, t4.PARENTDIRECTORY_ID FROM UNTYPEDDATA t1, METADATA_MAP t2, ENTITY_VERSIONS t3, ENTITIES t4 where t3.METADATA_ID=t2.METADATA_ID and t1.id=t2.MYMAP_ID and t2.MYMAP_KEY=15 and t1.STRING=:name and t3.PRIMARYENTITYID=t4.ID and t4.TYPE='F' and t4.PARENTDIRECTORY_ID=:parent").addEntity(PrimaryDataFileImplementation.class);
        fileQuery.setString("name", name);
        fileQuery.setString("parent", this.getID());
        List files = fileQuery.list();
        for (PrimaryDataFileImplementation file : files) {
            if (!file.getName().equals(name)) continue;
            session.close();
            return file;
        }
        SQLQuery directoryQuery = session.createSQLQuery("SELECT DISTINCT t4.ID, t4.TYPE, t4.PARENTDIRECTORY_ID FROM UNTYPEDDATA t1, METADATA_MAP t2, ENTITY_VERSIONS t3, ENTITIES t4 where t3.METADATA_ID=t2.METADATA_ID and t1.id=t2.MYMAP_ID and t2.MYMAP_KEY=15 and t1.STRING=:name and t3.PRIMARYENTITYID=t4.ID and t4.TYPE='D' and t4.PARENTDIRECTORY_ID=:parent").addEntity(PrimaryDataDirectoryImplementation.class);
        directoryQuery.setString("name", name);
        directoryQuery.setString("parent", this.getID());
        List dirs = directoryQuery.list();
        for (PrimaryDataDirectoryImplementation dir : dirs) {
            if (!dir.getName().equals(name)) continue;
            session.close();
            return dir;
        }
        session.close();
        return null;
    }

    private List<MyUntypedData> searchByUntypedData(UntypedData data, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        TermQuery query = null;
        if (fuzzy) {
            QueryParser queryParser = new QueryParser(Version.LUCENE_36, "string", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser.setAllowLeadingWildcard(true);
            query = this.consistsQueryParserSyntax(data.getString()) ? queryParser.parse(data.getString()) : queryParser.parse("*" + data.getString() + "*");
        } else {
            query = new TermQuery(new Term("string", data.getString()));
        }
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery((Query)query, new Class[]{MyUntypedData.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private boolean consistsQueryParserSyntax(String query) {
        return query.contains("+") || query.contains("*") || query.contains("?") || query.contains("~") || query.contains(":") || query.contains("{") || query.contains("}") || query.contains("[") || query.contains("]") || query.contains("^") || query.contains("-") || query.contains(" not ") || query.contains(" or ") || query.contains(" and ") || query.contains(" OR ") || query.contains(" AND ") || query.contains(" NOT ");
    }

    @Override
    protected List<PrimaryDataEntity> searchByDublinCoreElementImpl(EnumDublinCoreElements element, UntypedData data, boolean fuzzy, boolean recursiveIntoSubdirectories) throws PrimaryDataDirectoryException {
        long startTime = System.currentTimeMillis();
        List<Object> datatypeList = new ArrayList();
        try {
            if (data.getClass().equals(UntypedData.class)) {
                datatypeList = this.searchByUntypedData(data, fuzzy);
            } else if (data.getClass().equals(NaturalPerson.class)) {
                datatypeList = this.searchByNaturalPerson((NaturalPerson)data, fuzzy);
            } else if (data.getClass().equals(NaturalPerson.class)) {
                datatypeList = this.searchByLegalPerson((LegalPerson)data, fuzzy);
            } else if (data.getClass().equals(Identifier.class)) {
                datatypeList = this.searchByIdentifier((Identifier)data, fuzzy);
            } else if (data.getClass().equals(DataType.class)) {
                datatypeList = this.searchByDataType((DataType)data);
            } else if (data.getClass().equals(DataFormat.class)) {
                datatypeList = this.searchByDataFormat((DataFormat)data, fuzzy);
            } else if (data.getClass().equals(DateEvents.class)) {
                datatypeList = this.searchByDateEvents((DateEvents)data);
            } else if (data.getClass().equals(IdentifierRelation.class)) {
                datatypeList = this.searchByIdentifierRelation((IdentifierRelation)data, fuzzy);
            }
        }
        catch (ParseException e) {
            throw new PrimaryDataDirectoryException("Unable to find the UntypedData values", e);
        }
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().debug((Object)("Zeit (Search " + data.getClass().getSimpleName() + "): " + (System.currentTimeMillis() - startTime) + " msec"));
        if (datatypeList.isEmpty()) {
            return new ArrayList<PrimaryDataEntity>();
        }
        if (datatypeList.size() > 1000) {
            throw new PrimaryDataDirectoryException("find to much result please repeat query with more details");
        }
        ArrayList<Integer> datatypeIDList = new ArrayList<Integer>(datatypeList.size());
        for (MyUntypedData myUntypedData : datatypeList) {
            datatypeIDList.add(myUntypedData.getId());
        }
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        SQLQuery versionSQLQuery = session.createSQLQuery("SELECT DISTINCT v.ID FROM ENTITY_VERSIONS v , metadata_map m , TABLE(id BIGINT=(:list))virtual1 WHERE m.mymap_key=:key AND m.mymap_id=virtual1.id AND v.METADATA_ID =m.metadata_id ");
        versionSQLQuery.setParameterList("list", datatypeIDList);
        versionSQLQuery.setParameter("key", (Object)element.ordinal());
        List versionIDList = versionSQLQuery.list();
        HashSet<PrimaryDataEntity> resultSet = new HashSet<PrimaryDataEntity>();
        long startEntityQuery = System.currentTimeMillis();
        if (!recursiveIntoSubdirectories) {
            for (Integer version : versionIDList) {
                PrimaryDataEntityVersionImplementation currentVersion = (PrimaryDataEntityVersionImplementation)session.get(PrimaryDataEntityVersionImplementation.class, (Serializable)version);
                Criteria fileCriteria = session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)currentVersion.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this)).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
                Criteria directoryCriteria = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)currentVersion.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this)).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
                PrimaryDataFile primaryDataFile = (PrimaryDataFile)fileCriteria.uniqueResult();
                PrimaryDataDirectory primaryDataDirectory = (PrimaryDataDirectory)directoryCriteria.uniqueResult();
                if (primaryDataFile != null) {
                    try {
                        if (!primaryDataFile.getCurrentVersion().isDeleted()) {
                            primaryDataFile.switchCurrentVersion(currentVersion);
                        }
                    }
                    catch (PrimaryDataEntityVersionException e) {
                        throw new PrimaryDataDirectoryException(STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION, e);
                    }
                    resultSet.add(primaryDataFile);
                    continue;
                }
                if (primaryDataDirectory == null) continue;
                try {
                    if (!primaryDataDirectory.getCurrentVersion().isDeleted()) {
                        primaryDataDirectory.switchCurrentVersion(currentVersion);
                    }
                }
                catch (PrimaryDataEntityVersionException e) {
                    throw new PrimaryDataDirectoryException(STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION, e);
                }
                resultSet.add(primaryDataDirectory);
            }
        } else {
            ArrayList<PrimaryDataEntityVersionImplementation> maybeInSubDirectoriesList = new ArrayList<PrimaryDataEntityVersionImplementation>();
            for (Integer n : versionIDList) {
                PrimaryDataEntityVersionImplementation currentVersion = (PrimaryDataEntityVersionImplementation)session.get(PrimaryDataEntityVersionImplementation.class, (Serializable)n);
                try {
                    if (!((UntypedData)currentVersion.getMetaData().getElementValue(EnumDublinCoreElements.TYPE)).toString().equals(MetaData.DIRECTORY.toString())) {
                        Criteria fileQuery = session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)currentVersion.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this)).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
                        PrimaryDataFile pdf = (PrimaryDataFile)fileQuery.uniqueResult();
                        if (pdf != null) {
                            try {
                                if (!pdf.getCurrentVersion().isDeleted()) {
                                    pdf.switchCurrentVersion(currentVersion);
                                }
                            }
                            catch (PrimaryDataEntityVersionException e) {
                                throw new PrimaryDataDirectoryException("Unable to switch version", e);
                            }
                            resultSet.add(pdf);
                            continue;
                        }
                        maybeInSubDirectoriesList.add(currentVersion);
                        continue;
                    }
                    Criteria directoryQuery = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)currentVersion.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this)).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
                    PrimaryDataDirectory pdd = (PrimaryDataDirectory)directoryQuery.uniqueResult();
                    if (pdd != null) {
                        try {
                            if (!pdd.getCurrentVersion().isDeleted()) {
                                pdd.switchCurrentVersion(currentVersion);
                            }
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Unable to switch version", e);
                        }
                        resultSet.add(pdd);
                        continue;
                    }
                    maybeInSubDirectoriesList.add(currentVersion);
                }
                catch (MetaDataException e) {
                    throw new PrimaryDataDirectoryException("Unable to check object type", e);
                }
            }
            session.close();
            for (PrimaryDataEntityVersionImplementation primaryDataEntityVersionImplementation : maybeInSubDirectoriesList) {
                PrimaryDataEntity entity = this.searchIntoSubdirectories(this, primaryDataEntityVersionImplementation);
                if (entity == null) continue;
                if (entity.isDirectory()) {
                    if (((PrimaryDataDirectory)entity).getID().equals(this.getID())) continue;
                    resultSet.add((PrimaryDataDirectory)entity);
                    continue;
                }
                resultSet.add((PrimaryDataFile)entity);
            }
        }
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().debug((Object)("Zeit (Search Entity)    : " + (System.currentTimeMillis() - startEntityQuery) + " msec"));
        ArrayList<PrimaryDataEntity> results = new ArrayList<PrimaryDataEntity>(resultSet);
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info((Object)("Zeit (Search by Element): " + (System.currentTimeMillis() - startTime) + " msec"));
        session.close();
        return results;
    }

    private List<MyLegalPerson> searchByLegalPerson(LegalPerson legalPerson, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        BooleanQuery query = new BooleanQuery();
        if (fuzzy) {
            QueryParser queryParser1 = new QueryParser(Version.LUCENE_36, "legalName", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser1.setAllowLeadingWildcard(true);
            Query legalName = null;
            legalName = this.consistsQueryParserSyntax(legalPerson.getLegalName()) ? queryParser1.parse(legalPerson.getLegalName()) : queryParser1.parse("*" + legalPerson.getLegalName() + "*");
            QueryParser queryParser2 = new QueryParser(Version.LUCENE_36, "addressLine", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser2.setAllowLeadingWildcard(true);
            Query addressLine = null;
            addressLine = this.consistsQueryParserSyntax(legalPerson.getAddressLine()) ? queryParser2.parse(legalPerson.getAddressLine()) : queryParser2.parse("*" + legalPerson.getAddressLine() + "*");
            QueryParser queryParser3 = new QueryParser(Version.LUCENE_36, "zip", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser3.setAllowLeadingWildcard(true);
            Query zip = null;
            zip = this.consistsQueryParserSyntax(legalPerson.getZip()) ? queryParser3.parse(legalPerson.getZip()) : queryParser3.parse("*" + legalPerson.getZip() + "*");
            QueryParser queryParser4 = new QueryParser(Version.LUCENE_36, "country", (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
            queryParser4.setAllowLeadingWildcard(true);
            Query country = null;
            country = this.consistsQueryParserSyntax(legalPerson.getCountry()) ? queryParser4.parse(legalPerson.getCountry()) : queryParser4.parse("*" + legalPerson.getCountry() + "*");
            query.add(legalName, BooleanClause.Occur.SHOULD);
            query.add(addressLine, BooleanClause.Occur.SHOULD);
            query.add(zip, BooleanClause.Occur.SHOULD);
            query.add(country, BooleanClause.Occur.SHOULD);
        } else {
            TermQuery legalName = new TermQuery(new Term("legalName", legalPerson.getLegalName()));
            TermQuery adressLine = new TermQuery(new Term("addressLine", legalPerson.getAddressLine()));
            TermQuery zip = new TermQuery(new Term("zip", legalPerson.getZip()));
            TermQuery country = new TermQuery(new Term("country", legalPerson.getCountry()));
            query.add((Query)legalName, BooleanClause.Occur.SHOULD);
            query.add((Query)adressLine, BooleanClause.Occur.SHOULD);
            query.add((Query)zip, BooleanClause.Occur.SHOULD);
            query.add((Query)country, BooleanClause.Occur.SHOULD);
        }
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery((Query)query, new Class[]{MyLegalPerson.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private PrimaryDataEntity searchIntoSubdirectories(PrimaryDataDirectory entity, PrimaryDataEntityVersionImplementation version) throws PrimaryDataDirectoryException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Criteria directoryCriteria = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)version.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataDirectoryImplementation.class)).setCacheable(true).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
        PrimaryDataDirectory directory = (PrimaryDataDirectory)directoryCriteria.uniqueResult();
        if (directory != null && this.checkIfParentEntity(entity, directory)) {
            try {
                if (!directory.getCurrentVersion().isDeleted()) {
                    directory.switchCurrentVersion(version);
                }
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new PrimaryDataDirectoryException("Unable to switch version", e);
            }
            session.close();
            return directory;
        }
        Criteria fileCriteria = session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)version.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataFileImplementation.class)).setCacheable(true).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
        PrimaryDataFile file = (PrimaryDataFile)fileCriteria.uniqueResult();
        if (file != null && this.checkIfParentEntity(entity, file)) {
            try {
                if (!file.getCurrentVersion().isDeleted()) {
                    file.switchCurrentVersion(version);
                }
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new PrimaryDataDirectoryException("Unable to switch version", e);
            }
            session.close();
            return file;
        }
        session.close();
        return null;
    }

    private boolean checkIfParentEntity(PrimaryDataDirectory parent, PrimaryDataEntity child) {
        if (parent.getID().equals(child.getID())) {
            return true;
        }
        PrimaryDataDirectory grandParent = null;
        try {
            grandParent = child.getParentDirectory();
        }
        catch (PrimaryDataDirectoryException e) {
            e.printStackTrace();
        }
        if (grandParent == null) {
            return false;
        }
        return this.checkIfParentEntity(parent, grandParent);
    }

    @Override
    protected List<PrimaryDataEntity> searchByMetaDataImpl(MetaData query, boolean fuzzy, boolean recursiveIntoSubdirectories) throws PrimaryDataDirectoryException, MetaDataException {
        HashSet<PrimaryDataEntity> hashSet = new HashSet<PrimaryDataEntity>();
        EnumDublinCoreElements[] enumDublinCoreElementsArray = EnumDublinCoreElements.values();
        int n = enumDublinCoreElementsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDublinCoreElements element = enumDublinCoreElementsArray[n2];
            List<PrimaryDataEntity> tempList = this.searchByDublinCoreElement(element, (UntypedData)query.getElementValue(element), fuzzy, recursiveIntoSubdirectories);
            hashSet.addAll(tempList);
            ++n2;
        }
        if (hashSet.size() > 1000) {
            throw new PrimaryDataDirectoryException("find to much result please repeat query with more details");
        }
        ArrayList<PrimaryDataEntity> entityList = new ArrayList<PrimaryDataEntity>(hashSet);
        return entityList;
    }

    protected void setVersionList(SortedSet<PrimaryDataEntityVersionImplementation> versionList) {
        this.versionList = versionList;
        this.setCurrentVersion(this.versionList.last());
    }

    @Override
    protected void storeVersion(PrimaryDataEntityVersion publicVersion) throws PrimaryDataEntityVersionException {
        MetaDataImplementation metadata = (MetaDataImplementation)publicVersion.getMetaData();
        PrimaryDataEntityVersionImplementation privateVersion = new PrimaryDataEntityVersionImplementation();
        privateVersion.setCreationDate(publicVersion.getCreationDate());
        privateVersion.setPrimaryEntityId(this.getID());
        privateVersion.setMetaData(metadata);
        privateVersion.setRevision(publicVersion.getRevision());
        privateVersion.setDeleted(publicVersion.isDeleted());
        ArrayList<PublicReferenceImplementation> list = new ArrayList<PublicReferenceImplementation>();
        for (PublicReference publicReference : publicVersion.getPublicReferences()) {
            PublicReferenceImplementation privateReference = new PublicReferenceImplementation(publicReference);
            privateReference.setVersion(privateVersion);
            list.add(privateReference);
        }
        privateVersion.setInternReferences(list);
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        try {
            session.saveOrUpdate((Object)this);
            session.saveOrUpdate((Object)privateVersion);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            session.close();
            throw new PrimaryDataEntityVersionException("Unable to store PrimaryDataEntityVersion : " + e.getMessage(), e);
        }
        if (this.versionList == null) {
            this.versionList = new TreeSet<PrimaryDataEntityVersionImplementation>();
            this.versionList.add(privateVersion);
        } else {
            this.versionList.add(privateVersion);
        }
        this.setCurrentVersion(privateVersion);
        try {
            this.setDefaultPermissions();
        }
        catch (PrimaryDataEntityException e) {
            throw new PrimaryDataEntityVersionException("Unable to store default permissions : " + e.getMessage(), e);
        }
        Iterator<Principal> iterator = DataManager.getSubject().getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal principal = iterator.next();
            Transaction transaction2 = session.beginTransaction();
            PrincipalImplementation existingPrincipal = (PrincipalImplementation)session.createCriteria(PrincipalImplementation.class).add((Criterion)Restrictions.eq((String)"name", (Object)principal.getName())).add((Criterion)Restrictions.eq((String)"type", (Object)principal.getClass().getSimpleName())).uniqueResult();
            if (existingPrincipal == null) {
                throw new PrimaryDataEntityVersionException("Unable to load existing Principal");
            }
            privateVersion.setOwner(existingPrincipal);
            session.saveOrUpdate((Object)privateVersion);
            transaction2.commit();
            session.close();
        }
        this.setCurrentVersion(privateVersion);
    }

    @Override
    public boolean existImpl(String path) throws PrimaryDataDirectoryException {
        try {
            return this.checkIfEntityExists(path) != null;
        }
        catch (Exception e) {
            throw new PrimaryDataDirectoryException("unable to check if the Entity exist", e);
        }
    }

    @Override
    protected PrimaryDataEntity getPrimaryDataEntityImpl(String name) throws PrimaryDataDirectoryException {
        return this.checkIfEntityExists(name);
    }

    @Override
    protected List<? extends PrimaryDataEntity> searchByPublicationStatusImpl(PublicationStatus publicationStatus) throws PrimaryDataDirectoryException {
        PrimaryDataEntity entity;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        ArrayList<PrimaryDataEntity> results = new ArrayList<PrimaryDataEntity>();
        ArrayList<PrimaryDataEntityVersionImplementation> maybeResults = new ArrayList<PrimaryDataEntityVersionImplementation>();
        List notRequestedList = session.createCriteria(PublicReferenceImplementation.class).add((Criterion)Restrictions.eq((String)"publicationStatus", (Object)((Object)publicationStatus))).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).list();
        for (PublicReferenceImplementation publicReferenceImplementation : notRequestedList) {
            entity = publicReferenceImplementation.getVersion().getEntity();
            try {
                if (entity.getParentDirectory().equals(this)) {
                    results.add(entity);
                    continue;
                }
                maybeResults.add(publicReferenceImplementation.getVersion());
            }
            catch (PrimaryDataDirectoryException e) {
                throw new PrimaryDataDirectoryException("unable to search in directory", e);
            }
        }
        for (PrimaryDataEntityVersionImplementation version : maybeResults) {
            try {
                entity = this.searchIntoSubdirectories(this, version);
                if (entity == null) continue;
                results.add(entity);
            }
            catch (PrimaryDataDirectoryException e) {
                throw new PrimaryDataDirectoryException("unable to search into sub directories", e);
            }
        }
        return results;
    }

    @Override
    protected List<? extends PrimaryDataEntity> searchByKeywordImpl(String keyword, boolean fuzzy, boolean recursiveIntoSubdirectories) throws PrimaryDataDirectoryException {
        long startTime = System.currentTimeMillis();
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Query query = null;
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_36, new String[]{"string", "givenName", "sureName", "country", "zip", "addressLine", STRING_ID, "identifier", "mimeType"}, (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
        parser.setAllowLeadingWildcard(true);
        try {
            query = fuzzy ? (this.consistsQueryParserSyntax(keyword) ? parser.parse(keyword) : parser.parse("*" + keyword + "*")) : parser.parse(keyword);
        }
        catch (ParseException e) {
            throw new PrimaryDataDirectoryException("Unable to find the UntypedData values", e);
        }
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery(query, new Class[]{UntypedData.class});
        List datatypeList = hibernateQuery.list();
        session.close();
        if (datatypeList.isEmpty()) {
            return new ArrayList();
        }
        if (datatypeList.size() > 1000) {
            throw new PrimaryDataDirectoryException("find to much result please repeat query with more details");
        }
        ArrayList<Integer> datatypeIDList = new ArrayList<Integer>(datatypeList.size());
        for (MyUntypedData myUntypedData : datatypeList) {
            datatypeIDList.add(myUntypedData.getId());
        }
        Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        SQLQuery versionSQLQuery = session2.createSQLQuery("SELECT DISTINCT v.ID FROM ENTITY_VERSIONS v , metadata_map m , TABLE(id BIGINT=(:list))virtual1 WHERE m.mymap_id=virtual1.id AND v.METADATA_ID =m.metadata_id ");
        versionSQLQuery.setParameterList("list", datatypeIDList);
        List versionIDList = versionSQLQuery.list();
        HashSet<PrimaryDataEntity> resultSet = new HashSet<PrimaryDataEntity>();
        long startEntityQuery = System.currentTimeMillis();
        if (!recursiveIntoSubdirectories) {
            for (Integer version : versionIDList) {
                PrimaryDataEntityVersionImplementation currentVersion = (PrimaryDataEntityVersionImplementation)session2.get(PrimaryDataEntityVersionImplementation.class, (Serializable)version);
                Criteria fileCriteria = session2.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)currentVersion.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this)).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
                Criteria directoryCriteria = session2.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)currentVersion.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this)).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
                PrimaryDataFile primaryDataFile = (PrimaryDataFile)fileCriteria.uniqueResult();
                PrimaryDataDirectory primaryDataDirectory = (PrimaryDataDirectory)directoryCriteria.uniqueResult();
                if (primaryDataFile != null) {
                    try {
                        if (!primaryDataFile.getCurrentVersion().isDeleted()) {
                            primaryDataFile.switchCurrentVersion(currentVersion);
                        }
                    }
                    catch (PrimaryDataEntityVersionException e) {
                        throw new PrimaryDataDirectoryException(STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION, e);
                    }
                    resultSet.add(primaryDataFile);
                    continue;
                }
                if (primaryDataDirectory == null) continue;
                try {
                    if (!primaryDataDirectory.getCurrentVersion().isDeleted()) {
                        primaryDataDirectory.switchCurrentVersion(currentVersion);
                    }
                }
                catch (PrimaryDataEntityVersionException e) {
                    throw new PrimaryDataDirectoryException(STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION, e);
                }
                resultSet.add(primaryDataDirectory);
            }
        } else {
            ArrayList<PrimaryDataEntityVersionImplementation> maybeInSubDirectoriesList = new ArrayList<PrimaryDataEntityVersionImplementation>();
            for (Integer n : versionIDList) {
                PrimaryDataEntityVersionImplementation currentVersion = (PrimaryDataEntityVersionImplementation)session2.get(PrimaryDataEntityVersionImplementation.class, (Serializable)n);
                try {
                    if (!((UntypedData)currentVersion.getMetaData().getElementValue(EnumDublinCoreElements.TYPE)).toString().equals(MetaData.DIRECTORY.toString())) {
                        Criteria fileQuery = session2.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)currentVersion.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this)).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
                        PrimaryDataFile pdf = (PrimaryDataFile)fileQuery.uniqueResult();
                        if (pdf != null) {
                            try {
                                if (!pdf.getCurrentVersion().isDeleted()) {
                                    pdf.switchCurrentVersion(currentVersion);
                                }
                            }
                            catch (PrimaryDataEntityVersionException e) {
                                throw new PrimaryDataDirectoryException("Unable to switch version", e);
                            }
                            resultSet.add(pdf);
                            continue;
                        }
                        maybeInSubDirectoriesList.add(currentVersion);
                        continue;
                    }
                    Criteria directoryQuery = session2.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)STRING_ID, (Object)currentVersion.getPrimaryEntityId())).add((Criterion)Restrictions.eq((String)STRING_CLASS, PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)STRING_PARENT_DIRECTORY, (Object)this)).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY);
                    PrimaryDataDirectory pdd = (PrimaryDataDirectory)directoryQuery.uniqueResult();
                    if (pdd != null) {
                        try {
                            if (!pdd.getCurrentVersion().isDeleted()) {
                                pdd.switchCurrentVersion(currentVersion);
                            }
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Unable to switch version", e);
                        }
                        resultSet.add(pdd);
                        continue;
                    }
                    maybeInSubDirectoriesList.add(currentVersion);
                }
                catch (MetaDataException e) {
                    throw new PrimaryDataDirectoryException("Unable to check object type", e);
                }
            }
            session2.close();
            for (PrimaryDataEntityVersionImplementation primaryDataEntityVersionImplementation : maybeInSubDirectoriesList) {
                PrimaryDataEntity entity = this.searchIntoSubdirectories(this, primaryDataEntityVersionImplementation);
                if (entity == null) continue;
                if (entity.isDirectory()) {
                    if (((PrimaryDataDirectory)entity).getID().equals(this.getID())) continue;
                    resultSet.add((PrimaryDataDirectory)entity);
                    continue;
                }
                resultSet.add((PrimaryDataFile)entity);
            }
        }
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().debug((Object)("Zeit (Search Entity)    : " + (System.currentTimeMillis() - startEntityQuery) + " msec"));
        ArrayList results = new ArrayList(resultSet);
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info((Object)("Zeit (Search by keyword): " + (System.currentTimeMillis() - startTime) + " msec"));
        return results;
    }
}

