/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.PublicPermissionCheck;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.MetaDataImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataEntityVersionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.SortNatural;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@Entity
@Table(name="ENTITIES")
@DiscriminatorColumn(columnDefinition="char(1)", name="TYPE", discriminatorType=DiscriminatorType.CHAR)
@DiscriminatorValue(value="F")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="PrimaryDataFile")
public class PrimaryDataFileImplementation
extends PrimaryDataFile {
    private SortedSet<PrimaryDataEntityVersionImplementation> versionList;

    protected PrimaryDataFileImplementation() {
    }

    public PrimaryDataFileImplementation(PrimaryDataDirectory path, String name) throws PrimaryDataFileException, PrimaryDataEntityVersionException, PrimaryDataDirectoryException, MetaDataException {
        super(path, name);
    }

    private void deleteVersion(PrimaryDataEntityVersion version) throws PrimaryDataFileException {
        Path path = this.getPathToLocalFile(version);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new PrimaryDataFileException("unable to delete File", e);
        }
        this.getImplementationProvider().getLogger().info((Object)"rollback FileSytem");
    }

    @Override
    protected boolean existData() {
        return Files.exists(this.getPathToLocalFile(this.getCurrentVersion()), LinkOption.NOFOLLOW_LINKS);
    }

    @Override
    @Id
    @Column(columnDefinition="char(40)")
    public String getID() {
        String string;
        PublicPermissionCheck.ajc$cflowCounter$5.inc();
        try {
            string = super.getID();
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$5.dec();
        }
        return string;
    }

    @Override
    @OneToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    public PrimaryDataDirectoryImplementation getParentDirectory() throws PrimaryDataDirectoryException {
        return (PrimaryDataDirectoryImplementation)super.getParentDirectory();
    }

    protected Path getPathToLocalFile(PrimaryDataEntityVersion version) {
        Path path = Paths.get(((FileSystemImplementationProvider)this.getImplementationProvider()).getDataPath().toString(), String.valueOf(version.getCreationDate().get(1)), String.valueOf(version.getCreationDate().get(2)), String.valueOf(version.getCreationDate().get(5)), String.valueOf(version.getCreationDate().get(11)), String.valueOf(version.getCreationDate().get(12)), String.valueOf(this.getID()) + "-" + version.getRevision() + ".dat");
        return path;
    }

    @Override
    @Transient
    protected Map<Principal, List<EdalPermission>> getPermissionsImpl() throws PrimaryDataEntityException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Criteria query = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)this.getID())).add((Criterion)Restrictions.eq((String)"internVersion", (Object)this.getCurrentVersion().getRevision()));
        List privatePerms = query.list();
        HashMap<Principal, List<EdalPermission>> publicMap = new HashMap<Principal, List<EdalPermission>>();
        try {
            for (EdalPermissionImplementation p : privatePerms) {
                if (publicMap.containsKey(p.getPrincipal().toPrincipal())) continue;
                Criteria tmpQuery = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)this.getID())).add((Criterion)Restrictions.eq((String)"internVersion", (Object)this.getCurrentVersion().getRevision())).add((Criterion)Restrictions.eq((String)"principal", (Object)p.getPrincipal()));
                List userPerms = tmpQuery.list();
                ArrayList<EdalPermission> publicPerms = new ArrayList<EdalPermission>(privatePerms.size());
                for (EdalPermissionImplementation permission : userPerms) {
                    publicPerms.add(permission.toEdalPermission());
                }
                publicMap.put(p.getPrincipal().toPrincipal(), publicPerms);
            }
        }
        catch (Exception e) {
            session.close();
            throw new PrimaryDataEntityException("Unable to load permissions !", e);
        }
        session.close();
        return publicMap;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="primaryEntityId")
    @SortNatural
    protected SortedSet<PrimaryDataEntityVersionImplementation> getVersionList() {
        return this.versionList;
    }

    @Override
    @Transient
    protected SortedSet<PrimaryDataEntityVersion> getVersionsImpl() {
        if (this.getVersionList() == null) {
            return new TreeSet<PrimaryDataEntityVersion>();
        }
        return new TreeSet<PrimaryDataEntityVersion>((Collection<PrimaryDataEntityVersion>)this.getVersionList());
    }

    @Override
    protected void moveImpl(PrimaryDataDirectory destinationDirectory) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        this.setParentDirectory(destinationDirectory);
        session.update((Object)this);
        transaction.commit();
        session.close();
    }

    @Override
    protected void readImpl(OutputStream dataOutputStream) throws PrimaryDataFileException {
        Path path = this.getPathToLocalFile(this.getCurrentVersion());
        try {
            Files.copy(path, dataOutputStream);
            dataOutputStream.flush();
            this.getImplementationProvider().getLogger().info((Object)("File read  : " + path));
        }
        catch (IOException e) {
            throw new PrimaryDataFileException("Can not read File '" + this + "'", e);
        }
    }

    protected void setVersionList(SortedSet<PrimaryDataEntityVersionImplementation> versionList) {
        this.versionList = versionList;
        this.setCurrentVersion(this.versionList.last());
    }

    @Override
    protected void storeImpl(InputStream dataInputStream, PrimaryDataEntityVersion currentVersion) throws PrimaryDataFileException {
        Path path = this.getPathToLocalFile(currentVersion);
        try {
            if (Files.notExists(path, LinkOption.NOFOLLOW_LINKS)) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Files.copy(dataInputStream, path, StandardCopyOption.REPLACE_EXISTING);
            this.getImplementationProvider().getLogger().info((Object)("File saved : " + path));
        }
        catch (IOException e) {
            throw new PrimaryDataFileException("Can not store File : " + e.getMessage(), e);
        }
    }

    @Override
    protected void storeVersion(PrimaryDataEntityVersion publicVersion) throws PrimaryDataEntityVersionException {
        Session session;
        PrimaryDataEntityVersionImplementation privateVersion;
        block11: {
            MetaDataImplementation metadata = (MetaDataImplementation)publicVersion.getMetaData();
            privateVersion = new PrimaryDataEntityVersionImplementation();
            privateVersion.setCreationDate(publicVersion.getCreationDate());
            privateVersion.setPrimaryEntityId(this.getID());
            privateVersion.setMetaData(metadata);
            privateVersion.setRevision(publicVersion.getRevision());
            privateVersion.setDeleted(publicVersion.isDeleted());
            ArrayList<PublicReferenceImplementation> list = new ArrayList<PublicReferenceImplementation>();
            for (PublicReference publicReference : publicVersion.getPublicReferences()) {
                PublicReferenceImplementation privateReference = new PublicReferenceImplementation(publicReference);
                privateReference.setVersion(privateVersion);
                list.add(privateReference);
            }
            privateVersion.setInternReferences(list);
            session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            try {
                session.saveOrUpdate((Object)this);
                session.saveOrUpdate((Object)privateVersion);
                transaction.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (transaction == null) break block11;
                transaction.rollback();
                this.getImplementationProvider().getLogger().info((Object)("Unable to store PrimaryDataEntityVersion : " + e.getMessage() + " --> rollback Transaction"));
                try {
                    this.deleteVersion(publicVersion);
                }
                catch (PrimaryDataFileException e1) {
                    e1.printStackTrace();
                }
                session.close();
                throw new PrimaryDataEntityVersionException("Can not store Version into Database - rollback successful");
            }
        }
        if (this.versionList == null) {
            this.versionList = new TreeSet<PrimaryDataEntityVersionImplementation>();
            this.versionList.add(privateVersion);
        } else {
            this.versionList.add(privateVersion);
        }
        this.setCurrentVersion(privateVersion);
        try {
            this.setDefaultPermissions();
        }
        catch (PrimaryDataEntityException e) {
            throw new PrimaryDataEntityVersionException("Unable to store default permissions : " + e.getMessage(), e);
        }
        Iterator<Principal> iterator = DataManager.getSubject().getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal principal = iterator.next();
            Transaction transaction2 = session.beginTransaction();
            PrincipalImplementation existingPrincipal = (PrincipalImplementation)session.createCriteria(PrincipalImplementation.class).add((Criterion)Restrictions.eq((String)"name", (Object)principal.getName())).add((Criterion)Restrictions.eq((String)"type", (Object)principal.getClass().getSimpleName())).uniqueResult();
            if (existingPrincipal == null) {
                throw new PrimaryDataEntityVersionException("Unable to load existing Principal");
            }
            privateVersion.setOwner(existingPrincipal);
            session.saveOrUpdate((Object)privateVersion);
            transaction2.commit();
            session.close();
        }
        this.setCurrentVersion(privateVersion);
    }
}

