/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.CalculateDirectorySizeThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ServiceProviderImplementation
implements ServiceProvider {
    @Override
    public Long getUsedStorageSpace() throws EdalException {
        if (DataManager.getImplProv().getConfiguration().getDataPath() == null || Files.notExists(DataManager.getImplProv().getConfiguration().getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            final AtomicLong size = new AtomicLong();
            Files.walkFileTree(DataManager.getImplProv().getConfiguration().getDataPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }
            });
            return size.longValue();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request used space", e);
        }
    }

    @Override
    public Long getAvailableStorageSpace() throws EdalException {
        if (DataManager.getImplProv().getConfiguration().getDataPath() == null || Files.notExists(DataManager.getImplProv().getConfiguration().getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            return Files.getFileStore(DataManager.getImplProv().getConfiguration().getDataPath()).getUsableSpace();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request available space", e);
        }
    }

    @Override
    public synchronized void cleanUp() {
        System.out.println("CLEAN UP");
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        List references = session.createCriteria(PublicReferenceImplementation.class).add((Criterion)Restrictions.eq((String)"publicationStatus", (Object)((Object)PublicationStatus.REJECTED))).list();
        session.getTransaction().commit();
        session.close();
        for (PublicReferenceImplementation reference : references) {
            PrimaryDataEntity entity = reference.getVersion().getEntity();
            if (entity.getVersions().size() == 3 && !entity.isDirectory()) {
                this.deleteFileAndPermissions((PrimaryDataFileImplementation)entity);
                continue;
            }
            if (entity.getVersions().size() != 3 || !entity.isDirectory()) continue;
            this.deleteRecursiveDirectory((PrimaryDataDirectoryImplementation)entity);
        }
    }

    private void deleteRecursiveDirectory(PrimaryDataDirectoryImplementation directory) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        try {
            this.deleteFilesRecursively(session, directory);
            this.deleteDirectoriesRecursively(session, directory);
        }
        catch (PrimaryDataDirectoryException e) {
            e.printStackTrace();
        }
        this.deleteDirectoryAndPermissions(directory);
        session.getTransaction().commit();
        session.close();
    }

    public void deleteDirectoriesRecursively(Session session, PrimaryDataDirectory currentDirectory) throws PrimaryDataDirectoryException {
        List<PrimaryDataEntity> list = currentDirectory.listPrimaryDataEntities();
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                if (!primaryDataEntity.isDirectory()) continue;
                if (((PrimaryDataDirectory)primaryDataEntity).listPrimaryDataEntities().size() == 0) {
                    this.deleteDirectoryAndPermissions((PrimaryDataDirectoryImplementation)primaryDataEntity);
                    continue;
                }
                this.deleteDirectoriesRecursively(session, (PrimaryDataDirectory)primaryDataEntity);
                this.deleteDirectoryAndPermissions((PrimaryDataDirectoryImplementation)primaryDataEntity);
            }
        }
    }

    public void deleteFilesRecursively(Session session, PrimaryDataDirectory currentDirectory) throws PrimaryDataDirectoryException {
        List<PrimaryDataEntity> list = currentDirectory.listPrimaryDataEntities();
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                if (primaryDataEntity.isDirectory()) {
                    this.deleteFilesRecursively(session, (PrimaryDataDirectory)primaryDataEntity);
                    continue;
                }
                this.deleteFileAndPermissions((PrimaryDataFileImplementation)primaryDataEntity);
            }
        }
    }

    private void deleteFileAndPermissions(PrimaryDataFileImplementation file) {
        for (PrimaryDataEntityVersion version : file.getVersions()) {
            Path path = file.getPathToLocalFile(version);
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        session.delete((Object)file);
        List permissions = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)file.getID())).list();
        for (EdalPermissionImplementation permission : permissions) {
            session.delete((Object)permission);
        }
        session.getTransaction().commit();
        session.close();
    }

    private void deleteDirectoryAndPermissions(PrimaryDataDirectoryImplementation directory) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        session.delete((Object)directory);
        List permissions = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)directory.getID())).list();
        for (EdalPermissionImplementation permission : permissions) {
            session.delete((Object)permission);
        }
        session.getTransaction().commit();
        session.close();
    }

    private Long listDir(PublicReference reference, PrimaryDataDirectory directory) throws PrimaryDataDirectoryException, MetaDataException {
        List<PrimaryDataEntity> list = directory.listPrimaryDataEntities();
        Long dirSize = new Long(0L);
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                DataSize mySize = (DataSize)primaryDataEntity.getMetaData().getElementValue(EnumDublinCoreElements.SIZE);
                dirSize = dirSize + mySize.getFileSize();
                if (!primaryDataEntity.isDirectory()) continue;
                dirSize = dirSize + this.listDir(reference, (PrimaryDataDirectory)primaryDataEntity);
            }
            CalculateDirectorySizeThread.directorySizes.put(String.valueOf(reference.getInternalID()) + "/" + directory.getID(), dirSize);
        }
        return dirSize;
    }

    @Override
    public synchronized void calculateDirectorySizes() {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        List references = session.createCriteria(PublicReferenceImplementation.class).list();
        session.close();
        boolean updated = false;
        for (PublicReferenceImplementation reference : references) {
            if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(reference.getInternalID()) + "/" + reference.getVersion().getEntity().getID())) continue;
            try {
                this.listDir(reference, (PrimaryDataDirectory)reference.getVersion().getEntity());
                updated = true;
            }
            catch (PrimaryDataDirectoryException | MetaDataException e) {
                e.printStackTrace();
            }
        }
        if (updated) {
            EdalJettyHandler.cache.clean();
        }
    }
}

