/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDatePrecision;
import java.io.Serializable;
import java.util.Calendar;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class MyEdalDate
implements Serializable {
    private static final long serialVersionUID = 6150419465225565484L;
    private int id;
    private Calendar startDate;
    private EdalDatePrecision startPrecision;
    private String event;

    public MyEdalDate() {
    }

    public MyEdalDate(Calendar startDate, EdalDatePrecision startPrecision, String event) {
        this.setEvent(event);
        this.setStartDate(startDate);
        this.setStartPrecision(startPrecision);
    }

    public MyEdalDate(EdalDate date) {
        this(date.getStartDate(), date.getStartPrecision(), date.getString());
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    @Enumerated(value=EnumType.ORDINAL)
    public EdalDatePrecision getStartPrecision() {
        return this.startPrecision;
    }

    public void setStartPrecision(EdalDatePrecision startPrecision) {
        this.startPrecision = startPrecision;
    }

    @Id
    @GeneratedValue
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public EdalDate toEdalTimePoint() {
        EdalDate point = new EdalDate(this.getStartDate(), this.getStartPrecision(), this.getEvent());
        return point;
    }
}

