/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteMDSConnector;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class DataCiteSearchConnector {
    private String prefix = "";
    private HttpSolrServer dataciteSolrServer = null;
    private EdalConfiguration configuration = null;

    public HttpSolrServer getDataciteSolrServer() {
        return this.dataciteSolrServer;
    }

    public DataCiteSearchConnector(EdalConfiguration configuration) throws DataCiteException {
        this.configuration = configuration;
        HttpHost httpProxy = null;
        try {
            httpProxy = new HttpHost(configuration.getHttpProxyHost(), configuration.getHttpProxyPort());
        }
        catch (EdalConfigurationException edalConfigurationException) {
            DataManager.getImplProv().getLogger().debug((Object)"SolrSearchServer use no proxy");
        }
        RequestConfig requestConfig = RequestConfig.custom().setProxy(httpProxy).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(requestConfig).build();
        try {
            this.prefix = configuration.getDataCitePrefix();
        }
        catch (EdalConfigurationException e) {
            throw new DataCiteException("unable to load DataCite Prefix", e);
        }
        this.dataciteSolrServer = new HttpSolrServer("http://search.datacite.org/api/", (HttpClient)httpClient);
    }

    private int getNumberOfResolvableDOIs(int year, String dataCiteInfix) throws DataCiteException {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("q", new String[]{String.valueOf(this.prefix) + " and doi:" + this.prefix + "*" + dataCiteInfix + "*" + year + "*"});
        solrParams.set("fl", new String[]{"doi"});
        solrParams.set("rows", Integer.MAX_VALUE);
        solrParams.set("qt", new String[]{"/"});
        int numberOfResult = 0;
        try {
            numberOfResult = this.dataciteSolrServer.query((SolrParams)solrParams).getResults().size() == 0 ? 0 : this.dataciteSolrServer.query((SolrParams)solrParams).getResults().size() - 1;
        }
        catch (SolrServerException e) {
            throw new DataCiteException("unable to query the number of stored DOIs", e);
        }
        return numberOfResult;
    }

    private String getDataCentreStringForPrefix(String prefix) throws DataCiteException {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("q", new String[]{prefix});
        solrParams.set("fl", new String[]{"datacentre"});
        solrParams.set("rows", 1);
        solrParams.set("qt", new String[]{"/"});
        try {
            String str = (String)((SolrDocument)this.dataciteSolrServer.query((SolrParams)solrParams).getResults().get(0)).get((Object)"datacentre");
            String datacentre = str.substring(str.indexOf(".") + 1, str.indexOf("-") - 1);
            return datacentre;
        }
        catch (SolrServerException e) {
            throw new DataCiteException("unable to query the number of stored DOIs", e);
        }
    }

    public String generateNewDOI(int year) throws DataCiteException {
        try {
            if (this.configuration.getDoiInfix() != null) {
                DataCiteMDSConnector connector = new DataCiteMDSConnector(this.configuration);
                int nextFreeDoiNumber = connector.getNextFreeDOI(year, this.getNumberOfResolvableDOIs(year, this.configuration.getDoiInfix()), this.configuration.getDoiInfix());
                return String.valueOf(this.prefix) + "/" + this.configuration.getDoiInfix() + "/" + year + "/" + nextFreeDoiNumber;
            }
            DataCiteMDSConnector connector = new DataCiteMDSConnector(this.configuration);
            int nextFreeDoiNumber = connector.getNextFreeDOI(year, this.getNumberOfResolvableDOIs(year, this.getDataCentreStringForPrefix(this.prefix)), this.getDataCentreStringForPrefix(this.prefix));
            return String.valueOf(this.prefix) + "/" + this.getDataCentreStringForPrefix(this.prefix) + "/" + year + "/" + nextFreeDoiNumber;
        }
        catch (EdalException e) {
            throw new DataCiteException("unable to get number of stored DOIs", e);
        }
    }
}

