/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlNameIdentifier;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="creator")
public class XmlCreator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String creatorName;
    private XmlNameIdentifier nameIdentifier;

    public XmlCreator() {
    }

    public XmlCreator(String creatorName) {
        this();
        this.setCreatorName(creatorName);
    }

    public XmlCreator(String creatorName, XmlNameIdentifier nameIdentifier) {
        this(creatorName);
        this.setNameIdentifier(nameIdentifier);
    }

    public XmlCreator(Person person) {
        this();
        if (person instanceof NaturalPerson) {
            NaturalPerson naturalPerson = (NaturalPerson)person;
            this.setCreatorName(String.valueOf(naturalPerson.getGivenName()) + " " + naturalPerson.getSureName() + ", " + naturalPerson.getAddressLine() + ", " + naturalPerson.getZip() + ", " + naturalPerson.getCountry());
        } else if (person instanceof LegalPerson) {
            LegalPerson legalPerson = (LegalPerson)person;
            this.setCreatorName(String.valueOf(legalPerson.getLegalName()) + ", " + legalPerson.getAddressLine() + ", " + legalPerson.getZip() + ", " + legalPerson.getCountry());
        }
    }

    @XmlElement(required=true)
    public String getCreatorName() {
        return this.creatorName;
    }

    @XmlElement
    public XmlNameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setNameIdentifier(XmlNameIdentifier nameIdentifier) {
        this.nameIdentifier = nameIdentifier;
    }
}

