/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review;

import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ReviewStatusEvaluation {
    private static final String TRUTH_TABLE_FILE_VALUE_DELIMITER = ",";
    static final String PROPERTY_FILE_GROUP_TRUTH_TABLE = "group_truth_table.prop";
    static final String PROPERTY_FILE_DATAMANAGER_TRUTH_TABLE = "datamanager_truth_table.prop";
    protected Map<Pair<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>, ReviewStatus.ReviewStatusType> truthTable = new TreeMap<Pair<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>, ReviewStatus.ReviewStatusType>();

    static ReviewStatusEvaluation createReviewStatusEvaluationForDatamanager() throws IOException {
        return new ReviewStatusEvaluation(ReviewStatusEvaluation.loadTruthTable(PROPERTY_FILE_DATAMANAGER_TRUTH_TABLE));
    }

    static ReviewStatusEvaluation createReviewStatusEvaluationForGroups() throws IOException {
        return new ReviewStatusEvaluation(ReviewStatusEvaluation.loadTruthTable(PROPERTY_FILE_GROUP_TRUTH_TABLE));
    }

    static Collection<Triple<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>> loadTruthTable(String truth_file) throws IOException {
        Properties properties_group_truth_table = new Properties();
        InputStream in = ReviewStatusEvaluation.class.getResourceAsStream(truth_file);
        if (in == null) {
            throw new IOException("truth table file not found: " + truth_file);
        }
        ArrayList<Triple<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>> group_truth_table = new ArrayList<Triple<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>>(ReviewStatus.ReviewStatusType.values().length * ReviewStatus.ReviewStatusType.values().length);
        properties_group_truth_table.load(in);
        Set<Map.Entry<Object, Object>> truth_rows = properties_group_truth_table.entrySet();
        for (Map.Entry<Object, Object> entry : truth_rows) {
            String R = entry.getValue().toString().toUpperCase();
            String[] review_statuses = entry.getKey().toString().split(TRUTH_TABLE_FILE_VALUE_DELIMITER);
            String L = review_statuses[0].trim().toUpperCase();
            String M = review_statuses[1].trim().toUpperCase();
            ImmutableTriple row = new ImmutableTriple((Object)ReviewStatus.ReviewStatusType.valueOf(L), (Object)ReviewStatus.ReviewStatusType.valueOf(M), (Object)ReviewStatus.ReviewStatusType.valueOf(R));
            if (truth_file == PROPERTY_FILE_DATAMANAGER_TRUTH_TABLE && ReviewStatus.ReviewStatusType.valueOf(R) == ReviewStatus.ReviewStatusType.TIMEOUT) {
                throw new IllegalArgumentException("illegal evaluation result " + R + " in truth table " + truth_file + " line " + row.toString());
            }
            group_truth_table.add((Triple<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>)row);
        }
        in.close();
        return group_truth_table;
    }

    protected ReviewStatusEvaluation() {
    }

    protected ReviewStatusEvaluation(Collection<Triple<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>> truthTable) {
        this();
        for (Triple<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType> triple : truthTable) {
            this.truthTable.put((Pair<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>)new ImmutablePair((Object)((ReviewStatus.ReviewStatusType)((Object)triple.getLeft())), (Object)((ReviewStatus.ReviewStatusType)((Object)triple.getMiddle()))), (ReviewStatus.ReviewStatusType)((Object)triple.getRight()));
        }
    }

    public ReviewStatus.ReviewStatusType eval(Pair<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType> configuration) {
        return this.truthTable.get(configuration);
    }
}

