/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.security;

import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPermission;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.PermissionProvider;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;

public class EdalPolicy
extends Policy {
    private PermissionProvider permissionProvider;

    public EdalPolicy(PermissionProvider permissionProvider) {
        this.permissionProvider = permissionProvider;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        Permissions perms = new Permissions();
        perms.add(new AllPermission());
        return perms;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Permissions permissions = new Permissions();
        final HashSet<Principal> principalList = new HashSet<Principal>();
        Principal[] principals = domain.getPrincipals();
        if (principals != null && principals.length > 0) {
            void var6_10;
            Principal[] principalArray = principals;
            int n = principals.length;
            boolean n2 = false;
            while (var6_10 < n) {
                Principal p;
                Principal principal = p = principalArray[var6_10];
                principalList.add(principal);
                ++var6_10;
            }
            if (!principalList.isEmpty()) {
                try {
                    List<EdalPermission> perms = AccessController.doPrivileged(new PrivilegedExceptionAction<List<EdalPermission>>(){

                        @Override
                        public List<EdalPermission> run() {
                            return EdalPolicy.this.permissionProvider.findPermissions(principalList);
                        }
                    });
                    for (Permission permission : perms) {
                        permissions.add(permission);
                    }
                }
                catch (PrivilegedActionException e) {
                    e.printStackTrace();
                }
            }
        } else if (domain.getCodeSource() != null) {
            PermissionCollection codeSrcPerms = this.getPermissions(domain.getCodeSource());
            Enumeration<Permission> enumeration = codeSrcPerms.elements();
            while (enumeration.hasMoreElements()) {
                Permission p = enumeration.nextElement();
                permissions.add(p);
            }
        }
        return permissions;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        PermissionCollection perms = this.getPermissions(domain);
        return perms.implies(permission);
    }

    @Override
    public void refresh() {
    }
}

