/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SimpleSwingBrowserDialog
extends JDialog {
    private static final long serialVersionUID = -3918755777891924805L;
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private final JButton btnGo = new JButton("Go");
    private final JTextField txtURL = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();

    public SimpleSwingBrowserDialog(Frame parent, String url) {
        super(parent, true);
        this.initComponents(parent);
        this.loadURL(url);
    }

    private void initComponents(Frame parent) {
        this.createScene();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleSwingBrowserDialog.this.loadURL(SimpleSwingBrowserDialog.this.txtURL.getText());
            }
        };
        this.btnGo.addActionListener(al);
        this.txtURL.addActionListener(al);
        this.progressBar.setPreferredSize(new Dimension(150, 18));
        this.progressBar.setStringPainted(true);
        JPanel topBar = new JPanel(new BorderLayout(5, 0));
        topBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        topBar.add((Component)this.txtURL, "Center");
        topBar.add((Component)this.btnGo, "East");
        JPanel statusBar = new JPanel(new BorderLayout(5, 0));
        statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        statusBar.add((Component)this.lblStatus, "Center");
        statusBar.add((Component)this.progressBar, "East");
        this.panel.add((Component)topBar, "North");
        this.panel.add((Component)this.jfxPanel, "Center");
        this.panel.add((Component)statusBar, "South");
        this.getContentPane().add(this.panel);
        this.setPreferredSize(new Dimension(1024, 600));
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                SimpleSwingBrowserDialog.this.engine = view.getEngine();
                SimpleSwingBrowserDialog.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowserDialog.this.setTitle(newValue);
                            }
                        });
                    }
                });
                SimpleSwingBrowserDialog.this.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowserDialog.this.lblStatus.setText((String)event.getData());
                            }
                        });
                    }
                });
                SimpleSwingBrowserDialog.this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowserDialog.this.txtURL.setText(newValue);
                            }
                        });
                    }
                });
                SimpleSwingBrowserDialog.this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowserDialog.this.progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });
                SimpleSwingBrowserDialog.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                        if (SimpleSwingBrowserDialog.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(SimpleSwingBrowserDialog.this.panel, value != null ? String.valueOf(SimpleSwingBrowserDialog.this.engine.getLocation()) + "\n" + value.getMessage() : String.valueOf(SimpleSwingBrowserDialog.this.engine.getLocation()) + "\nUnexpected error.", "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                SimpleSwingBrowserDialog.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void loadURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String tmp = SimpleSwingBrowserDialog.toURL(url);
                if (tmp == null) {
                    tmp = SimpleSwingBrowserDialog.toURL("http://" + url);
                }
                URI uri = URI.create(tmp);
                LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
                headers.put("Set-Cookie", Arrays.asList("name=value"));
                try {
                    CookieHandler.getDefault().put(uri, headers);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SimpleSwingBrowserDialog.this.engine.load(tmp);
            }
        });
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.setProperty("http.proxyHost", "proxy1.ipk-gatersleben.de");
        System.setProperty("http.proxyPort", "3128");
        System.setProperty("https.proxyHost", "proxy1.ipk-gatersleben.de");
        System.setProperty("https.proxyPort", "3128");
        Platform.setImplicitExit((boolean)false);
        SimpleSwingBrowserDialog browser = new SimpleSwingBrowserDialog(null, "http://www.google.de");
        browser.setVisible(true);
        SimpleSwingBrowserDialog browser2 = new SimpleSwingBrowserDialog(null, "http://www.google.de");
        browser2.setVisible(true);
        Platform.setImplicitExit((boolean)true);
    }
}

