/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;

/**
 * Internal representation of {@link NaturalPerson} for persistence with
 * <em>HIBERNATE</em>.
 * 
 * @author arendd
 */
@Entity
@DiscriminatorValue("13")
@Indexed
public class MyNaturalPerson extends MyPerson {

	private static final long serialVersionUID = -8540414353817218447L;
	private String givenName;
	private String sureName;

	/**
	 * Default constructor for {@link MyNaturalPerson} is necessary for
	 * PojoInstantiator of <em>HIBERNATE</em>.
	 */
	public MyNaturalPerson() {

	}

	/**
	 * Copy constructor to convert public {@link NaturalPerson} to private
	 * {@link MyNaturalPerson}.
	 * 
	 * @param edal
	 *            the EDAL public {@link UntypedData} object to be cloned
	 */
	public MyNaturalPerson(final UntypedData edal) {

		super(edal);

		if (edal instanceof NaturalPerson) {

			NaturalPerson naturalPerson = (NaturalPerson) edal;

			this.setGivenName(naturalPerson.getGivenName());
			this.setSureName(naturalPerson.getSureName());
			this.setAddressLine(naturalPerson.getAddressLine());
			this.setCountry(naturalPerson.getCountry());
			this.setZip(naturalPerson.getZip());
		}
	}

	/**
	 * @return the givenName
	 */
	@Column(columnDefinition = "varchar(4000)")
	@Field(index = Index.YES, store = Store.YES)
	public String getGivenName() {
		return givenName;
	}

	/**
	 * @param givenName
	 *            the givenName to set
	 */
	public void setGivenName(String givenName) {
		this.givenName = givenName;
	}

	/**
	 * @return the sureName
	 */
	@Column(columnDefinition = "varchar(4000)")
	@Field(index = Index.YES, store = Store.YES)
	public String getSureName() {
		return sureName;
	}

	/**
	 * @param sureName
	 *            the sureName to set
	 */
	public void setSureName(String sureName) {
		this.sureName = sureName;
	}

}
