/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThreadPoolExcecutor;
import de.ipk_gatersleben.bit.bi.edal.primary_data.PipedThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.VeloCityHtmlGenerator;
import de.ipk_gatersleben.bit.bi.edal.primary_data.WebPageCache;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ZipThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipOutputStream;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.TeeOutputStream;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class EdalJettyHandler
extends AbstractHandler {
    private static HashMap<Integer, List<String>> hashmap = new HashMap();
    private static ExecutorService executor;
    private static EdalThreadPoolExcecutor zipExecutor;
    private static final int CorePoolSizeForZipExecutor;
    private static final int MaximumPoolSizeForZipExecutor;
    private static final Long LIMIT_INLINE_FILE_SIZE;
    public static WebPageCache cache;
    static VeloCityHtmlGenerator velocityHtmlGenerator;

    static {
        CorePoolSizeForZipExecutor = Runtime.getRuntime().availableProcessors();
        MaximumPoolSizeForZipExecutor = 2 * Runtime.getRuntime().availableProcessors();
        LIMIT_INLINE_FILE_SIZE = new Long(0xA00000L);
        cache = new WebPageCache();
        executor = DataManager.getJettyThreadPool();
        zipExecutor = new EdalThreadPoolExcecutor(CorePoolSizeForZipExecutor, MaximumPoolSizeForZipExecutor, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
        cache.init();
        velocityHtmlGenerator = new VeloCityHtmlGenerator();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getMethod().equalsIgnoreCase("GET")) {
            String url = request.getRequestURI().toString();
            DataManager.getImplProv().getLogger().debug((Object)url);
            StringTokenizer tokenizer = new StringTokenizer(url, "/");
            if (!tokenizer.hasMoreTokens()) {
                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "no ID and version specified");
            } else {
                String methodToken = tokenizer.nextToken().toUpperCase();
                try {
                    switch (EdalHttpFunctions.valueOf(methodToken)) {
                        case DOI: 
                        case URL: {
                            if (tokenizer.hasMoreTokens()) {
                                String internalId = tokenizer.nextToken();
                                if (tokenizer.hasMoreTokens()) {
                                    String uuidToken = tokenizer.nextToken();
                                    if (tokenizer.hasMoreTokens()) {
                                        String versionToken = tokenizer.nextToken();
                                        try {
                                            long versionNumber = Long.parseLong(versionToken);
                                            PrimaryDataEntity entity = null;
                                            if (tokenizer.hasMoreTokens()) {
                                                String reviewerToken = tokenizer.nextToken();
                                                if (tokenizer.hasMoreElements()) {
                                                    String methodTokenForReviewer = tokenizer.nextToken();
                                                    if (methodTokenForReviewer.equalsIgnoreCase(EdalHttpFunctions.DOWNLOAD.name())) {
                                                        this.responseDownloadRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, reviewerToken);
                                                        break;
                                                    }
                                                    if (methodTokenForReviewer.equalsIgnoreCase(EdalHttpFunctions.ZIP.name())) {
                                                        this.responseZipRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, reviewerToken);
                                                        break;
                                                    }
                                                    this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "unable to process '" + methodTokenForReviewer + "'");
                                                    break;
                                                }
                                                if (reviewerToken.equalsIgnoreCase(EdalHttpFunctions.DOWNLOAD.name())) {
                                                    this.responseDownloadRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, null);
                                                    break;
                                                }
                                                if (reviewerToken.equalsIgnoreCase(EdalHttpFunctions.ZIP.name())) {
                                                    this.responseZipRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, null);
                                                    break;
                                                }
                                                int reviewer = 0;
                                                try {
                                                    reviewer = Integer.parseInt(reviewerToken);
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "unable to process reviewer ID '" + reviewerToken + "', please check again");
                                                    break;
                                                }
                                                entity = DataManager.getPrimaryDataEntityForReviewer(uuidToken, versionNumber, internalId, reviewer);
                                                this.sendEntityMetaDataForReviewer(response, entity, versionNumber, internalId, PersistentIdentifier.valueOf(methodToken), reviewer);
                                                break;
                                            }
                                            entity = DataManager.getPrimaryDataEntityForPersistenIdentifier(uuidToken, versionNumber, PersistentIdentifier.valueOf(methodToken));
                                            this.sendEntityMetaDataForPersistentIdentifier(response, entity, versionNumber, PersistentIdentifier.valueOf(methodToken), internalId);
                                        }
                                        catch (EdalException e) {
                                            this.sendMessage(response, HttpStatus.Code.LOCKED, e.getMessage());
                                        }
                                        break;
                                    }
                                    this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "no version number set");
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "no entity id set");
                                break;
                            }
                            this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "no internal id set");
                            break;
                        }
                        case EDAL: {
                            String uuidToken = tokenizer.nextToken();
                            if (tokenizer.hasMoreTokens()) {
                                String versionToken = tokenizer.nextToken();
                                try {
                                    int versionNumber = Integer.parseInt(versionToken);
                                    PrimaryDataEntity entity = null;
                                    if (tokenizer.hasMoreElements()) {
                                        String downloadToken = tokenizer.nextToken();
                                        if (EdalHttpFunctions.valueOf(downloadToken.toUpperCase()).equals((Object)EdalHttpFunctions.DOWNLOAD)) {
                                            entity = DataManager.getPrimaryDataEntityByID(uuidToken, versionNumber);
                                            if (!entity.isDirectory()) {
                                                this.sendFile((PrimaryDataFile)entity, versionNumber, response);
                                                break;
                                            }
                                            this.sendEntityMetaData(response, entity);
                                        }
                                        break;
                                    }
                                    entity = DataManager.getPrimaryDataEntityByID(uuidToken, versionNumber);
                                    this.sendEntityMetaData(response, entity);
                                }
                                catch (EdalException | NumberFormatException e) {
                                    if (e.getClass().equals(NumberFormatException.class)) {
                                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to cast '" + versionToken + "' to a version number");
                                        break;
                                    }
                                    this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to send data : " + e.getMessage());
                                }
                                break;
                            }
                            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "no version number set");
                            break;
                        }
                        case ACCEPT: {
                            String ticketAccept = tokenizer.nextToken();
                            if (tokenizer.hasMoreElements()) {
                                try {
                                    int reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                                    if (!this.ticketAlreadyClicked(reviewerHashCode, ticketAccept)) {
                                        DataManager.getImplProv().getApprovalServiceProvider().newInstance().accept(ticketAccept, reviewerHashCode);
                                        this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                                        break;
                                    }
                                    this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Already clicked");
                                }
                                catch (EdalApprovalException | IllegalAccessException | InstantiationException | NumberFormatException e) {
                                    EdalJettyHandler.deleteTicketFromHashMap(ticketAccept);
                                    this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "Can not to accept ticket it seems to be already accepted: " + e.getMessage());
                                }
                                break;
                            }
                            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                            break;
                        }
                        case REJECT: {
                            String ticketReject = tokenizer.nextToken();
                            if (tokenizer.hasMoreElements()) {
                                try {
                                    int reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                                    if (!this.ticketAlreadyClicked(reviewerHashCode, ticketReject)) {
                                        DataManager.getImplProv().getApprovalServiceProvider().newInstance().reject(ticketReject, reviewerHashCode);
                                        this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                                        break;
                                    }
                                    this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Already clicked");
                                }
                                catch (EdalApprovalException | IllegalAccessException | InstantiationException | NumberFormatException e) {
                                    EdalJettyHandler.deleteTicketFromHashMap(ticketReject);
                                    this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "Can not to reject ticket  it seems to be already rejected: " + e.getMessage());
                                }
                                break;
                            }
                            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                            break;
                        }
                        case LOGIN: {
                            String uuid = tokenizer.nextToken();
                            String emailAddress = tokenizer.nextToken();
                            Boolean successful = false;
                            try {
                                successful = DataManager.getImplProv().getPermissionProvider().newInstance().validateRootUser(new InternetAddress(emailAddress), UUID.fromString(uuid));
                            }
                            catch (IllegalAccessException | InstantiationException | AddressException throwable) {
                                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "eDAL-Server Admin confirmation failed");
                            }
                            if (successful.booleanValue()) {
                                try {
                                    this.sendMessage(response, HttpStatus.Code.OK, "Thank you <br/>You have successfully registered as administrator for eDAL-Server on " + EdalJettyServer.getServerURL() + "<br/>The server is now started in working mode.");
                                }
                                catch (EdalException edalException) {
                                    this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to load server URL");
                                }
                                break;
                            }
                            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "root user validation failed");
                            break;
                        }
                        case LOGO: {
                            String logoUrl;
                            if (tokenizer.hasMoreTokens() && (logoUrl = tokenizer.nextToken()).equalsIgnoreCase("edal_scaled.png")) {
                                this.sendEmbeddedFile(response, "edal_scaled.png", "image/png");
                            }
                            break;
                        }
                        case CSS: {
                            if (tokenizer.hasMoreTokens()) {
                                String fileUrl = tokenizer.nextToken();
                                this.sendEmbeddedFile(response, "css/" + fileUrl, "text/css");
                            }
                            break;
                        }
                        case JS: {
                            if (tokenizer.hasMoreTokens()) {
                                String fileUrl = tokenizer.nextToken();
                                this.sendEmbeddedFile(response, "js/" + fileUrl, "application/javascript");
                            }
                            break;
                        }
                        case FONTS: {
                            if (tokenizer.hasMoreTokens()) {
                                String fileUrl = tokenizer.nextToken();
                                if (fileUrl.contains("svg")) {
                                    this.sendEmbeddedFile(response, "fonts/" + fileUrl, "image/svg+xml");
                                }
                                if (fileUrl.contains("eot")) {
                                    this.sendEmbeddedFile(response, "fonts/" + fileUrl, "application/vnd.ms-fontobject");
                                }
                                if (fileUrl.contains("woff")) {
                                    this.sendEmbeddedFile(response, "fonts/" + fileUrl, "application/x-font-woff");
                                }
                                if (fileUrl.contains("woff2")) {
                                    this.sendEmbeddedFile(response, "fonts/" + fileUrl, "application/x-font-woff");
                                }
                                if (fileUrl.contains("ttf")) {
                                    this.sendEmbeddedFile(response, "fonts/" + fileUrl, "application/x-font-ttf");
                                }
                            }
                            break;
                        }
                        case FILEICONS: {
                            if (tokenizer.hasMoreTokens()) {
                                String fileUrl = tokenizer.nextToken();
                                this.sendEmbeddedFile(response, "fileicons/" + fileUrl, "image/png");
                            }
                            break;
                        }
                        case USER_ACCEPT: {
                            String userAcceptTicket = tokenizer.nextToken();
                            if (tokenizer.hasMoreElements()) {
                                try {
                                    int reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                                    if (!this.ticketAlreadyClicked(reviewerHashCode, userAcceptTicket)) {
                                        DataManager.getImplProv().getApprovalServiceProvider().newInstance().acceptTicketByUser(userAcceptTicket, reviewerHashCode);
                                        this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                                        break;
                                    }
                                    this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Already clicked");
                                }
                                catch (EdalApprovalException | IllegalAccessException | InstantiationException | NumberFormatException e) {
                                    EdalJettyHandler.deleteTicketFromHashMap(userAcceptTicket);
                                    this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "Can not to accept ticket it seems to be already accepted: " + e.getMessage());
                                }
                                break;
                            }
                            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                            break;
                        }
                        case USER_REJECT: {
                            String userRejectTicket = tokenizer.nextToken();
                            if (tokenizer.hasMoreElements()) {
                                try {
                                    int reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                                    if (!this.ticketAlreadyClicked(reviewerHashCode, userRejectTicket)) {
                                        DataManager.getImplProv().getApprovalServiceProvider().newInstance().rejectTicketByUser(userRejectTicket, reviewerHashCode);
                                        this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                                        break;
                                    }
                                    this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Already clicked");
                                }
                                catch (EdalApprovalException | IllegalAccessException | InstantiationException | NumberFormatException e) {
                                    EdalJettyHandler.deleteTicketFromHashMap(userRejectTicket);
                                    this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "Can not to accept ticket it seems to be already rejected: " + e.getMessage());
                                }
                                break;
                            }
                            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                            break;
                        }
                        case REPORT: {
                            if (tokenizer.countTokens() == 0) {
                                this.sendReport(response, HttpStatus.Code.OK, null);
                                break;
                            }
                            if (tokenizer.countTokens() == 1) {
                                this.sendReport(response, HttpStatus.Code.OK, tokenizer.nextToken());
                                break;
                            }
                            if (tokenizer.countTokens() == 2) {
                                this.sendCSVReport(response, HttpStatus.Code.OK, tokenizer.nextToken(), tokenizer.nextToken());
                            }
                            break;
                        }
                        case OAI: {
                            if (DataManager.getConfiguration().isInTestMode()) break;
                            String dataCenter = null;
                            try {
                                dataCenter = DataManager.getConfiguration().getDataCiteUser();
                            }
                            catch (EdalConfigurationException e) {
                                e.printStackTrace();
                            }
                            String oaiRequest = request.getQueryString();
                            if (oaiRequest != null) {
                                if (oaiRequest.contains("set=")) {
                                    if (oaiRequest.indexOf("set=") > oaiRequest.lastIndexOf("&")) {
                                        oaiRequest = String.valueOf(oaiRequest.substring(0, oaiRequest.indexOf("set="))) + "set=" + dataCenter;
                                        response.sendRedirect("http://oai.datacite.org/oai?" + oaiRequest);
                                        break;
                                    }
                                    String prefix = oaiRequest.substring(0, oaiRequest.indexOf("set="));
                                    String suffix = oaiRequest.substring(oaiRequest.indexOf("&", oaiRequest.indexOf("set=")), oaiRequest.length());
                                    oaiRequest = String.valueOf(prefix) + suffix + "&set=" + dataCenter;
                                    response.sendRedirect("http://oai.datacite.org/oai?" + oaiRequest);
                                    break;
                                }
                                if (oaiRequest.contains("verb=Identify") || oaiRequest.contains("verb=ListMetadataFormats") || oaiRequest.contains("verb=ListRecords&metadataPrefix=oai_dc") || oaiRequest.contains("verb=ListSets") || oaiRequest.contains("verb=ListIdentifiers&metadataPrefix=oai_dc")) {
                                    response.sendRedirect("http://oai.datacite.org/oai?" + oaiRequest);
                                }
                                break;
                            }
                            response.sendRedirect("http://oai.datacite.org/oai");
                            break;
                        }
                        default: {
                            this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "path has to start with '" + (Object)((Object)EdalHttpFunctions.ACCEPT) + "'" + " or '" + (Object)((Object)EdalHttpFunctions.REJECT) + "'");
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "path has to start with '" + (Object)((Object)EdalHttpFunctions.ACCEPT) + "'" + " or '" + (Object)((Object)EdalHttpFunctions.REJECT) + "'");
                }
            }
        }
        response.flushBuffer();
    }

    private void sendCSVReport(HttpServletResponse response, HttpStatus.Code responseCode, String function, String filetype) {
        try {
            response.setStatus(responseCode.getCode());
            response.setContentType("text/comma-separated-values");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
            String filename = "eDAL_report_" + EdalJettyServer.getServerURL().getHost() + "_" + function + "_" + sdf.format(Calendar.getInstance().getTime()) + ".csv";
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            ServletOutputStream responseBody = response.getOutputStream();
            CountDownLatch latch = new CountDownLatch(1);
            OutputStreamWriter outputStreamWriter = null;
            outputStreamWriter = velocityHtmlGenerator.generateCSVForReport(function, filetype, responseCode, (OutputStream)responseBody, latch);
            try {
                latch.await();
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (EofException eofException) {
                DataManager.getImplProv().getLogger().warn((Object)"HTTP Response canceled by user");
                outputStreamWriter.close();
            }
            catch (InterruptedException e) {
                throw new EdalException(e);
            }
        }
        catch (Exception e) {
            DataManager.getImplProv().getLogger().error((Object)("unable to send " + responseCode + "-message : " + e.getClass()));
        }
    }

    private boolean ticketAlreadyClicked(int reviewerHashCode, String ticketAccept) {
        List<String> list = hashmap.get(reviewerHashCode);
        if (list != null) {
            if (list.contains(ticketAccept)) {
                return true;
            }
            list.add(ticketAccept);
            hashmap.put(reviewerHashCode, list);
            return false;
        }
        ArrayList<String> newlist = new ArrayList<String>();
        newlist.add(ticketAccept);
        hashmap.put(reviewerHashCode, newlist);
        return false;
    }

    private void responseDownloadRequest(HttpServletResponse response, PrimaryDataEntity entity, String uuid, Long versionNumber, String internalId, String identifierType, String reviewerCode) throws EdalException {
        if (reviewerCode == null) {
            entity = DataManager.getPrimaryDataEntityForPersistenIdentifier(uuid, versionNumber, PersistentIdentifier.valueOf(identifierType));
            if (!entity.isDirectory()) {
                this.sendFile((PrimaryDataFile)entity, versionNumber, response);
            } else {
                this.sendEntityMetaDataForPersistentIdentifier(response, entity, versionNumber, PersistentIdentifier.valueOf(identifierType), internalId);
            }
        } else {
            entity = DataManager.getPrimaryDataEntityForReviewer(uuid, versionNumber, internalId, Integer.parseInt(reviewerCode));
            if (!entity.isDirectory()) {
                this.sendFile((PrimaryDataFile)entity, versionNumber, response);
            } else {
                this.sendEntityMetaDataForReviewer(response, entity, versionNumber, internalId, PersistentIdentifier.valueOf(identifierType), Integer.parseInt(reviewerCode));
            }
        }
    }

    private void responseZipRequest(HttpServletResponse response, PrimaryDataEntity entity, String uuid, long versionNumber, String internalId, String identifierType, String reviewerId) throws EdalException {
        if (!zipExecutor.isShutdown() && zipExecutor.getActiveCount() >= CorePoolSizeForZipExecutor) {
            this.sendMessage(response, HttpStatus.Code.INSUFFICIENT_STORAGE, "No more free slots for downloading zip archive, please try again later");
        } else {
            entity = reviewerId == null ? DataManager.getPrimaryDataEntityForPersistenIdentifier(uuid, versionNumber, PersistentIdentifier.valueOf(identifierType)) : DataManager.getPrimaryDataEntityForReviewer(uuid, versionNumber, internalId, Integer.parseInt(reviewerId));
            if (entity.isDirectory()) {
                try {
                    response.setHeader("Content-Disposition", "inline; filename=\"" + entity.getName() + ".zip" + "\"");
                    response.setStatus(HttpStatus.Code.OK.getCode());
                    CountDownLatch countDownLatch = new CountDownLatch(1);
                    ServletOutputStream responseBody = response.getOutputStream();
                    ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream((OutputStream)responseBody));
                    ZipThread zipThread = new ZipThread(countDownLatch, zipOutputStream, (PrimaryDataDirectory)entity);
                    if (zipExecutor.isShutdown()) {
                        zipExecutor = new EdalThreadPoolExcecutor(CorePoolSizeForZipExecutor, MaximumPoolSizeForZipExecutor, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
                    }
                    zipExecutor.execute(zipThread);
                    try {
                        try {
                            countDownLatch.await();
                        }
                        catch (InterruptedException e) {
                            throw new EdalException("unable to send zip file '" + entity.getName() + ".zip'", e);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            zipOutputStream.flush();
                            zipOutputStream.close();
                        }
                        catch (EofException eofException) {
                            DataManager.getImplProv().getLogger().warn((Object)("HTTP Zip Response for '" + entity.getName() + ".zip' canceled by user"));
                            zipThread.stopListThread();
                        }
                        responseBody.flush();
                        responseBody.close();
                        throw throwable;
                    }
                    try {
                        zipOutputStream.flush();
                        zipOutputStream.close();
                    }
                    catch (EofException eofException) {
                        DataManager.getImplProv().getLogger().warn((Object)("HTTP Zip Response for '" + entity.getName() + ".zip' canceled by user"));
                        zipThread.stopListThread();
                    }
                    responseBody.flush();
                    responseBody.close();
                }
                catch (IOException e) {
                    throw new EdalException("unable to send zip file '" + entity.getName() + ".zip'", e);
                }
            }
        }
    }

    private void sendEmbeddedFile(HttpServletResponse response, String fileName, String contentType) {
        try {
            int length;
            InputStream file = EdalJettyHandler.class.getResourceAsStream(fileName);
            int fileSize = file.available();
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            response.setContentLength(fileSize);
            response.setStatus(HttpStatus.Code.OK.getCode());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServletOutputStream responseBody = response.getOutputStream();
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)fileSize);
            executor.execute(pipedThread);
            byte[] buffer = new byte[0x100000];
            while ((length = file.read(buffer)) != -1) {
                pipedOut.write(buffer, 0, length);
            }
            pipedOut.flush();
            try {
                countDownLatch.await();
                file.close();
                pipedOut.close();
                httpIn.close();
            }
            catch (InterruptedException e) {
                DataManager.getImplProv().getLogger().error((Object)("unable to wait for sending file : " + e.getMessage()));
            }
            responseBody.close();
        }
        catch (IOException e) {
            DataManager.getImplProv().getLogger().error((Object)("unable to send file : " + e.getMessage()));
        }
    }

    private void sendEntityMetaData(HttpServletResponse response, PrimaryDataEntity entity) throws EdalException {
        try {
            int length;
            StringWriter w = null;
            w = entity.isDirectory() ? velocityHtmlGenerator.generateHtmlForDirectory((PrimaryDataDirectory)entity) : velocityHtmlGenerator.generateHtmlForFile((PrimaryDataFile)entity);
            ByteArrayInputStream bis = new ByteArrayInputStream(String.valueOf(w.getBuffer()).getBytes());
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            ServletOutputStream responseBody = response.getOutputStream();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)bis.available());
            executor.execute(pipedThread);
            byte[] buffer = new byte[0x100000];
            while ((length = bis.read(buffer)) != -1) {
                pipedOut.write(buffer, 0, length);
            }
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("unable to send html page", e);
                }
            }
            finally {
                try {
                    bis.close();
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error((Object)("unable to close html streams : " + e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            throw new EdalException("unable to send the html page over HTTP", e);
        }
        catch (EdalException e) {
            throw e;
        }
    }

    private void sendEntityMetaDataForPersistentIdentifier(HttpServletResponse response, PrimaryDataEntity entity, long versionNumber, PersistentIdentifier identifierType, String internalId) throws EdalException {
        String cacheKey = this.generateCacheKey(identifierType, internalId, entity, versionNumber, 0);
        if (cache.get(cacheKey) == null) {
            DataManager.getImplProv().getLogger().debug((Object)("Regenerate Webpage : " + cacheKey));
            try {
                ByteArrayOutputStream cacheFileOutputStream = new ByteArrayOutputStream();
                TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)response.getOutputStream(), (OutputStream)cacheFileOutputStream);
                CountDownLatch latch = new CountDownLatch(1);
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = entity.isDirectory() ? velocityHtmlGenerator.generateHtmlForDirectoryOfSnapshot((PrimaryDataDirectory)entity, versionNumber, internalId, identifierType, teeOutputStream, latch) : velocityHtmlGenerator.generateHtmlForFileOfSnapshot((PrimaryDataFile)entity, versionNumber, identifierType, internalId, teeOutputStream, latch);
                response.setContentType("text/html");
                response.setStatus(HttpStatus.Code.OK.getCode());
                try {
                    latch.await();
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                    cache.put(cacheKey, cacheFileOutputStream);
                }
                catch (EofException eofException) {
                    DataManager.getImplProv().getLogger().warn((Object)"HTTP Response canceled by user");
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                }
                catch (InterruptedException e) {
                    throw new EdalException(e);
                }
            }
            catch (IOException e) {
                throw new EdalException(e);
            }
        } else {
            DataManager.getImplProv().getLogger().debug((Object)("Reload Webpage from Cache : " + cacheKey));
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            try {
                ByteArrayOutputStream cacheFileInputStream = cache.get(cacheKey);
                cacheFileInputStream.writeTo((OutputStream)response.getOutputStream());
                cacheFileInputStream.close();
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendEntityMetaDataForReviewer(HttpServletResponse response, PrimaryDataEntity entity, long versionNumber, String internalId, PersistentIdentifier identifierType, int reviewerCode) throws EdalException {
        String cacheKey = this.generateCacheKey(identifierType, internalId, entity, versionNumber, reviewerCode);
        if (cache.get(cacheKey) == null) {
            DataManager.getImplProv().getLogger().debug((Object)("Regenerate Webpage : " + cacheKey));
            try {
                ByteArrayOutputStream cacheFileOutputStream = new ByteArrayOutputStream();
                TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)response.getOutputStream(), (OutputStream)cacheFileOutputStream);
                CountDownLatch latch = new CountDownLatch(1);
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = entity.isDirectory() ? velocityHtmlGenerator.generateHtmlForDirectoryForReviewer((PrimaryDataDirectory)entity, versionNumber, internalId, identifierType, reviewerCode, teeOutputStream, latch) : velocityHtmlGenerator.generateHtmlForFileForReviewer((PrimaryDataFile)entity, versionNumber, internalId, identifierType, reviewerCode, teeOutputStream, latch);
                response.setContentType("text/html");
                response.setStatus(HttpStatus.Code.OK.getCode());
                try {
                    latch.await();
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                }
                catch (EofException eofException) {
                    DataManager.getImplProv().getLogger().warn((Object)"HTTP Response canceled by user");
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                }
                catch (InterruptedException e) {
                    throw new EdalException(e);
                }
            }
            catch (IOException e) {
                throw new EdalException(e);
            }
        } else {
            DataManager.getImplProv().getLogger().debug((Object)("Reload Webpage from Cache : " + cacheKey));
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            try {
                ByteArrayOutputStream cacheFileInputStream = cache.get(cacheKey);
                cacheFileInputStream.writeTo((OutputStream)response.getOutputStream());
                cacheFileInputStream.close();
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private final String generateCacheKey(PersistentIdentifier identifierType, String internalId, PrimaryDataEntity entity, long versionNumber, int reviewerCode) {
        return new String(String.valueOf(identifierType.toString()) + internalId + entity.getID() + String.valueOf(versionNumber) + String.valueOf(reviewerCode));
    }

    private void sendFile(PrimaryDataFile file, long versionNumber, HttpServletResponse response) throws EdalException {
        PrimaryDataFile currentFile = file;
        try {
            currentFile.switchCurrentVersion(currentFile.getVersionByRevisionNumber(versionNumber));
        }
        catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "no file found");
        }
        try {
            String type = "";
            Long size = null;
            try {
                type = ((DataFormat)currentFile.getCurrentVersion().getMetaData().getElementValue(EnumDublinCoreElements.FORMAT)).getMimeType();
                size = ((DataSize)currentFile.getCurrentVersion().getMetaData().getElementValue(EnumDublinCoreElements.SIZE)).getFileSize();
            }
            catch (MetaDataException e) {
                throw new EdalException("unable to load the MIME type/file size", e);
            }
            response.setContentType(type);
            if (size > LIMIT_INLINE_FILE_SIZE) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + currentFile.getName() + "\"");
            } else {
                response.setHeader("Content-Disposition", "inline; filename=\"" + currentFile.getName() + "\"");
            }
            response.setContentLengthLong(size.longValue());
            response.setStatus(HttpStatus.Code.OK.getCode());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServletOutputStream responseBody = response.getOutputStream();
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)size);
            executor.execute(pipedThread);
            currentFile.read(pipedOut);
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("unable to send file", e);
                }
            }
            finally {
                try {
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error((Object)("unable to close download streams : " + e.getMessage()));
                }
            }
        }
        catch (PrimaryDataFileException | IOException e) {
            throw new EdalException("unable to send file", e);
        }
    }

    private void sendMessage(HttpServletResponse response, HttpStatus.Code responseCode, String message) {
        try {
            String htmlOutput = velocityHtmlGenerator.generateHtmlForErrorMessage(responseCode, message).toString();
            response.setStatus(responseCode.getCode());
            response.setContentType("text/html");
            ServletOutputStream responseBody = response.getOutputStream();
            responseBody.write(htmlOutput.getBytes());
            responseBody.close();
        }
        catch (EofException eofException) {
        }
        catch (EdalException | IOException e) {
            DataManager.getImplProv().getLogger().error((Object)("unable to send " + responseCode + "-message : " + e));
        }
    }

    private void sendReport(HttpServletResponse response, HttpStatus.Code responseCode, String function) {
        try {
            response.setStatus(responseCode.getCode());
            response.setContentType("text/html");
            ServletOutputStream responseBody = response.getOutputStream();
            CountDownLatch latch = new CountDownLatch(1);
            OutputStreamWriter outputStreamWriter = null;
            outputStreamWriter = velocityHtmlGenerator.generateHtmlForReport(function, responseCode, (OutputStream)responseBody, latch);
            try {
                latch.await();
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (EofException eofException) {
                DataManager.getImplProv().getLogger().warn((Object)"HTTP Response canceled by user");
                outputStreamWriter.close();
            }
            catch (InterruptedException e) {
                throw new EdalException(e);
            }
        }
        catch (Exception e) {
            DataManager.getImplProv().getLogger().error((Object)("unable to send " + responseCode + "-message : " + e.getClass()));
        }
    }

    public static void deleteTicketFromHashMap(String ticket) {
        for (Map.Entry<Integer, List<String>> entry : hashmap.entrySet()) {
            List<String> list = entry.getValue();
            if (!list.contains(ticket)) continue;
            list.remove(ticket);
        }
    }
}

