/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.AsynchronList;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipThread
extends Thread {
    private static List<String> ENUM_LIST = null;
    private ZipOutputStream zout = null;
    private PrimaryDataDirectory directory = null;
    private CountDownLatch countDownLatch = null;
    private List<PrimaryDataEntity> list = null;

    static {
        ENUM_LIST = Stream.of(FILE_TYPES_WITH_COMPRESSION_SUPPORT.values()).map(Enum::name).collect(Collectors.toList());
    }

    public ZipThread(CountDownLatch countDownLatch, ZipOutputStream zout, PrimaryDataDirectory directory) {
        this.countDownLatch = countDownLatch;
        this.zout = zout;
        this.directory = directory;
    }

    @Override
    public void run() {
        try {
            try {
                this.readPrimaryDataDirectoryIntoZipOutputStream(this.zout, this.directory, true);
            }
            catch (PrimaryDataDirectoryException | PrimaryDataFileException | MetaDataException | IOException e) {
                DataManager.getImplProv().getLogger().error((Object)("Generating Zip File Stream for '" + this.directory.getName() + "' failed : " + e.getMessage()));
                this.countDownLatch.countDown();
            }
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    private void readPrimaryDataDirectoryIntoZipOutputStream(ZipOutputStream zipOutputStream, PrimaryDataDirectory entity, boolean log) throws PrimaryDataDirectoryException, PrimaryDataFileException, MetaDataException, IOException {
        if (log) {
            DataManager.getImplProv().getLogger().info((Object)("Preparing Zip File for '" + entity.getName() + "'"));
        }
        this.list = entity.listPrimaryDataEntities();
        DataManager.getImplProv().getLogger().debug((Object)("Adding directory " + entity.getPath()));
        for (PrimaryDataEntity primaryDataEntity : this.list) {
            if (primaryDataEntity.isDirectory()) {
                this.readPrimaryDataDirectoryIntoZipOutputStream(zipOutputStream, (PrimaryDataDirectory)primaryDataEntity, false);
                continue;
            }
            DataManager.getImplProv().getLogger().debug((Object)("Adding file " + primaryDataEntity.getPath()));
            ZipEntry zipEntry = new ZipEntry(primaryDataEntity.getPath().substring(2));
            DateEvents dateEvents = (DateEvents)primaryDataEntity.getMetaData().getElementValue(EnumDublinCoreElements.DATE);
            Set<EdalDate> set = dateEvents.getSet();
            long time = 0L;
            for (EdalDate edalDate : set) {
                if (!edalDate.getEvent().equals(EdalDate.STANDART_EVENT_TYPES.CREATED.toString())) continue;
                time = edalDate.getStartDate().getTimeInMillis();
                break;
            }
            zipEntry.setTime(time);
            String mimetype = ((DataFormat)primaryDataEntity.getCurrentVersion().getMetaData().getElementValue(EnumDublinCoreElements.FORMAT)).getMimeType();
            String mimeTypeGroup = mimetype.substring(0, mimetype.indexOf("/")).toUpperCase();
            zipOutputStream.setMethod(8);
            if (ENUM_LIST.contains(mimeTypeGroup)) {
                zipOutputStream.setLevel(1);
            } else {
                zipOutputStream.setLevel(0);
            }
            zipOutputStream.putNextEntry(zipEntry);
            ((PrimaryDataFile)primaryDataEntity).read(zipOutputStream);
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
        }
        if (log) {
            DataManager.getImplProv().getLogger().info((Object)("ZipOutputStream for '" + entity.getName() + "' finished"));
        }
    }

    public void stopListThread() {
        if (this.list instanceof AsynchronList) {
            ((AsynchronList)this.list).setStopped();
        }
    }

    private static enum FILE_TYPES_WITH_COMPRESSION_SUPPORT {
        TEXT;

    }
}

