/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.PublicPermissionCheck;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThreadPoolExcecutor;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.CalculateCheckSumThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.GuessMimeTypeThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PipedInputOutputThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.StoreFileThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.CheckNullValues;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDCMIDataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.sample.TimeMeasure;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class PrimaryDataFile
extends PrimaryDataEntity {
    private static ThreadPoolExecutor executor;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        PrimaryDataFile.ajc$preClinit();
        executor = new EdalThreadPoolExcecutor(3, Math.max(3, Runtime.getRuntime().availableProcessors()), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
    }

    protected PrimaryDataFile() {
    }

    public PrimaryDataFile(PrimaryDataDirectory path, String name) throws PrimaryDataFileException, PrimaryDataEntityVersionException, PrimaryDataDirectoryException, MetaDataException {
        super(path, name);
        try {
            this.getMetaData().setElementValue(EnumDublinCoreElements.TYPE, new DataType(EnumDCMIDataType.TEXT));
        }
        catch (MetaDataException e) {
            throw new PrimaryDataFileException(e.getMessage());
        }
        ByteArrayInputStream dataInputStream = new ByteArrayInputStream(new byte[0]);
        this.store(dataInputStream);
    }

    protected abstract boolean existData();

    public void read(OutputStream dataOutputStream) throws PrimaryDataFileException {
        OutputStream outputStream = dataOutputStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)outputStream);
        PrimaryDataFile.read_aroundBody3$advice(this, outputStream, joinPoint, TimeMeasure.aspectOf(), null, joinPoint);
    }

    protected abstract void readImpl(OutputStream var1) throws PrimaryDataFileException;

    @Override
    public void setMetaData(MetaData newMetadata) throws PrimaryDataEntityVersionException, MetaDataException {
        MetaData metaData = newMetadata;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)metaData);
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataFile.setMetaData_aroundBody5$advice(this, metaData, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataFile.setMetaData_aroundBody4(this, metaData, joinPoint);
    }

    public void store(InputStream dataInputStream) throws PrimaryDataFileException, PrimaryDataEntityVersionException {
        InputStream inputStream = dataInputStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)inputStream);
        if (!TimeMeasure.ajc$cflowCounter$0.isValid()) {
            PrimaryDataFile.store_aroundBody9$advice(this, inputStream, joinPoint, TimeMeasure.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataFile.store_aroundBody8(this, inputStream, joinPoint);
    }

    protected abstract void storeImpl(InputStream var1, PrimaryDataEntityVersion var2) throws PrimaryDataFileException;

    private static final /* synthetic */ void read_aroundBody0(PrimaryDataFile ajc$this, OutputStream dataOutputStream, JoinPoint joinPoint) {
        ReentrantReadWriteLock.WriteLock writelock = ajc$this.getCurrentVersion().getReadWriteLock().writeLock();
        if (writelock.tryLock()) {
            PrimaryDataEntityVersion oldVersion = ajc$this.getCurrentVersion();
            SortedSet<PrimaryDataEntityVersion> versions = ajc$this.getVersions();
            SortedSet<PrimaryDataEntityVersion> headSet = versions.headSet(oldVersion);
            PrimaryDataEntityVersion[] versionArray = new PrimaryDataEntityVersion[headSet.size()];
            int i = 0;
            Iterator iterator = headSet.iterator();
            while (iterator.hasNext()) {
                PrimaryDataEntityVersion primaryDataEntityVersion;
                versionArray[i] = primaryDataEntityVersion = (PrimaryDataEntityVersion)iterator.next();
                ++i;
            }
            int p = versionArray.length - 1;
            while (p >= 0) {
                if (ajc$this.existData()) break;
                try {
                    ajc$this.switchCurrentVersion(versionArray[p]);
                }
                catch (PrimaryDataEntityVersionException e) {
                    throw new PrimaryDataFileException("no data stored" + e.getMessage());
                }
                --p;
            }
            ajc$this.readImpl(dataOutputStream);
            try {
                ajc$this.switchCurrentVersion(oldVersion);
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new PrimaryDataFileException(e.getMessage());
            }
            writelock.unlock();
        }
    }

    private static final /* synthetic */ Object read_aroundBody1$advice(PrimaryDataFile ajc$this, OutputStream dataOutputStream, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var11_9;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var8_7;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataFile.read_aroundBody0(ajc$this, dataOutputStream, thisJoinPoint);
                var8_7 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var11_9 = var8_7;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var11_9;
    }

    private static final /* synthetic */ void read_aroundBody2(PrimaryDataFile primaryDataFile, OutputStream outputStream, JoinPoint joinPoint) {
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataFile.read_aroundBody1$advice(primaryDataFile, outputStream, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataFile.read_aroundBody0(primaryDataFile, outputStream, joinPoint);
    }

    private static final /* synthetic */ Object read_aroundBody3$advice(PrimaryDataFile ajc$this, OutputStream dataOutputStream, JoinPoint thisJoinPoint, TimeMeasure ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var11_9;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var8_7;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataFile.read_aroundBody2(ajc$this, dataOutputStream, thisJoinPoint);
                var8_7 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var11_9 = var8_7;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var11_9;
    }

    private static final /* synthetic */ void setMetaData_aroundBody4(PrimaryDataFile ajc$this, MetaData newMetadata, JoinPoint joinPoint) {
        if (((UntypedData)newMetadata.getElementValue(EnumDublinCoreElements.TYPE)).toString().equals(MetaData.DIRECTORY.toString())) {
            UntypedData originalData = ajc$this.reloadOldDataType(EnumDublinCoreElements.TYPE);
            throw new MetaDataException("valid value for meta data element in PrimaryDataFile: " + EnumDublinCoreElements.TYPE.name() + " is not allowed ! Rollback to " + originalData);
        }
        if (((UntypedData)newMetadata.getElementValue(EnumDublinCoreElements.FORMAT)).toString().equals(MetaData.EMPTY.toString())) {
            UntypedData originalData = ajc$this.reloadOldDataType(EnumDublinCoreElements.FORMAT);
            throw new MetaDataException("valid value for meta data element in PrimaryDataFile: " + EnumDublinCoreElements.FORMAT.name() + " is not allowed to be empty ! Rollback to " + originalData);
        }
        if (((UntypedData)newMetadata.getElementValue(EnumDublinCoreElements.FORMAT)).toString().equals(MetaData.DIRECTORY.toString())) {
            UntypedData originalData = ajc$this.reloadOldDataType(EnumDublinCoreElements.FORMAT);
            throw new MetaDataException("valid value for meta data element in PrimaryDataFile: " + EnumDublinCoreElements.FORMAT.name() + " is not allowed to be directory ! Rollback to " + originalData);
        }
        MetaData oldMetaData = null;
        try {
            oldMetaData = DataManager.getImplProv().reloadPrimaryDataEntityByID(ajc$this.getID(), ajc$this.getCurrentVersion().getRevision()).getMetaData();
        }
        catch (EdalException e) {
            throw new PrimaryDataEntityVersionException("unable to reload meta data: " + e.getMessage(), e);
        }
        if (((UntypedData)oldMetaData.getElementValue(EnumDublinCoreElements.SIZE)).compareTo((UntypedData)newMetadata.getElementValue(EnumDublinCoreElements.SIZE)) != 0) {
            UntypedData originalData = ajc$this.reloadOldDataType(EnumDublinCoreElements.SIZE);
            throw new MetaDataException("it is not allowed to overwrite the data size of a PrimaryDataFile ! Rollback to " + originalData);
        }
        if (!((UntypedData)oldMetaData.getElementValue(EnumDublinCoreElements.CHECKSUM)).equals(newMetadata.getElementValue(EnumDublinCoreElements.CHECKSUM))) {
            UntypedData originalData = ajc$this.reloadOldDataType(EnumDublinCoreElements.CHECKSUM);
            throw new MetaDataException("it is not allowed to overwrite the checksum of a PrimaryDataFile ! Rollback to " + originalData);
        }
        super.setMetaData(newMetadata);
    }

    private static final /* synthetic */ Object setMetaData_aroundBody5$advice(PrimaryDataFile ajc$this, MetaData newMetadata, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var11_9;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var8_7;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataFile.setMetaData_aroundBody4(ajc$this, newMetadata, thisJoinPoint);
                var8_7 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var11_9 = var8_7;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var11_9;
    }

    private static final /* synthetic */ void store_aroundBody6(PrimaryDataFile ajc$this, InputStream dataInputStream, JoinPoint joinPoint) {
        if (ajc$this.getCurrentVersion().isDeleted()) {
            throw new PrimaryDataEntityVersionException("file already deleted at: " + ajc$this.getCurrentVersion().getRevisionDate());
        }
        PrimaryDataEntityVersion newFileVersion = null;
        try {
            newFileVersion = new PrimaryDataEntityVersion(ajc$this, false, ajc$this.getCurrentVersion().getMetaData().clone());
        }
        catch (CloneNotSupportedException e) {
            throw new PrimaryDataFileException("unable to clone: " + e.getMessage(), e);
        }
        ArrayList<PipedInputStream> pipedInputStreams = new ArrayList<PipedInputStream>();
        pipedInputStreams.add(new PipedInputStream(0x100000));
        pipedInputStreams.add(new PipedInputStream(0x100000));
        pipedInputStreams.add(new PipedInputStream(0x100000));
        CountDownLatch countDownLatch = new CountDownLatch(pipedInputStreams.size());
        StoreFileThread storeFileThread = new StoreFileThread(ajc$this, (PipedInputStream)pipedInputStreams.get(0), newFileVersion, countDownLatch);
        CalculateCheckSumThread calculateCheckSumThread = new CalculateCheckSumThread((PipedInputStream)pipedInputStreams.get(1), countDownLatch);
        GuessMimeTypeThread guessMimeTypeThread = new GuessMimeTypeThread((PipedInputStream)pipedInputStreams.get(2), countDownLatch);
        PipedInputOutputThread pipedInputOutputThread = null;
        try {
            pipedInputOutputThread = new PipedInputOutputThread(dataInputStream, pipedInputStreams);
        }
        catch (IOException e) {
            throw new PrimaryDataFileException("exception while multiplexing input stream: " + e.getMessage(), e);
        }
        pipedInputOutputThread.start();
        if (executor.isShutdown()) {
            executor = new EdalThreadPoolExcecutor(3, Math.max(3, Runtime.getRuntime().availableProcessors()), 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        }
        executor.execute(storeFileThread);
        executor.execute(calculateCheckSumThread);
        executor.execute(guessMimeTypeThread);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new PrimaryDataFileException("exception while waiting for close all data stream: " + e.getMessage(), e);
        }
        try {
            for (PipedInputStream pipedInputStream : pipedInputStreams) {
                pipedInputStream.close();
            }
        }
        catch (IOException e) {
            throw new PrimaryDataFileException("exception while closing multiplexed piped stream: " + e.getMessage(), e);
        }
        try {
            newFileVersion.getMetaData().setElementValue(EnumDublinCoreElements.SIZE, new DataSize(pipedInputOutputThread.getSize()));
            newFileVersion.getMetaData().setElementValue(EnumDublinCoreElements.CHECKSUM, calculateCheckSumThread.getChecksum());
            newFileVersion.getMetaData().setElementValue(EnumDublinCoreElements.FORMAT, guessMimeTypeThread.getDataFormat());
        }
        catch (MetaDataException e) {
            throw new PrimaryDataFileException("exception while compute metadata from data stream: " + e.getMessage(), e);
        }
        ajc$this.commitVersion(newFileVersion);
    }

    private static final /* synthetic */ Object store_aroundBody7$advice(PrimaryDataFile ajc$this, InputStream dataInputStream, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var11_9;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var8_7;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataFile.store_aroundBody6(ajc$this, dataInputStream, thisJoinPoint);
                var8_7 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var11_9 = var8_7;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var11_9;
    }

    private static final /* synthetic */ void store_aroundBody8(PrimaryDataFile primaryDataFile, InputStream inputStream, JoinPoint joinPoint) {
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataFile.store_aroundBody7$advice(primaryDataFile, inputStream, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataFile.store_aroundBody6(primaryDataFile, inputStream, joinPoint);
    }

    private static final /* synthetic */ Object store_aroundBody9$advice(PrimaryDataFile ajc$this, InputStream dataInputStream, JoinPoint thisJoinPoint, TimeMeasure ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var11_9;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var8_7;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataFile.store_aroundBody8(ajc$this, dataInputStream, thisJoinPoint);
                var8_7 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var11_9 = var8_7;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var11_9;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PrimaryDataFile.java", PrimaryDataFile.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "read", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile", "java.io.OutputStream", "dataOutputStream", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException", "void"), 113);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMetaData", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile", "de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData", "newMetadata", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException:de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException", "void"), 178);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "store", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile", "java.io.InputStream", "dataInputStream", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException:de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException", "void"), 244);
    }
}

