/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.CalculateDirectorySizeJob;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ServiceProviderImplementation;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdSchedulerFactory;

public class CalculateDirectorySizeThread
extends Thread {
    private static final int INTERVAL_TO_REPEAT_JOB = 24;
    private static Scheduler scheduler;
    public static Map<String, Long> directorySizes;
    public static long totalVolumeDataStock;

    static {
        directorySizes = null;
        totalVolumeDataStock = 0L;
    }

    public void done() {
        try {
            this.getScheduler().shutdown(true);
        }
        catch (SchedulerException e) {
            DataManager.getImplProv().getLogger().info((Object)"unable to stop CalculateDirectorySizeThreadScheduler", (Throwable)e);
        }
    }

    public Scheduler getScheduler() {
        return scheduler;
    }

    @Override
    public void run() {
        Object readLong;
        ObjectInputStream ois;
        Path path = ServiceProviderImplementation.PATH_FOR_DIRECTORY_SIZE_MAP;
        if (Files.exists(path, new LinkOption[0])) {
            directorySizes = new HashMap<String, Long>();
            try {
                ois = new ObjectInputStream(new FileInputStream(path.toFile()));
                Object readMap = ois.readObject();
                if (readMap != null && readMap instanceof HashMap) {
                    directorySizes.putAll((Map)readMap);
                }
                ois.close();
            }
            catch (Exception e) {
                ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
            }
        } else {
            directorySizes = new HashMap<String, Long>();
        }
        if (Files.exists(path = ServiceProviderImplementation.PATH_FOR_TOTAL_FILE_NUMBER, new LinkOption[0])) {
            ServiceProviderImplementation.numberOfFiles = new Long(0L);
            try {
                ois = new ObjectInputStream(new FileInputStream(path.toFile()));
                readLong = ois.readObject();
                if (readLong != null && readLong instanceof Long) {
                    ServiceProviderImplementation.numberOfFiles = (Long)readLong;
                }
                ois.close();
            }
            catch (Exception e) {
                ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
            }
        } else {
            ServiceProviderImplementation.numberOfFiles = new Long(0L);
        }
        if (Files.exists(path = ServiceProviderImplementation.PATH_FOR_TOTAL_VOLUME, new LinkOption[0])) {
            totalVolumeDataStock = new Long(0L);
            try {
                ois = new ObjectInputStream(new FileInputStream(path.toFile()));
                readLong = ois.readObject();
                if (readLong != null && readLong instanceof Long) {
                    totalVolumeDataStock = (Long)readLong;
                }
                ois.close();
            }
            catch (Exception e) {
                ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
            }
        } else {
            totalVolumeDataStock = new Long(0L);
        }
        DataManager.getImplProv().getLogger().info((Object)"Starting CalculateDirectorySizeThread");
        Scheduler defaultQuartzScheduler = SchedulerRepository.getInstance().lookup("DefaultQuartzScheduler");
        if (defaultQuartzScheduler == null) {
            try {
                Scheduler std = new StdSchedulerFactory().getScheduler();
                CalculateDirectorySizeThread.setScheduler(std);
            }
            catch (SchedulerException e) {
                DataManager.getImplProv().getLogger().warn((Object)"unable to create new CalculateDirectorySizeThreadScheduler", (Throwable)e);
            }
        } else {
            CalculateDirectorySizeThread.setScheduler(defaultQuartzScheduler);
        }
        try {
            this.getScheduler().start();
            JobDetail job = JobBuilder.newJob(CalculateDirectorySizeJob.class).build();
            Trigger trigger = TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(24).repeatForever()).build();
            this.getScheduler().scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            DataManager.getImplProv().getLogger().warn((Object)"unable to start CalculateDirectorySizeThreadScheduler", (Throwable)e);
        }
    }

    private static void setScheduler(Scheduler scheduler) {
        CalculateDirectorySizeThread.scheduler = scheduler;
    }
}

