/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class CustomDailyRollingFileAppender
extends FileAppender {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final int TOP_OF_TROUBLE = -1;
    private static final int TOP_OF_MINUTE = 0;
    private static final int TOP_OF_HOUR = 1;
    private static final int HALF_DAY = 2;
    private static final int TOP_OF_DAY = 3;
    private static final int TOP_OF_WEEK = 4;
    private static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private boolean compressBackups = false;
    private int maxDays = 7;
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date lastCheck = new Date();
    SimpleDateFormat datePatternFormat = new SimpleDateFormat(this.datePattern);
    RollingCalendar rollingCalendar = new RollingCalendar();
    int checkPeriod = -1;

    public CustomDailyRollingFileAppender() {
    }

    public CustomDailyRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setFile(String filename) {
        this.makePath(filename);
        super.setFile(filename);
    }

    public void makePath(String filename) {
        boolean success;
        File dir;
        try {
            URL url = new URL(filename.trim());
            dir = new File(url.getFile()).getParentFile();
        }
        catch (MalformedURLException malformedURLException) {
            dir = new File(filename.trim()).getParentFile();
        }
        if (!dir.exists() && !(success = dir.mkdirs())) {
            LogLog.error((String)("Failed to create directory structure: " + dir));
        }
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.lastCheck.setTime(System.currentTimeMillis());
            this.datePatternFormat = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rollingCalendar.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = String.valueOf(this.fileName) + this.datePatternFormat.format(new Date(file.lastModified()));
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(GMT, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            int i = 0;
            while (i <= 5) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(GMT);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 != null && r1 != null && !r0.equals(r1)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    void rollOver() throws IOException {
        File file;
        boolean result;
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = String.valueOf(this.fileName) + this.datePatternFormat.format(this.lastCheck);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug((String)(String.valueOf(this.fileName) + " -> " + this.scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException iOException) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = datedFilename;
    }

    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.lastCheck.setTime(n);
            this.nextCheck = this.rollingCalendar.getNextCheckMillis(this.lastCheck);
            try {
                this.cleanupAndRollOver();
            }
            catch (IOException ioe) {
                LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
            }
        }
        super.subAppend(event);
    }

    protected void cleanupAndRollOver() throws IOException {
        File file = new File(this.fileName);
        Calendar cal = Calendar.getInstance();
        cal.add(5, -this.getMaxDays());
        Date cutoffDate = cal.getTime();
        if (file.getParentFile().exists()) {
            File[] files = file.getParentFile().listFiles(new StartsWithFileFilter(file.getName(), false));
            int nameLength = file.getName().length();
            int i = 0;
            while (i < files.length) {
                String datePart = null;
                try {
                    datePart = files[i].getName().substring(nameLength);
                    Date date = this.datePatternFormat.parse(datePart);
                    if (date.before(cutoffDate)) {
                        files[i].delete();
                    } else if (this.shouldCompress()) {
                        this.zipAndDelete(files[i]);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        this.rollOver();
    }

    private void zipAndDelete(File file) throws IOException {
        if (!file.getName().endsWith(".zip")) {
            int bytesRead;
            File zipFile = new File(file.getParent(), String.valueOf(file.getName()) + ".zip");
            FileInputStream fis = new FileInputStream(file);
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry zipEntry = new ZipEntry(file.getName());
            zos.putNextEntry(zipEntry);
            byte[] buffer = new byte[4096];
            while ((bytesRead = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, bytesRead);
            }
            zos.closeEntry();
            fis.close();
            zos.close();
            file.delete();
        }
    }

    public String getMaxNumberOfDays() {
        return String.valueOf(this.maxDays);
    }

    public int getMaxDays() {
        return this.maxDays;
    }

    public void setMaxNumberOfDays(String maxNumberOfDays) {
        try {
            this.maxDays = Integer.parseInt(maxNumberOfDays);
        }
        catch (NumberFormatException e) {
            LogLog.warn((String)("Could not parse numberOfDays-string " + maxNumberOfDays + ", using 7 as default"), (Throwable)e);
            this.maxDays = 7;
        }
    }

    public boolean shouldCompress() {
        return this.compressBackups;
    }

    public String getCompressBackups() {
        return String.valueOf(this.compressBackups);
    }

    public void setCompressBackups(String compressBackups) {
        this.compressBackups = "YES".equalsIgnoreCase(compressBackups) || "TRUE".equalsIgnoreCase(compressBackups);
    }

    class RollingCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -3560331770601814177L;
        int type;

        RollingCalendar() {
            this.type = -1;
        }

        RollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
            this.type = -1;
        }

        void setType(int type) {
            this.type = type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this.type) {
                case 0: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case 1: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case 2: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    int hour = this.get(11);
                    if (hour < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case 3: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case 4: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case 5: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            return this.getTime();
        }
    }

    class StartsWithFileFilter
    implements FileFilter {
        private String startsWith;
        private boolean inclDirs = false;

        public StartsWithFileFilter(String startsWith, boolean includeDirectories) {
            this.startsWith = startsWith.toUpperCase();
            this.inclDirs = includeDirectories;
        }

        @Override
        public boolean accept(File pathname) {
            if (!this.inclDirs && pathname.isDirectory()) {
                return false;
            }
            return pathname.getName().toUpperCase().startsWith(this.startsWith);
        }
    }
}

