/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.CheckSum;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormatException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DirectoryMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalLanguage;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EmptyMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Identifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.IdentifierRelation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Persons;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Subjects;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UnknownMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyCheckSum;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDirectoryMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEdalLanguage;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEmptyMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyIdentifierRelation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyLegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyNaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyPersons;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MySubjects;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyUnknownMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyUntypedData;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="METADATA")
public class MetaDataImplementation
extends MetaData
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Map<Class<? extends UntypedData>, Class<? extends MyUntypedData>> DATATYPE_MAP = Collections.unmodifiableMap(new HashMap<Class<? extends UntypedData>, Class<? extends MyUntypedData>>(){
        {
            this.put(DataFormat.class, MyDataFormat.class);
            this.put(DataType.class, MyDataType.class);
            this.put(DirectoryMetaData.class, MyDirectoryMetaData.class);
            this.put(EmptyMetaData.class, MyEmptyMetaData.class);
            this.put(Identifier.class, MyIdentifier.class);
            this.put(IdentifierRelation.class, MyIdentifierRelation.class);
            this.put(NaturalPerson.class, MyNaturalPerson.class);
            this.put(LegalPerson.class, MyLegalPerson.class);
            this.put(UnknownMetaData.class, MyUnknownMetaData.class);
            this.put(UntypedData.class, MyUntypedData.class);
            this.put(DataSize.class, MyDataSize.class);
            this.put(CheckSum.class, MyCheckSum.class);
            this.put(EdalLanguage.class, MyEdalLanguage.class);
            this.put(DateEvents.class, MyDateEvents.class);
            this.put(Subjects.class, MySubjects.class);
            this.put(Persons.class, MyPersons.class);
        }
    });
    private int id;
    private Map<EnumDublinCoreElements, MyUntypedData> myMap = new HashMap<EnumDublinCoreElements, MyUntypedData>();

    public MetaDataImplementation() {
        EnumDublinCoreElements[] enumDublinCoreElementsArray = EnumDublinCoreElements.values();
        int n = enumDublinCoreElementsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDublinCoreElements element = enumDublinCoreElementsArray[n2];
            try {
                this.myMap.put(element, this.convertToPrivateUntypedData((UntypedData)super.getElementValue(element)));
            }
            catch (MetaDataException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    @Override
    public MetaDataImplementation clone() throws CloneNotSupportedException {
        MetaDataImplementation clone = (MetaDataImplementation)super.clone();
        EnumDublinCoreElements[] enumDublinCoreElementsArray = EnumDublinCoreElements.values();
        int n = enumDublinCoreElementsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDublinCoreElements element = enumDublinCoreElementsArray[n2];
            try {
                clone.myMap.put(element, clone.convertToPrivateUntypedData((UntypedData)clone.getElementValue(element)));
            }
            catch (MetaDataException e) {
                throw new CloneNotSupportedException("Unable to clone MetaDataImplementation object! " + e.getMessage());
            }
            ++n2;
        }
        return clone;
    }

    private MyUntypedData convertToPrivateUntypedData(UntypedData value) {
        try {
            Constructor<? extends MyUntypedData> constructor = DATATYPE_MAP.get(value.getClass()).getConstructor(UntypedData.class);
            return constructor.newInstance(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            DataManager.getImplProv().getLogger().fatal((Object)("Error while convert to private UntypedData " + value.getClass().getSimpleName()), (Throwable)e);
            return new MyUntypedData();
        }
    }

    private UntypedData convertToPublicUntypedData(MyUntypedData myUntypedData) {
        if (myUntypedData.getClass().equals(MyUntypedData.class)) {
            return new UntypedData(myUntypedData.getString());
        }
        if (myUntypedData.getClass().equals(MyNaturalPerson.class)) {
            MyNaturalPerson p = (MyNaturalPerson)myUntypedData;
            return new NaturalPerson(p.getGivenName(), p.getSureName(), p.getAddressLine(), p.getZip(), p.getCountry());
        }
        if (myUntypedData.getClass().equals(MyLegalPerson.class)) {
            MyLegalPerson p = (MyLegalPerson)myUntypedData;
            return new LegalPerson(p.getLegalName(), p.getAddressLine(), p.getZip(), p.getCountry());
        }
        if (myUntypedData.getClass().equals(MyDataType.class)) {
            MyDataType myDataType = (MyDataType)myUntypedData;
            return new DataType(myDataType.getDataType());
        }
        if (myUntypedData.getClass().equals(MyDataFormat.class)) {
            MyDataFormat myDataFormat = (MyDataFormat)myUntypedData;
            try {
                return new DataFormat(myDataFormat.getMimeType());
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (myUntypedData.getClass().equals(MyEmptyMetaData.class)) {
            return MetaData.EMPTY;
        }
        if (myUntypedData.getClass().equals(MyDirectoryMetaData.class)) {
            return MetaData.DIRECTORY;
        }
        if (myUntypedData.getClass().equals(MyUnknownMetaData.class)) {
            return MetaData.UNKNOWN;
        }
        if (myUntypedData.getClass().equals(MyIdentifier.class)) {
            return new Identifier(((MyIdentifier)myUntypedData).getIdentifier());
        }
        if (myUntypedData.getClass().equals(MyIdentifierRelation.class)) {
            return ((MyIdentifierRelation)myUntypedData).toIdentifierRelation();
        }
        if (myUntypedData.getClass().equals(MyDateEvents.class)) {
            return ((MyDateEvents)myUntypedData).toDates();
        }
        if (myUntypedData.getClass().equals(MyDataSize.class)) {
            return ((MyDataSize)myUntypedData).toDataSize();
        }
        if (myUntypedData.getClass().equals(MyCheckSum.class)) {
            return ((MyCheckSum)myUntypedData).toCheckSum();
        }
        if (myUntypedData.getClass().equals(MyEdalLanguage.class)) {
            return new EdalLanguage(((MyEdalLanguage)myUntypedData).getLanguage());
        }
        if (myUntypedData.getClass().equals(MySubjects.class)) {
            return ((MySubjects)myUntypedData).toSubjets();
        }
        if (myUntypedData.getClass().equals(MyPersons.class)) {
            return ((MyPersons)myUntypedData).toPerson();
        }
        return null;
    }

    @Id
    @GeneratedValue
    @Column(name="ID")
    protected int getId() {
        return this.id;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @MapKeyEnumerated(value=EnumType.ORDINAL)
    @JoinTable(name="METADATA_MAP", joinColumns={@JoinColumn(name="METADATA_ID")})
    @Fetch(value=FetchMode.SELECT)
    protected Map<EnumDublinCoreElements, MyUntypedData> getMyMap() {
        return this.myMap;
    }

    @Override
    @Transient
    public void setElementValue(EnumDublinCoreElements key, UntypedData value) throws MetaDataException {
        super.setElementValue(key, value);
        this.myMap.put(key, this.convertToPrivateUntypedData(value));
    }

    protected void setId(int id) {
        this.id = id;
    }

    protected void setMyMap(Map<EnumDublinCoreElements, MyUntypedData> myMap) {
        this.myMap = myMap;
        for (Map.Entry<EnumDublinCoreElements, MyUntypedData> entry : myMap.entrySet()) {
            try {
                super.setElementValue(entry.getKey(), this.convertToPublicUntypedData(entry.getValue()));
            }
            catch (Exception e) {
                DataManager.getImplProv().getLogger().fatal((Object)("Error while convert to public UntypedData " + entry.getValue().getClass().getSimpleName()));
                DataManager.getImplProv().getLogger().error((Object)e);
            }
        }
    }
}

