/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.CalculateDirectorySizeThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataEntityVersionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ServiceProviderImplementation
implements ServiceProvider {
    public static boolean cleaned = false;
    private static final int DaysAfterCleanBrokenEntities = -14;
    public static final Path PATH_FOR_DIRECTORY_SIZE_MAP = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "directory_size_map.dat");
    public static final Path PATH_FOR_TOTAL_FILE_NUMBER = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "number_of_files.dat");
    public static final Path PATH_FOR_TOTAL_VOLUME = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "total_volume.dat");
    public static Long numberOfFiles;

    @Override
    public Long getUsedStorageSpace() throws EdalException {
        if (DataManager.getImplProv().getConfiguration().getDataPath() == null || Files.notExists(DataManager.getImplProv().getConfiguration().getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            final AtomicLong size = new AtomicLong();
            Files.walkFileTree(DataManager.getImplProv().getConfiguration().getDataPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }
            });
            return size.longValue();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request used space", e);
        }
    }

    @Override
    public Long getAvailableStorageSpace() throws EdalException {
        if (DataManager.getImplProv().getConfiguration().getDataPath() == null || Files.notExists(DataManager.getImplProv().getConfiguration().getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            return Files.getFileStore(DataManager.getImplProv().getConfiguration().getDataPath()).getUsableSpace();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request available space", e);
        }
    }

    @Override
    public synchronized void cleanUpForRejectedEntities() {
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info((Object)"CLEAN UP initiated");
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        List references = session.createCriteria(PublicReferenceImplementation.class).add((Criterion)Restrictions.eq((String)"publicationStatus", (Object)((Object)PublicationStatus.REJECTED))).list();
        session.getTransaction().commit();
        session.close();
        boolean foundReferenceToDelete = false;
        if (references != null) {
            foundReferenceToDelete = true;
        }
        for (PublicReferenceImplementation reference : references) {
            PrimaryDataEntity entity = reference.getVersion().getEntity();
            if (entity.getVersions().size() == 3 && !entity.isDirectory()) {
                this.deleteFileAndPermissions((PrimaryDataFileImplementation)entity);
                continue;
            }
            if (entity.getVersions().size() != 3 || !entity.isDirectory()) continue;
            this.deleteRecursiveDirectory((PrimaryDataDirectoryImplementation)entity);
        }
        if (foundReferenceToDelete) {
            this.setCleaned(true);
        }
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info((Object)"CLEAN UP finished");
    }

    private void deleteRecursiveDirectory(PrimaryDataDirectoryImplementation directory) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        try {
            this.deleteFilesRecursively(session, directory);
            this.deleteDirectoriesRecursively(session, directory);
        }
        catch (PrimaryDataDirectoryException e) {
            e.printStackTrace();
        }
        this.deleteDirectoryAndPermissions(directory);
        session.getTransaction().commit();
        session.close();
    }

    public void deleteDirectoriesRecursively(Session session, PrimaryDataDirectory currentDirectory) throws PrimaryDataDirectoryException {
        List<PrimaryDataEntity> list = currentDirectory.listPrimaryDataEntities();
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                if (!primaryDataEntity.isDirectory()) continue;
                if (((PrimaryDataDirectory)primaryDataEntity).listPrimaryDataEntities().size() == 0) {
                    this.deleteDirectoryAndPermissions((PrimaryDataDirectoryImplementation)primaryDataEntity);
                    continue;
                }
                this.deleteDirectoriesRecursively(session, (PrimaryDataDirectory)primaryDataEntity);
                this.deleteDirectoryAndPermissions((PrimaryDataDirectoryImplementation)primaryDataEntity);
            }
        }
    }

    public void deleteFilesRecursively(Session session, PrimaryDataDirectory currentDirectory) throws PrimaryDataDirectoryException {
        List<PrimaryDataEntity> list = currentDirectory.listPrimaryDataEntities();
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                if (primaryDataEntity.isDirectory()) {
                    this.deleteFilesRecursively(session, (PrimaryDataDirectory)primaryDataEntity);
                    continue;
                }
                this.deleteFileAndPermissions((PrimaryDataFileImplementation)primaryDataEntity);
            }
        }
    }

    private void deleteFileAndPermissions(PrimaryDataFileImplementation file) {
        DataManager.getImplProv().getLogger().info((Object)("Deleting concrete date file '" + file.getName() + "'"));
        ArrayList<Integer> versionIds = new ArrayList<Integer>();
        for (PrimaryDataEntityVersion version : file.getVersions()) {
            versionIds.add(((PrimaryDataEntityVersionImplementation)version).getId());
            Path path = file.getPathToLocalFile(version);
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DataManager.getImplProv().getLogger().info((Object)("Deleting PrimaryDataFile '" + file.getName() + "'"));
        Session s = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        s.beginTransaction();
        List allExistingVersionsInDB = s.createCriteria(PrimaryDataEntityVersionImplementation.class).add((Criterion)Restrictions.eq((String)"primaryEntityId", (Object)file.getID())).list();
        s.getTransaction().commit();
        s.close();
        for (PrimaryDataEntityVersionImplementation version : allExistingVersionsInDB) {
            if (versionIds.contains(version.getId())) continue;
            System.out.println("Needless version found " + version.getId());
            Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session.beginTransaction();
            session.delete((Object)version);
            session.getTransaction().commit();
            session.close();
        }
        try {
            Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session.beginTransaction();
            session.delete((Object)file);
            List permissions = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)file.getID())).list();
            for (EdalPermissionImplementation permission : permissions) {
                session.delete((Object)permission);
            }
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteDirectoryAndPermissions(PrimaryDataDirectoryImplementation directory) {
        DataManager.getImplProv().getLogger().info((Object)("Deleting PrimaryDataDirectory " + directory.getName()));
        ArrayList<Integer> versionIds = new ArrayList<Integer>();
        for (PrimaryDataEntityVersion version : directory.getVersions()) {
            versionIds.add(((PrimaryDataEntityVersionImplementation)version).getId());
        }
        Session s = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        s.beginTransaction();
        List allExistingVersionsInDB = s.createCriteria(PrimaryDataEntityVersionImplementation.class).add((Criterion)Restrictions.eq((String)"primaryEntityId", (Object)directory.getID())).list();
        s.getTransaction().commit();
        s.close();
        for (PrimaryDataEntityVersionImplementation version : allExistingVersionsInDB) {
            if (versionIds.contains(version.getId())) continue;
            System.out.println("Needless version found " + version.getId());
            Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session.beginTransaction();
            session.delete((Object)version);
            session.getTransaction().commit();
            session.close();
        }
        try {
            Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session.beginTransaction();
            session.delete((Object)directory);
            List permissions = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)directory.getID())).list();
            for (EdalPermissionImplementation permission : permissions) {
                session.delete((Object)permission);
            }
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Long listDir(PublicReference reference, PrimaryDataDirectory directory) throws PrimaryDataDirectoryException, MetaDataException {
        if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(reference.getInternalID()) + "/" + directory.getID())) {
            return CalculateDirectorySizeThread.directorySizes.get(String.valueOf(reference.getInternalID()) + "/" + directory.getID());
        }
        List<PrimaryDataEntity> list = directory.listPrimaryDataEntities();
        Long dirSize = new Long(0L);
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                DataSize mySize = (DataSize)primaryDataEntity.getMetaData().getElementValue(EnumDublinCoreElements.SIZE);
                dirSize = dirSize + mySize.getFileSize();
                if (primaryDataEntity.isDirectory()) {
                    dirSize = dirSize + this.listDir(reference, (PrimaryDataDirectory)primaryDataEntity);
                    continue;
                }
                if (!reference.getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) continue;
                numberOfFiles = numberOfFiles + 1L;
            }
            CalculateDirectorySizeThread.directorySizes.put(String.valueOf(reference.getInternalID()) + "/" + directory.getID(), dirSize);
        }
        return dirSize;
    }

    private void storeValuesToDisk() {
        ObjectOutputStream oos;
        File file = PATH_FOR_DIRECTORY_SIZE_MAP.toFile();
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(CalculateDirectorySizeThread.directorySizes);
            oos.close();
        }
        catch (Exception e) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
        }
        file = PATH_FOR_TOTAL_FILE_NUMBER.toFile();
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(numberOfFiles);
            oos.close();
        }
        catch (Exception e) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
        }
        file = PATH_FOR_TOTAL_VOLUME.toFile();
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(CalculateDirectorySizeThread.totalVolumeDataStock);
            oos.close();
        }
        catch (Exception e) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
        }
    }

    @Override
    public synchronized void calculateDirectorySizes() {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        List references = session.createCriteria(PublicReferenceImplementation.class).list();
        session.close();
        boolean updated = false;
        for (PublicReferenceImplementation reference : references) {
            if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(reference.getInternalID()) + "/" + reference.getVersion().getEntity().getID())) continue;
            try {
                Long size = this.listDir(reference, (PrimaryDataDirectory)reference.getVersion().getEntity());
                if (reference.getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) {
                    CalculateDirectorySizeThread.totalVolumeDataStock += size.longValue();
                }
                this.storeValuesToDisk();
                updated = true;
            }
            catch (PrimaryDataDirectoryException | MetaDataException e) {
                e.printStackTrace();
            }
        }
        if (updated) {
            DataManager.getImplProv().getLogger().info((Object)"Cleaning Webpage_Cache...");
            EdalJettyHandler.cache.clean();
            DataManager.getImplProv().getLogger().info((Object)"Webpage_Cache cleaned");
        }
    }

    @Override
    public int getNumberOfUsers() {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        List numberOfUsers = session.createCriteria(PrincipalImplementation.class).list();
        session.getTransaction().commit();
        session.close();
        return numberOfUsers.size();
    }

    @Override
    public void cleanUpForBrokenEntities(PrimaryDataDirectory root) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        List users = session.createCriteria(PrincipalImplementation.class).list();
        session.getTransaction().commit();
        session.close();
        for (PrincipalImplementation principal : users) {
            String user = principal.getName();
            try {
                for (PrimaryDataEntity entity : root.listPrimaryDataEntities()) {
                    if (!entity.getName().equals(user)) continue;
                    for (PrimaryDataEntity ent : ((PrimaryDataDirectory)entity).listPrimaryDataEntities()) {
                        if (!ent.isDirectory() || ent.getPublicReferences().size() != 0) continue;
                        Calendar today = Calendar.getInstance();
                        today.add(6, -14);
                        Calendar c = ent.getCurrentVersion().getCreationDate();
                        if (!c.before(today)) continue;
                        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info((Object)"CLEAN UP for broken Entities initiated");
                        this.deleteRecursiveDirectory((PrimaryDataDirectoryImplementation)ent);
                        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info((Object)"CLEAN UP for broken Entities finished");
                        this.setCleaned(true);
                    }
                }
            }
            catch (PrimaryDataDirectoryException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isCleaned() {
        return cleaned;
    }

    @Override
    public void setCleaned(boolean flag) {
        cleaned = flag;
    }
}

