/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DirectoryMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalLanguage;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EmptyMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Identifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Persons;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Subjects;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalPublicationMetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteMappingException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.XmlFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlAlternateIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlAlternateIdentifiers;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlContributor;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlContributors;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlCreator;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlCreators;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlDates;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlDescription;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlDescriptions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlFormats;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlResource;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlResourceType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlRightsList;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlSizes;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlSubject;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlSubjects;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlTitle;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlTitles;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.types.DescriptionType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.types.ResourceType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Calendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DataCiteXmlMapper {
    private static final String SCHEMA_LOCATION = "http://datacite.org/schema/kernel-4 http://schema.datacite.org/meta/kernel-4/metadata.xsd";
    private PrimaryDataEntityVersion version;

    public DataCiteXmlMapper(PrimaryDataEntityVersion version) {
        this.setVersion(version);
    }

    public Marshaller createXmlMarshaller() throws EdalPublicationMetaDataException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlResource.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.schemaLocation", (Object)SCHEMA_LOCATION);
            return jaxbMarshaller;
        }
        catch (JAXBException e) {
            throw new EdalPublicationMetaDataException("Unable to init JAXB-Marshaller", e);
        }
    }

    public XmlResource createXmlResource() throws EdalPublicationMetaDataException {
        XmlResource resource = new XmlResource();
        try {
            this.setAlternativeIdentifiers(resource);
            this.setCreators(resource);
            this.setContributors(resource);
            this.setDates(resource);
            this.setDescriptions(resource);
            this.setFormats(resource);
            this.setLanguage(resource);
            this.setIdentifier(resource);
            this.setPublicationYear(resource);
            this.setPublisher(resource);
            this.setTitles(resource);
            this.setSizes(resource);
            this.setSubjects(resource);
            this.setResourceType(resource);
            this.setRights(resource);
            this.setVersion(resource);
        }
        catch (DataCiteMappingException e) {
            throw new EdalPublicationMetaDataException("unable to map metadata to DataCite XML", e);
        }
        return resource;
    }

    protected MetaData getMetaData() {
        return this.getVersion().getMetaData();
    }

    protected PrimaryDataEntityVersion getVersion() {
        return this.version;
    }

    private void setAlternativeIdentifiers(XmlResource resource) throws DataCiteMappingException {
        XmlAlternateIdentifiers alternateIdentifiers = new XmlAlternateIdentifiers();
        try {
            Identifier id = (Identifier)this.getMetaData().getElementValue(EnumDublinCoreElements.IDENTIFIER);
            if (!id.getID().equals("Unknown_ID".toString())) {
                alternateIdentifiers.addAlternateIdentifier(new XmlAlternateIdentifier((Identifier)this.getMetaData().getElementValue(EnumDublinCoreElements.IDENTIFIER)));
                resource.setAlternateIdentifiers(alternateIdentifiers);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataCiteMappingException("unable to add identifiers", e);
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
    }

    private void setContributors(XmlResource resource) throws DataCiteMappingException {
        XmlContributors contributors = new XmlContributors();
        try {
            Persons persons = (Persons)this.getMetaData().getElementValue(EnumDublinCoreElements.CONTRIBUTOR);
            for (Person person : persons.getPersons()) {
                XmlContributor contributor = new XmlContributor(person);
                contributors.addContributor(contributor);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataCiteMappingException("unable to add contributor", e);
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
        resource.setContributors(contributors);
    }

    private void setCreators(XmlResource resource) throws DataCiteMappingException {
        XmlCreators creators = new XmlCreators();
        try {
            Persons persons = (Persons)this.getMetaData().getElementValue(EnumDublinCoreElements.CREATOR);
            for (Person person : persons.getPersons()) {
                creators.addCreator(new XmlCreator(person));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataCiteMappingException("unable to add creator", e);
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
        resource.setCreators(creators);
    }

    private void setDates(XmlResource resource) throws DataCiteMappingException {
        try {
            XmlDates dates = new XmlDates((DateEvents)this.getMetaData().getElementValue(EnumDublinCoreElements.DATE));
            if (dates.getDate().length != 0) {
                resource.setDates(dates);
            }
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
    }

    private void setDescriptions(XmlResource resource) throws DataCiteMappingException {
        XmlDescriptions descriptions = new XmlDescriptions();
        try {
            XmlDescription description = new XmlDescription(((UntypedData)this.getMetaData().getElementValue(EnumDublinCoreElements.DESCRIPTION)).getString());
            description.setDescriptionType(DescriptionType.Abstract);
            descriptions.addDescription(description);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataCiteMappingException("unable to add descriptions", e);
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
        resource.setDescriptions(descriptions);
    }

    private void setFormats(XmlResource resource) throws DataCiteMappingException {
        XmlFormats formats = new XmlFormats();
        try {
            if (this.getMetaData().getElementValue(EnumDublinCoreElements.FORMAT).getClass().equals(DataFormat.class)) {
                formats.addFormat(((DataFormat)this.getMetaData().getElementValue(EnumDublinCoreElements.FORMAT)).getMimeType());
                resource.setFormats(formats);
            } else {
                this.getMetaData().getElementValue(EnumDublinCoreElements.FORMAT).getClass().equals(EmptyMetaData.class);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataCiteMappingException("unable to add formats", e);
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
    }

    private void setIdentifier(XmlResource resource) {
        XmlIdentifier identifier = new XmlIdentifier("10.1000/100");
        resource.setIdentifier(identifier);
    }

    private void setLanguage(XmlResource resource) throws DataCiteMappingException {
        try {
            String language = ((EdalLanguage)this.getMetaData().getElementValue(EnumDublinCoreElements.LANGUAGE)).getLanguage().getLanguage();
            if (!language.isEmpty()) {
                resource.setLanguage(language);
            }
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
    }

    private void setPublicationYear(XmlResource resource) {
        resource.setPublicationYear(String.valueOf(Calendar.getInstance().get(1)));
    }

    private void setPublisher(XmlResource resource) throws DataCiteMappingException {
        try {
            Object data = this.getMetaData().getElementValue(EnumDublinCoreElements.PUBLISHER);
            if (data instanceof NaturalPerson) {
                NaturalPerson person = (NaturalPerson)data;
                StringBuffer buffer = new StringBuffer();
                if (!person.getSureName().isEmpty()) {
                    buffer.append(String.valueOf(person.getSureName()) + " ");
                }
                if (!person.getGivenName().isEmpty()) {
                    buffer.append(String.valueOf(person.getGivenName()) + " ");
                }
                if (!person.getZip().isEmpty()) {
                    buffer.append(String.valueOf(person.getZip()) + " ");
                }
                if (!person.getAddressLine().isEmpty()) {
                    buffer.append(String.valueOf(person.getAddressLine()) + " ");
                }
                if (!person.getCountry().isEmpty()) {
                    buffer.append(String.valueOf(person.getCountry()) + " ");
                }
                if (!buffer.toString().isEmpty()) {
                    resource.setPublisher(buffer.toString());
                }
            } else if (data instanceof LegalPerson) {
                LegalPerson person = (LegalPerson)data;
                StringBuffer buffer = new StringBuffer();
                if (!person.getLegalName().isEmpty()) {
                    buffer.append(String.valueOf(person.getLegalName()) + ", ");
                }
                if (!person.getAddressLine().isEmpty()) {
                    buffer.append(String.valueOf(person.getAddressLine()) + ", ");
                }
                if (!person.getZip().isEmpty()) {
                    buffer.append(String.valueOf(person.getZip()) + ", ");
                }
                if (!person.getCountry().isEmpty()) {
                    buffer.append(person.getCountry());
                }
                if (!buffer.toString().isEmpty()) {
                    resource.setPublisher(buffer.toString());
                }
            } else if (!((UntypedData)data).getString().isEmpty()) {
                resource.setPublisher(((UntypedData)data).getString());
            }
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
    }

    private void setResourceType(XmlResource resource) throws DataCiteMappingException {
        try {
            if (this.getMetaData().getElementValue(EnumDublinCoreElements.TYPE).getClass().equals(DataType.class)) {
                XmlResourceType resourceType = new XmlResourceType(((DataType)this.getMetaData().getElementValue(EnumDublinCoreElements.TYPE)).getString());
                resourceType.setResourceTypeGeneral(ResourceType.Dataset);
                resource.setResourceType(resourceType);
            } else if (this.getMetaData().getElementValue(EnumDublinCoreElements.TYPE).getClass().equals(DirectoryMetaData.class)) {
                XmlResourceType resourceType = new XmlResourceType("directory");
                resourceType.setResourceTypeGeneral(ResourceType.Collection);
                resource.setResourceType(resourceType);
            }
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
    }

    private void setRights(XmlResource resource) throws DataCiteMappingException {
        try {
            if (this.getMetaData().getElementValue(EnumDublinCoreElements.RIGHTS) != null && !((UntypedData)this.getMetaData().getElementValue(EnumDublinCoreElements.RIGHTS)).getString().equals("none")) {
                resource.setRightsList(new XmlRightsList((UntypedData)this.getMetaData().getElementValue(EnumDublinCoreElements.RIGHTS)));
            }
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
    }

    private void setSizes(XmlResource resource) throws DataCiteMappingException {
        XmlSizes sizes = new XmlSizes();
        try {
            sizes.addSize(((DataSize)this.getMetaData().getElementValue(EnumDublinCoreElements.SIZE)).getFileSize());
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataCiteMappingException("unable to add sizes", e);
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
        resource.setSizes(sizes);
    }

    private void setSubjects(XmlResource resource) throws DataCiteMappingException {
        XmlSubjects xmlSubjects = new XmlSubjects();
        Subjects subjects = null;
        try {
            subjects = (Subjects)this.getMetaData().getElementValue(EnumDublinCoreElements.SUBJECT);
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
        if (!subjects.isEmpty()) {
            for (UntypedData subject : subjects) {
                try {
                    xmlSubjects.addSubject(new XmlSubject(subject.getString()));
                }
                catch (IndexOutOfBoundsException e) {
                    throw new DataCiteMappingException("unable to add subject", e);
                }
            }
            resource.setSubjects(xmlSubjects);
        }
    }

    private void setTitles(XmlResource resource) throws DataCiteMappingException {
        XmlTitles titles = new XmlTitles();
        try {
            titles.addTitle(new XmlTitle((UntypedData)this.getMetaData().getElementValue(EnumDublinCoreElements.TITLE)));
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataCiteMappingException("unable to add title", e);
        }
        catch (MetaDataException e) {
            throw new DataCiteMappingException("unable to load metadata", e);
        }
        resource.setTitles(titles);
    }

    private void setVersion(PrimaryDataEntityVersion version) {
        this.version = version;
    }

    private void setVersion(XmlResource resource) {
        resource.setVersion(this.version.getRevisionDate().getTime().toString());
    }

    public void validateSchema(XmlResource resource) throws EdalPublicationMetaDataException {
        StringWriter stringWriter = new StringWriter();
        URL dataCiteMetadataSchema = DataCiteXmlMapper.class.getResource("schema-4/metadata.xsd");
        try {
            this.createXmlMarshaller().marshal((Object)resource, (Writer)stringWriter);
            stringWriter.close();
        }
        catch (JAXBException e) {
            throw new EdalPublicationMetaDataException("unable to marshall resource", e);
        }
        catch (IOException e) {
            throw new EdalPublicationMetaDataException("unable to write to StringWriter", e);
        }
        catch (EdalPublicationMetaDataException e) {
            throw new EdalPublicationMetaDataException("unable to create XML-Marshaller", e);
        }
        Document doc = XmlFunctions.parse(stringWriter.toString());
        try {
            XmlFunctions.validate(dataCiteMetadataSchema, doc);
        }
        catch (SAXException e) {
            throw new EdalPublicationMetaDataException("resource object is invalid: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new EdalPublicationMetaDataException("unable to load meta data schema", e);
        }
    }
}

