/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlNameIdentifier;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="creator", propOrder={"creatorName", "givenName", "familyName", "nameIdentifier", "affiliation"})
public class XmlCreator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String creatorName;
    private String givenName;
    private String familyName;
    private String affiliation;
    private XmlNameIdentifier nameIdentifier;

    public XmlCreator() {
    }

    public XmlCreator(String creatorName) {
        this();
        this.setCreatorName(creatorName);
    }

    public XmlCreator(String creatorName, XmlNameIdentifier nameIdentifier) {
        this(creatorName);
        this.setNameIdentifier(nameIdentifier);
    }

    public XmlCreator(Person person) {
        this();
        if (person instanceof NaturalPerson) {
            NaturalPerson naturalPerson = (NaturalPerson)person;
            this.setCreatorName(String.valueOf(naturalPerson.getGivenName()) + " " + naturalPerson.getSureName() + ", " + naturalPerson.getAddressLine() + ", " + naturalPerson.getZip() + ", " + naturalPerson.getCountry());
            this.setGivenName(naturalPerson.getGivenName());
            this.setFamilyName(naturalPerson.getSureName());
        } else if (person instanceof LegalPerson) {
            LegalPerson legalPerson = (LegalPerson)person;
            this.setCreatorName(String.valueOf(legalPerson.getLegalName()) + ", " + legalPerson.getAddressLine() + ", " + legalPerson.getZip() + ", " + legalPerson.getCountry());
        }
    }

    @XmlElement(required=true)
    public String getCreatorName() {
        return this.creatorName;
    }

    @XmlElement
    public XmlNameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setNameIdentifier(XmlNameIdentifier nameIdentifier) {
        this.nameIdentifier = nameIdentifier;
    }

    @XmlElement
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @XmlElement
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @XmlElement
    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }
}

