/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.sample.login;

import de.ipk_gatersleben.bit.bi.edal.sample.login.ORCIDPrincipal;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ORCIDLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> sharedState;
    private Map<String, ?> options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private ORCIDPrincipal principal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.setSharedState(sharedState);
        this.setOptions(options);
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to get authentication information from the user");
        }
        Callback[] callbacks = new Callback[1];
        try {
            callbacks[0] = new NameCallback(" ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.principal = new ORCIDPrincipal(this.username);
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.username = null;
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                int i = 0;
                while (i < this.password.length) {
                    this.password[i] = 32;
                    ++i;
                }
                this.password = null;
            }
            this.principal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            int i = 0;
            while (i < this.password.length) {
                this.password[i] = 32;
                ++i;
            }
            this.password = null;
        }
        this.principal = null;
        return true;
    }

    public Map<String, ?> getSharedState() {
        return this.sharedState;
    }

    public void setSharedState(Map<String, ?> sharedState) {
        this.sharedState = sharedState;
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, ?> options) {
        this.options = options;
    }
}

