/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.util.PlatformUtil;
import com.sun.security.auth.NTUserPrincipal;
import com.sun.security.auth.UnixPrincipal;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.ElixirPrincipal;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.GooglePrincipal;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.SamplePrincipal;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteMDSConnector;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteRestConnector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.SmtpAppender;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public final class EdalConfiguration {
    private static final String NOREPLY_EMAIL_DEFAULT = "noreply@nodomain.com.invalid";
    private static final String MSG_UNABLE_TO_SET_PROXY = "unable to set proxy: ";
    private static Logger logger = null;
    public static final String DATACITE_SEARCH_URL = "http://search.datacite.org/api/";
    private static final String DATACITE_MDS_URL = "https://mds.datacite.org/doi";
    public static final String DATACITE_TESTPREFIX = "10.5072";
    public static final int DATACITE_CONNECTION_TIMEOUT = 10000;
    public static final int DATACITE_CONNECTION_READ_TIMEOUT = 10000;
    public static final int SMTP_CONNECTION_TIMEOUT = 10000;
    public static final int STREAM_BUFFER_SIZE = 0xA00000;
    private static final String[] MAIL_SERVER_NAMES;
    public static final Path DEFAULT_PATH;
    public static final URL KEY_STORE_PATH;
    public static final String KEYSTORE_PASSWORD = "eDALkey";
    public static final List<Class<? extends Principal>> DEFAULT_SUPPORTED_PRINCIPALS;
    public static final String DEFAULT_DATABASE_USERNAME = "sa";
    public static final String DEFAULT_DATABASE_PASSWORD = "";
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    private boolean inTestMode = false;
    private boolean inReadOnlyMode = false;
    private String edalEmailAddress = "noreply";
    private String dataCitePassword;
    private String dataCitePrefix;
    private String dataCiteUser;
    private String doiInfix;
    private String staticServerAdress;
    private int staticServerPort;
    private Path mountPath = DEFAULT_PATH;
    private Path dataPath = DEFAULT_PATH;
    private boolean useSSL = true;
    private InternetAddress errorEmailAddress;
    private Logger errorLogger;
    private String databasePassword;
    private String databaseUsername;
    private int httpPort;
    private int httpsPort;
    private String httpProxyHost;
    private int httpProxyPort;
    private String httpsProxyHost;
    private int httpsProxyPort;
    private String mailSmtpHost;
    private String mailSmtpLogin;
    private String mailSmtpPassword;
    private InternetAddress reviewerManaging;
    private InternetAddress reviewerScientific;
    private InternetAddress reviewerSubstitute;
    private InternetAddress rootUser;
    private List<Class<? extends Principal>> supportedPrincipals;
    private boolean useSystemProxies = false;
    private boolean useSSLForHttpListener = false;
    private URL certificatePathForHttpListener = null;
    private String keystorePasswordForHttpListener = "";
    private boolean cleanBrokenEntities = true;
    private List<String> aliasDomainNames = null;
    private String instanceNameLong = "e!DAL - Plant Genomics & Phenomics Research Data Repository";
    private String instanceNameShort = "e!DAL - PGP Repository";
    private String publisherString = "e!DAL - Plant Genomics and Phenomics Research Data Repository (PGP), IPK Gatersleben";

    static {
        logger = LogManager.getLogger((String)"eDAL-API");
        MAIL_SERVER_NAMES = new String[]{"imap", "pop", "mail", "smtp", "exchange"};
        DEFAULT_PATH = Paths.get(System.getProperty("user.home"), "edal");
        KEY_STORE_PATH = EdalConfiguration.class.getClassLoader().getResource("de/ipk_gatersleben/bit/bi/edal/primary_data/keystore.jks");
        DEFAULT_SUPPORTED_PRINCIPALS = new ArrayList<Class>(Arrays.asList(SamplePrincipal.class, NTUserPrincipal.class, UnixPrincipal.class, KerberosPrincipal.class, GooglePrincipal.class, ElixirPrincipal.class));
    }

    public static InetSocketAddress guessProxySettings() {
        ArrayList<ProxySearch.Strategy> strategies = new ArrayList<ProxySearch.Strategy>();
        if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
            strategies.add(ProxySearch.Strategy.ENV_VAR);
            strategies.add(ProxySearch.Strategy.OS_DEFAULT);
            strategies.add(ProxySearch.Strategy.WIN);
            strategies.add(ProxySearch.Strategy.JAVA);
            strategies.add(ProxySearch.Strategy.BROWSER);
            strategies.add(ProxySearch.Strategy.IE);
            strategies.add(ProxySearch.Strategy.FIREFOX);
        } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.LINUX) {
            strategies.add(ProxySearch.Strategy.ENV_VAR);
            strategies.add(ProxySearch.Strategy.OS_DEFAULT);
            strategies.add(ProxySearch.Strategy.JAVA);
            strategies.add(ProxySearch.Strategy.BROWSER);
            strategies.add(ProxySearch.Strategy.KDE);
            strategies.add(ProxySearch.Strategy.GNOME);
            strategies.add(ProxySearch.Strategy.FIREFOX);
        } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.MAC_OS) {
            strategies.add(ProxySearch.Strategy.ENV_VAR);
            strategies.add(ProxySearch.Strategy.OS_DEFAULT);
            strategies.add(ProxySearch.Strategy.JAVA);
            strategies.add(ProxySearch.Strategy.BROWSER);
            strategies.add(ProxySearch.Strategy.FIREFOX);
        } else {
            strategies.add(ProxySearch.Strategy.OS_DEFAULT);
        }
        ProxySearch proxySearch = null;
        boolean findProxySettings = false;
        InetSocketAddress address = null;
        for (ProxySearch.Strategy strategy : strategies) {
            proxySearch = new ProxySearch();
            proxySearch.addStrategy(strategy);
            try {
                List<Proxy> proxyList = proxySearch.getProxySelector().select(new URI(DATACITE_MDS_URL));
                if (proxyList != null) {
                    for (Proxy proxy2 : proxyList) {
                        Proxy proxy = proxy2;
                        if (!proxy.type().equals((Object)Proxy.Type.HTTP) || (address = (InetSocketAddress)proxy.address()) == null) continue;
                        logger.info("Found HTTP Proxy : " + address.getHostName() + ":" + address.getPort());
                        findProxySettings = true;
                    }
                }
            }
            catch (NullPointerException | URISyntaxException exception) {
                logger.debug("No Proxy Settings found for Strategy " + strategy);
            }
            if (!findProxySettings) continue;
            logger.info("Proxy Settings determined automatically for Strategy : " + strategy);
            return address;
        }
        if (!findProxySettings) {
            logger.info("No automatic Proxy Settings found");
        }
        return null;
    }

    public static String guessSmtpSettings(String smtpLogin, String smtpPassword) throws EdalConfigurationException {
        String[] stringArray = MAIL_SERVER_NAMES;
        int n = MAIL_SERVER_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String mailServerNames = stringArray[n2];
            try {
                if (!System.getenv("userdnsdomain").isEmpty()) {
                    mailServerNames = String.valueOf(mailServerNames) + "." + System.getenv("userdnsdomain").toLowerCase(Locale.ENGLISH);
                }
            }
            catch (NullPointerException nullPointerException) {
                try {
                    if (InetAddress.getLocalHost().getCanonicalHostName().contains(".")) {
                        String domain = InetAddress.getLocalHost().getCanonicalHostName().substring(InetAddress.getLocalHost().getCanonicalHostName().indexOf(".") + 1, InetAddress.getLocalHost().getCanonicalHostName().length());
                        mailServerNames = String.valueOf(mailServerNames) + "." + domain.toLowerCase(Locale.ENGLISH);
                    }
                }
                catch (UnknownHostException unknownHostException) {}
            }
            Properties properties = new Properties();
            properties.put("mail.smtp.host", mailServerNames);
            properties.put("mail.smtp.connectiontimeout", (Object)10000);
            properties.put("mail.smtp.timeout", (Object)10000);
            properties.put("mail.smtp.ssl.trust", mailServerNames);
            Session session = Session.getDefaultInstance((Properties)properties);
            try {
                if (!smtpLogin.isEmpty() && !smtpPassword.isEmpty()) {
                    Transport transport = session.getTransport("smtp");
                    transport.connect(mailServerNames, smtpLogin, smtpPassword);
                    transport.close();
                } else {
                    Transport transport = session.getTransport("smtp");
                    transport.connect(mailServerNames, null, null);
                    transport.close();
                }
                logger.info("SMTP connection test: " + mailServerNames + " : successful");
                return mailServerNames;
            }
            catch (MessagingException e) {
                e.printStackTrace();
                logger.warn("SMTP connection test: " + mailServerNames + " -> failed : " + e.getMessage());
                ++n2;
            }
        }
        throw new EdalConfigurationException("unable to connect to eMail Server, check SMTP settings");
    }

    private EdalConfiguration() throws EdalConfigurationException {
        this.setDatabaseUsername(DEFAULT_DATABASE_USERNAME);
        this.setDatabasePassword(DEFAULT_DATABASE_PASSWORD);
        this.setSupportedPrincipals(DEFAULT_SUPPORTED_PRINCIPALS);
        this.setHttpPort(80);
        this.setHttpsPort(443);
        this.setMailSmtpHost(DEFAULT_DATABASE_PASSWORD);
        this.setMailSmtpLogin(DEFAULT_DATABASE_PASSWORD);
        this.setMailSmtpPassword(DEFAULT_DATABASE_PASSWORD);
    }

    public EdalConfiguration(String dataCiteUser, String dataCitePassword, String dataCitePrefix, InternetAddress scientificReviewer, InternetAddress substituteReviewer, InternetAddress managingReviewer, InternetAddress rootUser) throws EdalConfigurationException {
        this();
        this.setDataCiteUser(dataCiteUser);
        this.setDataCitePassword(dataCitePassword);
        this.setDataCitePrefix(dataCitePrefix);
        this.setReviewerScientific(scientificReviewer);
        this.setReviewerSubstitute(substituteReviewer);
        this.setReviewerManaging(managingReviewer);
        this.setRootUser(rootUser);
        this.setErrorEmailAddress(rootUser);
        this.validate();
    }

    public EdalConfiguration(String dataCiteUser, String dataCitePassword, String dataCitePrefix, InternetAddress scientificReviewer, InternetAddress substituteReviewer, InternetAddress managingReviewer, InternetAddress rootUser, String httpProxyHost, int httpProxyPort, String httpsProxyHost, int httpsProxyPort, String smtpHost, String smtpLogin, String smtpPassword) throws EdalConfigurationException {
        this();
        this.setUseSystemProxies(true);
        this.setHttpProxyHost(httpProxyHost);
        this.setHttpProxyPort(httpProxyPort);
        this.setHttpsProxyHost(httpsProxyHost);
        this.setHttpsProxyPort(httpsProxyPort);
        this.setDataCiteUser(dataCiteUser);
        this.setDataCitePassword(dataCitePassword);
        this.setDataCitePrefix(dataCitePrefix);
        this.setReviewerScientific(scientificReviewer);
        this.setReviewerSubstitute(substituteReviewer);
        this.setReviewerManaging(managingReviewer);
        this.setRootUser(rootUser);
        this.setErrorEmailAddress(rootUser);
        this.setMailSmtpHost(smtpHost);
        this.setMailSmtpLogin(smtpLogin);
        this.setMailSmtpPassword(smtpPassword);
        this.validate();
    }

    public EdalConfiguration(String dataCiteUser, String dataCitePassword, String dataCitePrefix, InternetAddress scientificReviewer, InternetAddress substituteReviewer, InternetAddress managingReviewer, InternetAddress rootUser, String smtpHost, String smtpLogin, String smtpPassword) throws EdalConfigurationException {
        this();
        this.setDataCiteUser(dataCiteUser);
        this.setDataCitePassword(dataCitePassword);
        this.setDataCitePrefix(dataCitePrefix);
        this.setReviewerScientific(scientificReviewer);
        this.setReviewerSubstitute(substituteReviewer);
        this.setReviewerManaging(managingReviewer);
        this.setRootUser(rootUser);
        this.setErrorEmailAddress(rootUser);
        this.setMailSmtpHost(smtpHost);
        this.setMailSmtpLogin(smtpLogin);
        this.setMailSmtpPassword(smtpPassword);
        this.validate();
    }

    public void addSupportedPrincipal(Class<? extends Principal> principal) {
        this.supportedPrincipals.add(principal);
    }

    public List<String> getAliasDomainNames() {
        return this.aliasDomainNames;
    }

    protected URL getCertificatePathForHttpListener() {
        return this.certificatePathForHttpListener;
    }

    public String getDatabasePassword() throws EdalConfigurationException {
        if (this.databasePassword == null) {
            throw new EdalConfigurationException("no database password set!");
        }
        return this.databasePassword;
    }

    public String getDatabaseUsername() throws EdalConfigurationException {
        if (this.databaseUsername == null || this.databaseUsername.isEmpty()) {
            throw new EdalConfigurationException("no database user name set!");
        }
        return this.databaseUsername;
    }

    public String getDataCitePassword() throws EdalConfigurationException {
        if (this.dataCitePassword == null || this.dataCitePassword.isEmpty()) {
            throw new EdalConfigurationException("no DataCite password set!");
        }
        return this.dataCitePassword;
    }

    public String getDataCitePrefix() throws EdalConfigurationException {
        if (this.dataCitePrefix == null || this.dataCitePrefix.isEmpty()) {
            throw new EdalConfigurationException("no DataCite prefix set!");
        }
        return this.dataCitePrefix;
    }

    public String getDataCiteUser() throws EdalConfigurationException {
        if (this.dataCiteUser == null || this.dataCiteUser.isEmpty()) {
            throw new EdalConfigurationException("no DataCite user name set!");
        }
        return this.dataCiteUser;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public String getDoiInfix() {
        return this.doiInfix;
    }

    public String getEdalEmailAddress() {
        return this.edalEmailAddress;
    }

    private void setEdalEmailAddress(String emailaddress) {
        this.edalEmailAddress = emailaddress;
    }

    protected InternetAddress getErrorEmailAddress() throws EdalConfigurationException {
        if (this.errorEmailAddress == null) {
            throw new EdalConfigurationException("no error Email address set!");
        }
        return this.errorEmailAddress;
    }

    public Logger getErrorLogger() {
        return this.errorLogger;
    }

    public int getHttpPort() throws EdalConfigurationException {
        if (this.httpPort == 0) {
            throw new EdalConfigurationException("no http port set! ");
        }
        return this.httpPort;
    }

    public String getHttpProxyHost() throws EdalConfigurationException {
        if (this.httpProxyHost == null || this.httpProxyHost.isEmpty()) {
            throw new EdalConfigurationException("no HTTP proxy host set!");
        }
        return this.httpProxyHost;
    }

    public int getHttpProxyPort() throws EdalConfigurationException {
        if (this.httpProxyPort == 0) {
            throw new EdalConfigurationException("no HTTP proxy port set!");
        }
        return this.httpProxyPort;
    }

    public int getHttpsPort() throws EdalConfigurationException {
        if (this.httpsPort == 0) {
            throw new EdalConfigurationException("no https port set! ");
        }
        return this.httpsPort;
    }

    public String getHttpsProxyHost() throws EdalConfigurationException {
        if (this.httpsProxyHost == null || this.httpsProxyHost.isEmpty()) {
            throw new EdalConfigurationException("no HTTPS proxy host set!");
        }
        return this.httpsProxyHost;
    }

    public int getHttpsProxyPort() throws EdalConfigurationException {
        if (this.httpsProxyPort == 0) {
            throw new EdalConfigurationException("no HTTPS port host set!");
        }
        return this.httpsProxyPort;
    }

    protected String getKeystorePasswordForHttpListener() {
        return this.keystorePasswordForHttpListener;
    }

    public Logger getLogger() {
        return logger;
    }

    public String getMailSmtpHost() {
        return this.mailSmtpHost;
    }

    public String getMailSmtpLogin() {
        return this.mailSmtpLogin;
    }

    public String getMailSmtpPassword() {
        return this.mailSmtpPassword;
    }

    public Path getMountPath() {
        return this.mountPath;
    }

    public InternetAddress getReviewerManaging() throws EdalConfigurationException {
        if (this.reviewerManaging == null) {
            throw new EdalConfigurationException("no email address for the managing reviewer set!");
        }
        try {
            this.reviewerManaging.validate();
        }
        catch (AddressException e) {
            throw new EdalConfigurationException("invalid email address for managing reviewer: " + e.getMessage());
        }
        return this.reviewerManaging;
    }

    public InternetAddress getReviewerScientific() throws EdalConfigurationException {
        if (this.reviewerScientific == null) {
            throw new EdalConfigurationException("no email address for the scientific reviewer set!");
        }
        try {
            this.reviewerScientific.validate();
        }
        catch (AddressException e) {
            throw new EdalConfigurationException("invalid email address for scientific reviewer: " + e.getMessage());
        }
        return this.reviewerScientific;
    }

    public InternetAddress getReviewerSubstitute() throws EdalConfigurationException {
        if (this.reviewerSubstitute == null) {
            throw new EdalConfigurationException("no email address for the substitute reviewer set!");
        }
        try {
            this.reviewerSubstitute.validate();
        }
        catch (AddressException e) {
            throw new EdalConfigurationException("invalid email address for substitute reviewer: " + e.getMessage());
        }
        return this.reviewerSubstitute;
    }

    public InternetAddress getRootUser() throws EdalConfigurationException {
        if (this.rootUser == null) {
            throw new EdalConfigurationException("no email address for the root user set!");
        }
        try {
            this.rootUser.validate();
        }
        catch (AddressException e) {
            throw new EdalConfigurationException("invalid email address for root user: " + e.getMessage());
        }
        return this.rootUser;
    }

    public String getStaticServerAdress() {
        return this.staticServerAdress;
    }

    public int getStaticServerPort() {
        return this.staticServerPort;
    }

    public List<Class<? extends Principal>> getSupportedPrincipals() throws EdalConfigurationException {
        if (this.supportedPrincipals.isEmpty()) {
            throw new EdalConfigurationException("no supported principals defined!");
        }
        return this.supportedPrincipals;
    }

    public boolean isInTestMode() {
        return this.inTestMode;
    }

    public boolean isReadOnly() {
        return this.inReadOnlyMode;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public boolean isUseSSLForHttpListener() {
        return this.useSSLForHttpListener;
    }

    public boolean isUseSystemProxies() {
        return this.useSystemProxies;
    }

    private List<String> requestRegisteredDataCiteDomainName() throws EdalConfigurationException {
        JerseyClient client = JerseyClientBuilder.createClient();
        JerseyWebTarget webResource = client.target("https://api.datacite.org/prefixes/" + this.dataCitePrefix);
        Response response = webResource.request(new String[]{"application/json"}).get();
        JSONObject json = null;
        try {
            json = (JSONObject)new JSONParser().parse((String)response.readEntity(String.class));
        }
        catch (ParseException e) {
            client.close();
            e.printStackTrace();
        }
        JSONArray included = (JSONArray)json.get((Object)"included");
        JSONObject eins = (JSONObject)included.get(0);
        JSONObject attributes = (JSONObject)eins.get((Object)"attributes");
        String domains = (String)attributes.get((Object)"domains");
        if (domains.contains(",")) {
            String[] registeredDomains = domains.split(",");
            return Arrays.asList(registeredDomains);
        }
        return new ArrayList<String>(Arrays.asList(domains));
    }

    private void setAliasDomainNames(List<String> aliasDomainNames) {
        this.aliasDomainNames = aliasDomainNames;
    }

    protected void setCertificatePathForHttpListener(URL certificatePathForHttpListener) {
        this.certificatePathForHttpListener = certificatePathForHttpListener;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public void setDatabaseUsername(String databaseUsername) {
        this.databaseUsername = databaseUsername;
    }

    private void setDataCitePassword(String dataCitePassword) {
        this.dataCitePassword = dataCitePassword;
    }

    private void setDataCitePrefix(String dataCitePrefix) {
        this.dataCitePrefix = dataCitePrefix;
    }

    private void setDataCiteUser(String dataCiteUser) {
        this.dataCiteUser = dataCiteUser;
    }

    public void setDataPath(Path dataPath) {
        this.dataPath = dataPath;
    }

    public void setDoiInfix(String doiInfix) throws EdalConfigurationException {
        if (doiInfix == null || doiInfix.isEmpty()) {
            throw new EdalConfigurationException("It is not allow to set an empty infix for DOI generation");
        }
        this.doiInfix = doiInfix;
    }

    protected void setErrorEmailAddress(InternetAddress errorEmailAddress) {
        this.errorEmailAddress = errorEmailAddress;
    }

    private void setErrorLogger(Logger errorLogger) {
        this.errorLogger = errorLogger;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public void setHttpsProxyHost(String httpsProxyHost) {
        this.httpsProxyHost = httpsProxyHost;
    }

    public void setHttpsProxyPort(int httpsProxyPort) {
        this.httpsProxyPort = httpsProxyPort;
    }

    private void setInTestMode(boolean inTestMode) {
        this.inTestMode = inTestMode;
    }

    protected void setKeystorePasswordForHttpListener(String keystorePasswordForHttpListener) {
        this.keystorePasswordForHttpListener = keystorePasswordForHttpListener;
    }

    public void setMailSmtpHost(String mailSmtpHost) {
        this.mailSmtpHost = mailSmtpHost;
    }

    public void setMailSmtpLogin(String mailSmtpLogin) {
        this.mailSmtpLogin = mailSmtpLogin;
    }

    public void setMailSmtpPassword(String mailSmtpPassword) {
        this.mailSmtpPassword = mailSmtpPassword;
    }

    public void setMountPath(Path mountPath) {
        this.mountPath = mountPath;
    }

    private void setReadOnly(boolean inReadOnlyMode) {
        this.inReadOnlyMode = inReadOnlyMode;
    }

    private void setReviewerManaging(InternetAddress reviewerManaging) {
        this.reviewerManaging = reviewerManaging;
    }

    private void setReviewerScientific(InternetAddress reviewerScientific) {
        this.reviewerScientific = reviewerScientific;
    }

    private void setReviewerSubstitute(InternetAddress reviewerSubstitute) {
        this.reviewerSubstitute = reviewerSubstitute;
    }

    private void setRootUser(InternetAddress rootUser) {
        this.rootUser = rootUser;
    }

    public void setStaticServerAdress(String staticServerAdress) {
        this.staticServerAdress = staticServerAdress;
    }

    public void setStaticServerPort(int staticServerPort) {
        this.staticServerPort = staticServerPort;
    }

    public void setSupportedPrincipals(List<Class<? extends Principal>> supportedPrincipals) {
        this.supportedPrincipals = supportedPrincipals;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setUseSSLForHttpListener(boolean useSSLForHttpListener, URL pathToKeyStore, String keystorePassword) {
        this.useSSLForHttpListener = useSSLForHttpListener;
        this.setCertificatePathForHttpListener(pathToKeyStore);
        this.setKeystorePasswordForHttpListener(keystorePassword);
    }

    public void setUseSystemProxies(boolean useSystemProxies) {
        this.useSystemProxies = useSystemProxies;
    }

    private boolean validate() throws EdalConfigurationException {
        this.getMountPath();
        this.getDatabaseUsername();
        this.getDatabasePassword();
        this.getHttpPort();
        this.getHttpsPort();
        this.getSupportedPrincipals();
        this.getReviewerScientific();
        this.getReviewerSubstitute();
        this.getReviewerManaging();
        this.getRootUser();
        this.validateProxies();
        this.validateSmtpSettings();
        try {
            this.validateDataCiteConnection();
            this.validateDataCiteAuthentication();
            this.validateDateCiteRestAPI();
        }
        catch (EdalConfigurationException e) {
            logger.warn("DataCite validation failed, System is running in read-only Mode: " + e.getMessage());
            this.errorLogger.fatal("DataCite validation failed, System is running in read-only Mode: " + e.getMessage());
            this.setReadOnly(true);
        }
        return true;
    }

    private boolean validateDataCiteAuthentication() throws EdalConfigurationException {
        if (!this.getDataCitePrefix().equals(DATACITE_TESTPREFIX)) {
            DataCiteMDSConnector connector;
            this.getDataCiteUser();
            this.getDataCitePassword();
            this.getDataCitePrefix();
            String dataCitePassword = this.getDataCitePassword();
            if (dataCitePassword.startsWith("#")) {
                try {
                    CodeSource codeSource = EdalConfiguration.class.getProtectionDomain().getCodeSource();
                    File currentFile = new File(codeSource.getLocation().toURI().getPath());
                    String currentPath = currentFile.getParentFile().getPath();
                    Properties prop = new Properties();
                    FileInputStream input = new FileInputStream(Paths.get(currentPath, "key.property").toFile());
                    prop.load(input);
                    ((InputStream)input).close();
                    dataCitePassword = dataCitePassword.substring(1, dataCitePassword.length());
                    byte[] key = prop.getProperty("key").getBytes("UTF-8");
                    MessageDigest sha = MessageDigest.getInstance("SHA-256");
                    key = sha.digest(key);
                    key = Arrays.copyOf(key, 16);
                    SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
                    byte[] crypted = Base64.getDecoder().decode(dataCitePassword);
                    Cipher cipher = Cipher.getInstance("AES");
                    cipher.init(2, secretKeySpec);
                    this.setDataCitePassword(new String(cipher.doFinal(crypted)));
                }
                catch (IOException | URISyntaxException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    logger.warn("DataCite password decryption failed : " + e.getMessage());
                }
            }
            try {
                connector = new DataCiteMDSConnector(this);
            }
            catch (EdalException edalException) {
                throw new EdalConfigurationException("DataCite Authentification Test failed : unable to create DataCiteMDSConnector");
            }
            Response response = connector.getDOI(String.valueOf(this.getDataCitePrefix()) + "/" + UUID.randomUUID().toString());
            if (response.getStatus() == 404 || response.getStatus() == 200) {
                logger.info("DataCite Authentification Test: successful");
                try {
                    DataCiteRestConnector restConnector = new DataCiteRestConnector(this);
                    if (!restConnector.checkIfPrefixIsRegisteredForDataCenterId()) {
                        throw new EdalConfigurationException("DataCite Prefix Test failed : this given prefix is not registered for the given DataCite account");
                    }
                    logger.info("DataCite Prefix Test: successful");
                }
                catch (DataCiteException dataCiteException) {
                    throw new EdalConfigurationException("DataCite Prefix Test failed : unabel tot check prefix");
                }
            } else {
                if (response.getStatus() == 401) {
                    throw new EdalConfigurationException("DataCite Authentification failed: please check username and password");
                }
                if (response.getStatus() == 500) {
                    throw new EdalConfigurationException("DataCite Authentification failed: please check prefix");
                }
                throw new EdalConfigurationException("DataCite Authentification Test failed: " + response.getStatus() + " : " + response.getStatusInfo().getReasonPhrase());
            }
            List<String> landingPageDomainNames = this.requestRegisteredDataCiteDomainName();
            if (landingPageDomainNames == null) {
                throw new EdalConfigurationException("DataCite Domain Check failed: no registrated domain found");
            }
            logger.info("DataCite Domain Check: " + landingPageDomainNames.toString());
            this.setAliasDomainNames(landingPageDomainNames);
            return true;
        }
        this.setInTestMode(true);
        logger.warn("DataCite Authentication : skiped (Publication-Module is running in test mode)");
        return true;
    }

    private boolean validateDataCiteConnection() throws EdalConfigurationException {
        try {
            logger.debug("connecting to DataCite...");
            Authenticator.setDefault(null);
            URL url = new URL(DATACITE_MDS_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("Authorization", null);
            connection.getResponseCode();
            logger.info("DataCite Connection Test : successful");
            return true;
        }
        catch (IOException e) {
            throw new EdalConfigurationException("unable to access DataCite : " + e.getMessage() + ", please check your proxy settings", e);
        }
    }

    private boolean validateDateCiteRestAPI() throws EdalConfigurationException {
        JerseyClient client = JerseyClientBuilder.createClient();
        JerseyWebTarget webResource = client.target("https://api.datacite.org/prefixes/" + this.dataCitePrefix);
        Response response = webResource.request(new String[]{"application/json"}).get();
        if (response.getStatus() == 200) {
            client.close();
            logger.info("DataCite RestAPI Test : successful");
            return true;
        }
        client.close();
        logger.error("DataCite RestAPI Test failed");
        throw new EdalConfigurationException("unable to connect to DataCite RestAPI: " + (String)response.readEntity(String.class));
    }

    private boolean validateProxies() throws EdalConfigurationException {
        if ((this.httpProxyHost == null || this.httpProxyHost.isEmpty()) && (this.httpsProxyHost == null || this.httpsProxyHost.isEmpty()) && this.httpProxyPort == 0 & this.httpsProxyPort == 0) {
            logger.info("No Proxy Settings configured");
            this.setUseSystemProxies(false);
        }
        if (this.isUseSystemProxies()) {
            System.setProperty("java.net.useSystemProxies", "true");
            try {
                this.getHttpProxyHost();
                System.setProperty("http.proxyHost", this.getHttpProxyHost());
            }
            catch (EdalConfigurationException e) {
                logger.error(MSG_UNABLE_TO_SET_PROXY + e.getMessage());
            }
            try {
                this.getHttpProxyPort();
                System.setProperty("http.proxyPort", String.valueOf(this.getHttpProxyPort()));
            }
            catch (EdalConfigurationException e) {
                logger.error("unabale to set Proxy : " + e.getMessage());
            }
            try {
                this.getHttpsProxyHost();
                System.setProperty("https.proxyHost", this.getHttpsProxyHost());
            }
            catch (EdalConfigurationException e) {
                logger.error(MSG_UNABLE_TO_SET_PROXY + e.getMessage());
            }
            try {
                this.getHttpsProxyPort();
                System.setProperty("https.proxyPort", String.valueOf(this.getHttpsProxyPort()));
            }
            catch (EdalConfigurationException e) {
                logger.error(MSG_UNABLE_TO_SET_PROXY + e.getMessage());
            }
            logger.info("apply manual proxy settings");
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("https.proxyHost");
            System.clearProperty("https.proxyPort");
            ArrayList<ProxySearch.Strategy> strategies = new ArrayList<ProxySearch.Strategy>();
            if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
                strategies.add(ProxySearch.Strategy.OS_DEFAULT);
                strategies.add(ProxySearch.Strategy.WIN);
                strategies.add(ProxySearch.Strategy.ENV_VAR);
                strategies.add(ProxySearch.Strategy.JAVA);
                strategies.add(ProxySearch.Strategy.BROWSER);
                strategies.add(ProxySearch.Strategy.IE);
                strategies.add(ProxySearch.Strategy.FIREFOX);
            } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.LINUX) {
                strategies.add(ProxySearch.Strategy.OS_DEFAULT);
                strategies.add(ProxySearch.Strategy.ENV_VAR);
                strategies.add(ProxySearch.Strategy.JAVA);
                strategies.add(ProxySearch.Strategy.BROWSER);
                strategies.add(ProxySearch.Strategy.KDE);
                strategies.add(ProxySearch.Strategy.GNOME);
                strategies.add(ProxySearch.Strategy.FIREFOX);
            } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.MAC_OS) {
                strategies.add(ProxySearch.Strategy.OS_DEFAULT);
                strategies.add(ProxySearch.Strategy.ENV_VAR);
                strategies.add(ProxySearch.Strategy.JAVA);
                strategies.add(ProxySearch.Strategy.BROWSER);
                strategies.add(ProxySearch.Strategy.FIREFOX);
            } else {
                strategies.add(ProxySearch.Strategy.OS_DEFAULT);
            }
            ProxySearch proxySearch = null;
            boolean findProxySettings = false;
            for (ProxySearch.Strategy strategy : strategies) {
                proxySearch = new ProxySearch();
                proxySearch.addStrategy(strategy);
                try {
                    List<Proxy> proxyList = proxySearch.getProxySelector().select(new URI(DATACITE_MDS_URL));
                    if (proxyList != null) {
                        for (Proxy proxy2 : proxyList) {
                            InetSocketAddress address;
                            Proxy proxy = proxy2;
                            if (!proxy.type().equals((Object)Proxy.Type.HTTP) || (address = (InetSocketAddress)proxy.address()) == null) continue;
                            System.setProperty("http.proxyHost", address.getHostName());
                            System.setProperty("https.proxyHost", address.getHostName());
                            System.setProperty("http.proxyPort", Integer.toString(address.getPort()));
                            System.setProperty("https.proxyPort", Integer.toString(address.getPort()));
                            logger.info("Found HTTP Proxy : " + address.getHostName() + ":" + address.getPort());
                            this.setHttpProxyHost(address.getHostName());
                            this.setHttpProxyPort(address.getPort());
                            this.setHttpsProxyHost(address.getHostName());
                            this.setHttpsProxyPort(address.getPort());
                            findProxySettings = true;
                        }
                    }
                }
                catch (NullPointerException | URISyntaxException exception) {
                    logger.debug("No Proxy Settings found for Strategy " + strategy);
                }
                if (!findProxySettings) continue;
                logger.info("Proxy Settings determined automatically for Strategy : " + strategy);
                break;
            }
            if (!findProxySettings) {
                logger.info("No automatic Proxy Settings found");
            }
        }
        return true;
    }

    private boolean validateSmtpSettings() throws EdalConfigurationException {
        if (!this.getMailSmtpHost().isEmpty()) {
            Properties properties = new Properties();
            properties.put("mail.smtp.host", this.getMailSmtpHost());
            properties.put("mail.smtp.connectiontimeout", (Object)10000);
            properties.put("mail.smtp.timeout", (Object)10000);
            properties.put("mail.smtp.ssl.trust", this.getMailSmtpHost());
            Session session = Session.getDefaultInstance((Properties)properties);
            if (this.getMailSmtpLogin() == null || this.getMailSmtpLogin().isEmpty()) {
                try {
                    Transport transport = session.getTransport("smtp");
                    transport.connect(this.getMailSmtpHost(), null, null);
                    transport.close();
                    logger.info("SMTP Connection Test -> successful");
                    this.setEdalEmailAddress(NOREPLY_EMAIL_DEFAULT);
                }
                catch (MessagingException e) {
                    logger.warn("SMTP Connection Test -> failed : " + e.getMessage());
                    throw new EdalConfigurationException("unable to connect to eMail Server, check SMTP settings : " + e.getMessage());
                }
                return true;
            }
            try {
                Transport transport = session.getTransport("smtp");
                transport.connect(this.getMailSmtpHost(), this.getMailSmtpLogin(), this.getMailSmtpPassword());
                transport.close();
                logger.info("SMTP Connection Test -> successful");
                this.setEdalEmailAddress(NOREPLY_EMAIL_DEFAULT);
            }
            catch (MessagingException e) {
                logger.warn("SMTP Connection Test -> failed : " + e.getMessage());
                throw new EdalConfigurationException("unable to connect to eMail Server, check SMTP settings : " + e.getMessage());
            }
            return true;
        }
        String[] stringArray = MAIL_SERVER_NAMES;
        int n = MAIL_SERVER_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String mailServerNames = stringArray[n2];
            try {
                if (!System.getenv("userdnsdomain").isEmpty()) {
                    mailServerNames = String.valueOf(mailServerNames) + "." + System.getenv("userdnsdomain").toLowerCase(Locale.ENGLISH);
                    this.setEdalEmailAddress(String.valueOf(this.getEdalEmailAddress()) + "@" + System.getenv("userdnsdomain").toLowerCase(Locale.ENGLISH));
                }
            }
            catch (NullPointerException nullPointerException) {
                try {
                    if (InetAddress.getLocalHost().getCanonicalHostName().contains(".")) {
                        String domain = InetAddress.getLocalHost().getCanonicalHostName().substring(InetAddress.getLocalHost().getCanonicalHostName().indexOf(".") + 1, InetAddress.getLocalHost().getCanonicalHostName().length());
                        mailServerNames = String.valueOf(mailServerNames) + "." + domain.toLowerCase(Locale.ENGLISH);
                        this.setEdalEmailAddress(String.valueOf(this.getEdalEmailAddress()) + "@" + domain.toLowerCase(Locale.ENGLISH));
                    } else {
                        this.setEdalEmailAddress(NOREPLY_EMAIL_DEFAULT);
                    }
                }
                catch (UnknownHostException e1) {
                    e1.printStackTrace();
                }
            }
            Properties properties = new Properties();
            properties.put("mail.smtp.host", mailServerNames);
            properties.put("mail.smtp.connectiontimeout", (Object)10000);
            properties.put("mail.smtp.timeout", (Object)10000);
            properties.put("mail.smtp.ssl.trust", mailServerNames);
            Session session = Session.getDefaultInstance((Properties)properties);
            try {
                Transport transport;
                if (!this.getMailSmtpLogin().isEmpty() && !this.getMailSmtpPassword().isEmpty()) {
                    transport = session.getTransport("smtp");
                    transport.connect(this.getMailSmtpLogin(), this.getMailSmtpPassword());
                    transport.close();
                } else {
                    transport = session.getTransport("smtp");
                    transport.connect();
                    transport.close();
                }
                Logger edalLogger = LogManager.getLogger((String)"EDAL_SMTP_ERROR_APPENDER");
                SmtpAppender smtp = SmtpAppender.createAppender(null, (String)"SMTP-APP", (String)this.getErrorEmailAddress().getAddress(), null, null, (String)this.getEdalEmailAddress(), null, (String)"[eDAL ERROR]", null, (String)mailServerNames, (String)"0", (String)this.getMailSmtpLogin(), (String)this.getMailSmtpPassword(), (String)"SMTP_DEBUG", (String)"512", null, null, null);
                ((org.apache.logging.log4j.core.Logger)edalLogger).addAppender((Appender)smtp);
                this.setErrorLogger(edalLogger);
                this.setMailSmtpHost(mailServerNames);
                logger.info("SMTP Connection Test: " + mailServerNames + " : successful");
                logger.info("e!DAL-eMail-Address: " + this.getEdalEmailAddress());
                return true;
            }
            catch (MessagingException e) {
                logger.warn("SMTP Connection Test: " + mailServerNames + " -> failed : " + e.getMessage());
                ++n2;
            }
        }
        throw new EdalConfigurationException("unable to connect to eMail Server, check SMTP settings");
    }

    public boolean isCleanBrokenEntities() {
        return this.cleanBrokenEntities;
    }

    public void setCleanBrokenEntities(boolean cleanBrokenEntities) {
        this.cleanBrokenEntities = cleanBrokenEntities;
    }

    public String getInstanceNameLong() {
        return this.instanceNameLong;
    }

    public void setInstanceNameLong(String instanceNameLong) {
        this.instanceNameLong = instanceNameLong;
    }

    public String getInstanceNameShort() {
        return this.instanceNameShort;
    }

    public void setInstanceNameShort(String instanceNameShort) {
        this.instanceNameShort = instanceNameShort;
    }

    public String getPublisherString() {
        return this.publisherString;
    }

    public void setPublisherString(String publisherString) {
        this.publisherString = publisherString;
    }
}

