/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.ContentNegotiator;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThreadPoolExcecutor;
import de.ipk_gatersleben.bit.bi.edal.primary_data.PipedReadEdalFileThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.PipedReadEmbeddedFileThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.PipedWriteThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.VeloCityHtmlGenerator;
import de.ipk_gatersleben.bit.bi.edal.primary_data.WebPageCache;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ZipThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ContentNegotiationType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipOutputStream;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.EnumUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class EdalHttpHandler
extends AbstractHandler {
    private static HashMap<Integer, List<String>> reviewerHashMap = new HashMap();
    private static HashMap<Integer, List<String>> userHashMap = new HashMap();
    private static HashMap<String, Long> requestTimeoutMap = new HashMap();
    private static ThreadPoolExecutor zipExecutor;
    private static final int MIN_NUMBER_OF_THREADS_IN_POOL = 2;
    private static final int MAX_NUMBER_OF_THREADS_IN_EXECUTOR_QUEUE = 60;
    private static final int EXCUTOR_THREAD_KEEP_ALIVE_SECONDS = 60;
    private static final int USEABLE_CORES;
    private static final Long LIMIT_INLINE_FILE_SIZE;
    private static final String EXECUTOR_NAME = "ZipExecutor";
    public static WebPageCache contentPageCache;
    public static WebPageCache reportPageCache;
    static VeloCityHtmlGenerator velocityHtmlGenerator;

    static {
        USEABLE_CORES = (int)Math.ceil(Runtime.getRuntime().availableProcessors() * 1 / 2);
        LIMIT_INLINE_FILE_SIZE = 0xA00000L;
        contentPageCache = new WebPageCache("contentpage");
        reportPageCache = new WebPageCache("reportpage");
        zipExecutor = 2 < USEABLE_CORES ? new EdalThreadPoolExcecutor(USEABLE_CORES, USEABLE_CORES, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(60), EXECUTOR_NAME) : new EdalThreadPoolExcecutor(2, 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(60), EXECUTOR_NAME);
        contentPageCache.init();
        reportPageCache.init();
        velocityHtmlGenerator = new VeloCityHtmlGenerator();
        $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions = EdalHttpHandler.$SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.checkForRobots(request)) {
            this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "blocked");
        } else {
            if (request.getMethod().equalsIgnoreCase("GET")) {
                String url = request.getRequestURI().toString();
                DataManager.getImplProv().getLogger().debug(url);
                StringTokenizer tokenizer = new StringTokenizer(url, "/");
                if (!tokenizer.hasMoreTokens()) {
                    this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "no ID and version specified");
                } else {
                    String methodToken = tokenizer.nextToken().toUpperCase();
                    try {
                        switch (EdalHttpFunctions.valueOf(methodToken)) {
                            case DOI: 
                            case URL: {
                                if (tokenizer.hasMoreTokens()) {
                                    String internalId = tokenizer.nextToken();
                                    if (tokenizer.hasMoreTokens()) {
                                        String uuidToken = tokenizer.nextToken();
                                        if (tokenizer.hasMoreTokens()) {
                                            String versionToken = tokenizer.nextToken();
                                            try {
                                                long versionNumber = Long.parseLong(versionToken);
                                                PrimaryDataEntity entity = null;
                                                if (tokenizer.hasMoreTokens()) {
                                                    String reviewerToken = tokenizer.nextToken();
                                                    if (tokenizer.hasMoreElements()) {
                                                        String methodTokenForReviewer = tokenizer.nextToken();
                                                        if (methodTokenForReviewer.equalsIgnoreCase(EdalHttpFunctions.DOWNLOAD.name())) {
                                                            this.responseDownloadRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, reviewerToken);
                                                            break;
                                                        }
                                                        if (methodTokenForReviewer.equalsIgnoreCase(EdalHttpFunctions.ZIP.name())) {
                                                            this.responseZipRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, reviewerToken);
                                                            break;
                                                        }
                                                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "unable to process '" + methodTokenForReviewer + "'");
                                                        break;
                                                    }
                                                    if (reviewerToken.equalsIgnoreCase(EdalHttpFunctions.DOWNLOAD.name())) {
                                                        this.responseDownloadRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, null);
                                                        break;
                                                    }
                                                    if (reviewerToken.equalsIgnoreCase(EdalHttpFunctions.ZIP.name())) {
                                                        this.responseZipRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, null);
                                                        break;
                                                    }
                                                    if (EnumUtils.isValidEnum(ContentNegotiationType.class, (String)reviewerToken)) {
                                                        this.sendContentNegotiation(response, entity, uuidToken, versionNumber, internalId, PersistentIdentifier.valueOf(methodToken), ContentNegotiationType.valueOf(reviewerToken));
                                                        break;
                                                    }
                                                    int reviewer = 0;
                                                    try {
                                                        reviewer = Integer.parseInt(reviewerToken);
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "unable to process reviewer ID '" + reviewerToken + "', please check again");
                                                        break;
                                                    }
                                                    entity = DataManager.getPrimaryDataEntityForReviewer(uuidToken, versionNumber, internalId, reviewer);
                                                    this.sendEntityMetaDataForReviewer(response, entity, versionNumber, internalId, PersistentIdentifier.valueOf(methodToken), reviewer);
                                                    break;
                                                }
                                                entity = DataManager.getPrimaryDataEntityForPersistenIdentifier(uuidToken, versionNumber, PersistentIdentifier.valueOf(methodToken));
                                                this.sendEntityMetaDataForPersistentIdentifier(response, entity, versionNumber, PersistentIdentifier.valueOf(methodToken), internalId);
                                            }
                                            catch (EdalException e) {
                                                this.sendMessage(response, HttpStatus.Code.LOCKED, e.getMessage());
                                            }
                                            break;
                                        }
                                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "no version number set");
                                        break;
                                    }
                                    this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "no entity id set");
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "no internal id set");
                                break;
                            }
                            case EDAL: {
                                String uuidToken = tokenizer.nextToken();
                                if (tokenizer.hasMoreTokens()) {
                                    String versionToken = tokenizer.nextToken();
                                    try {
                                        int versionNumber = Integer.parseInt(versionToken);
                                        PrimaryDataEntity entity = null;
                                        if (tokenizer.hasMoreElements()) {
                                            String downloadToken = tokenizer.nextToken();
                                            if (EdalHttpFunctions.valueOf(downloadToken.toUpperCase()).equals((Object)EdalHttpFunctions.DOWNLOAD)) {
                                                entity = DataManager.getPrimaryDataEntityByID(uuidToken, versionNumber);
                                                if (!entity.isDirectory()) {
                                                    this.sendFile((PrimaryDataFile)entity, versionNumber, response);
                                                    break;
                                                }
                                                this.sendEntityMetaData(response, entity);
                                            }
                                            break;
                                        }
                                        entity = DataManager.getPrimaryDataEntityByID(uuidToken, versionNumber);
                                        this.sendEntityMetaData(response, entity);
                                    }
                                    catch (EdalException | NumberFormatException e) {
                                        if (e.getClass().equals(NumberFormatException.class)) {
                                            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to cast '" + versionToken + "' to a version number");
                                            break;
                                        }
                                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to send data : " + e.getMessage());
                                    }
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "no version number set");
                                break;
                            }
                            case ACCEPT: {
                                String ticketAccept = tokenizer.nextToken();
                                if (tokenizer.hasMoreElements()) {
                                    try {
                                        int reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                                        if (!this.ticketForReviewerAlreadyClicked(reviewerHashCode, ticketAccept)) {
                                            DataManager.getImplProv().getApprovalServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).accept(ticketAccept, reviewerHashCode);
                                            this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                                            break;
                                        }
                                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Ticket already accepted");
                                    }
                                    catch (EdalApprovalException | NumberFormatException | ReflectiveOperationException e) {
                                        EdalHttpHandler.deleteTicketFromReviewerHashMap(ticketAccept);
                                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "Can not to accept ticket it seems to be already accepted: " + e.getMessage());
                                    }
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                                break;
                            }
                            case REJECT: {
                                String ticketReject = tokenizer.nextToken();
                                if (tokenizer.hasMoreElements()) {
                                    try {
                                        int reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                                        if (!this.ticketForReviewerAlreadyClicked(reviewerHashCode, ticketReject)) {
                                            DataManager.getImplProv().getApprovalServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).reject(ticketReject, reviewerHashCode);
                                            this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                                            break;
                                        }
                                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Ticket already rejected");
                                    }
                                    catch (EdalApprovalException | NumberFormatException | ReflectiveOperationException e) {
                                        EdalHttpHandler.deleteTicketFromReviewerHashMap(ticketReject);
                                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "Can not to reject ticket  it seems to be already rejected: " + e.getMessage());
                                    }
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                                break;
                            }
                            case LOGIN: {
                                String uuid = tokenizer.nextToken();
                                String emailAddress = tokenizer.nextToken();
                                Boolean successful = false;
                                try {
                                    successful = DataManager.getImplProv().getPermissionProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).validateRootUser(new InternetAddress(emailAddress), UUID.fromString(uuid));
                                }
                                catch (ReflectiveOperationException | AddressException throwable) {
                                    this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "eDAL-Server Admin confirmation failed");
                                }
                                if (successful.booleanValue()) {
                                    try {
                                        this.sendMessage(response, HttpStatus.Code.OK, "Thank you <br/>You have successfully registered as administrator for eDAL-Server on " + EdalHttpServer.getServerURL() + "<br/>The server is now started in working mode.");
                                    }
                                    catch (EdalException edalException) {
                                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to load server URL");
                                    }
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "root user validation failed");
                                break;
                            }
                            case LOGO: {
                                if (tokenizer.hasMoreTokens()) {
                                    String logoUrl = tokenizer.nextToken();
                                    if (logoUrl.equalsIgnoreCase("edal_logo.png")) {
                                        this.sendEmbeddedFile(response, "edal_logo.png", "image/png");
                                        break;
                                    }
                                    if (logoUrl.equalsIgnoreCase("ipk_logo.jpg")) {
                                        this.sendEmbeddedFile(response, "ipk_logo.jpg", "image/jpg");
                                        break;
                                    }
                                    if (logoUrl.equalsIgnoreCase("header_bg2.png")) {
                                        this.sendEmbeddedFile(response, "header_bg2.png", "image/png");
                                        break;
                                    }
                                    if (logoUrl.equalsIgnoreCase("edal_icon.png")) {
                                        this.sendEmbeddedFile(response, "edal_icon.png", "image/png");
                                    }
                                }
                                break;
                            }
                            case CSS: {
                                if (tokenizer.hasMoreTokens()) {
                                    String fileUrl = tokenizer.nextToken();
                                    this.sendEmbeddedFile(response, "css/" + fileUrl, "text/css");
                                }
                                break;
                            }
                            case JS: {
                                if (tokenizer.hasMoreTokens()) {
                                    String fileUrl = tokenizer.nextToken();
                                    this.sendEmbeddedFile(response, "js/" + fileUrl, "application/javascript");
                                }
                                break;
                            }
                            case USER_ACCEPT: {
                                String userAcceptTicket = tokenizer.nextToken();
                                if (tokenizer.hasMoreElements()) {
                                    try {
                                        int reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                                        if (!this.ticketForUserAlreadyClicked(reviewerHashCode, userAcceptTicket)) {
                                            DataManager.getImplProv().getApprovalServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).acceptTicketByUser(userAcceptTicket, reviewerHashCode);
                                            this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                                            break;
                                        }
                                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Ticket already accepted");
                                    }
                                    catch (EdalApprovalException | NumberFormatException | ReflectiveOperationException e) {
                                        EdalHttpHandler.deleteTicketFromUserHashMap(userAcceptTicket);
                                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "Can not to accept ticket it seems to be already accepted: " + e.getMessage());
                                    }
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                                break;
                            }
                            case USER_REJECT: {
                                String userRejectTicket = tokenizer.nextToken();
                                if (tokenizer.hasMoreElements()) {
                                    try {
                                        int reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                                        if (!this.ticketForUserAlreadyClicked(reviewerHashCode, userRejectTicket)) {
                                            DataManager.getImplProv().getApprovalServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).rejectTicketByUser(userRejectTicket, reviewerHashCode);
                                            this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                                            break;
                                        }
                                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Ticket already rejected");
                                    }
                                    catch (EdalApprovalException | NumberFormatException | ReflectiveOperationException e) {
                                        EdalHttpHandler.deleteTicketFromUserHashMap(userRejectTicket);
                                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "Can not to accept ticket it seems to be already rejected: " + e.getMessage());
                                    }
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                                break;
                            }
                            case REPORT: {
                                try {
                                    this.sendReport(response, HttpStatus.Code.OK);
                                }
                                catch (EdalException e) {
                                    e.printStackTrace();
                                }
                                break;
                            }
                            case OAI: {
                                if (DataManager.getConfiguration().isInTestMode()) break;
                                String dataCenter = null;
                                try {
                                    dataCenter = DataManager.getConfiguration().getDataCiteUser();
                                }
                                catch (EdalConfigurationException e) {
                                    e.printStackTrace();
                                }
                                String oaiRequest = request.getQueryString();
                                if (oaiRequest != null) {
                                    if (oaiRequest.contains("set=")) {
                                        if (oaiRequest.indexOf("set=") > oaiRequest.lastIndexOf("&")) {
                                            oaiRequest = String.valueOf(oaiRequest.substring(0, oaiRequest.indexOf("set="))) + "set=" + dataCenter;
                                            response.sendRedirect("http://oai.datacite.org/oai?" + oaiRequest);
                                            break;
                                        }
                                        String prefix = oaiRequest.substring(0, oaiRequest.indexOf("set="));
                                        String suffix = oaiRequest.substring(oaiRequest.indexOf("&", oaiRequest.indexOf("set=")), oaiRequest.length());
                                        oaiRequest = String.valueOf(prefix) + suffix + "&set=" + dataCenter;
                                        response.sendRedirect("http://oai.datacite.org/oai?" + oaiRequest);
                                        break;
                                    }
                                    if (oaiRequest.contains("verb=Identify") || oaiRequest.contains("verb=ListMetadataFormats") || oaiRequest.contains("verb=ListRecords&metadataPrefix=oai_dc") || oaiRequest.contains("verb=ListSets") || oaiRequest.contains("verb=ListIdentifiers&metadataPrefix=oai_dc")) {
                                        response.sendRedirect("http://oai.datacite.org/oai?" + oaiRequest);
                                    }
                                    break;
                                }
                                response.sendRedirect("http://oai.datacite.org/oai");
                                break;
                            }
                            default: {
                                this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Unknown function '" + methodToken + "' used !");
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (methodToken.toLowerCase().equals("robots.txt")) {
                            this.sendEmbeddedFile(response, "robots.txt", "text/plain");
                        }
                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Unknown function '" + methodToken + "' used !");
                    }
                }
            }
            response.flushBuffer();
        }
    }

    private boolean checkForRobots(HttpServletRequest request) {
        String userAgent = request.getHeader(HttpHeader.USER_AGENT.toString().toLowerCase());
        String url = request.getRequestURI().toString();
        if (userAgent == null || userAgent.contains("bot")) {
            String methodToken;
            if (url.endsWith(EdalHttpFunctions.DOWNLOAD.toString()) || url.endsWith(EdalHttpFunctions.DOWNLOAD.toString().toLowerCase()) || url.endsWith(EdalHttpFunctions.ZIP.toString()) || url.endsWith(EdalHttpFunctions.ZIP.toString().toLowerCase())) {
                return true;
            }
            if (url.toLowerCase().endsWith("robots.txt")) {
                return false;
            }
            StringTokenizer tokenizer = new StringTokenizer(url, "/");
            if (tokenizer.hasMoreTokens() && EdalHttpFunctions.valueOf(methodToken = tokenizer.nextToken().toUpperCase()).equals((Object)EdalHttpFunctions.DOI)) {
                if (requestTimeoutMap.containsKey(userAgent) && System.currentTimeMillis() - requestTimeoutMap.get(userAgent) <= 1000L) {
                    requestTimeoutMap.put(userAgent, System.currentTimeMillis());
                    return true;
                }
                requestTimeoutMap.put(userAgent, System.currentTimeMillis());
            }
            return false;
        }
        return false;
    }

    private void sendContentNegotiation(HttpServletResponse response, PrimaryDataEntity entity, String uuidToken, long versionNumber, String internalId, PersistentIdentifier persistentIdentifier, ContentNegotiationType contentNegotiationType) {
        try {
            entity = DataManager.getPrimaryDataEntityForPersistenIdentifier(uuidToken, versionNumber, persistentIdentifier);
            StringBuffer buffer = ContentNegotiator.generateContentNogitiation(entity, versionNumber, internalId, persistentIdentifier, contentNegotiationType);
            if (buffer != null) {
                response.setStatus(HttpStatus.Code.OK.getCode());
                String filename = String.valueOf(entity.getName()) + "." + contentNegotiationType.getFileEnding();
                response.setCharacterEncoding("UTF-8");
                response.setContentType(contentNegotiationType.getType());
                response.setHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
                ServletOutputStream responseBody = response.getOutputStream();
                responseBody.write(buffer.toString().getBytes(Charset.forName("UTF-8")));
                responseBody.flush();
                responseBody.close();
            } else {
                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to find citation information");
            }
        }
        catch (EdalException | IOException e1) {
            e1.printStackTrace();
        }
    }

    private boolean ticketForReviewerAlreadyClicked(int reviewerHashCode, String ticketAccept) {
        List<String> list = reviewerHashMap.get(reviewerHashCode);
        if (list != null) {
            if (list.contains(ticketAccept)) {
                return true;
            }
            list.add(ticketAccept);
            reviewerHashMap.put(reviewerHashCode, list);
            return false;
        }
        ArrayList<String> newlist = new ArrayList<String>();
        newlist.add(ticketAccept);
        reviewerHashMap.put(reviewerHashCode, newlist);
        return false;
    }

    private boolean ticketForUserAlreadyClicked(int reviewerHashCode, String ticketAccept) {
        List<String> list = userHashMap.get(reviewerHashCode);
        if (list != null) {
            if (list.contains(ticketAccept)) {
                return true;
            }
            list.add(ticketAccept);
            userHashMap.put(reviewerHashCode, list);
            return false;
        }
        ArrayList<String> newlist = new ArrayList<String>();
        newlist.add(ticketAccept);
        userHashMap.put(reviewerHashCode, newlist);
        return false;
    }

    private void responseDownloadRequest(HttpServletResponse response, PrimaryDataEntity entity, String uuid, Long versionNumber, String internalId, String identifierType, String reviewerCode) throws EdalException {
        if (reviewerCode == null) {
            entity = DataManager.getPrimaryDataEntityForPersistenIdentifier(uuid, versionNumber, PersistentIdentifier.valueOf(identifierType));
            if (!entity.isDirectory()) {
                this.sendFile((PrimaryDataFile)entity, versionNumber, response);
            } else {
                this.sendEntityMetaDataForPersistentIdentifier(response, entity, versionNumber, PersistentIdentifier.valueOf(identifierType), internalId);
            }
        } else {
            entity = DataManager.getPrimaryDataEntityForReviewer(uuid, versionNumber, internalId, Integer.parseInt(reviewerCode));
            if (!entity.isDirectory()) {
                this.sendFile((PrimaryDataFile)entity, versionNumber, response);
            } else {
                this.sendEntityMetaDataForReviewer(response, entity, versionNumber, internalId, PersistentIdentifier.valueOf(identifierType), Integer.parseInt(reviewerCode));
            }
        }
    }

    private void responseZipRequest(HttpServletResponse response, PrimaryDataEntity entity, String uuid, long versionNumber, String internalId, String identifierType, String reviewerId) throws EdalException {
        if (!zipExecutor.isShutdown() && zipExecutor.getActiveCount() >= zipExecutor.getMaximumPoolSize()) {
            this.sendMessage(response, HttpStatus.Code.INSUFFICIENT_STORAGE, "No more free slots for downloading zip archive, please try again later");
        } else {
            entity = reviewerId == null ? DataManager.getPrimaryDataEntityForPersistenIdentifier(uuid, versionNumber, PersistentIdentifier.valueOf(identifierType)) : DataManager.getPrimaryDataEntityForReviewer(uuid, versionNumber, internalId, Integer.parseInt(reviewerId));
            if (entity.isDirectory()) {
                try {
                    response.setContentType("application/zip");
                    response.setHeader("Content-Disposition", "inline; filename=\"" + entity.getName() + ".zip" + "\"");
                    response.setStatus(HttpStatus.Code.OK.getCode());
                    CountDownLatch countDownLatch = new CountDownLatch(1);
                    ServletOutputStream responseBody = response.getOutputStream();
                    ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream((OutputStream)responseBody));
                    ZipThread zipThread = new ZipThread(countDownLatch, zipOutputStream, (PrimaryDataDirectory)entity);
                    if (zipExecutor.isShutdown()) {
                        zipExecutor = 2 < USEABLE_CORES ? new EdalThreadPoolExcecutor(USEABLE_CORES, USEABLE_CORES, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(60), EXECUTOR_NAME) : new EdalThreadPoolExcecutor(2, 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(60), EXECUTOR_NAME);
                    }
                    zipExecutor.execute(zipThread);
                    try {
                        try {
                            countDownLatch.await();
                        }
                        catch (InterruptedException e) {
                            throw new EdalException("Unable to send zip file '" + entity.getName() + ".zip'", e);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            zipOutputStream.flush();
                            zipOutputStream.close();
                        }
                        catch (EofException eofException) {
                            DataManager.getImplProv().getLogger().warn("Zip Download for '" + entity.getName() + ".zip' canceled by user");
                            zipThread.stopListThread();
                            responseBody.close();
                        }
                        responseBody.flush();
                        responseBody.close();
                        throw throwable;
                    }
                    try {
                        zipOutputStream.flush();
                        zipOutputStream.close();
                    }
                    catch (EofException eofException) {
                        DataManager.getImplProv().getLogger().warn("Zip Download for '" + entity.getName() + ".zip' canceled by user");
                        zipThread.stopListThread();
                        responseBody.close();
                    }
                    responseBody.flush();
                    responseBody.close();
                }
                catch (IOException e) {
                    throw new EdalException("Unable to send zip file '" + entity.getName() + ".zip'", e);
                }
            }
            this.sendFile((PrimaryDataFile)entity, versionNumber, response);
        }
    }

    private void sendEmbeddedFile(HttpServletResponse response, String fileName, String contentType) {
        try {
            InputStream file = EdalHttpHandler.class.getResourceAsStream(fileName);
            int fileSize = file.available();
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
            response.setContentLength(fileSize);
            response.setStatus(HttpStatus.Code.OK.getCode());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServletOutputStream responseBody = response.getOutputStream();
            PipedInputStream httpIn = new PipedInputStream(0xA00000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedWriteThread pipedWriteThread = new PipedWriteThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)fileSize);
            PipedReadEmbeddedFileThread pipedReadThread = new PipedReadEmbeddedFileThread(fileName, file, pipedOut);
            DataManager.getJettyExecutorService().execute(pipedReadThread);
            DataManager.getJettyExecutorService().execute(pipedWriteThread);
            try {
                countDownLatch.await();
                file.close();
                pipedOut.close();
                httpIn.close();
            }
            catch (InterruptedException e) {
                DataManager.getImplProv().getLogger().error("Unable to wait for sending file: " + e.getMessage());
            }
            responseBody.close();
        }
        catch (IOException e) {
            DataManager.getImplProv().getLogger().error("Unable to send file: " + e.getMessage());
        }
    }

    private void sendEntityMetaData(HttpServletResponse response, PrimaryDataEntity entity) throws EdalException {
        try {
            StringWriter w = null;
            w = entity.isDirectory() ? velocityHtmlGenerator.generateHtmlForDirectory((PrimaryDataDirectory)entity) : velocityHtmlGenerator.generateHtmlForFile((PrimaryDataFile)entity);
            ByteArrayInputStream bis = new ByteArrayInputStream(String.valueOf(w.getBuffer()).getBytes());
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            ServletOutputStream responseBody = response.getOutputStream();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            PipedInputStream httpIn = new PipedInputStream(0xA00000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedWriteThread pipedThread = new PipedWriteThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)bis.available());
            PipedReadEmbeddedFileThread pipedReadThread = new PipedReadEmbeddedFileThread(entity.getName(), bis, pipedOut);
            DataManager.getJettyExecutorService().execute(pipedThread);
            DataManager.getJettyExecutorService().execute(pipedReadThread);
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("unable to send html page", e);
                }
            }
            finally {
                try {
                    bis.close();
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error("unable to close html streams : " + e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new EdalException("unable to send the html page over HTTP", e);
        }
        catch (EdalException e) {
            throw e;
        }
    }

    private void sendEntityMetaDataForPersistentIdentifier(HttpServletResponse response, PrimaryDataEntity entity, long versionNumber, PersistentIdentifier identifierType, String internalId) throws EdalException {
        String cacheKey = this.generateCacheKey(identifierType, internalId, entity, versionNumber, 0);
        if (contentPageCache.get(cacheKey) == null) {
            long start = System.currentTimeMillis();
            DataManager.getImplProv().getLogger().debug("Load new Contentpage : " + cacheKey);
            try {
                ByteArrayOutputStream cacheFileOutputStream = new ByteArrayOutputStream();
                TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)response.getOutputStream(), (OutputStream)cacheFileOutputStream);
                CountDownLatch latch = new CountDownLatch(1);
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = entity.isDirectory() ? velocityHtmlGenerator.generateHtmlForDirectoryOfSnapshot((PrimaryDataDirectory)entity, versionNumber, internalId, identifierType, teeOutputStream, latch) : velocityHtmlGenerator.generateHtmlForFileOfSnapshot((PrimaryDataFile)entity, versionNumber, identifierType, internalId, teeOutputStream, latch);
                response.setContentType("text/html");
                response.setStatus(HttpStatus.Code.OK.getCode());
                try {
                    latch.await();
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                    contentPageCache.put(cacheKey, cacheFileOutputStream);
                }
                catch (EofException eofException) {
                    DataManager.getImplProv().getLogger().warn("HTTP Request for '" + entity.getName() + "' canceled by user!");
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                }
                catch (InterruptedException e) {
                    DataManager.getImplProv().getLogger().warn("HTTP Request for '" + entity.getName() + "' canceled by user!");
                    throw new EdalException(e);
                }
            }
            catch (IOException e) {
                throw new EdalException(e);
            }
            DataManager.getImplProv().getLogger().debug("Load new Contentpage (" + cacheKey + ") in " + (System.currentTimeMillis() - start) + " ms");
        } else {
            long start = System.currentTimeMillis();
            DataManager.getImplProv().getLogger().debug("Reload Contentpage from Cache : " + cacheKey);
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            try {
                ByteArrayOutputStream cacheFileInputStream = contentPageCache.get(cacheKey);
                try {
                    cacheFileInputStream.writeTo((OutputStream)response.getOutputStream());
                    cacheFileInputStream.close();
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                }
                catch (EofException eofException) {
                    DataManager.getImplProv().getLogger().warn("HTTP Request for '" + entity.getName() + "' failed, unable to reload from cache");
                    cacheFileInputStream.close();
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                }
            }
            catch (IOException e) {
                throw new EdalException(e);
            }
            DataManager.getImplProv().getLogger().debug("Reload Contentpage (" + cacheKey + ")  in " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private void sendEntityMetaDataForReviewer(HttpServletResponse response, PrimaryDataEntity entity, long versionNumber, String internalId, PersistentIdentifier identifierType, int reviewerCode) throws EdalException {
        String cacheKey = this.generateCacheKey(identifierType, internalId, entity, versionNumber, reviewerCode);
        if (contentPageCache.get(cacheKey) == null) {
            DataManager.getImplProv().getLogger().debug("Regenerate Webpage : " + cacheKey);
            try {
                ByteArrayOutputStream cacheFileOutputStream = new ByteArrayOutputStream();
                TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)response.getOutputStream(), (OutputStream)cacheFileOutputStream);
                CountDownLatch latch = new CountDownLatch(1);
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = entity.isDirectory() ? velocityHtmlGenerator.generateHtmlForDirectoryForReviewer((PrimaryDataDirectory)entity, versionNumber, internalId, identifierType, reviewerCode, teeOutputStream, latch) : velocityHtmlGenerator.generateHtmlForFileForReviewer((PrimaryDataFile)entity, versionNumber, internalId, identifierType, reviewerCode, teeOutputStream, latch);
                response.setContentType("text/html");
                response.setStatus(HttpStatus.Code.OK.getCode());
                try {
                    latch.await();
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                }
                catch (EofException eofException) {
                    DataManager.getImplProv().getLogger().warn("HTTP Request for '" + entity.getName() + "'canceled by user!");
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                }
                catch (InterruptedException e) {
                    throw new EdalException(e);
                }
            }
            catch (IOException e) {
                throw new EdalException(e);
            }
        } else {
            DataManager.getImplProv().getLogger().debug("Reload Webpage from Cache : " + cacheKey);
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            try {
                ByteArrayOutputStream cacheFileInputStream = contentPageCache.get(cacheKey);
                cacheFileInputStream.writeTo((OutputStream)response.getOutputStream());
                cacheFileInputStream.close();
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private final String generateCacheKey(PersistentIdentifier identifierType, String internalId, PrimaryDataEntity entity, long versionNumber, int reviewerCode) {
        return new String(String.valueOf(identifierType.toString()) + "-" + internalId + "-" + entity.getID() + "-" + String.valueOf(versionNumber) + "-" + String.valueOf(reviewerCode));
    }

    private void sendFile(PrimaryDataFile file, long versionNumber, HttpServletResponse response) throws EdalException {
        PrimaryDataFile currentFile = file;
        try {
            currentFile.switchCurrentVersion(currentFile.getVersionByRevisionNumber(versionNumber));
        }
        catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "no file found");
        }
        try {
            String type = "";
            Long size = null;
            try {
                type = ((DataFormat)currentFile.getCurrentVersion().getMetaData().getElementValue(EnumDublinCoreElements.FORMAT)).getMimeType();
                size = ((DataSize)currentFile.getCurrentVersion().getMetaData().getElementValue(EnumDublinCoreElements.SIZE)).getFileSize();
            }
            catch (MetaDataException e) {
                throw new EdalException("unable to load the MIME type/file size", e);
            }
            response.setContentType(type);
            if (size > LIMIT_INLINE_FILE_SIZE) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + currentFile.getName() + "\"");
            } else {
                response.setHeader("Content-Disposition", "inline; filename=\"" + currentFile.getName() + "\"");
            }
            response.setContentLengthLong(size.longValue());
            response.setStatus(HttpStatus.Code.OK.getCode());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServletOutputStream responseBody = response.getOutputStream();
            PipedInputStream httpIn = new PipedInputStream(0xA00000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedWriteThread pipedWriteThread = new PipedWriteThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)size);
            PipedReadEdalFileThread pipedReadThread = new PipedReadEdalFileThread(currentFile, pipedOut);
            DataManager.getJettyExecutorService().execute(pipedWriteThread);
            DataManager.getJettyExecutorService().execute(pipedReadThread);
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("Unable to send file: " + e.getMessage(), e);
                }
            }
            finally {
                try {
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error("Unable to close download streams: " + e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new EdalException("Unable to send file: " + e.getMessage(), e);
        }
    }

    private void sendMessage(HttpServletResponse response, HttpStatus.Code responseCode, String message) {
        try {
            String htmlOutput = velocityHtmlGenerator.generateHtmlErrorMessage(responseCode, message).toString();
            response.setStatus(responseCode.getCode());
            response.setContentType("text/html");
            ServletOutputStream responseBody = response.getOutputStream();
            responseBody.write(htmlOutput.getBytes());
            responseBody.close();
        }
        catch (EofException eofException) {
        }
        catch (EdalException | IOException e) {
            DataManager.getImplProv().getLogger().error("Unable to send " + responseCode + "-message : " + e);
        }
    }

    private void sendReport(HttpServletResponse response, HttpStatus.Code responseCode) throws EdalException {
        String cacheKey = "ReportCache";
        if (reportPageCache.get(cacheKey) == null) {
            long start = System.currentTimeMillis();
            DataManager.getImplProv().getLogger().debug("Load new Reportpage : " + cacheKey);
            try {
                response.setStatus(responseCode.getCode());
                response.setContentType("text/html");
                ByteArrayOutputStream cacheFileOutputStream = new ByteArrayOutputStream();
                TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)response.getOutputStream(), (OutputStream)cacheFileOutputStream);
                CountDownLatch latch = new CountDownLatch(1);
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = velocityHtmlGenerator.generateHtmlForReport(responseCode, (OutputStream)teeOutputStream, latch);
                try {
                    latch.await();
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                    reportPageCache.put(cacheKey, cacheFileOutputStream);
                }
                catch (EofException eofException) {
                    DataManager.getImplProv().getLogger().warn("HTTP Request for report page canceled by user!");
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                    reportPageCache.clean();
                }
                catch (InterruptedException e) {
                    DataManager.getImplProv().getLogger().warn("HTTP Request for report page canceled by user!");
                    reportPageCache.clean();
                    throw new EdalException(e);
                }
            }
            catch (Exception e) {
                DataManager.getImplProv().getLogger().warn("Unable to send " + responseCode + "-message : " + e.getClass());
            }
            DataManager.getImplProv().getLogger().debug("Load new Reportpage in " + (System.currentTimeMillis() - start) + " ms");
        } else {
            long start = System.currentTimeMillis();
            DataManager.getImplProv().getLogger().debug("Reload Reportpage from Cache : " + cacheKey);
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            try {
                ByteArrayOutputStream cacheFileInputStream = reportPageCache.get(cacheKey);
                try {
                    cacheFileInputStream.writeTo((OutputStream)response.getOutputStream());
                    cacheFileInputStream.close();
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                }
                catch (EofException eofException) {
                    DataManager.getImplProv().getLogger().warn("HTTP Request for reportpage failed, unable to reload from cache");
                    cacheFileInputStream.close();
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                    reportPageCache.clean();
                }
            }
            catch (IOException e) {
                reportPageCache.clean();
                throw new EdalException(e);
            }
            DataManager.getImplProv().getLogger().debug("Reload Reportpage from Cache in " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public static void deleteTicketFromReviewerHashMap(String ticket) {
        for (Map.Entry<Integer, List<String>> entry : reviewerHashMap.entrySet()) {
            List<String> list = entry.getValue();
            if (!list.contains(ticket)) continue;
            list.remove(ticket);
        }
    }

    public static void deleteTicketFromUserHashMap(String ticket) {
        for (Map.Entry<Integer, List<String>> entry : userHashMap.entrySet()) {
            List<String> list = entry.getValue();
            if (!list.contains(ticket)) continue;
            list.remove(ticket);
        }
    }
}

