/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.Location;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class GenerateLocations {
    private static DatabaseReader reader = null;
    private static JSONArray allIPsList = new JSONArray();

    static {
        try {
            reader = new DatabaseReader.Builder(GenerateLocations.class.getResourceAsStream("GeoLite2-City.mmdb")).withCache((NodeCache)new CHMCache(16384)).build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getAllIPsList() {
        return allIPsList;
    }

    public static String generateGpsLocations(HashSet<String> ipList) {
        StringBuffer locationXML = new StringBuffer();
        locationXML.append("<markers>");
        for (String ip : ipList) {
            try {
                InetAddress ipAddress = InetAddress.getByName(ip);
                CityResponse response = reader.city(ipAddress);
                Location location = response.getLocation();
                if (location == null) continue;
                String str = "";
                String cityName = response.getCity().getName();
                if (cityName != null) {
                    if (cityName.contains("'")) {
                        cityName = cityName.replace("'", " ");
                    }
                    str = "<marker lat='" + location.getLatitude() + "' lng='" + location.getLongitude() + "' title='" + cityName + "' percent='" + "'></marker>";
                } else {
                    str = "<marker lat='" + location.getLatitude() + "' lng='" + location.getLongitude() + "' title='' percent='" + "'></marker>";
                }
                locationXML.append(str);
            }
            catch (Exception exception) {}
        }
        locationXML.append("</markers>");
        return locationXML.toString();
    }

    public static JSONArray generateGpsLocationsToJson(HashSet<String> ipList) {
        JSONArray list = new JSONArray();
        for (String ip : ipList) {
            try {
                InetAddress ipAddress = InetAddress.getByName(ip);
                CityResponse response = reader.city(ipAddress);
                Location location = response.getLocation();
                if (location == null) continue;
                JSONObject str = new JSONObject();
                String cityName = response.getCity().getName();
                if (cityName != null) {
                    if (cityName.contains("'")) {
                        cityName = cityName.replace("'", " ");
                    }
                    str.put((Object)"lat", (Object)location.getLatitude());
                    str.put((Object)"long", (Object)location.getLongitude());
                    str.put((Object)"city", (Object)cityName);
                } else {
                    str.put((Object)"lat", (Object)location.getLatitude());
                    str.put((Object)"long", (Object)location.getLongitude());
                    str.put((Object)"city", null);
                }
                if (!list.contains((Object)str)) {
                    list.add((Object)str);
                }
                if (allIPsList.contains((Object)str)) continue;
                allIPsList.add((Object)str);
            }
            catch (GeoIp2Exception | IOException throwable) {}
        }
        return list;
    }
}

