/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.io.EofException;

public class PipedWriteThread
extends Thread {
    private PipedInputStream httpinstream = null;
    private OutputStream responseBody = null;
    private CountDownLatch countDownLatch = null;
    private long contentLength = 0L;

    PipedWriteThread(PipedInputStream httpinstream, OutputStream responseBody, CountDownLatch countDownLatch, long contentLength) {
        this.httpinstream = httpinstream;
        this.responseBody = responseBody;
        this.countDownLatch = countDownLatch;
        this.contentLength = contentLength;
    }

    @Override
    public void run() {
        DataManager.getImplProv().getLogger().debug("COUNTDOWNLATCH PipedThread before: " + this.countDownLatch.getCount());
        try {
            try {
                int readbytes = 0;
                long content = 0L;
                byte[] buffer = new byte[0xA00000];
                boolean finish = false;
                while (!finish) {
                    readbytes = this.httpinstream.read(buffer);
                    DataManager.getImplProv().getLogger().debug("read from piped stream: " + readbytes);
                    this.responseBody.write(buffer, 0, readbytes);
                    DataManager.getImplProv().getLogger().debug("read finish");
                    if ((content += (long)readbytes) != this.contentLength) continue;
                    finish = true;
                }
            }
            catch (EofException eofException) {
                DataManager.getImplProv().getLogger().warn("HTTP Request canceled by user!");
                this.countDownLatch.countDown();
                DataManager.getImplProv().getLogger().debug("COUNTDOWNLATCH PipedThread after: " + this.countDownLatch.getCount());
            }
            catch (IOException e) {
                DataManager.getImplProv().getLogger().warn("Unable to write piped streams: " + e.getMessage());
                this.countDownLatch.countDown();
                DataManager.getImplProv().getLogger().debug("COUNTDOWNLATCH PipedThread after: " + this.countDownLatch.getCount());
            }
        }
        finally {
            this.countDownLatch.countDown();
            DataManager.getImplProv().getLogger().debug("COUNTDOWNLATCH PipedThread after: " + this.countDownLatch.getCount());
        }
    }
}

