/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.GenerateLocations;
import de.ipk_gatersleben.bit.bi.edal.primary_data.MergingEntityOutputThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.MergingMessageOutputThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.MergingReportOutputThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.CalculateDirectorySizeThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ServiceProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ApprovalServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.eclipse.jetty.http.HttpStatus;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class VeloCityHtmlGenerator {
    private static final String STRING_VERSION = "version";
    private static final String STRING_NO_PUBLIC_REFERENCE_FOR_THIS_VERSION_SET = "No Public Reference for this version set!";
    private static final String STRING_UNABLE_TO_LOAD_VERSIONS_OF = "unable to load versions of ";
    private static final String STRING_PUBLIC_REFERENCE_AND_VERSION_NUMBER_ARE_NOT_COMPATIBLE = "PublicReference and version number are not compatible";
    private static final String STRING_UNABLE_TO_INITIALIZE_APPROVAL_SERVICE_PROVIDER = "unable to initialize ApprovalServiceProvider: ";
    private static final String STRING_ALLOBJECTS = "allobjects";
    private static final String STRING_REVIEWER_CODE = "reviewerCode";
    private static final String STRING_INTERNAL_ID = "internalId";
    private static final String STRING_IDENTIFIER_TYPE = "identifierType";
    private static final String STRING_DATE = "date";
    private static final String STRING_ENTITY = "entity";
    private static final String STRING_ALL_ELEMENTS = "allElements";
    private static final String STRING_UNABLE_TO_WRITE_HTML_OUTPUT = "unable to write HTML output";
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final String STRING_SERVER_URL = "serverURL";
    private static final String STRING_CITATION_ENTITY = "citation_entity";
    private static final String DOWNLOAD_SERVER_URL = "downloadURL";

    VeloCityHtmlGenerator() {
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        Velocity.setProperty((String)"input.encoding", (Object)DEFAULT_CHARSET);
        Velocity.setProperty((String)"output.encoding", (Object)DEFAULT_CHARSET);
        Velocity.init();
    }

    protected StringWriter generateEmailForChangedRootUser(InternetAddress newAddress, InternetAddress oldAddress) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("charset", (Object)DEFAULT_CHARSET.toString());
        context.put("newRoot", (Object)newAddress);
        context.put("oldRoot", (Object)oldAddress);
        context.put(STRING_SERVER_URL, (Object)EdalHttpServer.getServerURL());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/ChangedRootUserEmailTemplate.xml", (String)DEFAULT_CHARSET.toString(), (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected StringWriter generateEmailForDoubleOptIn(InternetAddress address, UUID uuid) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("charset", (Object)DEFAULT_CHARSET.toString());
        String url = String.valueOf(EdalHttpServer.getServerURL().toString()) + "/" + EdalHttpFunctions.LOGIN.toString() + "/" + uuid.toString() + "/" + address.getAddress();
        context.put(STRING_SERVER_URL, (Object)url);
        context.put("server", (Object)EdalHttpServer.getServerURL());
        context.put("root", (Object)address);
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/DoubleOptInEmailTemplate.xml", (String)DEFAULT_CHARSET.toString(), (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected OutputStreamWriter generateEmbeddedHtmlForErrorMessage(HttpStatus.Code responseCode, String message, TeeOutputStream teeOutputStream, CountDownLatch latch) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("charset", (Object)DEFAULT_CHARSET.toString());
        context.put("responseCode", (Object)responseCode.getCode());
        context.put("title", (Object)responseCode.getMessage());
        context.put("message", (Object)message);
        context.put(STRING_SERVER_URL, (Object)EdalHttpServer.getServerURL());
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)teeOutputStream);
        MergingMessageOutputThread thread = new MergingMessageOutputThread("de/ipk_gatersleben/bit/bi/edal/primary_data/HtmlMessageTemplate.xml", DEFAULT_CHARSET.toString(), (Context)context, output, latch);
        DataManager.getVelocityExecutorService().execute(thread);
        return output;
    }

    protected StringWriter generateHtmlForDirectory(PrimaryDataDirectory directory) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("charset", (Object)DEFAULT_CHARSET.toString());
        context.put(STRING_ENTITY, (Object)directory);
        context.put(STRING_VERSION, (Object)directory.getCurrentVersion());
        context.put(STRING_ALL_ELEMENTS, MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put(STRING_SERVER_URL, (Object)EdalHttpServer.getServerURL().toString());
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("rights", (Object)EnumDublinCoreElements.RIGHTS);
        context.put("title", (Object)EnumDublinCoreElements.TITLE);
        context.put("creator", (Object)EnumDublinCoreElements.CREATOR);
        context.put("format", (Object)EnumDublinCoreElements.FORMAT);
        context.put("year", (Object)1);
        try {
            context.put(STRING_ALLOBJECTS, directory.listPrimaryDataEntities());
        }
        catch (PrimaryDataDirectoryException e) {
            throw new EdalException("unable to load entity list of the directory", e);
        }
        StringWriter output = new StringWriter();
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected OutputStreamWriter generateHtmlForDirectoryForReviewer(PrimaryDataDirectory directory, long versionNumber, String internalId, PersistentIdentifier identifierType, int reviewerCode, TeeOutputStream teeOutputStream, CountDownLatch latch) throws EdalException {
        Calendar date = null;
        Long publicReferenceDirectorySize = 0L;
        String publicReferenceFileDirectoryNumber = new String();
        try {
            date = DataManager.getImplProv().getApprovalServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getPublicReferenceByInternalId(internalId).getCreationDate();
        }
        catch (ReflectiveOperationException e) {
            throw new EdalException(STRING_UNABLE_TO_INITIALIZE_APPROVAL_SERVICE_PROVIDER + e.getMessage(), e);
        }
        catch (EdalException e) {
            throw e;
        }
        try {
            if (!directory.getVersionByDate(date).equals(directory.getVersionByRevisionNumber(versionNumber))) {
                return this.generateEmbeddedHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, STRING_PUBLIC_REFERENCE_AND_VERSION_NUMBER_ARE_NOT_COMPATIBLE, teeOutputStream, latch);
            }
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException(STRING_UNABLE_TO_LOAD_VERSIONS_OF + directory + " :" + e.getMessage(), e);
        }
        if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(internalId) + "/" + directory.getID())) {
            publicReferenceDirectorySize = CalculateDirectorySizeThread.directorySizes.get(String.valueOf(internalId) + "/" + directory.getID());
        }
        if (CalculateDirectorySizeThread.directoryFiles.containsKey(String.valueOf(internalId) + "/" + directory.getID())) {
            publicReferenceFileDirectoryNumber = CalculateDirectorySizeThread.directoryFiles.get(String.valueOf(internalId) + "/" + directory.getID());
        }
        VelocityContext context = new VelocityContext();
        context.put("charset", (Object)DEFAULT_CHARSET.toString());
        context.put(STRING_CITATION_ENTITY, (Object)directory);
        context.put(STRING_IDENTIFIER_TYPE, (Object)identifierType.toString());
        context.put(STRING_INTERNAL_ID, (Object)internalId);
        context.put(STRING_DATE, (Object)date);
        context.put(STRING_ENTITY, (Object)directory);
        context.put(STRING_ALL_ELEMENTS, MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put(STRING_SERVER_URL, (Object)EdalHttpServer.getServerURL().toString());
        context.put(DOWNLOAD_SERVER_URL, (Object)EdalHttpServer.getHttpDownloadURL().toString());
        context.put(STRING_REVIEWER_CODE, (Object)String.valueOf(reviewerCode));
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("rights", (Object)EnumDublinCoreElements.RIGHTS);
        context.put("metadatasize", (Object)DataSize.StorageUnit.of(publicReferenceDirectorySize).format(publicReferenceDirectorySize));
        context.put("SizeList", CalculateDirectorySizeThread.directorySizes);
        context.put("DataSizeClass", DataSize.StorageUnit.class);
        context.put("EnumSize", (Object)EnumDublinCoreElements.SIZE);
        context.put("repositoryNameLong", (Object)DataManager.getConfiguration().getInstanceNameLong());
        context.put("repositoryNameShort", (Object)DataManager.getConfiguration().getInstanceNameShort());
        List<PrimaryDataEntity> list = null;
        if (!publicReferenceFileDirectoryNumber.isEmpty()) {
            context.put("directorynumber", (Object)publicReferenceFileDirectoryNumber.split(",")[0]);
            context.put("filenumber", (Object)publicReferenceFileDirectoryNumber.split(",")[1]);
        }
        try {
            list = directory.listPrimaryDataEntities();
            context.put(STRING_ALLOBJECTS, list);
        }
        catch (PrimaryDataDirectoryException e) {
            throw new EdalException("unable to load entity list of the directory", e);
        }
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)teeOutputStream);
        MergingEntityOutputThread thread = new MergingEntityOutputThread("de/ipk_gatersleben/bit/bi/edal/primary_data/DirectoryTemplateForReviewer.xml", DEFAULT_CHARSET.toString(), (Context)context, output, latch, list);
        DataManager.getVelocityExecutorService().execute(thread);
        return output;
    }

    /*
     * Unable to fully structure code
     */
    protected OutputStreamWriter generateHtmlForDirectoryOfSnapshot(PrimaryDataDirectory directory, long versionNumber, String internalId, PersistentIdentifier identifierType, TeeOutputStream teeOutputStream, CountDownLatch latch) throws EdalException {
        block28: {
            entityWithPersitentIdentifierForCitation = null;
            if (directory.getPublicReferences().size() == 0) {
                entityWithPersitentIdentifierForCitation = DataManager.getPrimaryDataEntityRekursiveForPersistenIdentifier(directory, versionNumber, identifierType);
            }
            date = null;
            try {
                date = DataManager.getImplProv().getApprovalServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getPublicReferenceByInternalId(internalId).getCreationDate();
            }
            catch (ReflectiveOperationException e) {
                throw new EdalException("unable to initialize ApprovalServiceProvider: " + e.getMessage(), e);
            }
            try {
                if (!directory.getVersionByDate(date).equals(directory.getVersionByRevisionNumber(versionNumber))) {
                    return this.generateEmbeddedHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "PublicReference and version number are not compatible", teeOutputStream, latch);
                }
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException("unable to load versions of " + directory + " :" + e.getMessage(), e);
            }
            log = DataManager.getImplProv().getLogger();
            currentDirectory = directory;
            primaryDataEntityVersion = null;
            publicReferenceDirectorySize = 0L;
            publicReferenceFileDirectoryNumber = new String();
            primaryDataEntityVersion = currentDirectory.getVersionByRevisionNumber(versionNumber);
            foundPublicReference = false;
            try {
                if (primaryDataEntityVersion.getPublicReference(identifierType).getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) {
                    currentDirectory.switchCurrentVersion(primaryDataEntityVersion);
                    if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(internalId) + "/" + currentDirectory.getID())) {
                        publicReferenceDirectorySize = CalculateDirectorySizeThread.directorySizes.get(String.valueOf(internalId) + "/" + currentDirectory.getID());
                    }
                    if (CalculateDirectorySizeThread.directoryFiles.containsKey(String.valueOf(internalId) + "/" + currentDirectory.getID())) {
                        publicReferenceFileDirectoryNumber = CalculateDirectorySizeThread.directoryFiles.get(String.valueOf(internalId) + "/" + currentDirectory.getID());
                    }
                }
                break block28;
            }
            catch (PrimaryDataEntityVersionException e) {
                log.debug(currentDirectory + " has no " + (Object)identifierType);
                ** while (!foundPublicReference)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    log.debug("try ParentDirectory '" + currentDirectory.getParentDirectory() + "'");
                    if (currentDirectory.getParentDirectory() == null) {
                        return this.generateEmbeddedHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "No Public Reference for this version set!", teeOutputStream, latch);
                    }
                    if (!currentDirectory.getParentDirectory().getVersionByDate(date).getPublicReference(identifierType).getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) continue;
                    if (primaryDataEntityVersion.getRevisionDate().before(date)) {
                        log.debug(currentDirectory.getParentDirectory() + " has " + (Object)identifierType);
                        foundPublicReference = true;
                        currentDirectory = directory;
                        if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(internalId) + "/" + currentDirectory.getID())) {
                            publicReferenceDirectorySize = CalculateDirectorySizeThread.directorySizes.get(String.valueOf(internalId) + "/" + currentDirectory.getID());
                        }
                        if (!CalculateDirectorySizeThread.directoryFiles.containsKey(String.valueOf(internalId) + "/" + currentDirectory.getID())) continue;
                        publicReferenceFileDirectoryNumber = CalculateDirectorySizeThread.directoryFiles.get(String.valueOf(internalId) + "/" + currentDirectory.getID());
                        continue;
                    }
                    return this.generateEmbeddedHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "No Public Reference for this version set!", teeOutputStream, latch);
                }
                catch (PrimaryDataDirectoryException | PrimaryDataEntityVersionException v0) {
                    try {
                        log.debug("ParentDirectory has no " + (Object)identifierType);
                        foundPublicReference = false;
                        try {
                            currentDirectory = currentDirectory.getParentDirectory();
                            continue;
                        }
                        catch (PrimaryDataDirectoryException v1) {
                            throw new EdalException("unable to get parent directory: " + e.getMessage(), e);
                        }
                    }
                    catch (PrimaryDataEntityVersionException e) {
                        throw new EdalException("unable to get version by version number: " + e.getMessage(), e);
                    }
                }
            }
        }
        context = new VelocityContext();
        context.put("charset", (Object)VeloCityHtmlGenerator.DEFAULT_CHARSET.toString());
        if (entityWithPersitentIdentifierForCitation != null) {
            context.put("citation_entity", (Object)entityWithPersitentIdentifierForCitation);
        } else {
            context.put("citation_entity", (Object)currentDirectory);
        }
        context.put("date", (Object)date);
        context.put("identifierType", (Object)identifierType.toString());
        context.put("internalId", (Object)internalId);
        context.put("entity", (Object)currentDirectory);
        context.put("allElements", MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put("publisher", (Object)EnumDublinCoreElements.PUBLISHER);
        context.put("subjects", (Object)EnumDublinCoreElements.SUBJECT);
        context.put("creator", (Object)EnumDublinCoreElements.CREATOR);
        context.put("contributor", (Object)EnumDublinCoreElements.CONTRIBUTOR);
        context.put("language", (Object)EnumDublinCoreElements.LANGUAGE);
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("rights", (Object)EnumDublinCoreElements.RIGHTS);
        context.put("type", (Object)EnumDublinCoreElements.TYPE);
        context.put("format", (Object)EnumDublinCoreElements.FORMAT);
        context.put("serverURL", (Object)EdalHttpServer.getServerURL().toString());
        context.put("downloadURL", (Object)EdalHttpServer.getHttpDownloadURL().toString());
        context.put("metadatasize", (Object)DataSize.StorageUnit.of(publicReferenceDirectorySize).format(publicReferenceDirectorySize));
        context.put("SizeList", CalculateDirectorySizeThread.directorySizes);
        context.put("directorynumber", (Object)publicReferenceFileDirectoryNumber.split(",")[0]);
        context.put("DataSizeClass", DataSize.StorageUnit.class);
        context.put("EnumSize", (Object)EnumDublinCoreElements.SIZE);
        context.put("repositoryNameLong", (Object)DataManager.getConfiguration().getInstanceNameLong());
        context.put("repositoryNameShort", (Object)DataManager.getConfiguration().getInstanceNameShort());
        if (!publicReferenceFileDirectoryNumber.isEmpty()) {
            context.put("directorynumber", (Object)publicReferenceFileDirectoryNumber.split(",")[0]);
            context.put("filenumber", (Object)publicReferenceFileDirectoryNumber.split(",")[1]);
        }
        if (CalculateDirectorySizeThread.referenceContent.containsKey(internalId)) {
            context.put("referenceDirectoryContent", (Object)CalculateDirectorySizeThread.referenceContent.get(internalId).split(",")[0]);
            context.put("referenceFileContent", (Object)CalculateDirectorySizeThread.referenceContent.get(internalId).split(",")[1]);
            context.put("referenceDataVolume", (Object)DataSize.StorageUnit.of(Long.valueOf(CalculateDirectorySizeThread.referenceContent.get(internalId).split(",")[2])).format(Long.valueOf(CalculateDirectorySizeThread.referenceContent.get(internalId).split(",")[2])));
        }
        list = null;
        try {
            list = currentDirectory.listPrimaryDataEntities();
            context.put("allobjects", list);
        }
        catch (PrimaryDataDirectoryException e) {
            throw new EdalException("unable to load entity list of the directory", e);
        }
        outputStreamWriter = new OutputStreamWriter((OutputStream)teeOutputStream);
        thread = new MergingEntityOutputThread("de/ipk_gatersleben/bit/bi/edal/primary_data/DirectoryTemplateForSnapshot.xml", VeloCityHtmlGenerator.DEFAULT_CHARSET.toString(), (Context)context, outputStreamWriter, latch, list);
        DataManager.getVelocityExecutorService().execute(thread);
        return outputStreamWriter;
    }

    protected StringWriter generateHtmlErrorMessage(HttpStatus.Code responseCode, String message) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("charset", (Object)DEFAULT_CHARSET.toString());
        context.put("responseCode", (Object)responseCode.getCode());
        context.put("title", (Object)responseCode.getMessage());
        context.put("message", (Object)message);
        context.put(STRING_SERVER_URL, (Object)EdalHttpServer.getServerURL());
        context.put("repositoryNameLong", (Object)DataManager.getConfiguration().getInstanceNameLong());
        context.put("repositoryNameShort", (Object)DataManager.getConfiguration().getInstanceNameShort());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/HtmlMessageTemplate.xml", (String)DEFAULT_CHARSET.toString(), (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected StringWriter generateHtmlForFile(PrimaryDataFile file) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("charset", (Object)DEFAULT_CHARSET.toString());
        context.put(STRING_ENTITY, (Object)file);
        context.put(STRING_VERSION, (Object)file.getCurrentVersion());
        context.put(STRING_ALL_ELEMENTS, MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put(STRING_SERVER_URL, (Object)EdalHttpServer.getServerURL().toString());
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("rights", (Object)EnumDublinCoreElements.RIGHTS);
        context.put("title", (Object)EnumDublinCoreElements.TITLE);
        context.put("creator", (Object)EnumDublinCoreElements.CREATOR);
        context.put("format", (Object)EnumDublinCoreElements.FORMAT);
        context.put("year", (Object)1);
        context.put("publisher", (Object)EnumDublinCoreElements.PUBLISHER);
        context.put("subjects", (Object)EnumDublinCoreElements.SUBJECT);
        context.put("language", (Object)EnumDublinCoreElements.LANGUAGE);
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/FileTemplate.xml", (String)DEFAULT_CHARSET.toString(), (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected OutputStreamWriter generateHtmlForFileForReviewer(PrimaryDataFile file, long versionNumber, String internalId, PersistentIdentifier identifierType, int reviewerCode, TeeOutputStream teeOutputStream, CountDownLatch latch) throws EdalException {
        Calendar date = null;
        try {
            date = DataManager.getImplProv().getApprovalServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getPublicReferenceByInternalId(internalId).getCreationDate();
        }
        catch (ReflectiveOperationException e) {
            throw new EdalException(STRING_UNABLE_TO_INITIALIZE_APPROVAL_SERVICE_PROVIDER + e.getMessage(), e);
        }
        catch (EdalException e) {
            throw e;
        }
        try {
            if (!file.getVersionByDate(date).equals(file.getVersionByRevisionNumber(versionNumber))) {
                return this.generateEmbeddedHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, STRING_PUBLIC_REFERENCE_AND_VERSION_NUMBER_ARE_NOT_COMPATIBLE, teeOutputStream, latch);
            }
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException(STRING_UNABLE_TO_LOAD_VERSIONS_OF + file + " :" + e.getMessage(), e);
        }
        VelocityContext context = new VelocityContext();
        context.put("charset", (Object)DEFAULT_CHARSET.toString());
        context.put(STRING_CITATION_ENTITY, (Object)file);
        context.put(STRING_IDENTIFIER_TYPE, (Object)identifierType.toString());
        context.put(STRING_INTERNAL_ID, (Object)internalId);
        context.put(STRING_DATE, (Object)date);
        context.put(STRING_ENTITY, (Object)file);
        context.put(STRING_ALL_ELEMENTS, MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put(STRING_SERVER_URL, (Object)EdalHttpServer.getServerURL().toString());
        context.put(DOWNLOAD_SERVER_URL, (Object)EdalHttpServer.getHttpDownloadURL().toString());
        context.put(STRING_REVIEWER_CODE, (Object)String.valueOf(reviewerCode));
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("rights", (Object)EnumDublinCoreElements.RIGHTS);
        context.put("repositoryNameLong", (Object)DataManager.getConfiguration().getInstanceNameLong());
        context.put("repositoryNameShort", (Object)DataManager.getConfiguration().getInstanceNameShort());
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)teeOutputStream);
        MergingEntityOutputThread thread = new MergingEntityOutputThread("de/ipk_gatersleben/bit/bi/edal/primary_data/FileTemplateForReviewer.xml", DEFAULT_CHARSET.toString(), (Context)context, output, latch, null);
        DataManager.getVelocityExecutorService().execute(thread);
        return output;
    }

    /*
     * Unable to fully structure code
     */
    protected OutputStreamWriter generateHtmlForFileOfSnapshot(PrimaryDataFile file, long versionNumber, PersistentIdentifier identifierType, String internalId, TeeOutputStream teeOutputStream, CountDownLatch latch) throws EdalException {
        block25: {
            entityWithPersitentIdentifierForCitation = null;
            if (file.getPublicReferences().size() == 0) {
                entityWithPersitentIdentifierForCitation = DataManager.getPrimaryDataEntityRekursiveForPersistenIdentifier(file, versionNumber, identifierType);
            }
            date = null;
            try {
                date = DataManager.getImplProv().getApprovalServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getPublicReferenceByInternalId(internalId).getCreationDate();
            }
            catch (ReflectiveOperationException e) {
                throw new EdalException("unable to initialize ApprovalServiceProvider: " + e.getMessage(), e);
            }
            try {
                if (!file.getVersionByDate(date).equals(file.getVersionByRevisionNumber(versionNumber))) {
                    return this.generateEmbeddedHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "PublicReference and version number are not compatible", teeOutputStream, latch);
                }
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException("unable to load versions of " + file + " :" + e.getMessage(), e);
            }
            log = DataManager.getImplProv().getLogger();
            currentFile = file;
            primaryDataEntityVersion = null;
            primaryDataEntityVersion = currentFile.getVersionByRevisionNumber(versionNumber);
            foundPublicReference = false;
            try {
                if (primaryDataEntityVersion.getPublicReference(identifierType).getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) {
                    currentFile.switchCurrentVersion(primaryDataEntityVersion);
                }
                break block25;
            }
            catch (PrimaryDataEntityVersionException e) {
                log.debug(currentFile + " has no " + (Object)identifierType);
                currentDirectory = null;
                try {
                    currentDirectory = currentFile.getParentDirectory();
                }
                catch (PrimaryDataDirectoryException v0) {}
                ** while (!foundPublicReference)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    log.debug("try ParentDirectory '" + currentDirectory + "'");
                    if (currentDirectory == null) {
                        return this.generateEmbeddedHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "No Public Reference for this version set!", teeOutputStream, latch);
                    }
                    if (!currentDirectory.getVersionByDate(date).getPublicReference(identifierType).getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) continue;
                    if (primaryDataEntityVersion.getRevisionDate().before(date)) {
                        log.debug(currentDirectory + " has " + (Object)identifierType);
                        foundPublicReference = true;
                        currentFile = file;
                        continue;
                    }
                    return this.generateEmbeddedHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "No Public Reference for this version set!", teeOutputStream, latch);
                }
                catch (PrimaryDataEntityVersionException v1) {
                    try {
                        log.debug("ParentDirectory has no " + (Object)identifierType);
                        foundPublicReference = false;
                        try {
                            if (currentDirectory.getParentDirectory() == null) {
                                throw new EdalException("root Directory arrived -> no reference found" + e.getMessage(), e);
                            }
                            currentDirectory = currentDirectory.getParentDirectory();
                            continue;
                        }
                        catch (PrimaryDataDirectoryException v2) {
                            throw new EdalException("unable to get parent directory: " + e.getMessage(), e);
                        }
                    }
                    catch (PrimaryDataEntityVersionException e) {
                        throw new EdalException("unable to get version by revision number: " + e.getMessage(), e);
                    }
                }
            }
        }
        context = new VelocityContext();
        context.put("charset", (Object)VeloCityHtmlGenerator.DEFAULT_CHARSET.toString());
        if (entityWithPersitentIdentifierForCitation != null) {
            context.put("citation_entity", (Object)entityWithPersitentIdentifierForCitation);
        } else {
            context.put("citation_entity", (Object)file);
        }
        context.put("identifierType", (Object)identifierType.toString());
        context.put("entity", (Object)file);
        context.put("date", (Object)date);
        context.put("allElements", MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put("serverURL", (Object)EdalHttpServer.getServerURL().toString());
        context.put("downloadURL", (Object)EdalHttpServer.getHttpDownloadURL().toString());
        context.put("internalId", (Object)internalId);
        context.put("publisher", (Object)EnumDublinCoreElements.PUBLISHER);
        context.put("subjects", (Object)EnumDublinCoreElements.SUBJECT);
        context.put("creator", (Object)EnumDublinCoreElements.CREATOR);
        context.put("contributor", (Object)EnumDublinCoreElements.CONTRIBUTOR);
        context.put("language", (Object)EnumDublinCoreElements.LANGUAGE);
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("rights", (Object)EnumDublinCoreElements.RIGHTS);
        context.put("type", (Object)EnumDublinCoreElements.TYPE);
        context.put("format", (Object)EnumDublinCoreElements.FORMAT);
        context.put("repositoryNameLong", (Object)DataManager.getConfiguration().getInstanceNameLong());
        context.put("repositoryNameShort", (Object)DataManager.getConfiguration().getInstanceNameShort());
        if (CalculateDirectorySizeThread.referenceContent.containsKey(internalId)) {
            context.put("referenceDirectoryContent", (Object)CalculateDirectorySizeThread.referenceContent.get(internalId).split(",")[0]);
            context.put("referenceFileContent", (Object)CalculateDirectorySizeThread.referenceContent.get(internalId).split(",")[1]);
            context.put("referenceDataVolume", (Object)DataSize.StorageUnit.of(Long.valueOf(CalculateDirectorySizeThread.referenceContent.get(internalId).split(",")[2])).format(Long.valueOf(CalculateDirectorySizeThread.referenceContent.get(internalId).split(",")[2])));
        }
        outputStreamWriter = new OutputStreamWriter((OutputStream)teeOutputStream);
        thread = new MergingEntityOutputThread("de/ipk_gatersleben/bit/bi/edal/primary_data/FileTemplateForSnapshot.xml", VeloCityHtmlGenerator.DEFAULT_CHARSET.toString(), (Context)context, outputStreamWriter, latch, null);
        DataManager.getVelocityExecutorService().execute(thread);
        return outputStreamWriter;
    }

    protected OutputStreamWriter generateHtmlForReport(HttpStatus.Code responseCode, OutputStream outputStream, CountDownLatch latch) throws Exception {
        Object size;
        JSONArray finalArray = new JSONArray();
        HashMap<String, HashSet<String>> accessMap = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> ipMap = new HashMap<String, HashSet<String>>();
        HashMap<String, Long> downloadedVolume = new HashMap<String, Long>();
        HashMap<String, Long> uniqueAccessNumbers = new HashMap<String, Long>();
        TreeMap<String, String[]> accessStatistic = new TreeMap<String, String[]>();
        Path pathToLogFiles = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "jetty_log");
        File[] fileArray = pathToLogFiles.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object strLine;
            File file = fileArray[n2];
            FileInputStream is = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            while ((strLine = bufferedReader.readLine()) != null) {
                String ipAddress;
                String publicReferenceId;
                String[] split = ((String)strLine).split("\t");
                if (!split[5].startsWith("GET /DOI/") || (publicReferenceId = split[5].split("/")[2]).length() != 36) continue;
                if (split[5].endsWith("ZIP HTTP/1.1") && split[6].equals("200")) {
                    String directoryId = split[5].split("/")[3];
                    if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(publicReferenceId) + "/" + directoryId)) {
                        if (downloadedVolume.containsKey(publicReferenceId)) {
                            downloadedVolume.put(publicReferenceId, (Long)downloadedVolume.get(publicReferenceId) + CalculateDirectorySizeThread.directorySizes.get(String.valueOf(publicReferenceId) + "/" + directoryId));
                        } else {
                            downloadedVolume.put(publicReferenceId, CalculateDirectorySizeThread.directorySizes.get(String.valueOf(publicReferenceId) + "/" + directoryId));
                        }
                    }
                } else if (downloadedVolume.containsKey(publicReferenceId)) {
                    downloadedVolume.put(publicReferenceId, (Long)downloadedVolume.get(publicReferenceId) + Long.parseLong(split[7]));
                } else {
                    downloadedVolume.put(publicReferenceId, Long.parseLong(split[7]));
                }
                if (accessMap.containsKey(ipAddress = split[1])) {
                    ((HashSet)accessMap.get(ipAddress)).add(publicReferenceId);
                } else {
                    accessMap.put(ipAddress, new HashSet<String>(Arrays.asList(publicReferenceId)));
                }
                if (ipMap.containsKey(publicReferenceId)) {
                    ((HashSet)ipMap.get(publicReferenceId)).add(ipAddress);
                    continue;
                }
                ipMap.put(publicReferenceId, new HashSet<String>(Arrays.asList(ipAddress)));
            }
            bufferedReader.close();
            is.close();
            ++n2;
        }
        for (Map.Entry ipToPublicReferenceEntry : accessMap.entrySet()) {
            for (String publicReferenceID : (HashSet)ipToPublicReferenceEntry.getValue()) {
                if (uniqueAccessNumbers.containsKey(publicReferenceID)) {
                    uniqueAccessNumbers.put(publicReferenceID, (Long)uniqueAccessNumbers.get(publicReferenceID) + 1L);
                    continue;
                }
                uniqueAccessNumbers.put(publicReferenceID, 1L);
            }
        }
        for (Map.Entry entry : uniqueAccessNumbers.entrySet()) {
            PublicReference reference = null;
            try {
                ApprovalServiceProvider appService = DataManager.getImplProv().getApprovalServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                reference = appService.getPublicReferenceByInternalId((String)entry.getKey());
            }
            catch (EdalException | ReflectiveOperationException exception) {}
            if (reference == null || reference.getAssignedID() == null) continue;
            accessStatistic.put(reference.getAssignedID(), new String[]{reference.getVersion().getMetaData().toString(), String.valueOf(entry.getValue()), String.valueOf(downloadedVolume.get(entry.getKey())), GenerateLocations.generateGpsLocations((HashSet)ipMap.get(reference.getInternalID()))});
            JSONObject obj = new JSONObject();
            obj.put((Object)"year", (Object)reference.getReleaseDate().get(1));
            obj.put((Object)"doi", (Object)reference.getAssignedID());
            obj.put((Object)"title", (Object)reference.getVersion().getMetaData().toString());
            obj.put((Object)"downloads", (Object)String.valueOf(downloadedVolume.get(entry.getKey())));
            obj.put((Object)"accesses", (Object)String.valueOf(entry.getValue()));
            obj.put((Object)"locations", (Object)GenerateLocations.generateGpsLocationsToJson((HashSet)ipMap.get(reference.getInternalID())));
            finalArray.add((Object)obj);
        }
        ArrayList<String> statisticList = new ArrayList<String>();
        long totalAccesses = 0L;
        long totalDownloadVolume = 0L;
        for (Map.Entry entry : accessStatistic.entrySet()) {
            size = ((String[])entry.getValue())[2] != null ? DataSize.StorageUnit.of(Long.valueOf(((String[])entry.getValue())[2])).format(Long.valueOf(((String[])entry.getValue())[2])) : "0";
            statisticList.add(String.valueOf((String)entry.getKey()) + "\t" + ((String[])entry.getValue())[0] + "\t" + ((String[])entry.getValue())[1] + "\t" + (String)size + "\t" + ((String[])entry.getValue())[3]);
            totalAccesses += Long.valueOf(((String[])entry.getValue())[1]).longValue();
            totalDownloadVolume += Long.valueOf(((String[])entry.getValue())[2]).longValue();
        }
        String string = DataSize.StorageUnit.of(totalDownloadVolume).format(totalDownloadVolume);
        VelocityContext context = new VelocityContext();
        context.put("charset", (Object)DEFAULT_CHARSET.toString());
        context.put("responseCode", (Object)responseCode.getCode());
        context.put("title", (Object)"Request-Statistics");
        context.put("accessStatistic", statisticList);
        context.put("json", (Object)finalArray.toString().replace("\\/", "/"));
        context.put("repositoryNameLong", (Object)DataManager.getConfiguration().getInstanceNameLong());
        context.put("repositoryNameShort", (Object)DataManager.getConfiguration().getInstanceNameShort());
        context.put(STRING_SERVER_URL, (Object)EdalHttpServer.getServerURL());
        context.put("dois", (Object)statisticList.size());
        context.put("totalAccesses", (Object)totalAccesses);
        context.put("totalDownloadVolume", (Object)string);
        size = new DataSize(CalculateDirectorySizeThread.totalVolumeDataStock);
        context.put("datastock", (Object)((UntypedData)size).toHTML());
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        context.put("filenumber", (Object)numberFormat.format(ServiceProviderImplementation.totalNumberOfFiles));
        context.put("users", (Object)DataManager.getImplProv().getServiceProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getNumberOfUsers());
        context.put("jsonall", (Object)GenerateLocations.getAllIPsList());
        OutputStreamWriter output = new OutputStreamWriter(outputStream);
        MergingReportOutputThread thread = new MergingReportOutputThread("de/ipk_gatersleben/bit/bi/edal/primary_data/ReportTemplate.xml", DEFAULT_CHARSET.toString(), (Context)context, output, latch);
        DataManager.getVelocityExecutorService().execute(thread);
        return output;
    }
}

