/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.CheckSum;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.CheckSumType;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;

class CalculateCheckSumThread
extends EdalThread {
    private PipedInputStream pipedInputStream;
    private CheckSum checksum;
    private CountDownLatch stopLatch;

    CalculateCheckSumThread(PipedInputStream pipedInputStream, CountDownLatch stopLatch) {
        this.pipedInputStream = pipedInputStream;
        this.stopLatch = stopLatch;
    }

    @Override
    public void run() {
        try {
            CheckSum cs = new CheckSum();
            cs.add(new CheckSumType("MD5", this.generateMD5(this.pipedInputStream)));
            this.setChecksum(cs);
        }
        catch (PrimaryDataEntityVersionException e) {
            DataManager.getImplProv().getLogger().error("unable to compute checksum from data stream: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.stopLatch.countDown();
    }

    private String generateMD5(InputStream inputStream) throws PrimaryDataEntityVersionException {
        if (inputStream == null) {
            throw new PrimaryDataEntityVersionException("inputstream is null");
        }
        try {
            String md5;
            int read;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buff = new byte[0xA00000];
            while ((read = inputStream.read(buff)) != -1) {
                md.update(buff, 0, read);
            }
            byte[] hashValue = md.digest();
            StringBuffer sb = new StringBuffer();
            byte[] byArray = hashValue;
            int n = hashValue.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                sb.append(Integer.toHexString(0xFF & element));
                ++n2;
            }
            String string = md5 = sb.toString();
            return string;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new PrimaryDataEntityVersionException("error creating MD5 checksum: " + e.getMessage(), e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new PrimaryDataEntityVersionException("error closing inputstream: " + e.getMessage(), e);
            }
        }
    }

    CheckSum getChecksum() {
        return this.checksum;
    }

    private void setChecksum(CheckSum checksum) {
        this.checksum = checksum;
    }
}

