/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

final class PipedInputOutputThread
extends EdalThread {
    private InputStream pipedSource;
    private Collection<PipedOutputStream> pipedout;
    private long StreamSize = 0L;

    private PipedInputOutputThread() {
    }

    PipedInputOutputThread(InputStream pipedSource, Collection<PipedInputStream> pipedDest) throws IOException {
        this();
        this.pipedout = new Vector<PipedOutputStream>(pipedDest.size());
        this.pipedSource = pipedSource;
        for (PipedInputStream pipedInputStream : pipedDest) {
            PipedOutputStream out = new PipedOutputStream(pipedInputStream);
            this.pipedout.add(out);
        }
    }

    long getSize() {
        return this.StreamSize;
    }

    @Override
    public void run() {
        int readbytes = 0;
        byte[] buffer = new byte[0xA00000];
        try {
            ArrayList<PipedOutputStream> closedStreams = new ArrayList<PipedOutputStream>(this.pipedout.size());
            while ((readbytes = this.pipedSource.read(buffer)) != -1) {
                this.StreamSize += (long)readbytes;
                DataManager.getImplProv().getLogger().debug("read from piped stream: " + readbytes);
                this.pipedout.removeAll(closedStreams);
                for (PipedOutputStream pipedOutputStream : this.pipedout) {
                    try {
                        pipedOutputStream.write(buffer, 0, readbytes);
                    }
                    catch (IOException e) {
                        DataManager.getImplProv().getLogger().debug("unable to write piped streams. Consumer closed inputstream: " + e.getMessage());
                        closedStreams.add(pipedOutputStream);
                        try {
                            pipedOutputStream.close();
                        }
                        catch (IOException iOException) {
                            DataManager.getImplProv().getLogger().error("unable to close piped output streams: " + e.getMessage());
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            DataManager.getImplProv().getLogger().error("unable to read from data streams: " + e.getMessage());
        }
        for (PipedOutputStream pipedOutputStream : this.pipedout) {
            try {
                pipedOutputStream.close();
            }
            catch (IOException e) {
                DataManager.getImplProv().getLogger().error("unable to close piped output streams: " + e.getMessage());
            }
        }
    }
}

