/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.aspectj.security.PublicPermissionCheck;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.ImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.CheckNullValues;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDatePrecision;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPermission;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.PermissionProvider;
import java.security.Principal;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.Subject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class PrimaryDataEntity
implements Comparable<PrimaryDataEntity> {
    private PrimaryDataEntityVersion currentVersion;
    private PrimaryDataDirectory parentDirectory;
    private String id;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    protected PrimaryDataEntity() {
    }

    protected PrimaryDataEntity(PrimaryDataDirectory path, String name) throws PrimaryDataEntityVersionException, PrimaryDataDirectoryException, MetaDataException {
        this.setParentDirectory(path);
        MetaData metadata = null;
        if (this.getParentDirectory() == null) {
            metadata = this.getImplementationProvider().createMetaDataInstance();
        } else {
            try {
                metadata = this.getParentDirectory().getMetaData().clone();
            }
            catch (CloneNotSupportedException e) {
                DataManager.getImplProv().getLogger().fatal(e.getMessage());
                throw new MetaDataException("Can not clone metadata of parent directory: " + e.getMessage());
            }
        }
        try {
            metadata.setElementValue(EnumDublinCoreElements.TITLE, new UntypedData(name));
            this.setCurrentVersion(new PrimaryDataEntityVersion(this, false, metadata));
        }
        catch (Exception e) {
            DataManager.getImplProv().getLogger().fatal(e.getMessage());
            throw new PrimaryDataEntityVersionException("Can not set current Version: " + e.getMessage());
        }
        this.setID(UUID.randomUUID().toString());
    }

    public void addPublicReference(PersistentIdentifier identifierType) throws PrimaryDataEntityException {
        PersistentIdentifier persistentIdentifier = identifierType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)((Object)persistentIdentifier));
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataEntity.addPublicReference_aroundBody1$advice(this, persistentIdentifier, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataEntity.addPublicReference_aroundBody0(this, persistentIdentifier, joinPoint);
    }

    protected void commitVersion(PrimaryDataEntityVersion version) throws PrimaryDataEntityVersionException {
        MetaData metaData = version.getMetaData();
        try {
            DateEvents dateEvents;
            if (version.getRevision() == 0L) {
                dateEvents = new DateEvents("event");
                dateEvents.add(new EdalDate(version.getCreationDate(), EdalDatePrecision.MILLISECOND, EdalDate.STANDART_EVENT_TYPES.CREATED.name()));
                dateEvents.add(new EdalDate(version.getCreationDate(), EdalDatePrecision.MILLISECOND, EdalDate.STANDART_EVENT_TYPES.UPDATED.name()));
                metaData.setElementValue(EnumDublinCoreElements.DATE, dateEvents);
            } else {
                dateEvents = (DateEvents)metaData.getElementValue(EnumDublinCoreElements.DATE);
                HashSet<EdalDate> removeSet = new HashSet<EdalDate>();
                for (EdalDate edalDate : dateEvents.getSet()) {
                    if (!edalDate.getEvent().toString().equalsIgnoreCase(EdalDate.STANDART_EVENT_TYPES.UPDATED.toString())) continue;
                    removeSet.add(edalDate);
                }
                dateEvents.removeAll(removeSet);
                dateEvents.add(new EdalDate(version.getRevisionDate(), EdalDatePrecision.MILLISECOND, EdalDate.STANDART_EVENT_TYPES.UPDATED.name()));
                metaData.setElementValue(EnumDublinCoreElements.DATE, dateEvents);
            }
            version.setMetaData(metaData);
        }
        catch (MetaDataException e) {
            throw new PrimaryDataEntityVersionException("exception while set default metadata", e);
        }
        ReentrantReadWriteLock.WriteLock lock = this.currentVersion.getReadWriteLock().writeLock();
        if (lock.tryLock()) {
            try {
                this.storeVersion(version);
                this.setCurrentVersion(this.getVersions().last());
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public int compareTo(PrimaryDataEntity other) {
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public final void delete() throws PrimaryDataEntityVersionException, PrimaryDataDirectoryException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataEntity.delete_aroundBody3$advice(this, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataEntity.delete_aroundBody2(this, joinPoint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        PublicPermissionCheck.ajc$cflowCounter$8.inc();
        try {
            boolean bl;
            if (this == obj) {
                bl = true;
                return bl;
            }
            if (obj == null) {
                bl = false;
                return bl;
            }
            if (!(obj instanceof PrimaryDataEntity)) {
                bl = false;
                return bl;
            }
            PrimaryDataEntity other = (PrimaryDataEntity)obj;
            if (this.id == null) {
                if (other.id != null) {
                    bl = false;
                    return bl;
                }
            } else if (!this.id.equals(other.id)) {
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$8.dec();
        }
    }

    public PrimaryDataEntityVersion getCurrentVersion() {
        PrimaryDataEntityVersion primaryDataEntityVersion;
        PublicPermissionCheck.ajc$cflowCounter$9.inc();
        try {
            primaryDataEntityVersion = this.currentVersion;
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$9.dec();
        }
        return primaryDataEntityVersion;
    }

    public String getID() {
        String string;
        PublicPermissionCheck.ajc$cflowCounter$5.inc();
        try {
            string = this.id;
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$5.dec();
        }
        return string;
    }

    protected ImplementationProvider getImplementationProvider() {
        return DataManager.getImplProv();
    }

    public MetaData getMetaData() {
        return this.getCurrentVersion().getMetaData();
    }

    public final String getName() {
        String string;
        PublicPermissionCheck.ajc$cflowCounter$2.inc();
        try {
            try {
                string = ((UntypedData)this.getMetaData().getElementValue(EnumDublinCoreElements.TITLE)).toString();
            }
            catch (MetaDataException metaDataException) {
                string = "";
            }
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$2.dec();
        }
        return string;
    }

    public PrimaryDataDirectory getParentDirectory() throws PrimaryDataDirectoryException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            return (PrimaryDataDirectory)PrimaryDataEntity.getParentDirectory_aroundBody5$advice(this, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
        }
        return PrimaryDataEntity.getParentDirectory_aroundBody4(this, joinPoint);
    }

    public String getPath() {
        String string;
        PublicPermissionCheck.ajc$cflowCounter$3.inc();
        try {
            try {
                string = String.valueOf(this.getParentDirectory().getPath()) + "/" + this.getName();
            }
            catch (PrimaryDataDirectoryException primaryDataDirectoryException) {
                string = "/" + this.getName();
            }
            catch (NullPointerException nullPointerException) {
                string = "/";
            }
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$3.dec();
        }
        return string;
    }

    public Map<Principal, List<EdalPermission>> getPermissions() throws PrimaryDataEntityException {
        Map<Principal, List<EdalPermission>> map;
        PublicPermissionCheck.ajc$cflowCounter$4.inc();
        try {
            map = Collections.unmodifiableMap(this.getPermissionsImpl());
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$4.dec();
        }
        return map;
    }

    protected abstract Map<Principal, List<EdalPermission>> getPermissionsImpl() throws PrimaryDataEntityException;

    public List<PublicReference> getPublicReferences() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            return (List)PrimaryDataEntity.getPublicReferences_aroundBody7$advice(this, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
        }
        return PrimaryDataEntity.getPublicReferences_aroundBody6(this, joinPoint);
    }

    protected Subject getSubject() {
        return DataManager.getSubject();
    }

    public PrimaryDataEntityVersion getVersionByDate(Calendar date) throws PrimaryDataEntityVersionException {
        PrimaryDataEntityVersion primaryDataEntityVersion;
        PublicPermissionCheck.ajc$cflowCounter$c.inc();
        try {
            if (date == null) {
                throw new PrimaryDataEntityVersionException("The given date is null !");
            }
            SortedSet<PrimaryDataEntityVersion> versions = this.getVersions();
            PrimaryDataEntityVersion version = null;
            for (PrimaryDataEntityVersion primaryDataEntityVersion2 : versions) {
                if (!primaryDataEntityVersion2.getRevisionDate().before(date) && !primaryDataEntityVersion2.getRevisionDate().equals(date)) break;
                version = primaryDataEntityVersion2;
            }
            if (version == null) {
                throw new PrimaryDataEntityVersionException("All version are older than the given version");
            }
            primaryDataEntityVersion = version;
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$c.dec();
        }
        return primaryDataEntityVersion;
    }

    public PrimaryDataEntityVersion getVersionByRevisionNumber(long revisionNumber) throws PrimaryDataEntityVersionException {
        PrimaryDataEntityVersion primaryDataEntityVersion;
        block4: {
            PublicPermissionCheck.ajc$cflowCounter$b.inc();
            try {
                SortedSet<PrimaryDataEntityVersion> versions = this.getVersions();
                for (PrimaryDataEntityVersion primaryDataEntityVersion2 : versions) {
                    Long version = primaryDataEntityVersion2.getRevision();
                    if (!version.equals(revisionNumber)) continue;
                    primaryDataEntityVersion = primaryDataEntityVersion2;
                    break block4;
                }
                throw new PrimaryDataEntityVersionException("found no version with number '" + revisionNumber + "' !");
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$b.dec();
            }
        }
        return primaryDataEntityVersion;
    }

    public SortedSet<PrimaryDataEntityVersion> getVersions() {
        SortedSet<PrimaryDataEntityVersion> sortedSet;
        PublicPermissionCheck.ajc$cflowCounter$a.inc();
        try {
            sortedSet = Collections.unmodifiableSortedSet(this.getVersionsImpl());
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$a.dec();
        }
        return sortedSet;
    }

    protected abstract SortedSet<PrimaryDataEntityVersion> getVersionsImpl();

    public void grantPermission(Principal principal, GrantableMethods.Methods method) throws PrimaryDataEntityException {
        Principal principal2 = principal;
        GrantableMethods.Methods methods = method;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)principal2, (Object)((Object)methods));
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataEntity.grantPermission_aroundBody9$advice(this, principal2, methods, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataEntity.grantPermission_aroundBody8(this, principal2, methods, joinPoint);
    }

    public int hashCode() {
        int n;
        PublicPermissionCheck.ajc$cflowCounter$7.inc();
        try {
            int result = 1;
            n = result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$7.dec();
        }
        return n;
    }

    public boolean isDirectory() {
        boolean bl;
        block6: {
            PublicPermissionCheck.ajc$cflowCounter$6.inc();
            try {
                block5: {
                    try {
                        if (!((UntypedData)this.getMetaData().getElementValue(EnumDublinCoreElements.TYPE)).toString().equals(MetaData.DIRECTORY.toString())) break block5;
                        bl = true;
                        break block6;
                    }
                    catch (MetaDataException e) {
                        e.printStackTrace();
                    }
                }
                bl = false;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$6.dec();
            }
        }
        return bl;
    }

    public void move(PrimaryDataDirectory destinationDirectory) throws PrimaryDataDirectoryException {
        PrimaryDataDirectory primaryDataDirectory = destinationDirectory;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)primaryDataDirectory);
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataEntity.move_aroundBody11$advice(this, primaryDataDirectory, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataEntity.move_aroundBody10(this, primaryDataDirectory, joinPoint);
    }

    protected abstract void moveImpl(PrimaryDataDirectory var1);

    public final void rename(String name) throws PrimaryDataEntityVersionException, PrimaryDataDirectoryException {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataEntity.rename_aroundBody13$advice(this, string, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataEntity.rename_aroundBody12(this, string, joinPoint);
    }

    public void revokePermission(Principal principal, GrantableMethods.Methods method) throws PrimaryDataEntityException {
        Principal principal2 = principal;
        GrantableMethods.Methods methods = method;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)principal2, (Object)((Object)methods));
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataEntity.revokePermission_aroundBody15$advice(this, principal2, methods, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataEntity.revokePermission_aroundBody14(this, principal2, methods, joinPoint);
    }

    protected void setCurrentVersion(PrimaryDataEntityVersion version) {
        this.currentVersion = version;
    }

    protected final void setDefaultPermissions() throws PrimaryDataEntityException {
        Principal principal = null;
        Iterator<Object> iterator = this.getSubject().getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal p;
            principal = p = iterator.next();
        }
        for (GrantableMethods.Methods method : GrantableMethods.ENTITY_METHODS) {
            try {
                this.grantPermission(principal, method);
            }
            catch (PrimaryDataEntityException e) {
                throw new PrimaryDataEntityException("Unable to set default entity permissions", e);
            }
        }
        if (this.isDirectory()) {
            for (GrantableMethods.Methods method : GrantableMethods.DIRECTORY_METHODS) {
                try {
                    this.grantPermission(principal, method);
                }
                catch (PrimaryDataEntityException e) {
                    throw new PrimaryDataEntityException("Unable to set default directory permissions", e);
                }
            }
        } else {
            for (GrantableMethods.Methods method : GrantableMethods.FILE_METHODS) {
                try {
                    this.grantPermission(principal, method);
                }
                catch (PrimaryDataEntityException e) {
                    throw new PrimaryDataEntityException("Unable to set default file permissions", e);
                }
            }
        }
        this.setUserPermissions();
    }

    protected void setID(String id) {
        this.id = id;
    }

    protected UntypedData reloadOldDataType(EnumDublinCoreElements element) throws MetaDataException {
        MetaData oldMetaData = null;
        try {
            oldMetaData = DataManager.getImplProv().reloadPrimaryDataEntityByID(this.getID(), this.getCurrentVersion().getRevision()).getMetaData();
        }
        catch (EdalException e) {
            throw new MetaDataException("unable to reload the old metadata: " + e.getMessage(), e);
        }
        this.getCurrentVersion().getMetaData().setElementValue(element, (UntypedData)oldMetaData.getElementValue(element));
        return oldMetaData.getElementValue(element);
    }

    public void setMetaData(MetaData newMetadata) throws PrimaryDataEntityVersionException, MetaDataException {
        MetaData metaData = newMetadata;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)metaData);
        if (!(PublicPermissionCheck.ajc$cflowCounter$0.isValid() || PublicPermissionCheck.ajc$cflowCounter$1.isValid() || PublicPermissionCheck.ajc$cflowCounter$2.isValid() || PublicPermissionCheck.ajc$cflowCounter$3.isValid() || PublicPermissionCheck.ajc$cflowCounter$4.isValid() || PublicPermissionCheck.ajc$cflowCounter$5.isValid() || PublicPermissionCheck.ajc$cflowCounter$6.isValid() || PublicPermissionCheck.ajc$cflowCounter$7.isValid() || PublicPermissionCheck.ajc$cflowCounter$8.isValid() || PublicPermissionCheck.ajc$cflowCounter$9.isValid() || PublicPermissionCheck.ajc$cflowCounter$a.isValid() || PublicPermissionCheck.ajc$cflowCounter$b.isValid() || PublicPermissionCheck.ajc$cflowCounter$c.isValid() || PublicPermissionCheck.ajc$cflowCounter$d.isValid() || PublicPermissionCheck.ajc$cflowCounter$e.isValid() || PublicPermissionCheck.ajc$cflowCounter$f.isValid())) {
            PrimaryDataEntity.setMetaData_aroundBody17$advice(this, metaData, joinPoint, PublicPermissionCheck.aspectOf(), null, joinPoint);
            return;
        }
        PrimaryDataEntity.setMetaData_aroundBody16(this, metaData, joinPoint);
    }

    private void checkDateEventConsitency(MetaData oldMetaData, MetaData newMetaData) throws MetaDataException {
        DateEvents oldDateEvents = (DateEvents)oldMetaData.getElementValue(EnumDublinCoreElements.DATE);
        DateEvents newDateEvents = (DateEvents)newMetaData.getElementValue(EnumDublinCoreElements.DATE);
        boolean consistCreateDate = false;
        boolean consistModifiedDate = false;
        for (EdalDate edalDate : newDateEvents) {
            if (edalDate.getEvent().equalsIgnoreCase(EdalDate.STANDART_EVENT_TYPES.CREATED.toString())) {
                consistCreateDate = true;
            }
            if (!edalDate.getEvent().equalsIgnoreCase(EdalDate.STANDART_EVENT_TYPES.UPDATED.toString())) continue;
            consistModifiedDate = true;
        }
        if (!consistCreateDate) {
            this.reloadOldDataType(EnumDublinCoreElements.DATE);
            throw new MetaDataException("not allowed to set a DateEvent with no CREATED date");
        }
        if (!consistModifiedDate && this.currentVersion.getRevision() != 0L) {
            UntypedData originalData = this.reloadOldDataType(EnumDublinCoreElements.DATE);
            throw new MetaDataException("not allowed to set a DateEvent with no UPDATED date ! Rollback to " + originalData);
        }
        DateEvents tempDateEvents = new DateEvents("temp");
        if (!oldDateEvents.getSet().equals(newDateEvents.getSet())) {
            for (EdalDate newEdalDate : newDateEvents) {
                if (oldDateEvents.contains(newEdalDate)) continue;
                tempDateEvents.add(newEdalDate);
            }
            for (EdalDate edalDate : tempDateEvents) {
                if (edalDate.getEvent().equalsIgnoreCase(EdalDate.STANDART_EVENT_TYPES.CREATED.toString())) {
                    UntypedData originalData = this.reloadOldDataType(EnumDublinCoreElements.DATE);
                    throw new MetaDataException("it is not allowed to set or change the CREATED Date of an object ! Rollback to " + originalData);
                }
                if (!edalDate.getEvent().equalsIgnoreCase(EdalDate.STANDART_EVENT_TYPES.UPDATED.toString())) continue;
                UntypedData originalData = this.reloadOldDataType(EnumDublinCoreElements.DATE);
                throw new MetaDataException("it is not allowed to set or change the UPDATED Date of an object ! Rollback to " + originalData);
            }
        }
    }

    protected void setParentDirectory(PrimaryDataDirectory parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    private void setUserPermissions() throws PrimaryDataEntityException {
        Map<Principal, List<GrantableMethods.Methods>> permissions = DataManager.getDefaultPermissions();
        if (permissions != null) {
            for (Map.Entry<Principal, List<GrantableMethods.Methods>> entry : permissions.entrySet()) {
                for (GrantableMethods.Methods method : entry.getValue()) {
                    if (GrantableMethods.ENTITY_METHODS.contains((Object)method)) {
                        try {
                            this.grantPermission(entry.getKey(), method);
                            continue;
                        }
                        catch (PrimaryDataEntityException e) {
                            throw new PrimaryDataEntityException("Unable to set user permissions :" + e.getMessage());
                        }
                    }
                    if (this.isDirectory() && GrantableMethods.DIRECTORY_METHODS.contains((Object)method)) {
                        try {
                            this.grantPermission(entry.getKey(), method);
                            continue;
                        }
                        catch (PrimaryDataEntityException e) {
                            throw new PrimaryDataEntityException("Unable to set user permissions :" + e.getMessage());
                        }
                    }
                    if (this.isDirectory() || !GrantableMethods.FILE_METHODS.contains((Object)method)) continue;
                    try {
                        this.grantPermission(entry.getKey(), method);
                    }
                    catch (PrimaryDataEntityException e) {
                        throw new PrimaryDataEntityException("Unable to set user permissions :" + e.getMessage());
                    }
                }
            }
        }
    }

    protected abstract void storeVersion(PrimaryDataEntityVersion var1) throws PrimaryDataEntityVersionException;

    public void switchCurrentVersion(PrimaryDataEntityVersion version) throws PrimaryDataEntityVersionException {
        PublicPermissionCheck.ajc$cflowCounter$d.inc();
        try {
            if (!this.getVersions().contains(version)) {
                throw new PrimaryDataEntityVersionException("Requested version not available !");
            }
            this.setCurrentVersion(version);
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$d.dec();
        }
    }

    public String toString() {
        String string;
        PublicPermissionCheck.ajc$cflowCounter$1.inc();
        try {
            string = this.getName();
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$1.dec();
        }
        return string;
    }

    static {
        PrimaryDataEntity.ajc$preClinit();
    }

    private static final /* synthetic */ void addPublicReference_aroundBody0(PrimaryDataEntity ajc$this, PersistentIdentifier identifierType, JoinPoint joinPoint) {
        ajc$this.getCurrentVersion().addPublicReference(identifierType, ajc$this);
    }

    private static final /* synthetic */ Object addPublicReference_aroundBody1$advice(PrimaryDataEntity ajc$this, PersistentIdentifier identifierType, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var11_9;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var8_7;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataEntity.addPublicReference_aroundBody0(ajc$this, identifierType, thisJoinPoint);
                var8_7 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var11_9 = var8_7;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var11_9;
    }

    private static final /* synthetic */ void delete_aroundBody2(PrimaryDataEntity ajc$this, JoinPoint joinPoint) {
        if (ajc$this.getParentDirectory() == null) {
            throw new PrimaryDataDirectoryException("Can not delete root directory !");
        }
        PrimaryDataEntityVersion lastVersion = ajc$this.getVersions().last();
        if (ajc$this.getCurrentVersion().compareTo(ajc$this.getVersions().last()) != 0) {
            throw new PrimaryDataEntityVersionException("Can not delete non-current version !");
        }
        PrimaryDataEntityVersion newFileVersion = new PrimaryDataEntityVersion(ajc$this, true, lastVersion.getMetaData());
        ajc$this.commitVersion(newFileVersion);
    }

    private static final /* synthetic */ Object delete_aroundBody3$advice(PrimaryDataEntity ajc$this, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var10_8;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var7_6;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataEntity.delete_aroundBody2(ajc$this, thisJoinPoint);
                var7_6 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var10_8 = var7_6;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var10_8;
    }

    private static final /* synthetic */ PrimaryDataDirectory getParentDirectory_aroundBody4(PrimaryDataEntity ajc$this, JoinPoint joinPoint) {
        if (ajc$this.parentDirectory == null) {
            throw new PrimaryDataDirectoryException("Can not access parent directory of root directory !");
        }
        if (ajc$this.getCurrentVersion() != null) {
            try {
                ajc$this.parentDirectory.switchCurrentVersion(ajc$this.parentDirectory.getVersionByDate(ajc$this.currentVersion.getRevisionDate()));
            }
            catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
                throw new PrimaryDataDirectoryException("Can not switch to correct parent version");
            }
            return ajc$this.parentDirectory;
        }
        return ajc$this.parentDirectory;
    }

    private static final /* synthetic */ Object getParentDirectory_aroundBody5$advice(PrimaryDataEntity ajc$this, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        PrimaryDataDirectory primaryDataDirectory;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            PrimaryDataDirectory primaryDataDirectory2;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                primaryDataDirectory2 = PrimaryDataEntity.getParentDirectory_aroundBody4(ajc$this, thisJoinPoint);
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            primaryDataDirectory = primaryDataDirectory2;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return primaryDataDirectory;
    }

    private static final /* synthetic */ List getPublicReferences_aroundBody6(PrimaryDataEntity ajc$this, JoinPoint joinPoint) {
        return ajc$this.getCurrentVersion().getPublicReferences();
    }

    private static final /* synthetic */ Object getPublicReferences_aroundBody7$advice(PrimaryDataEntity ajc$this, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        List list;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            List list2;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                list2 = PrimaryDataEntity.getPublicReferences_aroundBody6(ajc$this, thisJoinPoint);
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            list = list2;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return list;
    }

    private static final /* synthetic */ void grantPermission_aroundBody8(PrimaryDataEntity ajc$this, Principal principal, GrantableMethods.Methods method, JoinPoint joinPoint) {
        Class<? extends PermissionProvider> permProv = ajc$this.getImplementationProvider().getPermissionProvider();
        if (method.equals((Object)GrantableMethods.Methods.ALL)) {
            try {
                permProv.getMethod("grantPermission", String.class, String.class, PrimaryDataEntity.class).invoke((Object)permProv.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), principal.getClass().getSimpleName(), principal.getName(), ajc$this);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new PrimaryDataEntityException("Unable to call grantPermission() function", e);
            }
        }
        try {
            EdalPermission edalPermission = new EdalPermission(ajc$this.getID(), ajc$this.getCurrentVersion().getRevision(), method.getImplClass(ajc$this.getClass()).getDeclaringClass(), method.getImplClass(ajc$this.getClass()));
            permProv.getMethod("grantPermission", String.class, String.class, EdalPermission.class).invoke((Object)permProv.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), principal.getClass().getSimpleName(), principal.getName(), edalPermission);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new PrimaryDataEntityException("Unable to call grantPermission() function", e);
        }
    }

    private static final /* synthetic */ Object grantPermission_aroundBody9$advice(PrimaryDataEntity ajc$this, Principal principal, GrantableMethods.Methods method, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var12_10;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var9_8;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataEntity.grantPermission_aroundBody8(ajc$this, principal, method, thisJoinPoint);
                var9_8 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var12_10 = var9_8;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var12_10;
    }

    private static final /* synthetic */ void move_aroundBody10(PrimaryDataEntity ajc$this, PrimaryDataDirectory destinationDirectory, JoinPoint joinPoint) {
        if (ajc$this.getParentDirectory() == null) {
            throw new PrimaryDataDirectoryException("You can not move the root directory !");
        }
        ajc$this.moveImpl(destinationDirectory);
    }

    private static final /* synthetic */ Object move_aroundBody11$advice(PrimaryDataEntity ajc$this, PrimaryDataDirectory destinationDirectory, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var11_9;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var8_7;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataEntity.move_aroundBody10(ajc$this, destinationDirectory, thisJoinPoint);
                var8_7 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var11_9 = var8_7;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var11_9;
    }

    private static final /* synthetic */ void rename_aroundBody12(PrimaryDataEntity ajc$this, String name, JoinPoint joinPoint) {
        if (ajc$this.parentDirectory.exist(name)) {
            throw new PrimaryDataDirectoryException("Can not rename, object '" + name + "' already exists !");
        }
        MetaData metadata = null;
        try {
            metadata = ajc$this.getMetaData().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new PrimaryDataEntityVersionException("Unable to clone", e);
        }
        try {
            metadata.setElementValue(EnumDublinCoreElements.TITLE, new UntypedData(name));
            ajc$this.setMetaData(metadata);
        }
        catch (MetaDataException e) {
            throw new PrimaryDataEntityVersionException("Can not rename", e);
        }
    }

    private static final /* synthetic */ Object rename_aroundBody13$advice(PrimaryDataEntity ajc$this, String name, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var11_9;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var8_7;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataEntity.rename_aroundBody12(ajc$this, name, thisJoinPoint);
                var8_7 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var11_9 = var8_7;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var11_9;
    }

    private static final /* synthetic */ void revokePermission_aroundBody14(PrimaryDataEntity ajc$this, Principal principal, GrantableMethods.Methods method, JoinPoint joinPoint) {
        Principal currentPrincipal = null;
        Iterator<Principal> iterator = ajc$this.getSubject().getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal p;
            currentPrincipal = p = iterator.next();
        }
        if (currentPrincipal == null) {
            throw new PrimaryDataEntityException("could not get the current pricipal from the authenticated subject");
        }
        if (currentPrincipal.equals(principal) && (method.equals((Object)GrantableMethods.Methods.grantPermission) || method.equals((Object)GrantableMethods.Methods.ALL))) {
            throw new PrimaryDataEntityException("you couldn't revoke the method grantPermission for your own Entity");
        }
        Class<? extends PermissionProvider> permProv = ajc$this.getImplementationProvider().getPermissionProvider();
        if (method.equals((Object)GrantableMethods.Methods.ALL)) {
            try {
                permProv.getMethod("revokePermission", String.class, String.class, PrimaryDataEntity.class).invoke((Object)permProv.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), principal.getClass().getSimpleName(), principal.getName(), ajc$this);
            }
            catch (Exception e) {
                throw new PrimaryDataEntityException("unable to call revokePermission() function:" + e);
            }
        }
        try {
            EdalPermission edalPermission = new EdalPermission(ajc$this.getID().toString(), ajc$this.getCurrentVersion().getRevision(), method.getImplClass(ajc$this.getClass()).getDeclaringClass(), method.getImplClass(ajc$this.getClass()));
            permProv.getMethod("revokePermission", String.class, String.class, EdalPermission.class).invoke((Object)permProv.newInstance(), principal.getClass().getSimpleName(), principal.getName(), edalPermission);
        }
        catch (Exception e) {
            throw new PrimaryDataEntityException("unable to call revokePermission() function:" + e);
        }
    }

    private static final /* synthetic */ Object revokePermission_aroundBody15$advice(PrimaryDataEntity ajc$this, Principal principal, GrantableMethods.Methods method, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var12_10;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var9_8;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataEntity.revokePermission_aroundBody14(ajc$this, principal, method, thisJoinPoint);
                var9_8 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var12_10 = var9_8;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var12_10;
    }

    private static final /* synthetic */ void setMetaData_aroundBody16(PrimaryDataEntity ajc$this, MetaData newMetadata, JoinPoint joinPoint) {
        MetaData cloneNewMetaData = null;
        try {
            cloneNewMetaData = newMetadata.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MetaDataException("unable to clone: " + e.getMessage(), e);
        }
        MetaData oldMetaData = null;
        try {
            oldMetaData = DataManager.getImplProv().reloadPrimaryDataEntityByID(ajc$this.getID(), ajc$this.getCurrentVersion().getRevision()).getMetaData();
        }
        catch (EdalException e) {
            throw new MetaDataException("unable to reload metadata: " + e.getMessage(), e);
        }
        ajc$this.checkDateEventConsitency(oldMetaData, cloneNewMetaData);
        if (!oldMetaData.equals(cloneNewMetaData)) {
            PrimaryDataEntityVersion newVersion = new PrimaryDataEntityVersion(ajc$this, false, cloneNewMetaData);
            ajc$this.commitVersion(newVersion);
        } else {
            DataManager.getImplProv().getLogger().debug("tried to set the same metadata again !");
        }
    }

    private static final /* synthetic */ Object setMetaData_aroundBody17$advice(PrimaryDataEntity ajc$this, MetaData newMetadata, JoinPoint thisJoinPoint, PublicPermissionCheck ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        Object var11_9;
        CheckNullValues.ajc$cflowCounter$0.inc();
        try {
            Object var8_7;
            PublicPermissionCheck.ajc$cflowCounter$f.inc();
            try {
                ajc$aspectInstance.checkPermission(thisJoinPoint2);
                AroundClosure aroundClosure = ajc$aroundClosure;
                PrimaryDataEntity.setMetaData_aroundBody16(ajc$this, newMetadata, thisJoinPoint);
                var8_7 = null;
            }
            finally {
                PublicPermissionCheck.ajc$cflowCounter$f.dec();
            }
            var11_9 = var8_7;
        }
        finally {
            CheckNullValues.ajc$cflowCounter$0.dec();
        }
        return var11_9;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PrimaryDataEntity.java", PrimaryDataEntity.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addPublicReference", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity", "de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier", "identifierType", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException", "void"), 136);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "delete", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity", "", "", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException:de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException", "void"), 245);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentDirectory", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity", "", "", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory"), 367);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPublicReferences", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity", "", "", "", "java.util.List"), 445);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "grantPermission", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity", "java.security.Principal:de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods$Methods", "principal:method", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException", "void"), 560);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "move", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory", "destinationDirectory", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException", "void"), 643);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "rename", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity", "java.lang.String", "name", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException:de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException", "void"), 677);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "revokePermission", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity", "java.security.Principal:de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods$Methods", "principal:method", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException", "void"), 720);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMetaData", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity", "de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData", "newMetadata", "de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException:de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException", "void"), 905);
    }
}

