/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AsynchronList<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 876424262765176354L;
    private final AtomicBoolean finish = new AtomicBoolean(false);
    private boolean stopped = false;

    public AsynchronList() {
    }

    public AsynchronList(Collection<? extends E> collection) {
        super(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAllElementsPresent() {
        while (!this.finish.get()) {
            try {
                AsynchronList asynchronList = this;
                synchronized (asynchronList) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean checkPresentElementAtIndex(int index) {
        try {
            super.get(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkVolatileElement(int index) {
        while (!this.checkPresentElementAtIndex(index) && !this.finish.get()) {
            try {
                AsynchronList asynchronList = this;
                synchronized (asynchronList) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void clear() {
        this.checkAllElementsPresent();
        super.clear();
    }

    @Override
    public E get(int index) {
        this.checkVolatileElement(index);
        return super.get(index);
    }

    @Override
    public int indexOf(Object elem) {
        this.checkAllElementsPresent();
        return super.indexOf(elem);
    }

    @Override
    public boolean isEmpty() {
        this.checkAllElementsPresent();
        return super.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        this.checkAllElementsPresent();
        return super.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewDataAvailable() {
        AsynchronList asynchronList = this;
        synchronized (asynchronList) {
            this.notifyAll();
        }
    }

    public void notifyNoMoreNewData() {
        this.finish.set(true);
        this.notifyNewDataAvailable();
    }

    @Override
    public E remove(int index) {
        this.checkVolatileElement(index);
        return super.remove(index);
    }

    @Override
    public E set(int index, E elem) {
        this.checkVolatileElement(index);
        return super.set(index, elem);
    }

    @Override
    public int size() {
        this.checkAllElementsPresent();
        return super.size();
    }

    @Override
    public Object[] toArray() {
        this.checkAllElementsPresent();
        return super.toArray();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped() {
        this.stopped = true;
    }

    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            AsynchronList.this.checkVolatileElement(this.cursor + 1);
            if (!AsynchronList.this.finish.get()) {
                return true;
            }
            return this.cursor != AsynchronList.this.size();
        }

        @Override
        public E next() {
            try {
                int i = this.cursor;
                Object next = AsynchronList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                AsynchronList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public void add(E e) {
            try {
                int i = this.cursor;
                AsynchronList.this.add(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public E previous() {
            try {
                int i = this.cursor - 1;
                Object previous = AsynchronList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                AsynchronList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

