/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.CalculateDirectorySizeJob;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ServiceProviderImplementation;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdSchedulerFactory;

public class CalculateDirectorySizeThread
extends EdalThread {
    private static final int INTERVAL_TO_REPEAT_JOB = 24;
    private static Scheduler scheduler;
    public static Map<String, Long> directorySizes;
    public static Map<String, String> directoryFiles;
    public static long totalVolumeDataStock;
    public static Map<String, String> referenceContent;

    static {
        directorySizes = null;
        directoryFiles = null;
        totalVolumeDataStock = 0L;
        referenceContent = null;
    }

    public void done() {
        try {
            if (this.getScheduler() != null) {
                this.getScheduler().shutdown(true);
            }
        }
        catch (SchedulerException e) {
            DataManager.getImplProv().getLogger().info("unable to stop CalculateDirectorySizeThreadScheduler", (Throwable)e);
        }
    }

    public Scheduler getScheduler() {
        return scheduler;
    }

    @Override
    public void run() {
        Object readLong;
        Object readMap;
        ObjectInputStream ois;
        Path path = ServiceProviderImplementation.PATH_FOR_DIRECTORY_SIZE_MAP;
        if (Files.exists(path, new LinkOption[0])) {
            directorySizes = new HashMap<String, Long>();
            try {
                ois = new ObjectInputStream(new FileInputStream(path.toFile()));
                readMap = ois.readObject();
                if (readMap != null && readMap instanceof HashMap) {
                    directorySizes.putAll((Map)readMap);
                }
                ois.close();
            }
            catch (Exception e) {
                ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
            }
        } else {
            directorySizes = new HashMap<String, Long>();
        }
        if (Files.exists(path = ServiceProviderImplementation.PATH_FOR_DIRECTORY_FILE_MAP, new LinkOption[0])) {
            directoryFiles = new HashMap<String, String>();
            try {
                ois = new ObjectInputStream(new FileInputStream(path.toFile()));
                readMap = ois.readObject();
                if (readMap != null && readMap instanceof HashMap) {
                    directoryFiles.putAll((Map)readMap);
                }
                ois.close();
            }
            catch (Exception e) {
                ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
            }
        } else {
            directoryFiles = new HashMap<String, String>();
        }
        if (Files.exists(path = ServiceProviderImplementation.PATH_FOR_REFERENCE_CONTENT, new LinkOption[0])) {
            referenceContent = new HashMap<String, String>();
            try {
                ois = new ObjectInputStream(new FileInputStream(path.toFile()));
                readMap = ois.readObject();
                if (readMap != null && readMap instanceof HashMap) {
                    referenceContent.putAll((Map)readMap);
                }
                ois.close();
            }
            catch (Exception e) {
                ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
            }
        } else {
            referenceContent = new HashMap<String, String>();
        }
        if (Files.exists(path = ServiceProviderImplementation.PATH_FOR_TOTAL_FILE_NUMBER, new LinkOption[0])) {
            ServiceProviderImplementation.totalNumberOfFiles = 0L;
            try {
                ois = new ObjectInputStream(new FileInputStream(path.toFile()));
                readLong = ois.readObject();
                if (readLong != null && readLong instanceof Long) {
                    ServiceProviderImplementation.totalNumberOfFiles = (Long)readLong;
                }
                ois.close();
            }
            catch (Exception e) {
                ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
            }
        } else {
            ServiceProviderImplementation.totalNumberOfFiles = 0L;
        }
        if (Files.exists(path = ServiceProviderImplementation.PATH_FOR_TOTAL_VOLUME, new LinkOption[0])) {
            totalVolumeDataStock = 0L;
            try {
                ois = new ObjectInputStream(new FileInputStream(path.toFile()));
                readLong = ois.readObject();
                if (readLong != null && readLong instanceof Long) {
                    totalVolumeDataStock = (Long)readLong;
                }
                ois.close();
            }
            catch (Exception e) {
                ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
            }
        } else {
            totalVolumeDataStock = 0L;
        }
        DataManager.getImplProv().getLogger().info("Starting CalculateDirectorySizeThread");
        Scheduler defaultQuartzScheduler = SchedulerRepository.getInstance().lookup("DefaultQuartzScheduler");
        if (defaultQuartzScheduler == null) {
            try {
                CalculateDirectorySizeThread.setScheduler(new StdSchedulerFactory().getScheduler());
            }
            catch (SchedulerException e) {
                DataManager.getImplProv().getLogger().warn("unable to create new CalculateDirectorySizeThreadScheduler", (Throwable)e);
            }
        } else {
            CalculateDirectorySizeThread.setScheduler(defaultQuartzScheduler);
        }
        try {
            this.getScheduler().start();
            JobDetail job = JobBuilder.newJob(CalculateDirectorySizeJob.class).build();
            Trigger trigger = TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(24).repeatForever()).build();
            this.getScheduler().scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            DataManager.getImplProv().getLogger().warn("unable to start CalculateDirectorySizeThreadScheduler", (Throwable)e);
        }
    }

    private static void setScheduler(Scheduler scheduler) {
        CalculateDirectorySizeThread.scheduler = scheduler;
    }
}

