/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.HttpServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.ImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ApprovalServiceProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.DoiImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.HttpServiceProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.IndexWriterThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.MetaDataImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PermissionProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataEntityVersionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewStatusImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewersImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.RootImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ServiceProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.SupportedPrincipals;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.TicketImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.UrlImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyCheckSum;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyCheckSumType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDirectoryMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEdalDateRange;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEdalLanguage;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEmptyMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyIdentifierRelation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyLegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyNaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyORCID;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyPersons;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MySubjects;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyUnknownMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyUntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ApprovalServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.PermissionProvider;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.logging.log4j.Logger;
import org.ehcache.CacheManager;
import org.ehcache.Status;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.xml.XmlConfiguration;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.Statistics;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.tool.schema.TargetType;

public class FileSystemImplementationProvider
implements ImplementationProvider {
    private static final String EDALDB_DBNAME = "edaldb";
    private Logger logger;
    private static final int SQL_ERROR_DATABASE_IN_USE = 90020;
    private static final int SQL_ERROR_DATABASE_NOT_FOUND = 90013;
    private boolean autoIndexing;
    private EdalConfiguration configuration;
    private Connection connection;
    private String databasePassword;
    private String databaseUsername;
    private IndexWriterThread indexThread;
    private SessionFactory sessionFactory;
    private Path indexDirectory;
    private CacheManager cacheManager;

    public FileSystemImplementationProvider(EdalConfiguration configuration) {
        MetadataSources metadata;
        StandardServiceRegistry standardRegistry;
        block33: {
            this.logger = null;
            this.connection = null;
            this.indexThread = null;
            this.sessionFactory = null;
            this.indexDirectory = null;
            this.cacheManager = null;
            this.configuration = configuration;
            try {
                this.setDatabaseUsername(this.getConfiguration().getDatabaseUsername());
                this.setDatabasePassword(this.getConfiguration().getDatabasePassword());
            }
            catch (EdalConfigurationException e) {
                e.printStackTrace();
            }
            this.logger = configuration.getLogger();
            this.setAutoIndexing(this.autoIndexing);
            try {
                try {
                    Class.forName("org.h2.Driver");
                    this.setConnection(DriverManager.getConnection("jdbc:h2:split:30:" + this.getMountPath() + ";IFEXISTS=TRUE;DB_CLOSE_ON_EXIT=FALSE", this.getDatabaseUsername(), this.getDatabasePassword()));
                    this.getLogger().info("Database connection established");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.getLogger().error("Could not find driver for H2 connection !");
                    System.exit(0);
                }
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 90020) {
                    this.getLogger().warn("Database still in use -> close and restart please !");
                    System.exit(0);
                }
                if (se.getErrorCode() != 90013) break block33;
                this.getLogger().info("No database found -> creating new database...");
                try {
                    this.setConnection(DriverManager.getConnection("jdbc:h2:split:30:" + this.getMountPath() + ";DB_CLOSE_ON_EXIT=FALSE", this.getDatabaseUsername(), this.getDatabasePassword()));
                }
                catch (SQLException sQLException) {
                    this.getLogger().error("Could not start H2 connection !");
                    System.exit(0);
                }
            }
        }
        this.indexDirectory = Paths.get(this.getMountPath().toString(), "lucene");
        org.hibernate.cfg.Configuration config = new org.hibernate.cfg.Configuration();
        config.configure(FileSystemImplementationProvider.class.getResource("hibernate.cfg.xml"));
        XmlConfiguration xmlconfig = new XmlConfiguration(this.getClass().getResource("ehcache.cfg.xml"));
        CacheManager ehcacheManager = CacheManagerBuilder.newCacheManager((Configuration)xmlconfig);
        ehcacheManager.init();
        this.setCacheManager(ehcacheManager);
        config.setProperty("hibernate.connection.url", "jdbc:h2:split:30:" + this.getMountPath() + ";DB_CLOSE_ON_EXIT=FALSE");
        config.setProperty("hibernate.connection.username", this.getDatabaseUsername());
        config.setProperty("hibernate.connection.password", this.getDatabasePassword());
        config.setProperty("hibernate.search.default.exclusive_index_use", "false");
        config.setProperty("hibernate.search.default.indexBase", this.indexDirectory.toString());
        if (!this.isAutoIndexing()) {
            config.setProperty("hibernate.search.indexing_strategy", "manual");
        }
        Boolean exists = false;
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (ResultSet result = this.getConnection().createStatement().executeQuery("SELECT count(*) FROM ENTITIES ");){
                result.last();
                int resultSize = result.getInt("COUNT(*)");
                if (resultSize > 0) {
                    exists = true;
                }
                result.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            exists = false;
        }
        List<Class> annotatedHibernateClasses = Arrays.asList(RootImplementation.class, PrincipalImplementation.class, PrimaryDataDirectoryImplementation.class, PrimaryDataFileImplementation.class, PrimaryDataEntityVersionImplementation.class, MetaDataImplementation.class, EdalPermissionImplementation.class, SupportedPrincipals.class, PublicReferenceImplementation.class, TicketImplementation.class, ReviewersImplementation.class, ReviewStatusImplementation.class, UrlImplementation.class, DoiImplementation.class, MyDataFormat.class, MyDataSize.class, MyDataType.class, MyDirectoryMetaData.class, MyEmptyMetaData.class, MyIdentifier.class, MyIdentifierRelation.class, MyPersons.class, MyPerson.class, MyNaturalPerson.class, MyLegalPerson.class, MyUnknownMetaData.class, MyUntypedData.class, MySubjects.class, MyCheckSumType.class, MyCheckSum.class, MyEdalLanguage.class, MyEdalDate.class, MyEdalDateRange.class, MyDateEvents.class, MyORCID.class);
        if (!exists.booleanValue()) {
            standardRegistry = new StandardServiceRegistryBuilder().applySettings((Map)config.getProperties()).build();
            metadata = new MetadataSources((ServiceRegistry)standardRegistry);
            for (Class annotatedClass : annotatedHibernateClasses) {
                metadata.addAnnotatedClass(annotatedClass);
            }
            SchemaExport export = new SchemaExport();
            export.setDelimiter(";");
            export.setFormat(true);
            EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
            export.createOnly(targetTypes, metadata.buildMetadata());
            try {
                Metadata meta = metadata.buildMetadata();
                this.setSessionFactory(meta.getSessionFactoryBuilder().build());
            }
            catch (HibernateException e) {
                e.printStackTrace();
                this.logger.error("Lucene Index damaged", (Throwable)e);
                this.logger.info("Lucene Index damaged -> clean up index directory to rebuild the index !");
                System.exit(0);
            }
        } else {
            standardRegistry = new StandardServiceRegistryBuilder().applySettings((Map)config.getProperties()).build();
            metadata = new MetadataSources((ServiceRegistry)standardRegistry);
            for (Class annotatedClass : annotatedHibernateClasses) {
                metadata.addAnnotatedClass(annotatedClass);
            }
            try {
                Metadata meta = metadata.getMetadataBuilder().build();
                this.setSessionFactory(meta.getSessionFactoryBuilder().build());
            }
            catch (HibernateException e) {
                e.printStackTrace();
                this.logger.error("Lucene Index damaged", (Throwable)e);
                this.logger.info("Lucene Index damaged -> clean up index directory to rebuild the index !");
                System.exit(0);
            }
            try {
                SchemaValidator sv = new SchemaValidator();
                sv.validate(metadata.buildMetadata());
                this.getLogger().info("Database Schema Validation : successful");
            }
            catch (HibernateException e) {
                e.printStackTrace();
                this.getLogger().error("Found existing, but not compatible database schema in path '" + configuration.getMountPath() + "' (" + e.getMessage() + ") ");
                this.getLogger().error("Please delete path or specify another mount path !");
                System.exit(0);
            }
        }
        this.getSessionFactory().getStatistics().setStatisticsEnabled(true);
        if (!this.isAutoIndexing()) {
            this.setIndexThread(new IndexWriterThread(this.getSessionFactory(), this.indexDirectory, this.logger));
            this.getIndexThread().start();
        }
    }

    @Override
    public MetaDataImplementation createMetaDataInstance() {
        return new MetaDataImplementation();
    }

    @Override
    public Class<? extends ApprovalServiceProvider> getApprovalServiceProvider() {
        return ApprovalServiceProviderImplementation.class;
    }

    @Override
    public EdalConfiguration getConfiguration() {
        return this.configuration;
    }

    private Connection getConnection() {
        return this.connection;
    }

    public Path getDataPath() {
        return Paths.get(this.getConfiguration().getDataPath().toString(), EDALDB_DBNAME);
    }

    private String getDatabasePassword() {
        return this.databasePassword;
    }

    private String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public IndexWriterThread getIndexThread() {
        return this.indexThread;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public Path getMountPath() {
        return Paths.get(this.getConfiguration().getMountPath().toString(), EDALDB_DBNAME);
    }

    @Override
    public Class<? extends PermissionProvider> getPermissionProvider() {
        return PermissionProviderImplementation.class;
    }

    @Override
    public Class<? extends PrimaryDataDirectory> getPrimaryDataDirectoryProvider() {
        return PrimaryDataDirectoryImplementation.class;
    }

    @Override
    public PrimaryDataEntity reloadPrimaryDataEntityByID(String uuid, long versionNumber) throws EdalException {
        PrimaryDataEntityVersion version;
        Session session = this.getSessionFactory().openSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
        Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
        fileCriteria.where((Expression)builder.and((Expression)builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class), (Expression)builder.equal((Expression)fileRoot.get("ID"), (Object)uuid)));
        PrimaryDataFile file = (PrimaryDataFile)session.createQuery(fileCriteria).uniqueResult();
        if (file == null) {
            PrimaryDataEntityVersion version2;
            CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
            Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
            directoryCriteria.where((Expression)builder.and((Expression)builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class), (Expression)builder.equal((Expression)directoryRoot.get("ID"), (Object)uuid)));
            PrimaryDataDirectory directory = (PrimaryDataDirectory)session.createQuery(directoryCriteria).uniqueResult();
            if (directory == null) {
                session.close();
                throw new EdalException("found no entity with ID '" + uuid + "'");
            }
            try {
                version2 = directory.getVersionByRevisionNumber(versionNumber);
            }
            catch (PrimaryDataEntityVersionException e) {
                session.close();
                throw new EdalException(e.getMessage(), e);
            }
            try {
                directory.switchCurrentVersion(version2);
            }
            catch (PrimaryDataEntityVersionException e) {
                session.close();
                throw new EdalException("unable to switch the version with the number " + versionNumber, e);
            }
            session.close();
            return directory;
        }
        try {
            version = file.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            session.close();
            throw new EdalException(e.getMessage(), e);
        }
        try {
            file.switchCurrentVersion(version);
        }
        catch (PrimaryDataEntityVersionException e) {
            session.close();
            throw new EdalException("unable to switch the version with the number " + versionNumber, e);
        }
        session.close();
        return file;
    }

    @Override
    public Class<? extends PrimaryDataFile> getPrimaryDataFileProvider() {
        return PrimaryDataFileImplementation.class;
    }

    public Session getSession() {
        return this.getSessionFactory().openSession();
    }

    private SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Statistics getStatistics() {
        return this.getSessionFactory().getStatistics();
    }

    private boolean isAutoIndexing() {
        return this.autoIndexing;
    }

    @Override
    public PrimaryDataDirectory mount(List<Class<? extends Principal>> supportedPrincipals) throws PrimaryDataDirectoryException {
        Session session = this.getSessionFactory().openSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery rootDirectoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
        Root rootDirectoryRoot = rootDirectoryCriteria.from(PrimaryDataDirectoryImplementation.class);
        rootDirectoryCriteria.where((Expression)builder.and((Expression)builder.equal(rootDirectoryRoot.type(), PrimaryDataDirectoryImplementation.class), (Expression)builder.isNull((Expression)rootDirectoryRoot.get("parentDirectory"))));
        if (session.createQuery(rootDirectoryCriteria).uniqueResult() == null) {
            session.close();
            DataManager.getImplProv().getLogger().info("Creating new RootDirectory...");
            Session sess = this.getSessionFactory().openSession();
            Transaction transaction = sess.beginTransaction();
            for (Class<? extends Principal> clazz : supportedPrincipals) {
                sess.save((Object)new SupportedPrincipals(clazz));
            }
            transaction.commit();
            sess.close();
            PrimaryDataDirectory newRootDirectory = null;
            try {
                Constructor<? extends PrimaryDataDirectory> constructor = DataManager.getImplProv().getPrimaryDataDirectoryProvider().getConstructor(PrimaryDataDirectory.class, String.class);
                newRootDirectory = constructor.newInstance(null, "/");
            }
            catch (Exception e) {
                throw new PrimaryDataDirectoryException("Can not instantiate the constructor to mount implementation: " + e.getMessage(), e);
            }
            return newRootDirectory;
        }
        CriteriaQuery principalCriteria = builder.createQuery(SupportedPrincipals.class);
        Root principalRoot = principalCriteria.from(SupportedPrincipals.class);
        principalCriteria.select((Selection)principalRoot);
        List privatePrincipals = session.createQuery(principalCriteria).list();
        ArrayList<SupportedPrincipals> publicPrincipals = new ArrayList<SupportedPrincipals>(supportedPrincipals.size());
        for (Class<? extends Principal> clazz : supportedPrincipals) {
            publicPrincipals.add(new SupportedPrincipals(clazz));
        }
        if (!privatePrincipals.containsAll(publicPrincipals)) {
            DataManager.getImplProv().getLogger().warn("Not all principals are supported , please define new list and connect again !");
            throw new PrimaryDataDirectoryException("Not all principals are supported , please define new list and connect again !");
        }
        DataManager.getImplProv().getLogger().info("All principals are supported !");
        DataManager.getImplProv().getLogger().info("Getting existing RootDirectory...");
        PrimaryDataDirectoryImplementation existingRootDirectory = (PrimaryDataDirectoryImplementation)session.createQuery(rootDirectoryCriteria).uniqueResult();
        session.close();
        PrimaryDataDirectoryImplementation existingRootDirectoryOrg = existingRootDirectory;
        return existingRootDirectoryOrg;
    }

    private void setAutoIndexing(boolean autoIndexing) {
        this.autoIndexing = autoIndexing;
    }

    private void setConnection(Connection connection) {
        this.connection = connection;
    }

    private void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    private void setDatabaseUsername(String databaseUsername) {
        this.databaseUsername = databaseUsername;
    }

    private void setIndexThread(IndexWriterThread indexThread) {
        this.indexThread = indexThread;
    }

    private void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void shutdown() {
        if (!this.isAutoIndexing()) {
            this.getIndexThread().waitForFinish();
        }
        try {
            this.getConnection().close();
            this.getSessionFactory().close();
            if (!this.getCacheManager().getStatus().equals((Object)Status.UNINITIALIZED)) {
                this.getCacheManager().close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Class<? extends ServiceProvider> getServiceProvider() {
        return ServiceProviderImplementation.class;
    }

    @Override
    public Class<? extends HttpServiceProvider> getHttpServiceProvider() {
        return HttpServiceProviderImplementation.class;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    private void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

