/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.HttpServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewersImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import java.util.Calendar;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.Session;

public class HttpServiceProviderImplementation
implements HttpServiceProvider {
    @Override
    public PrimaryDataEntity getPrimaryDataEntityByID(String uuid, long versionNumber) throws EdalException {
        PrimaryDataEntityVersion version;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
        Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
        fileCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class)}), builder.equal((Expression)fileRoot.get("ID"), (Object)uuid)});
        PrimaryDataFileImplementation file = (PrimaryDataFileImplementation)session.createQuery(fileCriteria).uniqueResult();
        if (file == null) {
            PrimaryDataEntityVersion version2;
            CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
            Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
            directoryCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class)}), builder.equal((Expression)directoryRoot.get("ID"), (Object)uuid)});
            PrimaryDataDirectoryImplementation directory = (PrimaryDataDirectoryImplementation)session.createQuery(directoryCriteria).uniqueResult();
            if (directory == null) {
                throw new EdalException("found no entity with ID '" + uuid + "'");
            }
            try {
                version2 = directory.getVersionByRevisionNumber(versionNumber);
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException(e.getMessage(), e);
            }
            try {
                directory.switchCurrentVersion(version2);
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException("unable to switch the version with the number " + versionNumber, e);
            }
            List<PublicReference> list = directory.getCurrentVersion().getPublicReferences();
            for (PublicReference publicReference : list) {
                if (!publicReference.isPublic()) continue;
                if (publicReference.getReleaseDate() == null) {
                    return directory;
                }
                if (publicReference.getReleaseDate().after(Calendar.getInstance())) {
                    throw new EdalException(this.isLockedMessage(directory, publicReference));
                }
                return directory;
            }
            throw new EdalException("found no PublicReference for this version of " + directory.getName());
        }
        try {
            version = file.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException(e.getMessage(), e);
        }
        try {
            file.switchCurrentVersion(version);
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException("unable to switch the version with the number " + versionNumber, e);
        }
        List<PublicReference> list = file.getCurrentVersion().getPublicReferences();
        for (PublicReference publicReference : list) {
            if (!publicReference.isPublic()) continue;
            if (publicReference.getReleaseDate() == null) {
                return file;
            }
            if (publicReference.getReleaseDate().after(Calendar.getInstance())) {
                throw new EdalException(this.isLockedMessage(file, publicReference));
            }
            return file;
        }
        throw new EdalException("found no PublicReference for this version of " + file.getName());
    }

    @Override
    public PrimaryDataEntity getPrimaryDataEntityForPersistentIdentifier(String uuid, long versionNumber, PersistentIdentifier persistentIdentifier) throws EdalException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
        Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
        fileCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class)}), builder.equal((Expression)fileRoot.get("ID"), (Object)uuid)});
        PrimaryDataFileImplementation file = (PrimaryDataFileImplementation)session.createQuery(fileCriteria).uniqueResult();
        if (file == null) {
            CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
            Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
            directoryCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class)}), builder.equal((Expression)directoryRoot.get("ID"), (Object)uuid)});
            PrimaryDataDirectoryImplementation directory = (PrimaryDataDirectoryImplementation)session.createQuery(directoryCriteria).uniqueResult();
            if (directory == null) {
                session.close();
                throw new EdalException("no entity with ID '" + uuid + "' found !");
            }
            try {
                PublicReference reference = directory.getVersionByRevisionNumber(versionNumber).getPublicReference(persistentIdentifier);
                if (reference.isPublic()) {
                    if (reference.getReleaseDate() == null) {
                        session.close();
                        return directory;
                    }
                    if (reference.getReleaseDate().after(Calendar.getInstance())) {
                        session.close();
                        throw new EdalException(this.isLockedMessage(directory, reference));
                    }
                    session.close();
                    return directory;
                }
                session.close();
                return this.searchRekursiveForPersistentIdentifiers(directory, versionNumber, persistentIdentifier);
            }
            catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
                session.close();
                return this.searchRekursiveForPersistentIdentifiers(directory, versionNumber, persistentIdentifier);
            }
        }
        try {
            PublicReference reference = file.getVersionByRevisionNumber(versionNumber).getPublicReference(persistentIdentifier);
            if (reference.isPublic()) {
                if (reference.getReleaseDate() == null) {
                    session.close();
                    return file;
                }
                if (reference.getReleaseDate().after(Calendar.getInstance())) {
                    session.close();
                    throw new EdalException(this.isLockedMessage(file, reference));
                }
                session.close();
                return file;
            }
            session.close();
            return this.searchRekursiveForPersistentIdentifiers(file, versionNumber, persistentIdentifier);
        }
        catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
            session.close();
            return this.searchRekursiveForPersistentIdentifiers(file, versionNumber, persistentIdentifier);
        }
    }

    @Override
    public PrimaryDataEntity getPrimaryDataEntityForReviewer(String uuid, long versionNumber, String internalId, int reviewerCode) throws EdalException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery reviewerCriteria = builder.createQuery(ReviewersImplementation.class);
        Root reviewerRoot = reviewerCriteria.from(ReviewersImplementation.class);
        reviewerCriteria.where((Expression)builder.equal((Expression)reviewerRoot.get("hashCode"), (Object)reviewerCode));
        ReviewersImplementation reviewer = (ReviewersImplementation)session.createQuery(reviewerCriteria).uniqueResult();
        if (reviewer != null) {
            CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
            Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
            fileCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class)}), builder.equal((Expression)fileRoot.get("ID"), (Object)uuid)});
            PrimaryDataFileImplementation file = (PrimaryDataFileImplementation)session.createQuery(fileCriteria).uniqueResult();
            if (file != null) {
                try {
                    PrimaryDataEntityVersion version = file.getVersionByRevisionNumber(versionNumber);
                    file.switchCurrentVersion(version);
                    session.close();
                    return file;
                }
                catch (PrimaryDataEntityVersionException e) {
                    session.close();
                    throw new EdalException(e.getMessage(), e);
                }
            }
            CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
            Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
            directoryCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class)}), builder.equal((Expression)directoryRoot.get("ID"), (Object)uuid)});
            PrimaryDataDirectoryImplementation directory = (PrimaryDataDirectoryImplementation)session.createQuery(directoryCriteria).uniqueResult();
            if (directory == null) {
                session.close();
                throw new EdalException("no entity with ID '" + uuid + "' found !");
            }
            try {
                PrimaryDataEntityVersion version = directory.getVersionByRevisionNumber(versionNumber);
                directory.switchCurrentVersion(version);
                session.close();
                return directory;
            }
            catch (PrimaryDataEntityVersionException e) {
                session.close();
                throw new EdalException(e.getMessage(), e);
            }
        }
        session.close();
        throw new EdalException("no reviewer with ID '" + reviewerCode + "' found !");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PrimaryDataEntity getPrimaryDataEntityRekursiveForPersistenIdentifier(PrimaryDataEntity entity, long versionNumber, PersistentIdentifier persistentIdentifier) throws EdalException {
        version = null;
        try {
            version = entity.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException(e.getMessage());
        }
        ready = false;
        parent = null;
        try {
            parent = entity.getParentDirectory();
            if (parent == null) {
                throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
            }
            ** GOTO lbl38
        }
        catch (PrimaryDataDirectoryException v0) {
            throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
        }
lbl-1000:
        // 1 sources

        {
            set = parent.getVersions();
            found = false;
            for (PrimaryDataEntityVersion primaryDataEntityVersion : set) {
                try {
                    if (!primaryDataEntityVersion.getPublicReference(persistentIdentifier).isPublic() || !primaryDataEntityVersion.getRevisionDate().after(version.getRevisionDate())) continue;
                    if (primaryDataEntityVersion.getPublicReference(persistentIdentifier).getReleaseDate() != null && primaryDataEntityVersion.getPublicReference(persistentIdentifier).getReleaseDate().after(Calendar.getInstance())) {
                        throw new EdalException(this.isLockedMessage(parent, primaryDataEntityVersion.getPublicReference(persistentIdentifier)));
                    }
                    found = true;
                }
                catch (PrimaryDataEntityVersionException v1) {
                    DataManager.getImplProv().getLogger().debug("no public reference found for '" + parent + "', trying next");
                }
            }
            if (!found) {
                try {
                    parent = parent.getParentDirectory();
                }
                catch (PrimaryDataDirectoryException v2) {
                    throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
                }
                if (parent != null) continue;
                throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
            }
            ready = true;
            return parent;
lbl38:
            // 2 sources

            ** while (!ready)
        }
lbl39:
        // 1 sources

        return entity;
    }

    private final String isLockedMessage(PrimaryDataEntity primary_data, PublicReference publicReference) {
        return "The access to '" + primary_data.getName() + "' is under embargo until " + publicReference.getReleaseDate().getTime();
    }

    /*
     * Unable to fully structure code
     */
    private PrimaryDataEntity searchRekursiveForPersistentIdentifiers(PrimaryDataEntity entity, long versionNumber, PersistentIdentifier persistentIdentifier) throws EdalException {
        version = null;
        try {
            version = entity.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException(e.getMessage());
        }
        ready = false;
        parent = null;
        try {
            parent = entity.getParentDirectory();
            if (parent == null) {
                throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
            }
            ** GOTO lbl37
        }
        catch (PrimaryDataDirectoryException v0) {
            throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
        }
lbl-1000:
        // 1 sources

        {
            set = parent.getVersions();
            found = false;
            for (PrimaryDataEntityVersion primaryDataEntityVersion : set) {
                try {
                    if (!primaryDataEntityVersion.getPublicReference(persistentIdentifier).isPublic() || !primaryDataEntityVersion.getRevisionDate().after(version.getRevisionDate())) continue;
                    if (primaryDataEntityVersion.getPublicReference(persistentIdentifier).getReleaseDate() != null && primaryDataEntityVersion.getPublicReference(persistentIdentifier).getReleaseDate().after(Calendar.getInstance())) {
                        throw new EdalException(this.isLockedMessage(parent, primaryDataEntityVersion.getPublicReference(persistentIdentifier)));
                    }
                    found = true;
                }
                catch (PrimaryDataEntityVersionException v1) {
                    DataManager.getImplProv().getLogger().debug("no public reference found for '" + parent + "', trying next");
                }
            }
            if (!found) {
                try {
                    parent = parent.getParentDirectory();
                }
                catch (PrimaryDataDirectoryException v2) {
                    throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
                }
                if (parent != null) continue;
                throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
            }
            ready = true;
lbl37:
            // 3 sources

            ** while (!ready)
        }
lbl38:
        // 1 sources

        return entity;
    }
}

