/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyUntypedData;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.indexes.IndexReaderAccessor;

public class IndexWriterThread
extends EdalThread {
    private static final int SLEEP_RUNTIME_FACTOR = 2;
    private static final long MIN_THREAD_SLEEP_MILLISECONDS = 500L;
    private static final long MAX_THREAD_SLEEP_MILLISECONDS = 2000L;
    private SessionFactory sessionFactory;
    private int lastIndexedID = 0;
    private Path indexDirectory;
    private Logger indexWriterThreadLogger = null;
    private Logger implementationProviderLogger = null;
    private boolean requestForReset = false;
    private final ReentrantLock lock = new ReentrantLock(true);
    private CountDownLatch latch = new CountDownLatch(1);

    protected IndexWriterThread(SessionFactory sessionFactory, Path indexDirectory, Logger implementationProviderLogger) {
        this.indexWriterThreadLogger = LogManager.getLogger((String)"IndexWriterThread");
        this.implementationProviderLogger = implementationProviderLogger;
        this.indexDirectory = indexDirectory;
        this.sessionFactory = sessionFactory;
        Session session = this.sessionFactory.openSession();
        SearchFactory searchFactory = Search.getFullTextSession((Session)session).getSearchFactory();
        IndexReaderAccessor readerProvider = searchFactory.getIndexReaderAccessor();
        IndexReader reader = readerProvider.open(new Class[]{MyUntypedData.class});
        try {
            this.implementationProviderLogger.info("Starting IndexWriterThread (current number of documents : " + reader.numDocs() + ")");
            Path path = Paths.get(this.indexDirectory.toString(), "last_id.dat");
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    FileInputStream fis = new FileInputStream(path.toFile());
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    this.lastIndexedID = (Integer)ois.readObject();
                    ois.close();
                }
                catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            this.indexWriterThreadLogger.debug("Last indexed ID : " + this.lastIndexedID);
        }
        finally {
            readerProvider.close(reader);
            session.close();
        }
    }

    private void executeIndexing() {
        if (!this.sessionFactory.isClosed()) {
            Session session = this.sessionFactory.openSession();
            session.setDefaultReadOnly(true);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            int fetchSize = (int)Math.pow(10.0, 4.0);
            fullTextSession.setHibernateFlushMode(FlushMode.MANUAL);
            fullTextSession.setCacheMode(CacheMode.NORMAL);
            Transaction transaction = fullTextSession.beginTransaction();
            long queryStartTime = System.currentTimeMillis();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery criteria = criteriaBuilder.createQuery(MyUntypedData.class);
            Root root = criteria.from(MyUntypedData.class);
            criteria.where((Expression)criteriaBuilder.gt((Expression)root.get("id"), (Number)this.lastIndexedID)).orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("id"))});
            ScrollableResults results = session.createQuery(criteria).setMaxResults(fetchSize).scroll(ScrollMode.FORWARD_ONLY);
            int indexedObjects = 0;
            int flushedObjects = 0;
            long queryTime = System.currentTimeMillis() - queryStartTime;
            long indexStartTime = System.currentTimeMillis();
            while (results.next()) {
                fullTextSession.index(results.get(0));
                if (++indexedObjects % fetchSize != 0) continue;
                try {
                    fullTextSession.flushToIndexes();
                    fullTextSession.clear();
                    flushedObjects += fetchSize;
                }
                catch (Exception exception) {
                    throw new Error("Unable to read/write index files");
                }
                if (((MyUntypedData)results.get(0)).getId() <= this.lastIndexedID) continue;
                this.lastIndexedID = ((MyUntypedData)results.get(0)).getId();
            }
            results.close();
            transaction.commit();
            session.close();
            long indexingTime = System.currentTimeMillis() - indexStartTime;
            SimpleDateFormat df = new SimpleDateFormat("mm:ss:SSS");
            if (indexedObjects > 0 || flushedObjects > 0) {
                this.indexWriterThreadLogger.debug("INDEXING SUCCESSFUL : indexed objects|flushed objects|Index|Query : " + indexedObjects + " | " + flushedObjects + " | " + df.format(new Date(indexingTime)) + " | " + df.format(new Date(queryTime)));
            }
            if (flushedObjects != 0) {
                try {
                    FileOutputStream fos = new FileOutputStream(Paths.get(this.indexDirectory.toString(), "last_id.dat").toFile());
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(this.lastIndexedID);
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(Math.min(Math.max(indexingTime * 2L, 500L), 2000L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (flushedObjects != indexedObjects) {
                this.indexRestObjects();
            }
        }
    }

    private void indexRestObjects() {
        if (!this.sessionFactory.isClosed()) {
            Session session = this.sessionFactory.openSession();
            session.setDefaultReadOnly(true);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            fullTextSession.setHibernateFlushMode(FlushMode.MANUAL);
            fullTextSession.setCacheMode(CacheMode.NORMAL);
            Transaction transaction = fullTextSession.beginTransaction();
            long queryStartTime = System.currentTimeMillis();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery criteria = criteriaBuilder.createQuery(MyUntypedData.class);
            Root root = criteria.from(MyUntypedData.class);
            criteria.where((Expression)criteriaBuilder.gt((Expression)root.get("id"), (Number)this.lastIndexedID)).orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("id"))});
            ScrollableResults results = session.createQuery(criteria).scroll(ScrollMode.FORWARD_ONLY);
            int indexedObjects = 0;
            int flushedObjects = 0;
            long queryTime = System.currentTimeMillis() - queryStartTime;
            long indexStartTime = System.currentTimeMillis();
            while (results.next()) {
                fullTextSession.index(results.get(0));
                if (((MyUntypedData)results.get(0)).getId() > this.lastIndexedID) {
                    this.lastIndexedID = ((MyUntypedData)results.get(0)).getId();
                }
                ++indexedObjects;
                ++flushedObjects;
            }
            try {
                fullTextSession.flushToIndexes();
                fullTextSession.clear();
            }
            catch (Exception exception) {
                throw new Error("Unable to read/write index files");
            }
            results.close();
            transaction.commit();
            session.close();
            long indexingTime = System.currentTimeMillis() - indexStartTime;
            SimpleDateFormat df = new SimpleDateFormat("mm:ss:SSS");
            if (indexedObjects > 0 || flushedObjects > 0) {
                this.indexWriterThreadLogger.debug("INDEXING SUCCESSFUL : indexed objects|flushed objects|Index|Query : " + indexedObjects + " | " + flushedObjects + " | " + df.format(new Date(indexingTime)) + " | " + df.format(new Date(queryTime)));
            }
            if (flushedObjects != 0) {
                try {
                    FileOutputStream fos = new FileOutputStream(Paths.get(this.indexDirectory.toString(), "last_id.dat").toFile());
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(this.lastIndexedID);
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(Math.min(Math.max(indexingTime * 2L, 500L), 2000L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public void run() {
        while (!this.sessionFactory.isClosed()) {
            this.indexWriterThreadLogger.debug("Wait for Reseting the index structure: " + this.requestForReset);
            if (this.requestForReset) continue;
            this.indexWriterThreadLogger.debug("try lock run method");
            this.getLock().lock();
            this.latch = new CountDownLatch(1);
            this.indexWriterThreadLogger.debug("locked run method");
            this.executeIndexing();
            this.indexWriterThreadLogger.debug("unlock run method");
            this.getLock().unlock();
            this.latch.countDown();
        }
    }

    void waitForFinish() {
        long time = System.currentTimeMillis();
        this.indexWriterThreadLogger.debug("Wait for finish current indexing...");
        this.lock.lock();
        this.indexWriterThreadLogger.debug("Got lock for last indexing...");
        this.indexWriterThreadLogger.debug("FINALZE indexing...");
        this.executeIndexing();
        this.sessionFactory.close();
        this.lock.unlock();
        this.indexWriterThreadLogger.debug("Index is finished after waiting : " + (System.currentTimeMillis() - time) + " ms");
        this.indexWriterThreadLogger.debug("unlock Lock");
    }

    protected void resetIndexThread() {
        this.requestForReset = true;
        this.indexWriterThreadLogger.debug("Reseting index structure...");
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.implementationProviderLogger.info("Start reseting index structure...");
        Session session = this.sessionFactory.openSession();
        session.setDefaultReadOnly(true);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        fullTextSession.setHibernateFlushMode(FlushMode.MANUAL);
        fullTextSession.setCacheMode(CacheMode.NORMAL);
        Transaction transaction = fullTextSession.beginTransaction();
        fullTextSession.purgeAll(MyUntypedData.class);
        fullTextSession.flushToIndexes();
        transaction.commit();
        SearchFactory searchFactory = Search.getFullTextSession((Session)session).getSearchFactory();
        IndexReaderAccessor readerProvider = searchFactory.getIndexReaderAccessor();
        IndexReader reader = readerProvider.open(new Class[]{MyUntypedData.class});
        this.indexWriterThreadLogger.debug("Number of docs after index rebuild: " + reader.numDocs());
        readerProvider.close(reader);
        session.close();
        this.lastIndexedID = 0;
        this.requestForReset = false;
        this.indexWriterThreadLogger.debug("Index structure deleted, restart index calculating...");
        this.implementationProviderLogger.info("Index structure deleted, restart index calculating...");
    }
}

