/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.AsynchronList;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import java.util.Calendar;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class ListThread
extends EdalThread {
    private static final String STRING_PARENT_DIRECTORY = "parentDirectory";
    private AsynchronList<PrimaryDataEntity> asynList = new AsynchronList();
    private PrimaryDataDirectory parentDirectory = null;
    private Calendar currentVersionDate = null;
    private Calendar nextVersionDate = null;

    public ListThread(PrimaryDataDirectory parentDirectory, Calendar currentVersionDate, Calendar nextVersionDate) {
        this.parentDirectory = parentDirectory;
        this.currentVersionDate = currentVersionDate;
        this.nextVersionDate = nextVersionDate;
    }

    public AsynchronList<PrimaryDataEntity> getAsynchronList() {
        return this.asynList;
    }

    @Override
    public void run() {
        try {
            Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session.setDefaultReadOnly(true);
            int firstPage = 0;
            int pagesSteps = 1000;
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
            Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
            directoryCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class)}), builder.equal((Expression)directoryRoot.get(STRING_PARENT_DIRECTORY), (Object)this.parentDirectory)});
            Query directoryQuery = session.createQuery(directoryCriteria).setFirstResult(firstPage).setMaxResults(pagesSteps);
            List directories = null;
            while ((directories = directoryQuery.list()).size() > 0) {
                session.clear();
                System.gc();
                block11: for (PrimaryDataDirectoryImplementation directory : directories) {
                    if (this.nextVersionDate == null) {
                        try {
                            directory.switchCurrentVersion(directory.getVersionByRevisionNumber(directory.getVersions().size() - 1));
                            this.asynList.add(directory);
                            this.asynList.notifyNewDataAvailable();
                            continue;
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Can not switch version of '" + this + "' :" + e.getMessage());
                        }
                    }
                    for (PrimaryDataEntityVersion version : directory.getVersions()) {
                        if (!version.getRevisionDate().before(this.nextVersionDate) || !version.getRevisionDate().after(this.currentVersionDate)) continue;
                        try {
                            directory.switchCurrentVersion(version);
                            this.asynList.add(directory);
                            this.asynList.notifyNewDataAvailable();
                            continue block11;
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Can not switch version of '" + this + "' :" + e.getMessage());
                        }
                    }
                }
                if (this.asynList.isStopped()) {
                    DataManager.getImplProv().getLogger().warn("Stopped ListThread !");
                    break;
                }
                directoryQuery.setFirstResult(firstPage += pagesSteps);
            }
            firstPage = 0;
            CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
            Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
            fileCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class)}), builder.equal((Expression)fileRoot.get(STRING_PARENT_DIRECTORY), (Object)this.parentDirectory)});
            Query fileQuery = session.createQuery(fileCriteria).setFirstResult(firstPage).setMaxResults(pagesSteps);
            List files = null;
            while ((files = fileQuery.list()).size() > 0) {
                session.clear();
                System.gc();
                block14: for (PrimaryDataFileImplementation file : files) {
                    if (this.nextVersionDate == null) {
                        try {
                            file.switchCurrentVersion(file.getVersionByRevisionNumber(file.getVersions().size() - 1));
                            this.asynList.add(file);
                            this.asynList.notifyNewDataAvailable();
                            continue;
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Can not switch version of '" + this + "' :" + e.getMessage());
                        }
                    }
                    for (PrimaryDataEntityVersion version : file.getVersions()) {
                        if (!version.getRevisionDate().before(this.nextVersionDate) || !version.getRevisionDate().after(this.currentVersionDate)) continue;
                        try {
                            file.switchCurrentVersion(version);
                            this.asynList.add(file);
                            this.asynList.notifyNewDataAvailable();
                            continue block14;
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Can not switch version of '" + this + "' :" + e.getMessage());
                        }
                    }
                }
                if (this.asynList.isStopped()) {
                    DataManager.getImplProv().getLogger().warn("Stopped ListThread !");
                    break;
                }
                fileQuery.setFirstResult(firstPage += pagesSteps);
            }
            session.clear();
            session.close();
            System.gc();
            this.asynList.notifyNoMoreNewData();
        }
        catch (Exception e) {
            DataManager.getImplProv().getLogger().error("Can not list all PrimaryDataEntities of '" + this.parentDirectory.getName() + "' :" + e.getMessage());
        }
    }
}

