/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ALLPrincipal;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.RootImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.SupportedPrincipals;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPermission;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.PermissionProvider;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.security.auth.Subject;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PermissionProviderImplementation
implements Serializable,
PermissionProvider {
    private static final String CACHE_REGION_ROOT = "query.root";
    private static final String CACHE_REGION_FOR_PRINCIPALS = "query.principal";
    private static final String CACHE_REGION_FOR_PERMISSIONS = "query.permission";
    private static final String STRING_INTERN_VERSION = "internVersion";
    private static final String STRING_INTERN_METHOD = "internMethod";
    private static final String STRING_INTERN_CLASS = "internClass";
    private static final String STRING_INTERN_ID = "internId";
    private static final String STRING_PRINCIPAL = "principal";
    private static final String STRING_TYPE = "type";
    private static final String STRING_NAME = "name";
    private static final long serialVersionUID = -8397868034521482885L;
    private static final InheritableThreadLocal<String> THREAD_LOCAL_ENTITY_ID = new InheritableThreadLocal();

    public static InheritableThreadLocal<String> getThreadlocalentityid() {
        return THREAD_LOCAL_ENTITY_ID;
    }

    @Override
    public List<EdalPermission> findPermissions(Set<Principal> principalList) {
        DataManager.getImplProv().getLogger().debug("Start FindPermission ");
        ArrayList<EdalPermission> permissions = new ArrayList<EdalPermission>();
        List<EdalPermissionImplementation> internalPermissions = null;
        for (Principal principal : principalList) {
            try {
                internalPermissions = this.getEDALPermissionsFromDB(principal.getClass().getSimpleName(), principal.getName());
                for (EdalPermissionImplementation edalperm : internalPermissions) {
                    permissions.add(edalperm.toEdalPermission());
                }
            }
            finally {
                if (!internalPermissions.isEmpty()) break;
            }
        }
        if (permissions.isEmpty()) {
            internalPermissions = this.getEDALPermissionsFromDB(ALLPrincipal.class.getSimpleName(), new ALLPrincipal().getName());
            for (EdalPermissionImplementation edalperm : internalPermissions) {
                permissions.add(edalperm.toEdalPermission());
            }
        }
        return permissions;
    }

    private List<EdalPermissionImplementation> getEDALPermissionsFromDB(String principalType, String principalName) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery principalCriteria = builder.createQuery(PrincipalImplementation.class);
        Root principalRoot = principalCriteria.from(PrincipalImplementation.class);
        principalCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)principalRoot.get(STRING_NAME), (Object)principalName)}), builder.equal((Expression)principalRoot.get(STRING_TYPE), (Object)principalType)});
        PrincipalImplementation principal = (PrincipalImplementation)session.createQuery(principalCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS).uniqueResult();
        CriteriaQuery permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
        Root permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
        permissionCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)permissionRoot.get(STRING_INTERN_ID), PermissionProviderImplementation.getThreadlocalentityid().get())}), builder.equal((Expression)permissionRoot.get(STRING_PRINCIPAL), (Object)principal)});
        List permissions = session.createQuery(permissionCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).list();
        session.close();
        return permissions;
    }

    @Override
    public void grantPermission(String principalType, String principalName, EdalPermission edalPermission) throws PrimaryDataEntityException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery principalCriteria = builder.createQuery(PrincipalImplementation.class);
        Root principalRoot = principalCriteria.from(PrincipalImplementation.class);
        principalCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)principalRoot.get(STRING_NAME), (Object)principalName)}), builder.equal((Expression)principalRoot.get(STRING_TYPE), (Object)principalType)});
        PrincipalImplementation principal = (PrincipalImplementation)session.createQuery(principalCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS).uniqueResult();
        if (principal == null) {
            principal = new PrincipalImplementation(principalName, principalType);
            EdalPermissionImplementation newPermission = new EdalPermissionImplementation(principal, edalPermission.getPrimaryDataEntityID(), edalPermission.getVersion(), GrantableMethods.EdalClasses.valueOf(edalPermission.getActionClass().getSimpleName()), GrantableMethods.Methods.valueOf(edalPermission.getActionMethod().getName()));
            Transaction transaction = session.beginTransaction();
            try {
                session.save((Object)principal);
                session.save((Object)newPermission);
                transaction.commit();
                session.close();
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.rollback();
                    throw new PrimaryDataEntityException("Can not save principal for permission: " + e.getMessage() + "-> rollback");
                }
                throw new PrimaryDataEntityException("Can not save principal for permission: " + e.getMessage());
            }
        }
        CriteriaQuery permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
        Root permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
        permissionCriteria.where(new Predicate[]{builder.and((Expression)builder.and((Expression)builder.and((Expression)builder.and(new Predicate[]{builder.equal((Expression)permissionRoot.get(STRING_INTERN_ID), (Object)edalPermission.getPrimaryDataEntityID())}), (Expression)builder.equal((Expression)permissionRoot.get(STRING_PRINCIPAL), (Object)principal)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_CLASS), (Object)GrantableMethods.EdalClasses.valueOf(edalPermission.getActionClass().getSimpleName()))), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_METHOD), (Object)GrantableMethods.Methods.valueOf(edalPermission.getActionMethod().getName()))), builder.equal((Expression)permissionRoot.get(STRING_INTERN_VERSION), (Object)edalPermission.getVersion())});
        EdalPermissionImplementation permission = (EdalPermissionImplementation)session.createQuery(permissionCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
        if (permission == null) {
            EdalPermissionImplementation newPermission = new EdalPermissionImplementation(principal, edalPermission.getPrimaryDataEntityID(), edalPermission.getVersion(), GrantableMethods.EdalClasses.valueOf(edalPermission.getActionClass().getSimpleName()), GrantableMethods.Methods.valueOf(edalPermission.getActionMethod().getName()));
            Transaction transaction2 = session.beginTransaction();
            try {
                session.save((Object)newPermission);
                transaction2.commit();
                session.close();
            }
            catch (Exception e) {
                if (transaction2 != null) {
                    transaction2.rollback();
                    throw new PrimaryDataEntityException("Can not save permission: " + e.getMessage() + "-> rollback");
                }
                throw new PrimaryDataEntityException("Can not save permission: " + e.getMessage());
            }
        }
    }

    @Override
    public void grantPermission(String principalType, String principalName, PrimaryDataEntity entity) throws PrimaryDataEntityException {
        EdalPermissionImplementation newPermission;
        EdalPermissionImplementation permission;
        Root permissionRoot;
        CriteriaQuery permissionCriteria;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery principalCriteria = builder.createQuery(PrincipalImplementation.class);
        Root principalRoot = principalCriteria.from(PrincipalImplementation.class);
        principalCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)principalRoot.get(STRING_NAME), (Object)principalName)}), builder.equal((Expression)principalRoot.get(STRING_TYPE), (Object)principalType)});
        PrincipalImplementation principal = (PrincipalImplementation)session.createQuery(principalCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS).uniqueResult();
        if (principal == null) {
            principal = new PrincipalImplementation(principalName, principalType);
            Transaction transaction = session.beginTransaction();
            session.save((Object)principal);
            transaction.commit();
        }
        Boolean isAllPrincipal = false;
        if (principal.getType().equals(ALLPrincipal.class.getSimpleName()) && principal.getName().equals(new ALLPrincipal().getName())) {
            isAllPrincipal = true;
        }
        Transaction trans = session.beginTransaction();
        for (GrantableMethods.Methods method : GrantableMethods.ENTITY_METHODS) {
            if (isAllPrincipal.booleanValue() && (method.equals((Object)GrantableMethods.Methods.grantPermission) || method.equals((Object)GrantableMethods.Methods.revokePermission))) continue;
            permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
            permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
            permissionCriteria.where(new Predicate[]{builder.and((Expression)builder.and((Expression)builder.and((Expression)builder.and(new Predicate[]{builder.equal((Expression)permissionRoot.get(STRING_INTERN_ID), (Object)entity.getID())}), (Expression)builder.equal((Expression)permissionRoot.get(STRING_PRINCIPAL), (Object)principal)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_CLASS), (Object)GrantableMethods.EdalClasses.PrimaryDataEntity)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_METHOD), (Object)method)), builder.equal((Expression)permissionRoot.get(STRING_INTERN_VERSION), (Object)entity.getCurrentVersion().getRevision())});
            permission = (EdalPermissionImplementation)session.createQuery(permissionCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
            if (permission != null) continue;
            newPermission = new EdalPermissionImplementation(principal, entity.getID(), entity.getCurrentVersion().getRevision(), GrantableMethods.EdalClasses.PrimaryDataEntity, method);
            session.save((Object)newPermission);
        }
        if (entity.isDirectory()) {
            for (GrantableMethods.Methods method : GrantableMethods.DIRECTORY_METHODS) {
                permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
                permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
                permissionCriteria.where(new Predicate[]{builder.and((Expression)builder.and((Expression)builder.and((Expression)builder.and(new Predicate[]{builder.equal((Expression)permissionRoot.get(STRING_INTERN_ID), (Object)entity.getID())}), (Expression)builder.equal((Expression)permissionRoot.get(STRING_PRINCIPAL), (Object)principal)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_CLASS), (Object)GrantableMethods.EdalClasses.PrimaryDataDirectory)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_METHOD), (Object)method)), builder.equal((Expression)permissionRoot.get(STRING_INTERN_VERSION), (Object)entity.getCurrentVersion().getRevision())});
                permission = (EdalPermissionImplementation)session.createQuery(permissionCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
                if (permission != null) continue;
                newPermission = new EdalPermissionImplementation(principal, entity.getID(), entity.getCurrentVersion().getRevision(), GrantableMethods.EdalClasses.PrimaryDataDirectory, method);
                session.save((Object)newPermission);
            }
        }
        if (!entity.isDirectory()) {
            for (GrantableMethods.Methods method : GrantableMethods.FILE_METHODS) {
                permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
                permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
                permissionCriteria.where(new Predicate[]{builder.and((Expression)builder.and((Expression)builder.and((Expression)builder.and(new Predicate[]{builder.equal((Expression)permissionRoot.get(STRING_INTERN_ID), (Object)entity.getID())}), (Expression)builder.equal((Expression)permissionRoot.get(STRING_PRINCIPAL), (Object)principal)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_CLASS), (Object)GrantableMethods.EdalClasses.PrimaryDataFile)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_METHOD), (Object)method)), builder.equal((Expression)permissionRoot.get(STRING_INTERN_VERSION), (Object)entity.getCurrentVersion().getRevision())});
                permission = (EdalPermissionImplementation)session.createQuery(permissionCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
                if (permission != null) continue;
                newPermission = new EdalPermissionImplementation(principal, entity.getID(), entity.getCurrentVersion().getRevision(), GrantableMethods.EdalClasses.PrimaryDataFile, method);
                session.save((Object)newPermission);
            }
        }
        trans.commit();
        session.close();
    }

    @Override
    public boolean isRoot(Principal principal) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery rootCriteria = builder.createQuery(RootImplementation.class);
        Root rootRoot = rootCriteria.from(RootImplementation.class);
        rootCriteria.select((Selection)rootRoot);
        RootImplementation root = (RootImplementation)session.createQuery(rootCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_ROOT).uniqueResult();
        if (root == null) {
            Transaction transaction = session.beginTransaction();
            session.save((Object)new RootImplementation(principal.getName(), principal.getClass().getSimpleName()));
            transaction.commit();
            session.close();
            return true;
        }
        if (root.getName().equals(principal.getName()) && root.getType().equals(principal.getClass().getSimpleName())) {
            session.close();
            return true;
        }
        session.close();
        return false;
    }

    @Override
    public void revokePermission(String principalType, String principalName, EdalPermission edalPermission) throws PrimaryDataEntityException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery principalCriteria = builder.createQuery(PrincipalImplementation.class);
        Root principalRoot = principalCriteria.from(PrincipalImplementation.class);
        principalCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)principalRoot.get(STRING_NAME), (Object)principalName)}), builder.equal((Expression)principalRoot.get(STRING_TYPE), (Object)principalType)});
        PrincipalImplementation principal = (PrincipalImplementation)session.createQuery(principalCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS).uniqueResult();
        if (principal == null) {
            throw new PrimaryDataEntityException("couldn't found the correct principal to delete permission" + edalPermission.getActionMethod().getName());
        }
        CriteriaQuery permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
        Root permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
        permissionCriteria.where(new Predicate[]{builder.and((Expression)builder.and((Expression)builder.and((Expression)builder.and(new Predicate[]{builder.equal((Expression)permissionRoot.get(STRING_INTERN_ID), (Object)edalPermission.getPrimaryDataEntityID())}), (Expression)builder.equal((Expression)permissionRoot.get(STRING_PRINCIPAL), (Object)principal)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_CLASS), (Object)GrantableMethods.EdalClasses.valueOf(edalPermission.getActionClass().getSimpleName()))), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_METHOD), (Object)GrantableMethods.Methods.valueOf(edalPermission.getActionMethod().getName()))), builder.equal((Expression)permissionRoot.get(STRING_INTERN_VERSION), (Object)edalPermission.getVersion())});
        EdalPermissionImplementation permission = (EdalPermissionImplementation)session.createQuery(permissionCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
        if (permission == null) {
            throw new PrimaryDataEntityException("couldn't found method permission to delete " + edalPermission.getActionMethod().getName());
        }
        Transaction transaction = session.beginTransaction();
        session.delete((Object)permission);
        transaction.commit();
        session.close();
    }

    @Override
    public void revokePermission(String principalType, String principalName, PrimaryDataEntity entity) throws PrimaryDataEntityException {
        Transaction transaction;
        EdalPermissionImplementation permission;
        Root permissionRoot;
        CriteriaQuery permissionCriteria;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery principalCriteria = builder.createQuery(PrincipalImplementation.class);
        Root principalRoot = principalCriteria.from(PrincipalImplementation.class);
        principalCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)principalRoot.get(STRING_NAME), (Object)principalName)}), builder.equal((Expression)principalRoot.get(STRING_TYPE), (Object)principalType)});
        PrincipalImplementation principal = (PrincipalImplementation)session.createQuery(principalCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS).uniqueResult();
        if (principal == null) {
            throw new PrimaryDataEntityException("couldn't found the correct principal to delete permission");
        }
        for (GrantableMethods.Methods method : GrantableMethods.ENTITY_METHODS) {
            permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
            permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
            permissionCriteria.where(new Predicate[]{builder.and((Expression)builder.and((Expression)builder.and((Expression)builder.and(new Predicate[]{builder.equal((Expression)permissionRoot.get(STRING_INTERN_ID), (Object)entity.getID())}), (Expression)builder.equal((Expression)permissionRoot.get(STRING_PRINCIPAL), (Object)principal)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_CLASS), (Object)GrantableMethods.EdalClasses.PrimaryDataEntity)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_METHOD), (Object)method)), builder.equal((Expression)permissionRoot.get(STRING_INTERN_VERSION), (Object)entity.getCurrentVersion().getRevision())});
            permission = (EdalPermissionImplementation)session.createQuery(permissionCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
            if (permission == null) continue;
            transaction = session.beginTransaction();
            session.delete((Object)permission);
            transaction.commit();
        }
        if (entity.isDirectory()) {
            for (GrantableMethods.Methods method : GrantableMethods.DIRECTORY_METHODS) {
                permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
                permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
                permissionCriteria.where(new Predicate[]{builder.and((Expression)builder.and((Expression)builder.and((Expression)builder.and(new Predicate[]{builder.equal((Expression)permissionRoot.get(STRING_INTERN_ID), (Object)entity.getID())}), (Expression)builder.equal((Expression)permissionRoot.get(STRING_PRINCIPAL), (Object)principal)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_CLASS), (Object)GrantableMethods.EdalClasses.PrimaryDataDirectory)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_METHOD), (Object)method)), builder.equal((Expression)permissionRoot.get(STRING_INTERN_VERSION), (Object)entity.getCurrentVersion().getRevision())});
                permission = (EdalPermissionImplementation)session.createQuery(permissionCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
                if (permission == null) continue;
                transaction = session.beginTransaction();
                session.delete((Object)permission);
                transaction.commit();
            }
        }
        if (!entity.isDirectory()) {
            for (GrantableMethods.Methods method : GrantableMethods.FILE_METHODS) {
                permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
                permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
                permissionCriteria.where(new Predicate[]{builder.and((Expression)builder.and((Expression)builder.and((Expression)builder.and(new Predicate[]{builder.equal((Expression)permissionRoot.get(STRING_INTERN_ID), (Object)entity.getID())}), (Expression)builder.equal((Expression)permissionRoot.get(STRING_PRINCIPAL), (Object)principal)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_CLASS), (Object)GrantableMethods.EdalClasses.PrimaryDataFile)), (Expression)builder.equal((Expression)permissionRoot.get(STRING_INTERN_METHOD), (Object)method)), builder.equal((Expression)permissionRoot.get(STRING_INTERN_VERSION), (Object)entity.getCurrentVersion().getRevision())});
                permission = (EdalPermissionImplementation)session.createQuery(permissionCriteria).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
                if (permission == null) continue;
                transaction = session.beginTransaction();
                session.delete((Object)permission);
                transaction.commit();
            }
        }
        session.close();
    }

    @Override
    public void setPermissionObjectID(String id) {
        PermissionProviderImplementation.getThreadlocalentityid().set(id);
    }

    @Override
    public void storeRootUser(Subject subject, InternetAddress address, UUID uuid) throws EdalException {
        Principal principal = null;
        Iterator<Principal> iterator = subject.getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal p;
            principal = p = iterator.next();
        }
        if (principal == null) {
            throw new EdalException("could not get the current principal from the authenticated subject");
        }
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery rootCriteria = builder.createQuery(RootImplementation.class);
        Root rootRoot = rootCriteria.from(RootImplementation.class);
        rootCriteria.select((Selection)rootRoot);
        RootImplementation existingRoot = (RootImplementation)session.createQuery(rootCriteria).setCacheable(true).uniqueResult();
        if (existingRoot != null) {
            session.delete((Object)existingRoot);
        }
        RootImplementation newRoot = new RootImplementation(principal.getName(), principal.getClass().getSimpleName(), address, uuid.toString());
        session.save((Object)newRoot);
        transaction.commit();
        session.close();
    }

    @Override
    public boolean validateRootUser(InternetAddress address, UUID uuid) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery rootCriteria = builder.createQuery(RootImplementation.class);
        Root rootRoot = rootCriteria.from(RootImplementation.class);
        rootCriteria.select((Selection)rootRoot);
        RootImplementation rootUser = (RootImplementation)session.createQuery(rootCriteria).setCacheable(true).uniqueResult();
        if (rootUser.getAddress().equals(address.getAddress()) && rootUser.getUuid().equals(uuid.toString())) {
            rootUser.setValidated(true);
            session.update((Object)rootUser);
            transaction.commit();
            session.close();
            return true;
        }
        transaction.commit();
        session.close();
        return false;
    }

    @Override
    public InternetAddress getCurrentRootUser() throws EdalException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery rootCriteria = builder.createQuery(RootImplementation.class);
        Root rootRoot = rootCriteria.from(RootImplementation.class);
        rootCriteria.select((Selection)rootRoot);
        RootImplementation rootUser = (RootImplementation)session.createQuery(rootCriteria).setCacheable(true).uniqueResult();
        session.close();
        if (rootUser == null) {
            return null;
        }
        InternetAddress address = null;
        try {
            address = new InternetAddress(rootUser.getAddress());
        }
        catch (NullPointerException | AddressException throwable) {
            return null;
        }
        return address;
    }

    @Override
    public boolean isRootValidated(InternetAddress address) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery rootCriteria = builder.createQuery(RootImplementation.class);
        Root rootRoot = rootCriteria.from(RootImplementation.class);
        rootCriteria.select((Selection)rootRoot);
        RootImplementation rootUser = (RootImplementation)session.createQuery(rootCriteria).setCacheable(true).uniqueResult();
        session.close();
        if (rootUser.getAddress().equals(address.getAddress()) && rootUser.isValidated()) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info("root user validated");
            return true;
        }
        return false;
    }

    @Override
    public List<Class<? extends Principal>> getSupportedPrincipals() throws EdalException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery principalCriteria = builder.createQuery(SupportedPrincipals.class);
        Root principalRoot = principalCriteria.from(SupportedPrincipals.class);
        principalCriteria.select((Selection)principalRoot);
        List privatePrincipals = session.createQuery(principalCriteria).list();
        session.close();
        if (privatePrincipals.isEmpty()) {
            throw new EdalException("Unable to load all supported Principals : no type stored");
        }
        ArrayList<Class<? extends Principal>> list = new ArrayList<Class<? extends Principal>>(privatePrincipals.size());
        for (SupportedPrincipals principal : privatePrincipals) {
            try {
                list.add(Class.forName(principal.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new EdalException("Unable to load all supported Principals", e);
            }
        }
        return list;
    }
}

