/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.PublicPermissionCheck;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ListThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.MetaDataImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataEntityVersionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDatePrecision;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDateRange;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Identifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.IdentifierRelation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyDateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyEdalDateRange;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyIdentifierRelation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyLegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyNaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.implementation.MyUntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPermission;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.SortNatural;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.query.NativeQuery;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;

@Entity
@Table(name="ENTITIES")
@DiscriminatorColumn(columnDefinition="char(1)", name="TYPE", discriminatorType=DiscriminatorType.CHAR)
@DiscriminatorValue(value="D")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="PrimaryDataDirectory")
public class PrimaryDataDirectoryImplementation
extends PrimaryDataDirectory {
    private static final String STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION = "Unable to switch to current version";
    private static final String CACHE_REGION_SEARCH_ENTITY = "search.entity";
    private static final String STRING_ID = "ID";
    private static final String STRING_PARENT_DIRECTORY = "parentDirectory";
    private static final String SUPPRESS_UNCHECKED_WARNING = "unchecked";
    private static final int MAX_NUMBER_SEARCH_RESULTS = 1000;
    private SortedSet<PrimaryDataEntityVersionImplementation> versionList;

    protected PrimaryDataDirectoryImplementation() {
    }

    public PrimaryDataDirectoryImplementation(PrimaryDataDirectory path, String name) throws PrimaryDataEntityVersionException, PrimaryDataDirectoryException, MetaDataException {
        super(path, name);
    }

    private PrimaryDataEntity checkIfEntityExists(String name) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.setDefaultReadOnly(true);
        NativeQuery fileQuery = session.createNativeQuery("SELECT DISTINCT t4.ID, t4.TYPE, t4.PARENTDIRECTORY_ID FROM UNTYPEDDATA t1, METADATA_MAP t2, ENTITY_VERSIONS t3, ENTITIES t4 where t3.METADATA_ID=t2.METADATA_ID and t1.id=t2.MYMAP_ID and t2.MYMAP_KEY=15 and t1.STRING=:name and t3.PRIMARYENTITYID=t4.ID and t4.TYPE='F' and t4.PARENTDIRECTORY_ID=:parent", PrimaryDataFileImplementation.class);
        fileQuery.setParameter("name", (Object)name);
        fileQuery.setParameter("parent", (Object)this.getID());
        List files = fileQuery.list();
        for (PrimaryDataFileImplementation file : files) {
            if (!file.getName().equals(name)) continue;
            session.close();
            return file;
        }
        NativeQuery directoryQuery = session.createNativeQuery("SELECT DISTINCT t4.ID, t4.TYPE, t4.PARENTDIRECTORY_ID FROM UNTYPEDDATA t1, METADATA_MAP t2, ENTITY_VERSIONS t3, ENTITIES t4 where t3.METADATA_ID=t2.METADATA_ID and t1.id=t2.MYMAP_ID and t2.MYMAP_KEY=15 and t1.STRING=:name and t3.PRIMARYENTITYID=t4.ID and t4.TYPE='D' and t4.PARENTDIRECTORY_ID=:parent", PrimaryDataDirectoryImplementation.class);
        directoryQuery.setParameter("name", (Object)name);
        directoryQuery.setParameter("parent", (Object)this.getID());
        List dirs = directoryQuery.list();
        for (PrimaryDataDirectoryImplementation dir : dirs) {
            if (!dir.getName().equals(name)) continue;
            session.close();
            return dir;
        }
        session.close();
        return null;
    }

    private boolean checkIfParentEntity(PrimaryDataDirectory parent, PrimaryDataEntity child) {
        if (parent.getID().equals(child.getID())) {
            return true;
        }
        PrimaryDataDirectory grandParent = null;
        try {
            grandParent = child.getParentDirectory();
        }
        catch (PrimaryDataDirectoryException e) {
            e.printStackTrace();
        }
        if (grandParent == null) {
            return false;
        }
        return this.checkIfParentEntity(parent, grandParent);
    }

    private boolean consistsQueryParserSyntax(String query) {
        return query.contains("+") || query.contains("*") || query.contains("?") || query.contains("~") || query.contains(":") || query.contains("{") || query.contains("}") || query.contains("[") || query.contains("]") || query.contains("^") || query.contains("-") || query.contains(" not ") || query.contains(" or ") || query.contains(" and ") || query.contains(" OR ") || query.contains(" AND ") || query.contains(" NOT ");
    }

    @Override
    public boolean existImpl(String path) throws PrimaryDataDirectoryException {
        try {
            return this.checkIfEntityExists(path) != null;
        }
        catch (Exception e) {
            throw new PrimaryDataDirectoryException("unable to check if the Entity exist", e);
        }
    }

    @Override
    @Id
    @Column(columnDefinition="char(40)")
    public String getID() {
        String string;
        PublicPermissionCheck.ajc$cflowCounter$5.inc();
        try {
            string = super.getID();
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$5.dec();
        }
        return string;
    }

    @Override
    @OneToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    public PrimaryDataDirectoryImplementation getParentDirectory() {
        try {
            return (PrimaryDataDirectoryImplementation)super.getParentDirectory();
        }
        catch (PrimaryDataDirectoryException primaryDataDirectoryException) {
            return null;
        }
    }

    @Override
    @Transient
    protected Map<Principal, List<EdalPermission>> getPermissionsImpl() throws PrimaryDataEntityException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EdalPermissionImplementation.class);
        Root root = criteria.from(EdalPermissionImplementation.class);
        criteria.where((Expression)builder.and((Expression)builder.equal((Expression)root.get("internId"), (Object)this.getID()), (Expression)builder.equal((Expression)root.get("internVersion"), (Object)this.getCurrentVersion().getRevision())));
        List privatePerms = session.createQuery(criteria).list();
        HashMap<Principal, List<EdalPermission>> publicMap = new HashMap<Principal, List<EdalPermission>>();
        try {
            for (EdalPermissionImplementation p : privatePerms) {
                if (publicMap.containsKey(p.getPrincipal().toPrincipal())) continue;
                CriteriaQuery tmpCriteria = builder.createQuery(EdalPermissionImplementation.class);
                Root tmpRoot = tmpCriteria.from(EdalPermissionImplementation.class);
                tmpCriteria.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal((Expression)tmpRoot.get("internId"), (Object)this.getID()), (Expression)builder.equal((Expression)tmpRoot.get("internVersion"), (Object)this.getCurrentVersion().getRevision())), (Expression)builder.equal((Expression)tmpRoot.get("principal"), (Object)p.getPrincipal())));
                List userPerms = session.createQuery(tmpCriteria).list();
                ArrayList<EdalPermission> publicPerms = new ArrayList<EdalPermission>(privatePerms.size());
                for (EdalPermissionImplementation permission : userPerms) {
                    publicPerms.add(permission.toEdalPermission());
                }
                publicMap.put(p.getPrincipal().toPrincipal(), publicPerms);
            }
        }
        catch (Exception e) {
            session.close();
            throw new PrimaryDataEntityException("Unable to load permissions !", e);
        }
        session.close();
        return publicMap;
    }

    @Override
    protected PrimaryDataEntity getPrimaryDataEntityImpl(String name) throws PrimaryDataDirectoryException {
        return this.checkIfEntityExists(name);
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="primaryEntityId")
    @SortNatural
    protected SortedSet<PrimaryDataEntityVersionImplementation> getVersionList() {
        return this.versionList;
    }

    @Override
    @Transient
    protected SortedSet<PrimaryDataEntityVersion> getVersionsImpl() {
        if (this.getVersionList() == null) {
            return Collections.synchronizedSortedSet(new TreeSet());
        }
        return Collections.synchronizedSortedSet(new TreeSet<PrimaryDataEntityVersionImplementation>((Collection<PrimaryDataEntityVersionImplementation>)this.getVersionList()));
    }

    @Override
    protected List<PrimaryDataEntity> listPrimaryDataEntitiesImpl(Calendar currentVersionDate, Calendar nextVersionDate) throws PrimaryDataDirectoryException {
        ListThread thread = new ListThread(this, currentVersionDate, nextVersionDate);
        DataManager.getListExecutorService().execute(thread);
        return thread.getAsynchronList();
    }

    @Override
    protected void moveImpl(PrimaryDataDirectory destinationDirectory) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        this.setParentDirectory(destinationDirectory);
        session.update((Object)this);
        transaction.commit();
        session.close();
    }

    private List<MyDataFormat> searchByDataFormat(DataFormat dataFormat, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Query query = null;
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = ftSession.getSearchFactory().buildQueryBuilder().forEntity(MyDataFormat.class).get();
        query = fuzzy ? queryBuilder.keyword().wildcard().onField("mimeType").matching((Object)("*" + dataFormat.getMimeType() + "*")).createQuery() : queryBuilder.keyword().onField("mimeType").matching((Object)dataFormat.getMimeType()).createQuery();
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery(query, new Class[]{MyDataFormat.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private List<MyDataType> searchByDataType(DataType dataType) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Query query = null;
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = ftSession.getSearchFactory().buildQueryBuilder().forEntity(MyDataType.class).get();
        query = queryBuilder.keyword().onField("string").matching((Object)dataType.getDataType().toString().toLowerCase()).createQuery();
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery(query, new Class[]{MyDataType.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private List<MyDateEvents> searchByDateEvents(DateEvents dateEvents) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        ArrayList<MyDateEvents> result = new ArrayList<MyDateEvents>();
        Set<EdalDate> set = dateEvents.getSet();
        if (set.size() > 1) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().warn("no DateEvents with multiple BasicDates allowed");
        } else if (set.size() == 1) {
            for (EdalDate edalDate : set) {
                List idlist;
                NativeQuery metaDataQuery;
                List<MyEdalDate> list;
                if (edalDate instanceof EdalDateRange) {
                    list = this.searchByEDALDateRange((EdalDateRange)edalDate);
                    metaDataQuery = session.createSQLQuery("select D.UNTYPEDDATA_ID from UNTYPEDDATA_MYEDALDATE D where D.SET_ID in (:list)");
                    metaDataQuery.setParameterList("list", list);
                    idlist = metaDataQuery.list();
                    for (Integer integer : idlist) {
                        result.add((MyDateEvents)session.get(MyDateEvents.class, (Serializable)integer));
                    }
                    continue;
                }
                if (!(edalDate instanceof EdalDate)) continue;
                list = this.searchByEDALDate(edalDate);
                metaDataQuery = session.createSQLQuery("select D.UNTYPEDDATA_ID from UNTYPEDDATA_MYEDALDATE D where D.SET_ID in (:list)");
                metaDataQuery.setParameterList("list", list);
                idlist = metaDataQuery.list();
                for (Integer integer : idlist) {
                    result.add((MyDateEvents)session.get(MyDateEvents.class, (Serializable)integer));
                }
            }
        }
        session.close();
        return result;
    }

    @Override
    protected List<PrimaryDataEntity> searchByDublinCoreElementImpl(EnumDublinCoreElements element, UntypedData data, boolean fuzzy, boolean recursiveIntoSubdirectories) throws PrimaryDataDirectoryException {
        long startTime = System.currentTimeMillis();
        List<Object> datatypeList = new ArrayList();
        try {
            if (data.getClass().equals(UntypedData.class)) {
                datatypeList = this.searchByUntypedData(data, fuzzy);
            } else if (data.getClass().equals(NaturalPerson.class)) {
                datatypeList = this.searchByNaturalPerson((NaturalPerson)data, fuzzy);
            } else if (data.getClass().equals(NaturalPerson.class)) {
                datatypeList = this.searchByLegalPerson((LegalPerson)data, fuzzy);
            } else if (data.getClass().equals(Identifier.class)) {
                datatypeList = this.searchByIdentifier((Identifier)data, fuzzy);
            } else if (data.getClass().equals(DataType.class)) {
                datatypeList = this.searchByDataType((DataType)data);
            } else if (data.getClass().equals(DataFormat.class)) {
                datatypeList = this.searchByDataFormat((DataFormat)data, fuzzy);
            } else if (data.getClass().equals(DateEvents.class)) {
                datatypeList = this.searchByDateEvents((DateEvents)data);
            } else if (data.getClass().equals(IdentifierRelation.class)) {
                datatypeList = this.searchByIdentifierRelation((IdentifierRelation)data, fuzzy);
            }
        }
        catch (ParseException e) {
            throw new PrimaryDataDirectoryException("Unable to find the UntypedData values", e);
        }
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().debug("Zeit (Search " + data.getClass().getSimpleName() + "): " + (System.currentTimeMillis() - startTime) + " msec");
        if (datatypeList.isEmpty()) {
            return new ArrayList<PrimaryDataEntity>();
        }
        if (datatypeList.size() > 1000) {
            throw new PrimaryDataDirectoryException("find to much result please repeat query with more details");
        }
        ArrayList<Integer> datatypeIDList = new ArrayList<Integer>(datatypeList.size());
        for (MyUntypedData myUntypedData : datatypeList) {
            datatypeIDList.add(myUntypedData.getId());
        }
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        NativeQuery versionSQLQuery = session.createSQLQuery("SELECT DISTINCT v.ID FROM ENTITY_VERSIONS v , metadata_map m , TABLE(id BIGINT=(:list))virtual1 WHERE m.mymap_key=:key AND m.mymap_id=virtual1.id AND v.METADATA_ID =m.metadata_id ");
        versionSQLQuery.setParameterList("list", datatypeIDList);
        versionSQLQuery.setParameter("key", (Object)element.ordinal());
        List versionIDList = versionSQLQuery.list();
        HashSet<PrimaryDataEntity> resultSet = new HashSet<PrimaryDataEntity>();
        long startEntityQuery = System.currentTimeMillis();
        if (!recursiveIntoSubdirectories) {
            for (Integer version : versionIDList) {
                PrimaryDataEntityVersionImplementation currentVersion = (PrimaryDataEntityVersionImplementation)session.get(PrimaryDataEntityVersionImplementation.class, (Serializable)version);
                CriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
                Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
                fileCriteria.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class), (Expression)builder.equal((Expression)fileRoot.get(STRING_ID), (Object)currentVersion.getPrimaryEntityId())), (Expression)builder.equal((Expression)fileRoot.get(STRING_PARENT_DIRECTORY), (Object)this)));
                PrimaryDataFileImplementation primaryDataFile = (PrimaryDataFileImplementation)session.createQuery(fileCriteria).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY).uniqueResult();
                CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
                Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
                directoryCriteria.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class), (Expression)builder.equal((Expression)directoryRoot.get(STRING_ID), (Object)currentVersion.getPrimaryEntityId())), (Expression)builder.equal((Expression)directoryRoot.get(STRING_PARENT_DIRECTORY), (Object)this)));
                PrimaryDataDirectoryImplementation primaryDataDirectory = (PrimaryDataDirectoryImplementation)session.createQuery(directoryCriteria).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY).uniqueResult();
                if (primaryDataFile != null) {
                    try {
                        if (!primaryDataFile.getCurrentVersion().isDeleted()) {
                            primaryDataFile.switchCurrentVersion(currentVersion);
                        }
                    }
                    catch (PrimaryDataEntityVersionException e) {
                        throw new PrimaryDataDirectoryException(STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION, e);
                    }
                    resultSet.add(primaryDataFile);
                    continue;
                }
                if (primaryDataDirectory == null) continue;
                try {
                    if (!primaryDataDirectory.getCurrentVersion().isDeleted()) {
                        primaryDataDirectory.switchCurrentVersion(currentVersion);
                    }
                }
                catch (PrimaryDataEntityVersionException e) {
                    throw new PrimaryDataDirectoryException(STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION, e);
                }
                resultSet.add(primaryDataDirectory);
            }
        } else {
            ArrayList<PrimaryDataEntityVersionImplementation> maybeInSubDirectoriesList = new ArrayList<PrimaryDataEntityVersionImplementation>();
            for (Integer n : versionIDList) {
                PrimaryDataEntityVersionImplementation currentVersion = (PrimaryDataEntityVersionImplementation)session.get(PrimaryDataEntityVersionImplementation.class, (Serializable)n);
                try {
                    CriteriaBuilder builder;
                    if (!((UntypedData)currentVersion.getMetaData().getElementValue(EnumDublinCoreElements.TYPE)).toString().equals(MetaData.DIRECTORY.toString())) {
                        builder = session.getCriteriaBuilder();
                        CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
                        Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
                        fileCriteria.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class), (Expression)builder.equal((Expression)fileRoot.get(STRING_ID), (Object)currentVersion.getPrimaryEntityId())), (Expression)builder.equal((Expression)fileRoot.get(STRING_PARENT_DIRECTORY), (Object)this)));
                        PrimaryDataFileImplementation pdf = (PrimaryDataFileImplementation)session.createQuery(fileCriteria).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY).uniqueResult();
                        if (pdf != null) {
                            try {
                                if (!pdf.getCurrentVersion().isDeleted()) {
                                    pdf.switchCurrentVersion(currentVersion);
                                }
                            }
                            catch (PrimaryDataEntityVersionException e) {
                                throw new PrimaryDataDirectoryException("Unable to switch version", e);
                            }
                            resultSet.add(pdf);
                            continue;
                        }
                        maybeInSubDirectoriesList.add(currentVersion);
                        continue;
                    }
                    builder = session.getCriteriaBuilder();
                    CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
                    Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
                    directoryCriteria.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class), (Expression)builder.equal((Expression)directoryRoot.get(STRING_ID), (Object)currentVersion.getPrimaryEntityId())), (Expression)builder.equal((Expression)directoryRoot.get(STRING_PARENT_DIRECTORY), (Object)this)));
                    PrimaryDataDirectoryImplementation pdd = (PrimaryDataDirectoryImplementation)session.createQuery(directoryCriteria).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY).uniqueResult();
                    if (pdd != null) {
                        try {
                            if (!pdd.getCurrentVersion().isDeleted()) {
                                pdd.switchCurrentVersion(currentVersion);
                            }
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Unable to switch version", e);
                        }
                        resultSet.add(pdd);
                        continue;
                    }
                    maybeInSubDirectoriesList.add(currentVersion);
                }
                catch (MetaDataException e) {
                    throw new PrimaryDataDirectoryException("Unable to check object type", e);
                }
            }
            session.close();
            for (PrimaryDataEntityVersionImplementation primaryDataEntityVersionImplementation : maybeInSubDirectoriesList) {
                PrimaryDataEntity entity = this.searchIntoSubdirectories(this, primaryDataEntityVersionImplementation);
                if (entity == null) continue;
                if (entity.isDirectory()) {
                    if (((PrimaryDataDirectory)entity).getID().equals(this.getID())) continue;
                    resultSet.add(entity);
                    continue;
                }
                resultSet.add(entity);
            }
        }
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().debug("Zeit (Search Entity)    : " + (System.currentTimeMillis() - startEntityQuery) + " msec");
        ArrayList<PrimaryDataEntity> results = new ArrayList<PrimaryDataEntity>(resultSet);
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info("Zeit (Search by Element): " + (System.currentTimeMillis() - startTime) + " msec");
        if (session.isOpen()) {
            session.close();
        }
        return results;
    }

    private List<MyEdalDate> searchByEDALDate(EdalDate edalDate) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery dataCriteria = builder.createQuery(MyEdalDate.class);
        Root rootDate = dataCriteria.from(MyEdalDate.class);
        int precission = edalDate.getStartPrecision().ordinal();
        Calendar date = edalDate.getStartDate();
        if (precission == EdalDatePrecision.CENTURY.ordinal()) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().warn("no Dates with CENTURY Precission allowed");
            return new ArrayList<MyEdalDate>();
        }
        if (precission >= EdalDatePrecision.DECADE.ordinal()) {
            Expression yearExpression = builder.function("YEAR", String.class, new Expression[]{rootDate.get("startData")});
            dataCriteria.where((Expression)builder.equal(builder.substring(yearExpression, 1, 3), (Object)Integer.toString(date.get(1)).substring(0, 3)));
            if (precission >= EdalDatePrecision.YEAR.ordinal()) {
                dataCriteria.where((Expression)builder.equal(yearExpression, (Object)date.get(1)));
                if (precission >= EdalDatePrecision.MONTH.ordinal()) {
                    Expression monthExpression = builder.function("MONTH", String.class, new Expression[]{rootDate.get("startData")});
                    dataCriteria.where((Expression)builder.equal(monthExpression, (Object)(date.get(2) + 1)));
                    if (precission >= EdalDatePrecision.DAY.ordinal()) {
                        Expression dayExpression = builder.function("DAY", String.class, new Expression[]{rootDate.get("startData")});
                        dataCriteria.where((Expression)builder.equal(dayExpression, (Object)date.get(5)));
                        if (precission >= EdalDatePrecision.HOUR.ordinal()) {
                            Expression hourExpression = builder.function("HOUR", String.class, new Expression[]{rootDate.get("startData")});
                            dataCriteria.where((Expression)builder.equal(hourExpression, (Object)date.get(11)));
                            if (precission >= EdalDatePrecision.MINUTE.ordinal()) {
                                Expression minuteExpression = builder.function("MINUTE", String.class, new Expression[]{rootDate.get("startData")});
                                dataCriteria.where((Expression)builder.equal(minuteExpression, (Object)date.get(12)));
                                if (precission >= EdalDatePrecision.SECOND.ordinal()) {
                                    Expression secondExpression = builder.function("SECOND", String.class, new Expression[]{rootDate.get("startData")});
                                    dataCriteria.where((Expression)builder.equal(secondExpression, (Object)date.get(13)));
                                    if (precission >= EdalDatePrecision.MILLISECOND.ordinal()) {
                                        Expression millisecondExpression = builder.function("MILLISECOND", String.class, new Expression[]{rootDate.get("startData")});
                                        dataCriteria.where((Expression)builder.equal(millisecondExpression, (Object)date.get(14)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        List result = session.createQuery(dataCriteria).list();
        session.close();
        return result;
    }

    private List<MyEdalDateRange> searchByEDALDateRange(EdalDateRange edalDateRange) {
        Expression millisecondExpression;
        Expression secondExpression;
        Expression minuteExpression;
        Expression hourExpression;
        Expression dayExpression;
        Expression monthExpression;
        Expression yearExpression;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery dataCriteria = builder.createQuery(MyEdalDateRange.class);
        Root rootDate = dataCriteria.from(MyEdalDateRange.class);
        int precissionStart = edalDateRange.getStartPrecision().ordinal();
        Calendar dateStart = edalDateRange.getStartDate();
        int precissionEnd = edalDateRange.getEndPrecision().ordinal();
        Calendar dateEnd = edalDateRange.getEndDate();
        if (precissionStart == EdalDatePrecision.CENTURY.ordinal() || precissionEnd == EdalDatePrecision.CENTURY.ordinal()) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().warn("no DateRanges with CENTURY Precission allowed");
            return new ArrayList<MyEdalDateRange>();
        }
        if (precissionStart >= EdalDatePrecision.DECADE.ordinal()) {
            yearExpression = builder.function("YEAR", String.class, new Expression[]{rootDate.get("startData")});
            dataCriteria.where((Expression)builder.equal(builder.substring(yearExpression, 1, 3), (Object)Integer.toString(dateStart.get(1)).substring(0, 3)));
            if (precissionStart >= EdalDatePrecision.YEAR.ordinal()) {
                dataCriteria.where((Expression)builder.equal(yearExpression, (Object)dateStart.get(1)));
                if (precissionStart >= EdalDatePrecision.MONTH.ordinal()) {
                    monthExpression = builder.function("MONTH", String.class, new Expression[]{rootDate.get("startData")});
                    dataCriteria.where((Expression)builder.equal(monthExpression, (Object)(dateStart.get(2) + 1)));
                    if (precissionStart >= EdalDatePrecision.DAY.ordinal()) {
                        dayExpression = builder.function("DAY", String.class, new Expression[]{rootDate.get("startData")});
                        dataCriteria.where((Expression)builder.equal(dayExpression, (Object)dateStart.get(5)));
                        if (precissionStart >= EdalDatePrecision.HOUR.ordinal()) {
                            hourExpression = builder.function("HOUR", String.class, new Expression[]{rootDate.get("startData")});
                            dataCriteria.where((Expression)builder.equal(hourExpression, (Object)dateStart.get(11)));
                            if (precissionStart >= EdalDatePrecision.MINUTE.ordinal()) {
                                minuteExpression = builder.function("MINUTE", String.class, new Expression[]{rootDate.get("startData")});
                                dataCriteria.where((Expression)builder.equal(minuteExpression, (Object)dateStart.get(12)));
                                if (precissionStart >= EdalDatePrecision.SECOND.ordinal()) {
                                    secondExpression = builder.function("SECOND", String.class, new Expression[]{rootDate.get("startData")});
                                    dataCriteria.where((Expression)builder.equal(secondExpression, (Object)dateStart.get(13)));
                                    if (precissionStart >= EdalDatePrecision.MILLISECOND.ordinal()) {
                                        millisecondExpression = builder.function("MILLISECOND", String.class, new Expression[]{rootDate.get("startData")});
                                        dataCriteria.where((Expression)builder.equal(millisecondExpression, (Object)dateStart.get(14)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (precissionEnd >= EdalDatePrecision.DECADE.ordinal()) {
            yearExpression = builder.function("YEAR", String.class, new Expression[]{rootDate.get("endDate")});
            dataCriteria.where((Expression)builder.equal(builder.substring(yearExpression, 1, 3), (Object)Integer.toString(dateEnd.get(1)).substring(0, 3)));
            if (precissionEnd >= EdalDatePrecision.YEAR.ordinal()) {
                dataCriteria.where((Expression)builder.equal(yearExpression, (Object)dateEnd.get(1)));
                if (precissionEnd >= EdalDatePrecision.MONTH.ordinal()) {
                    monthExpression = builder.function("MONTH", String.class, new Expression[]{rootDate.get("endDate")});
                    dataCriteria.where((Expression)builder.equal(monthExpression, (Object)(dateEnd.get(2) + 1)));
                    if (precissionEnd >= EdalDatePrecision.DAY.ordinal()) {
                        dayExpression = builder.function("DAY", String.class, new Expression[]{rootDate.get("endDate")});
                        dataCriteria.where((Expression)builder.equal(dayExpression, (Object)dateEnd.get(5)));
                        if (precissionEnd >= EdalDatePrecision.HOUR.ordinal()) {
                            hourExpression = builder.function("HOUR", String.class, new Expression[]{rootDate.get("endDate")});
                            dataCriteria.where((Expression)builder.equal(hourExpression, (Object)dateEnd.get(11)));
                            if (precissionEnd >= EdalDatePrecision.MINUTE.ordinal()) {
                                minuteExpression = builder.function("MINUTE", String.class, new Expression[]{rootDate.get("endDate")});
                                dataCriteria.where((Expression)builder.equal(minuteExpression, (Object)dateEnd.get(12)));
                                if (precissionEnd >= EdalDatePrecision.SECOND.ordinal()) {
                                    secondExpression = builder.function("SECOND", String.class, new Expression[]{rootDate.get("endDate")});
                                    dataCriteria.where((Expression)builder.equal(secondExpression, (Object)dateEnd.get(13)));
                                    if (precissionEnd >= EdalDatePrecision.MILLISECOND.ordinal()) {
                                        millisecondExpression = builder.function("MILLISECOND", String.class, new Expression[]{rootDate.get("endDate")});
                                        dataCriteria.where((Expression)builder.equal(millisecondExpression, (Object)dateEnd.get(14)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        List result = session.createQuery(dataCriteria).list();
        session.close();
        return result;
    }

    private List<MyIdentifier> searchByIdentifier(Identifier identifier, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Query query = null;
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = ftSession.getSearchFactory().buildQueryBuilder().forEntity(MyIdentifier.class).get();
        query = fuzzy ? queryBuilder.keyword().wildcard().onField("identifier").matching((Object)("*" + identifier.getID() + "*")).createQuery() : queryBuilder.keyword().onField("identifier").matching((Object)identifier.getID()).createQuery();
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery(query, new Class[]{MyIdentifier.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private List<MyIdentifierRelation> searchByIdentifierRelation(IdentifierRelation identifierRelation, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        ArrayList<MyIdentifierRelation> result = new ArrayList<MyIdentifierRelation>();
        if (identifierRelation.getRelations().size() > 1) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().warn("only IdentifierRelations with only one Identifier allowed");
        } else if (identifierRelation.getRelations().size() == 1) {
            Identifier id = null;
            Iterator<Identifier> iterator = identifierRelation.iterator();
            while (iterator.hasNext()) {
                Identifier identifier;
                id = identifier = iterator.next();
            }
            List<MyIdentifier> myIdentifierList = this.searchByIdentifier(id, fuzzy);
            if (!myIdentifierList.isEmpty()) {
                org.hibernate.query.Query metaDataQuery = session.createQuery("select D.id from MyIdentifierRelation D join D.relations V where V in (:list)");
                metaDataQuery.setParameterList("list", myIdentifierList);
                List idlist = metaDataQuery.list();
                for (Integer integer : idlist) {
                    result.add((MyIdentifierRelation)session.get(MyIdentifierRelation.class, (Serializable)integer));
                }
            }
        }
        return result;
    }

    @Override
    protected List<? extends PrimaryDataEntity> searchByKeywordImpl(String keyword, boolean fuzzy, boolean recursiveIntoSubdirectories) throws PrimaryDataDirectoryException {
        long startTime = System.currentTimeMillis();
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Query query = null;
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = ftSession.getSearchFactory().buildQueryBuilder().forEntity(MyUntypedData.class).get();
        query = fuzzy ? (this.consistsQueryParserSyntax(keyword) ? queryBuilder.keyword().wildcard().onFields(new String[]{"string", "givenName", "sureName", "country", "zip", "addressLine", "id", "identifier", "mimeType"}).matching((Object)keyword).createQuery() : queryBuilder.keyword().wildcard().onFields(new String[]{"string", "givenName", "sureName", "country", "zip", "addressLine", "id", "identifier", "mimeType"}).matching((Object)("*" + keyword + "*")).createQuery()) : queryBuilder.keyword().wildcard().onFields(new String[]{"string", "givenName", "sureName", "country", "zip", "addressLine", "id", "identifier", "mimeType"}).matching((Object)keyword).createQuery();
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery(query, new Class[]{UntypedData.class});
        List datatypeList = hibernateQuery.list();
        session.close();
        if (datatypeList.isEmpty()) {
            return new ArrayList();
        }
        if (datatypeList.size() > 1000) {
            throw new PrimaryDataDirectoryException("find to much result please repeat query with more details");
        }
        ArrayList<Integer> datatypeIDList = new ArrayList<Integer>(datatypeList.size());
        for (MyUntypedData myUntypedData : datatypeList) {
            datatypeIDList.add(myUntypedData.getId());
        }
        Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        NativeQuery versionSQLQuery = session2.createSQLQuery("SELECT DISTINCT v.ID FROM ENTITY_VERSIONS v , metadata_map m , TABLE(id BIGINT=(:list))virtual1 WHERE m.mymap_id=virtual1.id AND v.METADATA_ID =m.metadata_id ");
        versionSQLQuery.setParameterList("list", datatypeIDList);
        List versionIDList = versionSQLQuery.list();
        HashSet<PrimaryDataEntity> resultSet = new HashSet<PrimaryDataEntity>();
        long startEntityQuery = System.currentTimeMillis();
        if (!recursiveIntoSubdirectories) {
            for (Integer version : versionIDList) {
                PrimaryDataEntityVersionImplementation currentVersion = (PrimaryDataEntityVersionImplementation)session2.get(PrimaryDataEntityVersionImplementation.class, (Serializable)version);
                CriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
                Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
                fileCriteria.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class), (Expression)builder.equal((Expression)fileRoot.get(STRING_ID), (Object)currentVersion.getPrimaryEntityId())), (Expression)builder.equal((Expression)fileRoot.get(STRING_PARENT_DIRECTORY), (Object)this)));
                PrimaryDataFileImplementation primaryDataFile = (PrimaryDataFileImplementation)session.createQuery(fileCriteria).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY).uniqueResult();
                CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
                Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
                directoryCriteria.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class), (Expression)builder.equal((Expression)directoryRoot.get(STRING_ID), (Object)currentVersion.getPrimaryEntityId())), (Expression)builder.equal((Expression)directoryRoot.get(STRING_PARENT_DIRECTORY), (Object)this)));
                PrimaryDataDirectoryImplementation primaryDataDirectory = (PrimaryDataDirectoryImplementation)session.createQuery(directoryCriteria).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY).uniqueResult();
                if (primaryDataFile != null) {
                    try {
                        if (!primaryDataFile.getCurrentVersion().isDeleted()) {
                            primaryDataFile.switchCurrentVersion(currentVersion);
                        }
                    }
                    catch (PrimaryDataEntityVersionException e) {
                        throw new PrimaryDataDirectoryException(STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION, e);
                    }
                    resultSet.add(primaryDataFile);
                    continue;
                }
                if (primaryDataDirectory == null) continue;
                try {
                    if (!primaryDataDirectory.getCurrentVersion().isDeleted()) {
                        primaryDataDirectory.switchCurrentVersion(currentVersion);
                    }
                }
                catch (PrimaryDataEntityVersionException e) {
                    throw new PrimaryDataDirectoryException(STRING_UNABLE_TO_SWITCH_TO_CURRENT_VERSION, e);
                }
                resultSet.add(primaryDataDirectory);
            }
        } else {
            ArrayList<PrimaryDataEntityVersionImplementation> maybeInSubDirectoriesList = new ArrayList<PrimaryDataEntityVersionImplementation>();
            for (Integer n : versionIDList) {
                PrimaryDataEntityVersionImplementation currentVersion = (PrimaryDataEntityVersionImplementation)session2.get(PrimaryDataEntityVersionImplementation.class, (Serializable)n);
                try {
                    CriteriaBuilder builder;
                    if (!((UntypedData)currentVersion.getMetaData().getElementValue(EnumDublinCoreElements.TYPE)).toString().equals(MetaData.DIRECTORY.toString())) {
                        builder = session.getCriteriaBuilder();
                        CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
                        Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
                        fileCriteria.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class), (Expression)builder.equal((Expression)fileRoot.get(STRING_ID), (Object)currentVersion.getPrimaryEntityId())), (Expression)builder.equal((Expression)fileRoot.get(STRING_PARENT_DIRECTORY), (Object)this)));
                        PrimaryDataFileImplementation pdf = (PrimaryDataFileImplementation)session.createQuery(fileCriteria).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY).uniqueResult();
                        if (pdf != null) {
                            try {
                                if (!pdf.getCurrentVersion().isDeleted()) {
                                    pdf.switchCurrentVersion(currentVersion);
                                }
                            }
                            catch (PrimaryDataEntityVersionException e) {
                                throw new PrimaryDataDirectoryException("Unable to switch version", e);
                            }
                            resultSet.add(pdf);
                            continue;
                        }
                        maybeInSubDirectoriesList.add(currentVersion);
                        continue;
                    }
                    builder = session.getCriteriaBuilder();
                    CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
                    Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
                    directoryCriteria.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class), (Expression)builder.equal((Expression)directoryRoot.get(STRING_ID), (Object)currentVersion.getPrimaryEntityId())), (Expression)builder.equal((Expression)directoryRoot.get(STRING_PARENT_DIRECTORY), (Object)this)));
                    PrimaryDataDirectoryImplementation pdd = (PrimaryDataDirectoryImplementation)session.createQuery(directoryCriteria).setCacheable(false).setCacheRegion(CACHE_REGION_SEARCH_ENTITY).uniqueResult();
                    if (pdd != null) {
                        try {
                            if (!pdd.getCurrentVersion().isDeleted()) {
                                pdd.switchCurrentVersion(currentVersion);
                            }
                        }
                        catch (PrimaryDataEntityVersionException e) {
                            throw new PrimaryDataDirectoryException("Unable to switch version", e);
                        }
                        resultSet.add(pdd);
                        continue;
                    }
                    maybeInSubDirectoriesList.add(currentVersion);
                }
                catch (MetaDataException e) {
                    throw new PrimaryDataDirectoryException("Unable to check object type", e);
                }
            }
            session2.close();
            for (PrimaryDataEntityVersionImplementation primaryDataEntityVersionImplementation : maybeInSubDirectoriesList) {
                PrimaryDataEntity entity = this.searchIntoSubdirectories(this, primaryDataEntityVersionImplementation);
                if (entity == null) continue;
                if (entity.isDirectory()) {
                    if (((PrimaryDataDirectory)entity).getID().equals(this.getID())) continue;
                    resultSet.add(entity);
                    continue;
                }
                resultSet.add(entity);
            }
        }
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().debug("Zeit (Search Entity)    : " + (System.currentTimeMillis() - startEntityQuery) + " msec");
        ArrayList results = new ArrayList(resultSet);
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info("Zeit (Search by keyword): " + (System.currentTimeMillis() - startTime) + " msec");
        return results;
    }

    private List<MyLegalPerson> searchByLegalPerson(LegalPerson legalPerson, boolean fuzzy) throws ParseException {
        Query queryB;
        Query queryA;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = ftSession.getSearchFactory().buildQueryBuilder().forEntity(MyLegalPerson.class).get();
        Query combinedQuery = null;
        if (fuzzy) {
            queryA = queryBuilder.keyword().wildcard().onField("legalName").matching((Object)("*" + legalPerson.getLegalName() + "*")).createQuery();
            queryB = queryBuilder.keyword().wildcard().onField("addressLine").matching((Object)("*" + legalPerson.getAddressLine() + "*")).createQuery();
            Query queryC = queryBuilder.keyword().wildcard().onField("zip").matching((Object)("*" + legalPerson.getZip() + "*")).createQuery();
            Query queryD = queryBuilder.keyword().wildcard().onField("country").matching((Object)("*" + legalPerson.getCountry() + "*")).createQuery();
            combinedQuery = queryBuilder.bool().should(queryA).should(queryB).should(queryC).should(queryD).createQuery();
        } else {
            queryA = queryBuilder.keyword().wildcard().onField("legalName").matching((Object)legalPerson.getLegalName()).createQuery();
            queryB = queryBuilder.keyword().wildcard().onField("addressLine").matching((Object)legalPerson.getAddressLine()).createQuery();
            Query queryC = queryBuilder.keyword().wildcard().onField("zip").matching((Object)legalPerson.getZip()).createQuery();
            Query queryD = queryBuilder.keyword().wildcard().onField("country").matching((Object)legalPerson.getCountry()).createQuery();
            combinedQuery = queryBuilder.bool().should(queryA).should(queryB).should(queryC).should(queryD).createQuery();
        }
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery(combinedQuery, new Class[]{MyLegalPerson.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    @Override
    protected List<PrimaryDataEntity> searchByMetaDataImpl(MetaData query, boolean fuzzy, boolean recursiveIntoSubdirectories) throws PrimaryDataDirectoryException, MetaDataException {
        HashSet<PrimaryDataEntity> hashSet = new HashSet<PrimaryDataEntity>();
        EnumDublinCoreElements[] enumDublinCoreElementsArray = EnumDublinCoreElements.values();
        int n = enumDublinCoreElementsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDublinCoreElements element = enumDublinCoreElementsArray[n2];
            List<PrimaryDataEntity> tempList = this.searchByDublinCoreElement(element, (UntypedData)query.getElementValue(element), fuzzy, recursiveIntoSubdirectories);
            hashSet.addAll(tempList);
            ++n2;
        }
        if (hashSet.size() > 1000) {
            throw new PrimaryDataDirectoryException("find to much result please repeat query with more details");
        }
        ArrayList<PrimaryDataEntity> entityList = new ArrayList<PrimaryDataEntity>(hashSet);
        return entityList;
    }

    private List<MyNaturalPerson> searchByNaturalPerson(NaturalPerson naturalPerson, boolean fuzzy) throws ParseException {
        Query queryB;
        Query queryA;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = ftSession.getSearchFactory().buildQueryBuilder().forEntity(MyNaturalPerson.class).get();
        Query combinedQuery = null;
        if (fuzzy) {
            queryA = queryBuilder.keyword().wildcard().onField("givenName").matching((Object)("*" + naturalPerson.getGivenName() + "*")).createQuery();
            queryB = queryBuilder.keyword().wildcard().onField("sureName").matching((Object)("*" + naturalPerson.getSureName() + "*")).createQuery();
            Query queryC = queryBuilder.keyword().wildcard().onField("addressLine").matching((Object)("*" + naturalPerson.getAddressLine() + "*")).createQuery();
            Query queryD = queryBuilder.keyword().wildcard().onField("zip").matching((Object)("*" + naturalPerson.getZip() + "*")).createQuery();
            Query queryE = queryBuilder.keyword().wildcard().onField("country").matching((Object)("*" + naturalPerson.getCountry() + "*")).createQuery();
            combinedQuery = queryBuilder.bool().should(queryA).should(queryB).should(queryC).should(queryD).should(queryE).createQuery();
        } else {
            queryA = queryBuilder.keyword().wildcard().onField("givenName").matching((Object)naturalPerson.getGivenName()).createQuery();
            queryB = queryBuilder.keyword().wildcard().onField("sureName").matching((Object)naturalPerson.getSureName()).createQuery();
            Query queryC = queryBuilder.keyword().wildcard().onField("addressLine").matching((Object)naturalPerson.getAddressLine()).createQuery();
            Query queryD = queryBuilder.keyword().wildcard().onField("zip").matching((Object)naturalPerson.getZip()).createQuery();
            Query queryE = queryBuilder.keyword().wildcard().onField("country").matching((Object)naturalPerson.getCountry()).createQuery();
            combinedQuery = queryBuilder.bool().should(queryA).should(queryB).should(queryC).should(queryD).should(queryE).createQuery();
        }
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery(combinedQuery, new Class[]{MyNaturalPerson.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    @Override
    protected List<? extends PrimaryDataEntity> searchByPublicationStatusImpl(PublicationStatus publicationStatus) throws PrimaryDataDirectoryException {
        PrimaryDataEntity entity;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        ArrayList<PrimaryDataEntity> results = new ArrayList<PrimaryDataEntity>();
        ArrayList<PrimaryDataEntityVersionImplementation> maybeResults = new ArrayList<PrimaryDataEntityVersionImplementation>();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery referenceCriteria = builder.createQuery(PublicReferenceImplementation.class);
        Root referenceRoot = referenceCriteria.from(PublicReferenceImplementation.class);
        referenceCriteria.where((Expression)builder.equal((Expression)referenceRoot.get("publicationStatus"), (Object)publicationStatus));
        List notRequestedList = session.createQuery(referenceCriteria).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).list();
        for (PublicReferenceImplementation publicReferenceImplementation : notRequestedList) {
            entity = publicReferenceImplementation.getVersion().getEntity();
            try {
                if (entity.getParentDirectory().equals(this)) {
                    results.add(entity);
                    continue;
                }
                maybeResults.add(publicReferenceImplementation.getVersion());
            }
            catch (PrimaryDataDirectoryException e) {
                throw new PrimaryDataDirectoryException("unable to search in directory", e);
            }
        }
        for (PrimaryDataEntityVersionImplementation version : maybeResults) {
            try {
                entity = this.searchIntoSubdirectories(this, version);
                if (entity == null) continue;
                results.add(entity);
            }
            catch (PrimaryDataDirectoryException e) {
                throw new PrimaryDataDirectoryException("unable to search into sub directories", e);
            }
        }
        return results;
    }

    private List<MyUntypedData> searchByUntypedData(UntypedData data, boolean fuzzy) throws ParseException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Query query = null;
        FullTextSession ftSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = ftSession.getSearchFactory().buildQueryBuilder().forEntity(MyUntypedData.class).get();
        query = fuzzy ? queryBuilder.keyword().wildcard().onField("string").matching((Object)("*" + data.getString() + "*")).createQuery() : queryBuilder.keyword().onField("string").matching((Object)data.getString()).createQuery();
        FullTextQuery hibernateQuery = ftSession.createFullTextQuery(query, new Class[]{MyUntypedData.class});
        List result = hibernateQuery.list();
        session.close();
        return result;
    }

    private PrimaryDataEntity searchIntoSubdirectories(PrimaryDataDirectory entity, PrimaryDataEntityVersionImplementation version) throws PrimaryDataDirectoryException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery directoryCriteria = builder.createQuery(PrimaryDataDirectoryImplementation.class);
        Root directoryRoot = directoryCriteria.from(PrimaryDataDirectoryImplementation.class);
        directoryCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)directoryRoot.get(STRING_ID), (Object)version.getPrimaryEntityId())}), builder.equal(directoryRoot.type(), PrimaryDataDirectoryImplementation.class)});
        PrimaryDataDirectory directory = (PrimaryDataDirectory)session.createQuery(directoryCriteria).uniqueResult();
        if (directory != null && this.checkIfParentEntity(entity, directory)) {
            try {
                if (!directory.getCurrentVersion().isDeleted()) {
                    directory.switchCurrentVersion(version);
                }
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new PrimaryDataDirectoryException("Unable to switch version", e);
            }
            session.close();
            return directory;
        }
        CriteriaQuery fileCriteria = builder.createQuery(PrimaryDataFileImplementation.class);
        Root fileRoot = fileCriteria.from(PrimaryDataFileImplementation.class);
        fileCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)fileRoot.get(STRING_ID), (Object)version.getPrimaryEntityId())}), builder.equal(fileRoot.type(), PrimaryDataFileImplementation.class)});
        PrimaryDataFile file = (PrimaryDataFile)session.createQuery(fileCriteria).uniqueResult();
        if (file != null && this.checkIfParentEntity(entity, file)) {
            try {
                if (!file.getCurrentVersion().isDeleted()) {
                    file.switchCurrentVersion(version);
                }
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new PrimaryDataDirectoryException("Unable to switch version", e);
            }
            session.close();
            return file;
        }
        session.close();
        return null;
    }

    protected void setVersionList(SortedSet<PrimaryDataEntityVersionImplementation> versionList) {
        this.versionList = Collections.synchronizedSortedSet(versionList);
        this.setCurrentVersion(this.versionList.last());
    }

    @Override
    protected void storeVersion(PrimaryDataEntityVersion publicVersion) throws PrimaryDataEntityVersionException {
        MetaDataImplementation metadata = (MetaDataImplementation)publicVersion.getMetaData();
        PrimaryDataEntityVersionImplementation privateVersion = new PrimaryDataEntityVersionImplementation();
        privateVersion.setCreationDate(publicVersion.getCreationDate());
        privateVersion.setPrimaryEntityId(this.getID());
        privateVersion.setMetaData(metadata);
        privateVersion.setRevision(publicVersion.getRevision());
        privateVersion.setDeleted(publicVersion.isDeleted());
        ArrayList<PublicReferenceImplementation> list = new ArrayList<PublicReferenceImplementation>();
        for (PublicReference publicReference : publicVersion.getPublicReferences()) {
            PublicReferenceImplementation privateReference = new PublicReferenceImplementation(publicReference);
            privateReference.setVersion(privateVersion);
            list.add(privateReference);
        }
        privateVersion.setInternReferences(list);
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        try {
            session.saveOrUpdate((Object)this);
            session.saveOrUpdate((Object)privateVersion);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            session.close();
            throw new PrimaryDataEntityVersionException("Unable to store PrimaryDataEntityVersion : " + e.getMessage(), e);
        }
        if (this.versionList == null) {
            this.versionList = Collections.synchronizedSortedSet(new TreeSet());
            this.versionList.add(privateVersion);
            Collections.synchronizedSortedSet(this.versionList);
        } else {
            this.versionList.add(privateVersion);
            Collections.synchronizedSortedSet(this.versionList);
        }
        this.setCurrentVersion(privateVersion);
        try {
            this.setDefaultPermissions();
        }
        catch (PrimaryDataEntityException e) {
            throw new PrimaryDataEntityVersionException("Unable to store default permissions : " + e.getMessage(), e);
        }
        Iterator<Principal> iterator = DataManager.getSubject().getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal principal = iterator.next();
            Transaction transaction2 = session.beginTransaction();
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(PrincipalImplementation.class);
            Root root = criteria.from(PrincipalImplementation.class);
            criteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)root.get("name"), (Object)principal.getName())}), builder.equal((Expression)root.get("type"), (Object)principal.getClass().getSimpleName())});
            PrincipalImplementation existingPrincipal = (PrincipalImplementation)session.createQuery(criteria).uniqueResult();
            if (existingPrincipal == null) {
                throw new PrimaryDataEntityVersionException("Unable to load existing Principal");
            }
            privateVersion.setOwner(existingPrincipal);
            session.saveOrUpdate((Object)privateVersion);
            transaction2.commit();
            session.close();
        }
        this.setCurrentVersion(privateVersion);
    }
}

